/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.zte.invoke;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.trip.exception.TripException;
import kd.fi.er.business.trip.model.AbstractCheckingBillDetailModel;
import kd.fi.er.business.trip.model.CheckingBillHeaderModel;
import kd.fi.er.business.trip.model.CheckingBillModel;
import kd.fi.er.business.trip.model.HotelCheckingBillDetailModel;
import kd.fi.er.business.trip.model.PlaneCheckingBillDetailModel;
import kd.fi.er.business.trip.model.TrainCheckingBillDetailModel;
import kd.fi.er.business.trip.model.VehicleCheckingBillDetailModel;
import kd.fi.er.business.trip.service.function.AbstractCheckingInvoke;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.zte.invoke.convert.ETripCarCheckingDetailConvert;
import kd.fi.er.business.trip.supplier.zte.invoke.convert.ETripHotelCheckingDetailConvert;
import kd.fi.er.business.trip.supplier.zte.invoke.convert.ETripPlaneCheckingDetailConvert;
import kd.fi.er.business.trip.supplier.zte.invoke.convert.ETripTrainCheckingDetailConvert;
import kd.fi.er.business.trip.util.TripCommonUtil;

public class ETripCheckingInvoke
extends AbstractCheckingInvoke<JSONObject> {
    private static final Log logger = LogFactory.getLog(ETripCheckingInvoke.class);

    public ETripCheckingInvoke() {
    }

    public ETripCheckingInvoke(Map<String, ? extends Object> params) {
        super((Map)params);
    }

    @Override
    protected String supplier() {
        return Supplier.ZHONGXING.name();
    }

    protected JSONObject process(Map params) throws TripException {
        String data = (String)params.get("data");
        logger.info("\u5546\u65c5\u96c6\u6210,\u4e2d\u5174\u7ed3\u7b97\u5355,\u6536\u5230\u5546\u65c5\u540c\u6b65\u7684\u5bf9\u8d26\u5355 syncBeeStatement checkbill-->:" + data);
        this.tripSyncLogParam.setResponsedata(params);
        JSONObject dataJsonObject = (JSONObject)JSONObject.parse((String)data);
        return dataJsonObject;
    }

    protected Object convert(Object value) throws TripException {
        JSONObject t = (JSONObject)value;
        CheckingBillModel billModel = new CheckingBillModel();
        CheckingBillHeaderModel headerModel = this.buildHeaderModel(t);
        List<AbstractCheckingBillDetailModel> details = this.buildDetailModel(t);
        billModel.setCheckingBillHeaderModel(headerModel);
        billModel.setCheckingBillDetailModels(details);
        ArrayList<CheckingBillModel> checkingBillModelList = new ArrayList<CheckingBillModel>();
        checkingBillModelList.add(billModel);
        return checkingBillModelList;
    }

    private List<AbstractCheckingBillDetailModel> buildDetailModel(JSONObject checkingBillJson) {
        ArrayList<AbstractCheckingBillDetailModel> details;
        block8: {
            String batchno;
            String batchnoPropName;
            String operationType;
            String periodStartDate;
            String periodSDatePropName;
            JSONArray detailCheckingBill;
            block9: {
                block7: {
                    detailCheckingBill = checkingBillJson.getJSONArray("settleOrders");
                    periodSDatePropName = "periodStartDate";
                    periodStartDate = checkingBillJson.getString(periodSDatePropName);
                    operationType = checkingBillJson.getString("operationType");
                    batchnoPropName = "batchno";
                    batchno = checkingBillJson.getString("billNum");
                    details = new ArrayList<AbstractCheckingBillDetailModel>();
                    if (!"DOMAIR".equals(operationType) && !"INTAIR".equals(operationType)) break block7;
                    for (int i = 0; i < detailCheckingBill.size(); ++i) {
                        JSONObject planeJson = detailCheckingBill.getJSONObject(i);
                        planeJson.put(periodSDatePropName, (Object)periodStartDate);
                        planeJson.put(batchnoPropName, (Object)batchno);
                        details.addAll(ETripPlaneCheckingDetailConvert.convert(planeJson));
                        PlaneCheckingBillDetailModel model = (PlaneCheckingBillDetailModel)details.get(i);
                        this.handlePlaneCheckingExtCovert(model, planeJson);
                    }
                    break block8;
                }
                if ("HOTEL".equals(operationType)) {
                    try {
                        for (int i = 0; i < detailCheckingBill.size(); ++i) {
                            JSONObject hotelJson = detailCheckingBill.getJSONObject(i);
                            hotelJson.put(periodSDatePropName, (Object)periodStartDate);
                            hotelJson.put(batchnoPropName, (Object)batchno);
                            details.addAll(ETripHotelCheckingDetailConvert.convert(hotelJson));
                            HotelCheckingBillDetailModel model = (HotelCheckingBillDetailModel)details.get(i);
                            this.handleHotelCheckingExtCovert(model, hotelJson);
                        }
                    }
                    catch (CloneNotSupportedException e) {
                        logger.error("\u5546\u65c5\u96c6\u6210,\u4e2d\u5174\u7ed3\u7b97\u5355,CloneNotSupportedException:", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
                if (!"TRAIN".equals(operationType)) break block9;
                for (int i = 0; i < detailCheckingBill.size(); ++i) {
                    JSONObject trainJson = detailCheckingBill.getJSONObject(i);
                    trainJson.put(periodSDatePropName, (Object)periodStartDate);
                    trainJson.put(batchnoPropName, (Object)batchno);
                    details.addAll(ETripTrainCheckingDetailConvert.convert(trainJson));
                    TrainCheckingBillDetailModel model = (TrainCheckingBillDetailModel)details.get(i);
                    this.handleTrainCheckingExtCovert(model, trainJson);
                }
                break block8;
            }
            if (!"CAR".equals(operationType)) break block8;
            for (int i = 0; i < detailCheckingBill.size(); ++i) {
                JSONObject carJson = detailCheckingBill.getJSONObject(i);
                carJson.put(periodSDatePropName, (Object)periodStartDate);
                carJson.put(batchnoPropName, (Object)batchno);
                details.addAll(ETripCarCheckingDetailConvert.convert(carJson));
                VehicleCheckingBillDetailModel model = (VehicleCheckingBillDetailModel)details.get(i);
                this.handleCarCheckingExtCovert(model, carJson);
            }
        }
        return details;
    }

    private CheckingBillHeaderModel buildHeaderModel(JSONObject checkingBillJson) {
        CheckingBillHeaderModel headerModel = new CheckingBillHeaderModel();
        headerModel.setBillNo(checkingBillJson.getString("billNum"));
        headerModel.setBillstatusname(checkingBillJson.getString("billStatusName"));
        headerModel.setPeriodStartDate(TripCommonUtil.convertToDate(checkingBillJson.getString("periodStartDate") + " 00:00:00"));
        headerModel.setPeriodEndDate(TripCommonUtil.convertToDate(checkingBillJson.getString("periodEndDate") + " 00:00:00"));
        headerModel.setSettlementAmount(checkingBillJson.getBigDecimal("arAmount"));
        headerModel.setServer(this.supplier());
        return headerModel;
    }
}

