/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.zte.invoke;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.HttpRetryServiceHelper;
import kd.fi.er.business.trip.model.JourneyModel;
import kd.fi.er.business.trip.model.TripReqbillModel;
import kd.fi.er.business.trip.service.function.AbstractTripReqBillInvoke;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.util.TripCommonUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class ETripReqbillInvoke
extends AbstractTripReqBillInvoke<JSONObject> {
    private static final Log logger = LogFactory.getLog(ETripReqbillInvoke.class);
    private boolean isCtrl = false;
    private String domairdatectrl = "1";
    private String domaircityctrl = "1";
    private String hoteldatectrl = "1";
    private String hotelcityctrl = "1";
    private String firstStartDate = "";
    private String lastEndDate = "";
    private String cityStr = "";

    public ETripReqbillInvoke(Object pk) {
        super(pk);
    }

    public ETripReqbillInvoke() {
    }

    @Override
    protected String supplier() {
        return Supplier.ZHONGXING.name();
    }

    protected JSONObject convert(Object value) {
        if (this.pk != null) {
            logger.info("\u5546\u65c5\u96c6\u6210,\u4e2d\u5174\u51fa\u5dee\u7533\u8bf7\u5355,\u5355\u636ebillid\u4e3a:" + this.pk);
            return this.convertPushBill(value);
        }
        String syncStatus = (String)this.getParams().get("syncStatus");
        logger.info("\u5546\u65c5\u96c6\u6210,\u4e2d\u5174\u51fa\u5dee\u7533\u8bf7\u5355,\u540c\u6b65\u7684\u72b6\u6001\u6709:1_\u63a8\u9001\u5355\u636e,2_\u5173\u95ed\u5355\u636e,3_\u542f\u7528\u5355\u636e,4_\u64a4\u9500\u5355\u636e,\u5f53\u524d\u72b6\u6001\u4e3a:" + syncStatus);
        switch (syncStatus) {
            case "1": {
                return this.convertPushBill(value);
            }
        }
        return null;
    }

    protected JSONObject convertPushBill(Object info) {
        String synBillSettleType;
        DynamicObject ctrlSettingObject;
        String endDate;
        String startDate;
        TripReqbillModel reqbill = (TripReqbillModel)info;
        JSONObject bodyDataJson = new JSONObject();
        JSONArray journeyInfos = new JSONArray();
        JSONArray policyPassengers = new JSONArray();
        List<JourneyModel> journeyModelList = reqbill.getJourneyModelList();
        for (JourneyModel journey : journeyModelList) {
            JSONObject oneJourneyInfo = new JSONObject();
            oneJourneyInfo.put("seqNo", (Object)journey.getSeqNo());
            oneJourneyInfo.put("fromCity", (Object)journey.getFromCity());
            oneJourneyInfo.put("toCity", (Object)journey.getToCity());
            oneJourneyInfo.put("journeyType", (Object)"RT");
            startDate = journey.getStartDate().toString();
            oneJourneyInfo.put("startDate", (Object)startDate.substring(0, 10));
            endDate = journey.getEndDate().toString();
            oneJourneyInfo.put("endDate", (Object)endDate.substring(0, 10));
            oneJourneyInfo.put("trafficTool", (Object)this.convertZTETrafficTool(journey.getTrafficTool()));
            journeyInfos.add((Object)oneJourneyInfo);
        }
        this.setCompanionInfos(bodyDataJson, journeyModelList, policyPassengers);
        if (reqbill.getCompanyId() != null && (ctrlSettingObject = TripCommonUtil.getTripControlSettings(reqbill.getCompanyId(), this.supplier())) != null) {
            this.isCtrl = true;
            this.domairdatectrl = ctrlSettingObject.getString("domairdatectrl");
            this.domaircityctrl = ctrlSettingObject.getString("domaircityctrl");
            this.hoteldatectrl = ctrlSettingObject.getString("hoteldatectrl");
            this.hotelcityctrl = ctrlSettingObject.getString("hotelcityctrl");
            for (int i = 0; i < journeyModelList.size(); ++i) {
                JourneyModel journeyModel = journeyModelList.get(i);
                startDate = journeyModelList.get(0).getStartDate().toString();
                this.firstStartDate = startDate.substring(0, 10);
                endDate = journeyModelList.get(journeyModelList.size() - 1).getEndDate().toString();
                this.lastEndDate = endDate.substring(0, 10);
                String fromCityStr = journeyModel.getFromCity();
                String toCityStr = journeyModel.getToCity();
                if (StringUtils.isEmpty((CharSequence)this.cityStr)) {
                    this.cityStr = fromCityStr;
                }
                if (!this.cityStr.contains(fromCityStr)) {
                    this.cityStr = this.cityStr + "," + toCityStr;
                }
                if (this.cityStr.contains(toCityStr)) continue;
                this.cityStr = this.cityStr + "," + toCityStr;
            }
            if ("2".equals(this.domairdatectrl) && "2".equals(this.domaircityctrl)) {
                this.setPlaneWholeBillErrandPolicy(bodyDataJson, ctrlSettingObject, policyPassengers);
            } else {
                this.setPlaneErrandPolicy(bodyDataJson, journeyModelList, ctrlSettingObject);
            }
            if ("2".equals(this.hoteldatectrl)) {
                this.setHotelWholeBillErrandPolicy(bodyDataJson, ctrlSettingObject, policyPassengers);
            } else {
                this.setHotelErrandPolicy(bodyDataJson, journeyModelList, ctrlSettingObject);
            }
        }
        bodyDataJson.put("sourceType", (Object)"kingdee");
        bodyDataJson.put("sourceKey", (Object)reqbill.getBillNo());
        bodyDataJson.put("applyEmpNum", (Object)reqbill.getCreatEmpNum());
        bodyDataJson.put("errandEmpNum", (Object)reqbill.getApplyEmpNum());
        bodyDataJson.put("journeyType", (Object)"INLAND");
        bodyDataJson.put("reason", (Object)reqbill.getDesc());
        bodyDataJson.put("journeyInfos", (Object)journeyInfos);
        bodyDataJson.put("isCanModify", (Object)"modify");
        Map<String, String> tripInfoDynamic = TripCommonUtil.getTripServiceInfo(Supplier.ZHONGXING.name());
        if (tripInfoDynamic != null && (synBillSettleType = tripInfoDynamic.get("syncreqbillsettleorg")) != null && !synBillSettleType.equals("2")) {
            if (synBillSettleType.equals("0")) {
                bodyDataJson.put("corporation", (Object)reqbill.getCostCompanyId());
                bodyDataJson.put("corporationName", (Object)reqbill.getCostCompany());
            } else if (synBillSettleType.equals("1")) {
                bodyDataJson.put("corporation", (Object)reqbill.getCompanyId());
                bodyDataJson.put("corporationName", (Object)reqbill.getCompany());
            }
        }
        return bodyDataJson;
    }

    private void setCompanionInfos(JSONObject bodyDataJson, List<JourneyModel> journeyModelList, JSONArray policyPassengers) {
        JSONArray companionInfoArray = new JSONArray();
        HashSet<String> travelerNum = new HashSet<String>();
        HashMap<String, String> companionInfoMap = new HashMap<String, String>();
        for (JourneyModel journey : journeyModelList) {
            Set<DynamicObject> journeytraverlers = journey.getTravelers();
            for (DynamicObject journeytraverler : journeytraverlers) {
                String number = journeytraverler.getString("number");
                String name = journeytraverler.getString("name");
                companionInfoMap.put(number, name);
                travelerNum.add(number);
            }
        }
        for (String key : travelerNum) {
            JSONObject companionInfoObject = new JSONObject();
            JSONObject policyPassenger = new JSONObject();
            companionInfoObject.put("personnelType", (Object)"EMPLOYEE");
            companionInfoObject.put("empNum", (Object)key);
            companionInfoObject.put("personnelName", companionInfoMap.get(key));
            policyPassenger.put("passengerName", companionInfoMap.get(key));
            companionInfoArray.add((Object)companionInfoObject);
            policyPassengers.add((Object)policyPassenger);
        }
        bodyDataJson.put("companionInfos", (Object)companionInfoArray);
    }

    private void setHotelWholeBillErrandPolicy(JSONObject bodyDataJson, DynamicObject ctrlSettingObject, JSONArray policyPassengers) {
        JSONArray hotelErrandPolicys = new JSONArray();
        JSONObject hotelErrandPolicy = new JSONObject();
        hotelErrandPolicy.put("type", (Object)"HOTEL");
        hotelErrandPolicy.put("checkinDateStart", (Object)this.firstStartDate);
        hotelErrandPolicy.put("checkinDateEnd", (Object)this.lastEndDate);
        hotelErrandPolicy.put("checkoutDateStart", (Object)this.firstStartDate);
        hotelErrandPolicy.put("checkoutDateEnd", (Object)this.lastEndDate);
        hotelErrandPolicy.put("toCityNames", (Object)this.cityStr);
        hotelErrandPolicy.put("minStar", (Object)ctrlSettingObject.getInt("mixstarclass"));
        hotelErrandPolicy.put("maxStar", (Object)ctrlSettingObject.getInt("maxstarclass"));
        hotelErrandPolicy.put("roomCount", (Object)ctrlSettingObject.getInt("dayroomcount"));
        hotelErrandPolicy.put("passengers", (Object)policyPassengers);
        hotelErrandPolicys.add((Object)hotelErrandPolicy);
        bodyDataJson.put("hotelErrandPolicys", (Object)hotelErrandPolicys);
    }

    private void setPlaneWholeBillErrandPolicy(JSONObject bodyDataJson, DynamicObject ctrlSettingObject, JSONArray policyPassengers) {
        JSONArray airErrandPolicys = new JSONArray();
        JSONObject airErrandPolicy = new JSONObject();
        airErrandPolicy.put("type", (Object)"DOMAIR");
        BigDecimal discount = ctrlSettingObject.getBigDecimal("domairdiscountctrl").multiply(new BigDecimal(10));
        airErrandPolicy.put("discount", (Object)discount.intValue());
        airErrandPolicy.put("flightType", (Object)("1".equals(ctrlSettingObject.getString("domairroundtripctrl")) ? "OW" : "RT"));
        airErrandPolicy.put("takeoffDateStart", (Object)this.firstStartDate);
        airErrandPolicy.put("takeoffDateEnd", (Object)this.lastEndDate);
        airErrandPolicy.put("returnDateStart", (Object)this.firstStartDate);
        airErrandPolicy.put("returnDateEnd", (Object)this.lastEndDate);
        airErrandPolicy.put("fromCityNames", (Object)this.cityStr);
        airErrandPolicy.put("toCityNames", (Object)this.cityStr);
        airErrandPolicy.put("passengers", (Object)policyPassengers);
        airErrandPolicys.add((Object)airErrandPolicy);
        bodyDataJson.put("airErrandPolicys", (Object)airErrandPolicys);
    }

    private void setPlaneErrandPolicy(JSONObject bodyDataJson, List<JourneyModel> journeyModelList, DynamicObject ctrlSettingObject) {
        JSONArray airErrandPolicys = new JSONArray();
        for (JourneyModel journey : journeyModelList) {
            Set<DynamicObject> journeytraverlers = journey.getTravelers();
            JSONObject airErrandPolicy = new JSONObject();
            JSONArray passengers = new JSONArray();
            for (DynamicObject journeytraverler : journeytraverlers) {
                JSONObject passenger = new JSONObject();
                String name = journeytraverler.getString("name");
                passenger.put("passengerName", (Object)name);
                passengers.add((Object)passenger);
            }
            airErrandPolicy.put("type", (Object)"DOMAIR");
            BigDecimal discount = ctrlSettingObject.getBigDecimal("domairdiscountctrl").multiply(new BigDecimal(10));
            airErrandPolicy.put("discount", (Object)discount.intValue());
            airErrandPolicy.put("flightType", (Object)("1".equals(ctrlSettingObject.getString("domairroundtripctrl")) ? "OW" : "RT"));
            if ("1".equals(this.domairdatectrl)) {
                String startDate = journey.getStartDate().toString().substring(0, 10);
                String endDate = journey.getEndDate().toString().substring(0, 10);
                airErrandPolicy.put("takeoffDateStart", (Object)startDate);
                airErrandPolicy.put("takeoffDateEnd", (Object)endDate);
                airErrandPolicy.put("returnDateStart", (Object)startDate);
                airErrandPolicy.put("returnDateEnd", (Object)endDate);
            } else if ("2".equals(this.domairdatectrl)) {
                airErrandPolicy.put("takeoffDateStart", (Object)this.firstStartDate);
                airErrandPolicy.put("takeoffDateEnd", (Object)this.lastEndDate);
                airErrandPolicy.put("returnDateStart", (Object)this.firstStartDate);
                airErrandPolicy.put("returnDateEnd", (Object)this.lastEndDate);
            }
            if ("1".equals(this.domaircityctrl)) {
                airErrandPolicy.put("fromCityNames", (Object)journey.getFromCity());
                airErrandPolicy.put("toCityNames", (Object)journey.getToCity());
            } else if ("2".equals(this.domaircityctrl)) {
                airErrandPolicy.put("fromCityNames", (Object)this.cityStr);
                airErrandPolicy.put("toCityNames", (Object)this.cityStr);
            }
            airErrandPolicy.put("passengers", (Object)passengers);
            airErrandPolicys.add((Object)airErrandPolicy);
            bodyDataJson.put("airErrandPolicys", (Object)airErrandPolicys);
        }
    }

    private void setHotelErrandPolicy(JSONObject bodyDataJson, List<JourneyModel> journeyModelList, DynamicObject ctrlSettingObject) {
        JSONArray hotelErrandPolicys = new JSONArray();
        for (JourneyModel journey : journeyModelList) {
            Set<DynamicObject> journeytraverlers = journey.getTravelers();
            JSONObject hotelErrandPolicy = new JSONObject();
            JSONArray passengers = new JSONArray();
            for (DynamicObject journeytraverler : journeytraverlers) {
                JSONObject passenger = new JSONObject();
                String name = journeytraverler.getString("name");
                passenger.put("passengerName", (Object)name);
                passengers.add((Object)passenger);
            }
            hotelErrandPolicy.put("type", (Object)"HOTEL");
            if ("1".equals(this.hoteldatectrl)) {
                String startDate = journey.getStartDate().toString().substring(0, 10);
                String endDate = journey.getEndDate().toString().substring(0, 10);
                hotelErrandPolicy.put("checkinDateStart", (Object)startDate);
                hotelErrandPolicy.put("checkinDateEnd", (Object)endDate);
                hotelErrandPolicy.put("checkoutDateStart", (Object)startDate);
                hotelErrandPolicy.put("checkoutDateEnd", (Object)endDate);
            } else if ("2".equals(this.hoteldatectrl)) {
                hotelErrandPolicy.put("checkinDateStart", (Object)this.firstStartDate);
                hotelErrandPolicy.put("checkinDateEnd", (Object)this.lastEndDate);
                hotelErrandPolicy.put("checkoutDateStart", (Object)this.firstStartDate);
                hotelErrandPolicy.put("checkoutDateEnd", (Object)this.lastEndDate);
            }
            if ("1".equals(this.hotelcityctrl)) {
                hotelErrandPolicy.put("toCityNames", (Object)journey.getToCity());
            } else if ("2".equals(this.hotelcityctrl)) {
                hotelErrandPolicy.put("toCityNames", (Object)this.cityStr);
            }
            hotelErrandPolicy.put("minStar", (Object)ctrlSettingObject.getInt("mixstarclass"));
            hotelErrandPolicy.put("maxStar", (Object)ctrlSettingObject.getInt("maxstarclass"));
            hotelErrandPolicy.put("roomCount", (Object)ctrlSettingObject.getInt("dayroomcount"));
            hotelErrandPolicy.put("passengers", (Object)passengers);
            hotelErrandPolicys.add((Object)hotelErrandPolicy);
        }
        bodyDataJson.put("hotelErrandPolicys", (Object)hotelErrandPolicys);
    }

    private String convertZTETrafficTool(Object tool) {
        if (null == tool) {
            return "plane";
        }
        String result = null;
        switch (tool.toString()) {
            case "1": {
                result = "plane";
                break;
            }
            case "2": {
                result = "train";
                break;
            }
            case "3": {
                result = "bus";
                break;
            }
            case "4": {
                result = "boat";
                break;
            }
            case "5": 
            case "6": {
                result = "other";
                break;
            }
            default: {
                result = "plane";
            }
        }
        return result;
    }

    protected String batPushProcess(Object value) {
        if (value == null) {
            return null;
        }
        String method = "errand.createbill";
        Map<String, String> ZTE_login_info = TripCommonUtil.getTripServiceInfo(this.supplier());
        String kingdee_user_name = ZTE_login_info.get("appkey");
        String kingdee_user_key = ZTE_login_info.get("appsecurity");
        if (this.isCtrl) {
            method = "errand.createbillwitherrandpolicy";
        }
        String currentTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        ArrayList<NameValuePair> body_params = new ArrayList<NameValuePair>();
        body_params.add((NameValuePair)new BasicNameValuePair("userName", kingdee_user_name));
        body_params.add((NameValuePair)new BasicNameValuePair("currentTime", currentTime));
        String password = CommonServiceHelper.getMD5(kingdee_user_name + method + kingdee_user_key + currentTime).toUpperCase();
        body_params.add((NameValuePair)new BasicNameValuePair("password", password));
        body_params.add((NameValuePair)new BasicNameValuePair("format", "json"));
        body_params.add((NameValuePair)new BasicNameValuePair("method", method));
        String data = "";
        JSONObject bodyDataJson = JSON.parseObject((String)JSON.toJSONString((Object)value));
        try {
            String dataJson = JSON.toJSONString((Object)bodyDataJson, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
            data = URLEncoder.encode(dataJson, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u5546\u65c5\u96c6\u6210,\u4e2d\u5174\u51fa\u5dee\u7533\u8bf7\u5355,encode\u5931\u8d25:", (Throwable)e);
            throw new RuntimeException(e);
        }
        body_params.add((NameValuePair)new BasicNameValuePair("data", data));
        String url = ZTE_login_info.get("reservedfield1");
        this.tripSyncLogParam.setRequestdata(value);
        this.tripSyncLogParam.setRequesturl(url);
        Map<String, Object> resultMap = HttpRetryServiceHelper.httpPost(url, body_params);
        this.tripSyncLogParam.setResponsedata(resultMap);
        int resultCode = (Integer)resultMap.get("code");
        String resultMessage = (String)resultMap.get("message");
        logger.info(String.format("\u5546\u65c5\u96c6\u6210,\u4e2d\u5174\u51fa\u5dee\u7533\u8bf7\u5355,requestJson: %s, resultCode: %s, resultMessage: %s", bodyDataJson.toJSONString(), resultCode, resultMessage));
        return String.valueOf(resultCode);
    }
}

