/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.zte.invoke.convert;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.trip.model.AbstractOrderModel;
import kd.fi.er.business.trip.model.VehicleOrderModel;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.zte.systemexternal.ETripPropMapping;
import kd.fi.er.business.trip.util.TripCommonUtil;

public class ETripCarOrderConvert {
    private static final Log logger = LogFactory.getLog(ETripCarOrderConvert.class);

    public static List<AbstractOrderModel> convert(JSONObject orderJson) {
        logger.info("\u5546\u65c5\u96c6\u6210,\u4e2d\u5174\u8ba2\u5355:" + orderJson.toJSONString());
        ArrayList orderModels = Lists.newArrayListWithExpectedSize((int)4);
        VehicleOrderModel vehicleOrderModel = new VehicleOrderModel();
        vehicleOrderModel.setOrderNum(orderJson.getString("orderNum"));
        vehicleOrderModel.setOrderNatrue(ETripPropMapping.setOrderNatrue(orderJson.getString("errandType")));
        vehicleOrderModel.setProductType(ETripPropMapping.setProductType(orderJson.getString("paymentType")));
        vehicleOrderModel.setOaBillNum(orderJson.getString("oaBillNum"));
        vehicleOrderModel.setModifyTime(TripCommonUtil.convertToDate(orderJson.getString("lastUpdateDate")));
        vehicleOrderModel.setOrderDate(TripCommonUtil.convertToDate(orderJson.getString("orderDate")));
        vehicleOrderModel.setHappendDate(TripCommonUtil.convertToDate(orderJson.getString("happendDate")));
        vehicleOrderModel.setSourceBookedId(orderJson.getString("sourceBookedId"));
        vehicleOrderModel.setBookedname(orderJson.getString("bookedName"));
        vehicleOrderModel.setPasseger(orderJson.getString("sourceTravelerId"));
        vehicleOrderModel.setPassegername(orderJson.getString("travelerName"));
        vehicleOrderModel.setOrderStatus(ETripCarOrderConvert.setOrderStatus(orderJson.getString("orderStatus")));
        vehicleOrderModel.setOverDesc(orderJson.getString("overDesc"));
        vehicleOrderModel.setTotalAmount(orderJson.getBigDecimal("totalAmount"));
        vehicleOrderModel.setDealAmount(orderJson.getBigDecimal("totalAmount"));
        vehicleOrderModel.setServiceFee(orderJson.getBigDecimal("serviceFee"));
        vehicleOrderModel.setVehicleType(ETripPropMapping.setVehicleType(orderJson.getString("carType")));
        vehicleOrderModel.setPersonalFee(orderJson.getBigDecimal("paymentPsFee"));
        vehicleOrderModel.setCityName(orderJson.getString("cityName"));
        vehicleOrderModel.setDepartAddress(orderJson.getString("startName"));
        vehicleOrderModel.setArriveAddress(orderJson.getString("endName"));
        vehicleOrderModel.setUseTime(TripCommonUtil.convertToDate(orderJson.getString("departureTime")));
        vehicleOrderModel.setServer(Supplier.ZHONGXING.name());
        vehicleOrderModel.setOrderType(AbstractOrderModel.OrderType.O);
        vehicleOrderModel.setOrderSort(AbstractOrderModel.OrderSort.A);
        vehicleOrderModel.setVendorName(orderJson.getString("subVendorName"));
        vehicleOrderModel.setOperationType(AbstractOrderModel.OperationType.C);
        orderModels.add(vehicleOrderModel);
        return orderModels;
    }

    private static VehicleOrderModel.OrderStatus setOrderStatus(String orderStatus) {
        switch (orderStatus) {
            case "600": {
                return VehicleOrderModel.OrderStatus.D;
            }
            case "610": {
                return VehicleOrderModel.OrderStatus.F;
            }
            case "650": {
                return VehicleOrderModel.OrderStatus.H;
            }
            case "700": {
                return VehicleOrderModel.OrderStatus.G;
            }
        }
        return VehicleOrderModel.OrderStatus.A;
    }
}

