/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.zte.invoke.convert;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.fi.er.business.trip.model.AbstractCheckingBillDetailModel;
import kd.fi.er.business.trip.model.AbstractOrderModel;
import kd.fi.er.business.trip.model.HotelCheckingBillDetailModel;
import kd.fi.er.business.trip.model.HotelOrderModel;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.util.TripCommonUtil;

public class ETripHotelCheckingDetailConvert {
    public static List<AbstractCheckingBillDetailModel> convert(JSONObject hotelJson) throws CloneNotSupportedException {
        ArrayList<AbstractCheckingBillDetailModel> details = new ArrayList<AbstractCheckingBillDetailModel>();
        HotelCheckingBillDetailModel detail = new HotelCheckingBillDetailModel();
        detail.setOaBillNum(hotelJson.getString("oaBillNum"));
        detail.setOrderNum(hotelJson.getString("orderNum"));
        detail.setServer(Supplier.ZHONGXING.name());
        detail.setOrderDate(TripCommonUtil.convertToDate(hotelJson.getString("orderDate")));
        detail.setTotalAmount(hotelJson.getBigDecimal("totalAmount"));
        detail.setOperationType(AbstractOrderModel.OperationType.A);
        String periodStartStr = hotelJson.getString("periodStartDate");
        Date periodStartDate = TripCommonUtil.convertToDate(periodStartStr);
        detail.setBillPeriod(periodStartDate);
        detail.setHappendDate(periodStartDate);
        detail.setBatchno(hotelJson.getString("batchno"));
        detail.setOrderNatrue(ETripHotelCheckingDetailConvert.setOrderNatrue(hotelJson.getString("errandType")));
        detail.setProductType(ETripHotelCheckingDetailConvert.setProductType(hotelJson.getString("paymentType")));
        detail.setSourceBookedId(hotelJson.getString("sourceBookedId"));
        detail.setOrderStatus(ETripHotelCheckingDetailConvert.setOrderStatus(hotelJson.getString("orderStatus")));
        detail.setOrderType(ETripHotelCheckingDetailConvert.setOrderType(hotelJson.getString("orderType")));
        detail.setOrderSort(AbstractCheckingBillDetailModel.OrderSort.A);
        detail.setPersonalFee(hotelJson.getBigDecimal("paymentPsFee"));
        Object settleMain = hotelJson.get((Object)"settleMain");
        if (settleMain != null && !settleMain.toString().equals("")) {
            detail.setSettlemain(hotelJson.getString("settleMain"));
        } else {
            detail.setSettlemain(null);
        }
        detail.setHotelName(hotelJson.getString("hotelName"));
        detail.setRoomAmount(hotelJson.getBigDecimal("roomAmount"));
        detail.setServiceFee(hotelJson.getBigDecimal("serviceFee"));
        detail.setUnbookfee(hotelJson.getBigDecimal("unbookFee"));
        detail.setCheckindate(TripCommonUtil.convertToDate(hotelJson.getString("checkInDate")));
        detail.setCheckoutdate(TripCommonUtil.convertToDate(hotelJson.getString("checkOutDate")));
        detail.setRoomcount(hotelJson.getIntValue("roomCount"));
        detail.setRoomstylename(hotelJson.getString("roomStyleName"));
        detail.setParentordernum(hotelJson.getString("orderNum"));
        detail.setBookedname(hotelJson.getString("bookedName"));
        detail.setCityName(hotelJson.getString("cityName"));
        JSONArray travelers = hotelJson.getJSONArray("travelers");
        if (travelers != null && travelers.size() > 0) {
            JSONObject traveler = travelers.getJSONObject(0);
            detail.setSourcetravelerid(traveler.getString("sourceTravelerId"));
            detail.setTravelername(traveler.getString("travelerName"));
            details.add(detail);
        }
        return details;
    }

    private static AbstractOrderModel.OrderNatrue setOrderNatrue(String orderNatrue) {
        if ("1".equals(orderNatrue)) {
            return AbstractOrderModel.OrderNatrue.A;
        }
        return AbstractOrderModel.OrderNatrue.B;
    }

    private static HotelOrderModel.OrderStatus setOrderStatus(String orderStatus) {
        switch (orderStatus) {
            case "1": {
                return HotelOrderModel.OrderStatus.A;
            }
            case "2": {
                return HotelOrderModel.OrderStatus.B;
            }
            case "3": {
                return HotelOrderModel.OrderStatus.C;
            }
            case "4": {
                return HotelOrderModel.OrderStatus.D;
            }
            case "5": {
                return HotelOrderModel.OrderStatus.E;
            }
            case "6": {
                return HotelOrderModel.OrderStatus.F;
            }
            case "7": {
                return HotelOrderModel.OrderStatus.G;
            }
            case "8": {
                return HotelOrderModel.OrderStatus.H;
            }
            case "10": {
                return HotelOrderModel.OrderStatus.I;
            }
            case "14": {
                return HotelOrderModel.OrderStatus.J;
            }
        }
        return HotelOrderModel.OrderStatus.A;
    }

    private static AbstractOrderModel.OrderType setOrderType(String orderType) {
        if ("O".equalsIgnoreCase(orderType)) {
            return AbstractOrderModel.OrderType.O;
        }
        if ("T".equalsIgnoreCase(orderType)) {
            return AbstractOrderModel.OrderType.T;
        }
        return AbstractOrderModel.OrderType.G;
    }

    private static AbstractOrderModel.ProductType setProductType(String productType) {
        if ("1".equals(productType)) {
            return AbstractOrderModel.ProductType.A;
        }
        return AbstractOrderModel.ProductType.B;
    }
}

