/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.zte.invoke.convert;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.trip.model.AbstractCheckingBillDetailModel;
import kd.fi.er.business.trip.model.AbstractOrderModel;
import kd.fi.er.business.trip.model.TrainCheckingBillDetailModel;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.zte.systemexternal.ETripPropMapping;
import kd.fi.er.business.trip.util.TripCommonUtil;

public class ETripTrainCheckingDetailConvert {
    private static final Log logger = LogFactory.getLog(ETripTrainCheckingDetailConvert.class);

    public static List<AbstractCheckingBillDetailModel> convert(JSONObject trainJson) {
        logger.info(String.format("\u5546\u65c5\u96c6\u6210,\u4e2d\u5174\u7ed3\u7b97\u5355:%s", trainJson));
        ArrayList<AbstractCheckingBillDetailModel> details = new ArrayList<AbstractCheckingBillDetailModel>();
        TrainCheckingBillDetailModel detail = new TrainCheckingBillDetailModel();
        detail.setArriveTime(TripCommonUtil.convertToDate(trainJson.getString("arriveDate")));
        detail.setSourceBookedId(trainJson.getString("sourceBookedId"));
        detail.setBookedname(trainJson.getString("bookedName"));
        detail.setOrderNatrue(ETripPropMapping.setOrderNatrue(trainJson.getString("errandType")));
        detail.setDepartAddress(trainJson.getString("fromStation"));
        detail.setDepartCity(trainJson.getString("fromCity"));
        String periodStartStr = trainJson.getString("periodStartDate");
        Date periodStartDate = TripCommonUtil.convertToDate(periodStartStr);
        detail.setBillPeriod(periodStartDate);
        detail.setHappendDate(periodStartDate);
        detail.setBatchno(trainJson.getString("batchno"));
        detail.setModifyTime(TripCommonUtil.convertToDate(trainJson.getString("lastUpdateDate")));
        detail.setOaBillNum(trainJson.getString("oaBillNum"));
        detail.setOrderDate(TripCommonUtil.convertToDate(trainJson.getString("orderDate")));
        detail.setOrderNum(trainJson.getString("orderNum"));
        detail.setOrderStatus(ETripPropMapping.setOrderStatus(trainJson.getString("orderStatus")));
        detail.setOrderType(ETripPropMapping.setOrderType(trainJson.getString("orderType")));
        detail.setParentordernum(trainJson.getString("parentOrderNum"));
        detail.setRefundamount(trainJson.getBigDecimal("refundAmount"));
        detail.setTrainseat(ETripPropMapping.setTrainseat(trainJson.getString("seatType")));
        detail.setServiceFee(trainJson.getBigDecimal("serviceFee"));
        detail.setDepartTime(TripCommonUtil.convertToDate(trainJson.getString("startDate")));
        detail.setTicketPrice(trainJson.getBigDecimal("ticketPrice"));
        detail.setArriveAddress(trainJson.getString("toStation"));
        detail.setArriveCity(trainJson.getString("toCity"));
        detail.setTotalAmount(trainJson.getBigDecimal("totalAmount"));
        detail.setVendorname(trainJson.getString("trainNumber"));
        detail.setPasseger(trainJson.getString("sourceTravelerId"));
        detail.setPassegername(trainJson.getString("travelerName"));
        detail.setServer(Supplier.ZHONGXING.name());
        detail.setProductType(ETripPropMapping.setProductType2(trainJson.getString("paymentType")));
        detail.setOrderSort(AbstractCheckingBillDetailModel.OrderSort.A);
        detail.setOperationType(AbstractOrderModel.OperationType.F);
        details.add(detail);
        return details;
    }
}

