/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.task.publicbiz;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ContactOverUnpaidTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(ContactOverUnpaidTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        String selectfield = "id,billstatus,detailtype,frameworkcontract,expenseentryentity.acexpeapprovecurramount,expenseentryentity.expnotpayamount,expenseentryentity.oriexpnotpayamount,expenseentryentity.happendate, expenseentryentity.exppayedamount,expenseentryentity.acexpeapprovecurramount,applyamount,nonpayamount,payedamount";
        QFilter qFilter = new QFilter("billstatus", "in", (Object)Lists.newArrayList((Object[])new String[]{"E", "F"}));
        qFilter.and(new QFilter("frameworkcontract", "=", (Object)"0"));
        qFilter.and(new QFilter("detailtype", "=", (Object)"biztype_applybill"));
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"er_contractbill", (String)selectfield, (QFilter[])new QFilter[]{qFilter});
        if (null == load || load.length == 0) {
            return;
        }
        String updateSqlnotover = "update t_er_contractentry_s  set  fexpisoverpay = '0'  where fexpisoverpay= '1' ";
        DB.execute((DBRoute)DBRoute.of((String)"er"), (String)updateSqlnotover);
        logger.info("\u5408\u540c\u4ed8\u6b3e\u9884\u8b66\u8c03\u5ea6\u66f4\u65b0\u5206\u5f55>>>>>>>>>>>>>\u5148\u53bb\u6389\u6240\u6709\u7684\u8d85\u671f\u52fe\u9009");
        logger.info("\u5408\u540c\u4ed8\u6b3e\u9884\u8b66\u8c03\u5ea6\u5f00\u59cb>>>>>>>>>>>>>load.length:" + load.length);
        LinkedList<Object[]> updateListexp = new LinkedList<Object[]>();
        LinkedList<Object[]> updateList = new LinkedList<Object[]>();
        LinkedList<Object[]> updateabnList = new LinkedList<Object[]>();
        String updateSqlexp = "update t_er_contractentry_s  set fexpisoverpay = ? ,fexppayprogress = ? where  fentryid = ? ";
        String updateSql = "update t_er_contractbill_s set fisoverpay = ?   where  fid = ? ";
        BigDecimal payprogress = BigDecimal.ZERO;
        int isoverpay = 48;
        for (DynamicObject contractDyn : load) {
            String billstatus = (String)contractDyn.get("billstatus");
            DynamicObjectCollection expenseentryentitycol = contractDyn.getDynamicObjectCollection("expenseentryentity");
            for (int i = 0; i < expenseentryentitycol.size(); ++i) {
                DynamicObject expObject = (DynamicObject)expenseentryentitycol.get(i);
                if ("F".equals(billstatus)) {
                    BigDecimal exppayedamount = expObject.getBigDecimal("exppayedamount");
                    BigDecimal acexpeapprovecurramount = expObject.getBigDecimal("acexpeapprovecurramount");
                    if (exppayedamount.compareTo(BigDecimal.ZERO) > 0 && acexpeapprovecurramount.compareTo(BigDecimal.ZERO) > 0) {
                        payprogress = exppayedamount.divide(acexpeapprovecurramount, 6, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L));
                    }
                }
                Date happendate = expObject.getDate("happendate");
                Date now = new Date();
                BigDecimal expnotpayamount = expObject.getBigDecimal("expnotpayamount");
                if (now.after(happendate) && expnotpayamount.compareTo(BigDecimal.ZERO) > 0) {
                    isoverpay = 49;
                    updateList.add(new Object[]{Character.valueOf((char)isoverpay), contractDyn.getLong("id")});
                }
                updateListexp.add(new Object[]{Character.valueOf((char)isoverpay), payprogress, expObject.getLong("id")});
                payprogress = BigDecimal.ZERO;
                isoverpay = 48;
            }
        }
        String updateabnSql = "update t_er_contractbill_s  set fabnormalpay = ?   where  fid = ? ";
        int abnormalpay = 48;
        BigDecimal nonpayamount = BigDecimal.ZERO;
        BigDecimal payedamount = BigDecimal.ZERO;
        BigDecimal applyamount = BigDecimal.ZERO;
        for (DynamicObject contractDyn : load) {
            String billstatus = (String)contractDyn.get("billstatus");
            if ("F".equals(billstatus)) {
                nonpayamount = contractDyn.getBigDecimal("nonpayamount");
                payedamount = contractDyn.getBigDecimal("payedamount");
                applyamount = contractDyn.getBigDecimal("applyamount");
                if (nonpayamount.add(payedamount).compareTo(applyamount) > 0) {
                    abnormalpay = 49;
                }
            }
            updateabnList.add(new Object[]{Character.valueOf((char)abnormalpay), contractDyn.getLong("id")});
            abnormalpay = 48;
        }
        if (!updateListexp.isEmpty()) {
            logger.info("\u5408\u540c\u4ed8\u6b3e\u9884\u8b66\u8c03\u5ea6\u66f4\u65b0\u5206\u5f55>>>>>>>>>>>>>updateListexp.size:" + updateListexp.size());
            DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)updateSqlexp, updateListexp);
        }
        if (!updateList.isEmpty()) {
            logger.info("\u5408\u540c\u4ed8\u6b3e\u9884\u8b66\u8c03\u5ea6\u66f4\u65b0\u5355\u5934>\u8d85\u671f\u5f85\u4ed8\u5b57\u6bb5>>>>>>>>>>>>updateList.size:" + updateList.size());
            DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)updateSql, updateList);
        }
        if (!updateabnList.isEmpty()) {
            logger.info("\u5408\u540c\u4ed8\u6b3e\u9884\u8b66\u8c03\u5ea6\u66f4\u65b0\u5355\u5934>>\u4ed8\u6b3e\u5f02\u5e38\u5b57\u6bb5>>>>>>>>>>>updateList.size:" + updateabnList.size());
            DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)updateabnSql, updateabnList);
        }
        logger.info("\u5408\u540c\u4ed8\u6b3e\u9884\u8b66\u8c03\u5ea6>>>>>>>>>>>>>end");
    }
}

