/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.task.tripboards;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.trip.task.tripboards.OrderSummaryTask;
import kd.fi.er.formplugin.web.tripboards.tripindex.financeindex.HotelDataProcessHandle;
import kd.fi.er.formplugin.web.tripboards.utils.TripBoardsUtil;

public class HotelSummary {
    private static final Log logger = LogFactory.getLog(HotelSummary.class);

    public void hotelSummary() {
        try {
            Date tmp;
            DynamicObjectCollection summary = QueryServiceHelper.query((String)"er_hotel_summary", (String)"max(summaryend) max", (QFilter[])new QFilter[0]);
            Date min = new Date();
            Date max = new Date();
            DynamicObjectCollection hotelDatas = QueryServiceHelper.query((String)"er_hotelbill", (String)"min(checkindate) min,max(checkindate) max", (QFilter[])new QFilter[0]);
            if (!hotelDatas.isEmpty()) {
                min = ((DynamicObject)hotelDatas.get(0)).getDate("min");
                max = ((DynamicObject)hotelDatas.get(0)).getDate("max");
            }
            if (!summary.isEmpty() && (tmp = ((DynamicObject)summary.get(0)).getDate("max")) != null) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(tmp);
                calendar.add(2, -3);
                min = calendar.getTime();
                DeleteServiceHelper.delete((String)"er_hotel_summary", (QFilter[])new QFilter[]{new QFilter("summaryend", "<=", (Object)max), new QFilter("summarystart", ">=", (Object)min)});
            }
            List<OrderSummaryTask.DateRange> dateRanges = OrderSummaryTask.getDateRanges(min, max);
            HotelDataProcessHandle dataProcessHandle = new HotelDataProcessHandle();
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"er_hotel_summary");
            for (OrderSummaryTask.DateRange dateRange : dateRanges) {
                QFilter timeFilter = new QFilter("checkindate", ">=", (Object)dateRange.startTime).and(new QFilter("checkindate", "<=", (Object)dateRange.endTime));
                DynamicObjectCollection hotelBillDatas = QueryServiceHelper.query((String)"er_hotelbill", (String)"totalamount,servicefee,unbookfee,expcommitcomnum,expcommitdepnum,sourcetravelerid,ordertype,cityname,checkindate,id", (QFilter[])new QFilter[]{timeFilter});
                if (hotelBillDatas.isEmpty()) continue;
                Map<Long, List<DynamicObject>> comGroup = hotelBillDatas.parallelStream().collect(Collectors.groupingBy(obj -> obj.getLong("expcommitcomnum")));
                Map<Long, List<DynamicObject>> depGroup = hotelBillDatas.parallelStream().collect(Collectors.groupingBy(obj -> obj.getLong("expcommitdepnum")));
                this.hotelDataCount(dateRange, comGroup, dataProcessHandle, type, "company");
                this.hotelDataCount(dateRange, depGroup, dataProcessHandle, type, "dept");
            }
        }
        catch (Exception ex) {
            logger.error("hotelSummary \u62a5\u9519", (Throwable)ex);
        }
    }

    private void hotelDataCount(OrderSummaryTask.DateRange dateRange, Map<Long, List<DynamicObject>> groupData, HotelDataProcessHandle dataProcessHandle, MainEntityType type, String orgType) {
        ArrayList needAdd = Lists.newArrayList();
        groupData.entrySet().parallelStream().forEach(entry -> {
            Long orgId = (Long)entry.getKey();
            List group = (List)entry.getValue();
            HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
            dataProcessHandle.dataDeal(resultMap, group, Boolean.FALSE);
            try {
                Set travelUserIdSet = group.parallelStream().filter(obj -> obj.get("sourcetravelerid") != null).map(obj -> obj.getLong("sourcetravelerid")).collect(Collectors.toSet());
                DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)type);
                dynamicObject.set("orgtype", (Object)orgType);
                dynamicObject.set("summaryamount", resultMap.getOrDefault("h_month_amount", BigDecimal.ZERO) == null ? BigDecimal.ZERO : resultMap.getOrDefault("h_month_amount", BigDecimal.ZERO));
                dynamicObject.set("ordernums", resultMap.get("h_order_nums") == null ? Integer.valueOf(0) : resultMap.get("h_order_nums"));
                dynamicObject.set("summaryrefundamount", resultMap.getOrDefault("h_refund_fee", BigDecimal.ZERO) == null ? BigDecimal.ZERO : resultMap.getOrDefault("h_refund_fee", BigDecimal.ZERO));
                dynamicObject.set("summaryservicefee", resultMap.getOrDefault("h_service_fee", BigDecimal.ZERO) == null ? BigDecimal.ZERO : resultMap.getOrDefault("h_service_fee", BigDecimal.ZERO));
                dynamicObject.set("summaryactivepeople", resultMap.getOrDefault("h_active_people", BigDecimal.ZERO) == null ? BigDecimal.ZERO : resultMap.getOrDefault("h_active_people", BigDecimal.ZERO));
                dynamicObject.set("orgid", (Object)orgId);
                dynamicObject.set("summarystart", (Object)TripBoardsUtil.converLocalDataToDate(dateRange.start));
                dynamicObject.set("summaryend", (Object)TripBoardsUtil.converLocalDataToDate(dateRange.end));
                List collect = travelUserIdSet.stream().map(String::valueOf).collect(Collectors.toList());
                dynamicObject.set("traveluser_tag", (Object)String.join((CharSequence)",", collect));
                JSONObject dataJson = new JSONObject();
                JSONArray orderNums = new JSONArray();
                for (DynamicObject order : group) {
                    long id = order.getLong("id");
                    BigDecimal totalamount = order.getBigDecimal("totalamount");
                    BigDecimal servicefee = order.getBigDecimal("servicefee");
                    BigDecimal endorsementamount = order.getBigDecimal("unbookfee");
                    String ordertype = order.getString("ordertype");
                    totalamount = totalamount == null ? BigDecimal.ZERO : totalamount;
                    servicefee = servicefee == null ? BigDecimal.ZERO : servicefee;
                    endorsementamount = endorsementamount == null ? BigDecimal.ZERO : endorsementamount;
                    ordertype = StringUtils.isEmail((String)ordertype) ? "O" : ordertype;
                    orderNums.add((Object)(id + "$" + totalamount + "$" + servicefee + "$" + endorsementamount + "$" + ordertype));
                }
                dataJson.put("orderNumsAndAmount", (Object)orderNums);
                dynamicObject.set("otherdatasummary_tag", (Object)dataJson);
                List list = needAdd;
                synchronized (list) {
                    needAdd.add(dynamicObject);
                }
            }
            catch (Exception ex) {
                logger.error("hotel\u62a5\u9519", (Throwable)ex);
            }
        });
        if (!needAdd.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])needAdd.toArray(new DynamicObject[0]));
        }
    }
}

