/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.task.tripboards;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.trip.supplier.ctrip.invoke.convert.ConvertUtil;
import kd.fi.er.business.trip.task.tripboards.OrderSummaryTask;
import kd.fi.er.formplugin.web.tripboards.dataprocesshandle.DataProcessHandle;
import kd.fi.er.formplugin.web.tripboards.tripindex.financeindex.PlaneDataProcessHandle;
import kd.fi.er.formplugin.web.tripboards.utils.TripBoardsUtil;
import org.apache.commons.lang3.StringUtils;

public class PlaneSummary {
    private static Log logger = LogFactory.getLog(PlaneSummary.class);

    public void planeSummary() {
        try {
            Result result = PlaneSummary.getResult();
            for (OrderSummaryTask.DateRange dateRange : result.dateRanges) {
                QFilter timeFilter = new QFilter("takeofftime", ">=", (Object)dateRange.startTime).and(new QFilter("takeofftime", "<=", (Object)dateRange.endTime));
                DynamicObjectCollection planeBillDatas = QueryServiceHelper.query((String)"er_planebill", (String)"parentordernum,server,totalamount,servicefee,endorsementamount,refundamount,expcommitcomnum,expcommitdepnum,ticketstatus,discount,sourcetravelerid,fromcityname,tocityname,takeofftime,ordertype,orderdate,airlinename,sourcetravelerid.name,ordernum,id", (QFilter[])new QFilter[]{timeFilter});
                if (planeBillDatas.isEmpty()) continue;
                Map<Long, List<DynamicObject>> comGroup = planeBillDatas.parallelStream().collect(Collectors.groupingBy(obj -> obj.getLong("expcommitcomnum")));
                Map<Long, List<DynamicObject>> depGroup = planeBillDatas.parallelStream().collect(Collectors.groupingBy(obj -> obj.getLong("expcommitdepnum")));
                ArrayList<String> alreadyCalcOrder = new ArrayList<String>(16);
                PlaneSummary.planeDataCount(dateRange, comGroup, (PlaneDataProcessHandle)result.dataProcessHandle, result.type, "company", alreadyCalcOrder);
                for (Map.Entry<Long, List<DynamicObject>> entry : comGroup.entrySet()) {
                    alreadyCalcOrder.addAll(entry.getValue().stream().map(dynamicObject -> dynamicObject.getString("ordernum")).collect(Collectors.toList()));
                }
                PlaneSummary.planeDataCount(dateRange, depGroup, (PlaneDataProcessHandle)result.dataProcessHandle, result.type, "dept", alreadyCalcOrder);
            }
        }
        catch (Exception ex) {
            logger.error("planeSummary \u62a5\u9519", (Throwable)ex);
        }
    }

    private static void planeDataCount(OrderSummaryTask.DateRange dateRange, Map<Long, List<DynamicObject>> groupData, PlaneDataProcessHandle dataProcessHandle, MainEntityType type, String orgType, List<String> alreadyCalcOrder) {
        ArrayList needAdd = Lists.newArrayList();
        List<String> ticketStatus = Arrays.asList("USED", "UNUSED", "CHANGED");
        groupData.entrySet().parallelStream().forEach(entry -> {
            Long orgId = (Long)entry.getKey();
            List group = (List)entry.getValue();
            HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
            dataProcessHandle.dataDeal(resultMap, group, Boolean.FALSE);
            try {
                Set travelUserIdSet = group.parallelStream().filter(obj -> obj.get("sourcetravelerid") != null).map(obj -> obj.getLong("sourcetravelerid")).collect(Collectors.toSet());
                DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)type);
                dynamicObject.set("orgtype", (Object)orgType);
                List<Object> discounts = new ArrayList(16);
                discounts = group.parallelStream().filter(obj -> obj.get("totalamount") != null && obj.get("discount") != null && Arrays.asList("UNUSED", "USED").contains(obj.getString("ticketstatus")) && obj.getBigDecimal("totalamount").compareTo(ConvertUtil.getOrderAmountInit()) != 0).map(obj -> obj.getBigDecimal("discount")).collect(Collectors.toList());
                dynamicObject.set("summarydiscount", (Object)(discounts.isEmpty() ? BigDecimal.ZERO : discounts.stream().reduce(BigDecimal.ZERO, BigDecimal::add)));
                dynamicObject.set("summaryamount", resultMap.getOrDefault("p_month_amount", BigDecimal.ZERO) == null ? BigDecimal.ZERO : resultMap.getOrDefault("p_month_amount", BigDecimal.ZERO));
                dynamicObject.set("ordernums", resultMap.get("p_order_nums") == null ? Integer.valueOf(0) : resultMap.get("p_order_nums"));
                dynamicObject.set("summarychangeamount", resultMap.getOrDefault("p_changes_fee", BigDecimal.ZERO) == null ? BigDecimal.ZERO : resultMap.getOrDefault("p_changes_fee", BigDecimal.ZERO));
                dynamicObject.set("summaryrefundamount", resultMap.getOrDefault("p_refund_fee", BigDecimal.ZERO) == null ? BigDecimal.ZERO : resultMap.getOrDefault("p_refund_fee", BigDecimal.ZERO));
                dynamicObject.set("summaryservicefee", resultMap.getOrDefault("p_service_fee", BigDecimal.ZERO) == null ? BigDecimal.ZERO : resultMap.getOrDefault("p_service_fee", BigDecimal.ZERO));
                dynamicObject.set("orgid", (Object)orgId);
                dynamicObject.set("summarystart", (Object)TripBoardsUtil.converLocalDataToDate(dateRange.start));
                dynamicObject.set("summaryend", (Object)TripBoardsUtil.converLocalDataToDate(dateRange.end));
                List collect = travelUserIdSet.stream().map(String::valueOf).collect(Collectors.toList());
                dynamicObject.set("traveluser_tag", (Object)String.join((CharSequence)",", collect));
                JSONObject dataJson = new JSONObject();
                SimpleDateFormat format = new SimpleDateFormat("HH:mm");
                JSONArray orderNums = new JSONArray();
                for (DynamicObject order : group) {
                    try {
                        long id = order.getLong("id");
                        BigDecimal totalamount = order.getBigDecimal("totalamount");
                        BigDecimal servicefee = order.getBigDecimal("servicefee");
                        BigDecimal endorsementamount = order.getBigDecimal("endorsementamount");
                        BigDecimal refundamount = order.getBigDecimal("refundamount");
                        Date takeOffTime = order.getDate("takeofftime");
                        String ticketstatus = order.getString("ticketstatus");
                        String orderType = order.getString("ordertype");
                        totalamount = totalamount == null ? BigDecimal.ZERO : totalamount;
                        servicefee = servicefee == null ? BigDecimal.ZERO : servicefee;
                        endorsementamount = endorsementamount == null ? BigDecimal.ZERO : endorsementamount;
                        refundamount = refundamount == null ? BigDecimal.ZERO : refundamount;
                        ticketstatus = StringUtils.isEmpty((CharSequence)"ticketstatus") ? "USED" : ticketstatus;
                        String timePeriod = PlaneSummary.getTimePeriod(format.format(takeOffTime));
                        BigDecimal disCount = order.getBigDecimal("discount");
                        int days = PlaneSummary.calculateAdvanceBookingDays(order.getDate("orderdate"), order.getDate("takeofftime"));
                        String advanceBookingPeriod = PlaneSummary.getAdvanceBookingPeriod(days);
                        if ("XIECHENG".equals(order.getString("server")) && disCount.compareTo(BigDecimal.ZERO) > 0 && disCount.compareTo(BigDecimal.ONE) < 0) {
                            disCount = disCount.multiply(new BigDecimal(100));
                        }
                        String importantValue = id + "$" + totalamount + "$" + servicefee + "$" + endorsementamount + "$" + refundamount + "$" + ticketstatus + "$" + orderType + "$" + timePeriod + "$" + disCount + "$" + days + "$" + advanceBookingPeriod + "$" + order.getString("airlinename");
                        orderNums.add((Object)importantValue);
                    }
                    catch (Exception ex) {
                        logger.error("\u5185\u90e8\u5faa\u73af\u62a5\u9519 \u786e\u4fdd\u4e0d\u4f1a\u4e2d\u65ad\u6574\u7ec4\u6570\u636e:", (Throwable)ex);
                    }
                }
                dataJson.put("orderNumsAndAmount", (Object)orderNums);
                List originOrder = group.stream().filter(planebill -> "O".equals(planebill.getString("ordertype")) && planebill.getBigDecimal("totalamount").compareTo(ConvertUtil.getOrderAmountInit()) != 0).collect(Collectors.toList());
                JSONObject takeoffTimeSpreadJson = new JSONObject();
                group.forEach(planebill -> {
                    Date takeOffTime = planebill.getDate("takeofftime");
                    String timePeriod = PlaneSummary.getTimePeriod(format.format(takeOffTime));
                    if (StringUtils.isEmpty((CharSequence)timePeriod)) {
                        return;
                    }
                    if (takeoffTimeSpreadJson.containsKey((Object)timePeriod)) {
                        Integer count = takeoffTimeSpreadJson.getInteger(timePeriod);
                        count = count + 1;
                        takeoffTimeSpreadJson.put(timePeriod, (Object)count);
                    } else {
                        takeoffTimeSpreadJson.put(timePeriod, (Object)1);
                    }
                });
                dataJson.put("takeofftime", (Object)takeoffTimeSpreadJson);
                List<DynamicObject> billData = group.stream().filter(planebill -> ticketStatus.contains(planebill.getString("ticketstatus")) && planebill.getBigDecimal("totalamount").compareTo(ConvertUtil.getOrderAmountInit()) != 0).collect(Collectors.toList());
                BigDecimal[] totalDiscount = new BigDecimal[]{BigDecimal.ZERO};
                billData.forEach(planebill -> {
                    if ("XIECHENG".equals(planebill.getString("server"))) {
                        BigDecimal ctripDiscount = planebill.getBigDecimal("discount");
                        if (ctripDiscount.compareTo(BigDecimal.ZERO) > 0 && ctripDiscount.compareTo(BigDecimal.ONE) < 0) {
                            totalDiscount[0] = totalDiscount[0].add(ctripDiscount.multiply(new BigDecimal(100)));
                        }
                    } else {
                        totalDiscount[0] = totalDiscount[0].add(planebill.getBigDecimal("discount"));
                    }
                });
                int[] totalDays = new int[]{0};
                billData.forEach(planebill -> {
                    int days = PlaneSummary.calculateAdvanceBookingDays(planebill.getDate("orderdate"), planebill.getDate("takeofftime"));
                    totalDays[0] = Integer.sum(days, totalDays[0]);
                });
                JSONArray fullTicketJsonArray = new JSONArray();
                billData.forEach(planebill -> {
                    BigDecimal ticketDiscount = planebill.getBigDecimal("discount");
                    if (ticketDiscount == null) {
                        return;
                    }
                    if (new BigDecimal(100).compareTo(ticketDiscount) >= 0 && new BigDecimal(70).compareTo(ticketDiscount) <= 0) {
                        JSONObject fullTicketJson = new JSONObject();
                        fullTicketJson.put("userName", (Object)planebill.getString("sourcetravelerid.name"));
                        fullTicketJson.put("orderAmount", (Object)planebill.getBigDecimal("totalamount"));
                        fullTicketJson.put("orderNum", (Object)planebill.getString("ordernum"));
                        fullTicketJson.put("lines", (Object)(planebill.getString("fromcityname") + "-" + planebill.getString("tocityname")));
                        fullTicketJson.put("discount", (Object)ticketDiscount);
                        fullTicketJsonArray.add((Object)fullTicketJson);
                    }
                });
                dataJson.put("fullticket", (Object)fullTicketJsonArray);
                JSONObject deptRankChangeAndRefundJson = new JSONObject();
                List fitOrders = group.stream().filter(plane -> ("G".equals(plane.getString("ordertype")) || "T".equals(plane.getString("ordertype"))) && plane.getBigDecimal("totalamount").compareTo(ConvertUtil.getOrderAmountInit()) != 0).map(obj -> obj.getString("parentordernum") + obj.getString("sourcetravelerid.name")).collect(Collectors.toList());
                deptRankChangeAndRefundJson.put("changeAndRefundOrderNums", (Object)fitOrders.size());
                deptRankChangeAndRefundJson.put("changeAndRefundOrderRate", (Object)(originOrder.isEmpty() ? Integer.valueOf(0) : new BigDecimal(fitOrders.size()).divide(new BigDecimal(originOrder.size()), 2, RoundingMode.HALF_UP)));
                dataJson.put("deptrank-changeAndRefund", (Object)deptRankChangeAndRefundJson);
                JSONObject deptRankAverageDiscount = new JSONObject();
                deptRankAverageDiscount.put("averageDiscount", (Object)(billData.isEmpty() ? Integer.valueOf(0) : totalDiscount[0].divide(new BigDecimal(billData.size()), 2, RoundingMode.HALF_UP)));
                dataJson.put("deptrank-averageDiscount", (Object)deptRankAverageDiscount);
                JSONObject deptRankAdvanceBookingDays = new JSONObject();
                deptRankAdvanceBookingDays.put("bookinadvancedays", (Object)(billData.isEmpty() ? Integer.valueOf(0) : new BigDecimal(totalDays[0]).divide(new BigDecimal(billData.size()), 2, RoundingMode.HALF_UP)));
                dataJson.put("deptrank-bookinadvancedays", (Object)deptRankAdvanceBookingDays);
                dynamicObject.set("otherdatasummary_tag", (Object)dataJson);
                List list = needAdd;
                synchronized (list) {
                    needAdd.add(dynamicObject);
                }
            }
            catch (Exception ex) {
                logger.error("plane\u62a5\u9519", (Throwable)ex);
            }
        });
        if (!needAdd.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])needAdd.toArray(new DynamicObject[0]));
        }
    }

    public static int calculateAdvanceBookingDays(Date bookingDate, Date departureDate) {
        if (bookingDate == null || departureDate == null) {
            return -1;
        }
        LocalDateTime bookingTime = bookingDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        LocalDateTime departureTime = departureDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        long hoursBetween = ChronoUnit.HOURS.between(bookingTime, departureTime);
        int daysBetween = (int)(hoursBetween / 24L);
        if (hoursBetween % 24L != 0L) {
            ++daysBetween;
        }
        return daysBetween;
    }

    public static String getAdvanceBookingPeriod(int days) {
        if (days <= 1) {
            return "0-1";
        }
        if (days <= 2) {
            return "1-2";
        }
        if (days <= 3) {
            return "2-3";
        }
        return days - 1 + "-" + days;
    }

    public static String getTimePeriod(String timeString) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm");
        LocalTime time = LocalTime.parse(timeString, formatter);
        LocalTime[] timePeriods = new LocalTime[]{LocalTime.of(0, 0), LocalTime.of(4, 0), LocalTime.of(8, 0), LocalTime.of(12, 0), LocalTime.of(16, 0), LocalTime.of(20, 0), LocalTime.of(23, 59, 59)};
        for (int i = 0; i < timePeriods.length - 1; ++i) {
            if (time.isBefore(timePeriods[i]) || !time.isBefore(timePeriods[i + 1])) continue;
            return PlaneSummary.formatPeriod(timePeriods[i], timePeriods[i + 1]);
        }
        return "";
    }

    private static String formatPeriod(LocalTime start, LocalTime end) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm");
        return formatter.format(start) + " - " + formatter.format(end);
    }

    private static Result getResult() {
        Date tmp;
        DynamicObjectCollection summary = QueryServiceHelper.query((String)"er_plane_summary", (String)"max(summaryend) max", (QFilter[])new QFilter[0]);
        DynamicObjectCollection planeDatas = QueryServiceHelper.query((String)"er_planebill", (String)"min(takeofftime) min,max(takeofftime) max", (QFilter[])new QFilter[0]);
        Date min = new Date();
        Date max = new Date();
        if (!planeDatas.isEmpty()) {
            min = ((DynamicObject)planeDatas.get(0)).getDate("min");
            max = ((DynamicObject)planeDatas.get(0)).getDate("max");
        }
        if (!summary.isEmpty() && (tmp = ((DynamicObject)summary.get(0)).getDate("max")) != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(tmp);
            calendar.add(2, -3);
            min = calendar.getTime();
            DeleteServiceHelper.delete((String)"er_plane_summary", (QFilter[])new QFilter[]{new QFilter("summaryend", "<=", (Object)max), new QFilter("summarystart", ">=", (Object)min)});
        }
        List<OrderSummaryTask.DateRange> dateRanges = OrderSummaryTask.getDateRanges(min, max);
        PlaneDataProcessHandle dataProcessHandle = new PlaneDataProcessHandle();
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"er_plane_summary");
        return new Result(dateRanges, dataProcessHandle, type);
    }

    private static class Result {
        public final List<OrderSummaryTask.DateRange> dateRanges;
        public final DataProcessHandle dataProcessHandle;
        public final MainEntityType type;

        public Result(List<OrderSummaryTask.DateRange> dateRanges, DataProcessHandle dataProcessHandle, MainEntityType type) {
            this.dateRanges = dateRanges;
            this.dataProcessHandle = dataProcessHandle;
            this.type = type;
        }
    }
}

