/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.task.tripboards;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.trip.task.tripboards.OrderSummaryTask;
import kd.fi.er.formplugin.web.tripboards.tripindex.financeindex.TrainDataProcessHandle;
import kd.fi.er.formplugin.web.tripboards.utils.TripBoardsUtil;

public class TrainSummary {
    private static final Log logger = LogFactory.getLog(TrainSummary.class);

    public void trainSummary() {
        try {
            Date tmp;
            DynamicObjectCollection summary = QueryServiceHelper.query((String)"er_train_summary", (String)"max(summaryend) max", (QFilter[])new QFilter[0]);
            Date min = new Date();
            Date max = new Date();
            DynamicObjectCollection trainDatas = QueryServiceHelper.query((String)"er_trainbill", (String)"min(departtime) min,max(departtime) max", (QFilter[])new QFilter[0]);
            if (!trainDatas.isEmpty()) {
                min = ((DynamicObject)trainDatas.get(0)).getDate("min");
                max = ((DynamicObject)trainDatas.get(0)).getDate("max");
            }
            if (!summary.isEmpty() && (tmp = ((DynamicObject)summary.get(0)).getDate("max")) != null) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(tmp);
                calendar.add(2, -3);
                min = calendar.getTime();
                DeleteServiceHelper.delete((String)"er_train_summary", (QFilter[])new QFilter[]{new QFilter("summaryend", "<=", (Object)max), new QFilter("summarystart", ">=", (Object)min)});
            }
            List<OrderSummaryTask.DateRange> dateRanges = OrderSummaryTask.getDateRanges(min, max);
            TrainDataProcessHandle dataProcessHandle = new TrainDataProcessHandle();
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"er_train_summary");
            for (OrderSummaryTask.DateRange dateRange : dateRanges) {
                QFilter timeFilter = new QFilter("departtime", ">=", (Object)dateRange.startTime).and(new QFilter("departtime", "<=", (Object)dateRange.endTime));
                DynamicObjectCollection trainBillDatas = QueryServiceHelper.query((String)"er_trainbill", (String)"totalamount,servicefee,passeger,expcommitcomnum,expcommitdepnum,ordertype,refundamount,departtime,arrivecity,id", (QFilter[])new QFilter[]{timeFilter});
                if (trainBillDatas.isEmpty()) continue;
                Map<Long, List<DynamicObject>> comGroup = trainBillDatas.parallelStream().collect(Collectors.groupingBy(obj -> obj.getLong("expcommitcomnum")));
                Map<Long, List<DynamicObject>> depGroup = trainBillDatas.parallelStream().collect(Collectors.groupingBy(obj -> obj.getLong("expcommitdepnum")));
                this.trainDataCount(dateRange, comGroup, dataProcessHandle, type, "company");
                this.trainDataCount(dateRange, depGroup, dataProcessHandle, type, "dept");
            }
        }
        catch (Exception ex) {
            logger.error("trainSummary \u62a5\u9519", (Throwable)ex);
        }
    }

    private void trainDataCount(OrderSummaryTask.DateRange dateRange, Map<Long, List<DynamicObject>> groupData, TrainDataProcessHandle dataProcessHandle, MainEntityType type, String orgType) {
        ArrayList needAdd = Lists.newArrayList();
        groupData.entrySet().parallelStream().forEach(entry -> {
            Long orgId = (Long)entry.getKey();
            List group = (List)entry.getValue();
            HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
            dataProcessHandle.dataDeal(resultMap, group, Boolean.FALSE);
            try {
                Set travelUserIdSet = group.parallelStream().filter(obj -> obj.get("passeger") != null).map(obj -> obj.getLong("passeger")).collect(Collectors.toSet());
                DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)type);
                dynamicObject.set("orgtype", (Object)orgType);
                dynamicObject.set("summaryamount", resultMap.getOrDefault("t_month_amount", BigDecimal.ZERO) == null ? BigDecimal.ZERO : resultMap.getOrDefault("t_month_amount", BigDecimal.ZERO));
                dynamicObject.set("ordernums", resultMap.get("t_order_nums") == null ? Integer.valueOf(0) : resultMap.get("t_order_nums"));
                dynamicObject.set("summaryrefundamount", resultMap.getOrDefault("t_refund_fee", BigDecimal.ZERO) == null ? BigDecimal.ZERO : resultMap.getOrDefault("t_refund_fee", BigDecimal.ZERO));
                dynamicObject.set("summaryservicefee", resultMap.getOrDefault("t_service_fee", BigDecimal.ZERO) == null ? BigDecimal.ZERO : resultMap.getOrDefault("t_service_fee", BigDecimal.ZERO));
                dynamicObject.set("summaryactivepeople", resultMap.getOrDefault("t_active_people", BigDecimal.ZERO) == null ? BigDecimal.ZERO : resultMap.getOrDefault("t_active_people", BigDecimal.ZERO));
                dynamicObject.set("orgid", (Object)orgId);
                dynamicObject.set("summarystart", (Object)TripBoardsUtil.converLocalDataToDate(dateRange.start));
                dynamicObject.set("summaryend", (Object)TripBoardsUtil.converLocalDataToDate(dateRange.end));
                List collect = travelUserIdSet.stream().map(String::valueOf).collect(Collectors.toList());
                dynamicObject.set("traveluser_tag", (Object)String.join((CharSequence)",", collect));
                JSONObject dataJson = new JSONObject();
                JSONArray orderNums = new JSONArray();
                for (DynamicObject order : group) {
                    long id = order.getLong("id");
                    BigDecimal totalamount = order.getBigDecimal("totalamount");
                    BigDecimal servicefee = order.getBigDecimal("servicefee");
                    BigDecimal endorsementamount = order.getBigDecimal("refundamount");
                    String ordertype = order.getString("ordertype");
                    totalamount = totalamount == null ? BigDecimal.ZERO : totalamount;
                    servicefee = servicefee == null ? BigDecimal.ZERO : servicefee;
                    endorsementamount = endorsementamount == null ? BigDecimal.ZERO : endorsementamount;
                    ordertype = StringUtils.isEmail((String)ordertype) ? "O" : ordertype;
                    orderNums.add((Object)(id + "$" + totalamount + "$" + servicefee + "$" + endorsementamount + "$" + ordertype));
                }
                dataJson.put("orderNumsAndAmount", (Object)orderNums);
                dynamicObject.set("otherdatasummary_tag", (Object)dataJson);
                List list = needAdd;
                synchronized (list) {
                    needAdd.add(dynamicObject);
                }
            }
            catch (Exception ex) {
                logger.error("train\u62a5\u9519", (Throwable)ex);
            }
        });
        if (!needAdd.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])needAdd.toArray(new DynamicObject[0]));
        }
    }
}

