/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.util;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.trip.annotation.KDTripField;

public class TripFieldSetValueUtil {
    private static final Log logger = LogFactory.getLog(TripFieldSetValueUtil.class);
    private static final TripFieldSetValueUtil util = new TripFieldSetValueUtil();

    private TripFieldSetValueUtil() {
    }

    public static TripFieldSetValueUtil getInstance() {
        return util;
    }

    public void HandleAllClassField(DynamicObject orderDynamic, Object orderModel, Class<?> orderModelClass) {
        Class<?> parentClass = orderModelClass.getSuperclass();
        if (!"Object".equals(parentClass.getSimpleName())) {
            this.HandleAllClassField(orderDynamic, orderModel, parentClass);
        }
        Field[] fields = orderModelClass.getDeclaredFields();
        this.handleFieldValue(orderDynamic, orderModel, fields);
    }

    private void handleFieldValue(DynamicObject orderDynamic, Object orderModel, Field[] fields) {
        Stream.of(fields).forEach(field -> {
            if (field.isSynthetic()) {
                return;
            }
            KDTripField fieldAnnotation = field.getAnnotation(KDTripField.class);
            boolean ignore = false;
            String fieldName = field.getName().toLowerCase();
            try {
                if (fieldAnnotation != null) {
                    if (null != fieldAnnotation.name() && !"".equals(fieldAnnotation.name())) {
                        fieldName = fieldAnnotation.name();
                    }
                    ignore = fieldAnnotation.ignore();
                }
                field.setAccessible(true);
                Object orderModelFieldVaule = field.get(orderModel);
                if ("extPropMap".equalsIgnoreCase(fieldName)) {
                    Map extPropMap = (Map)orderModelFieldVaule;
                    if (extPropMap == null || extPropMap.size() < 1) {
                        return;
                    }
                    extPropMap.forEach((k, v) -> orderDynamic.set(k, v));
                    return;
                }
                if (!ignore && orderModelFieldVaule != null) {
                    orderDynamic.set(fieldName, orderModelFieldVaule);
                }
            }
            catch (IllegalArgumentException e) {
                logger.error("\u5546\u65c5\u96c6\u6210,model\u8f6c\u6210dynamicobject\u5931\u8d251:" + e);
            }
            catch (IllegalAccessException e) {
                logger.error("\u5546\u65c5\u96c6\u6210,model\u8f6c\u6210dynamicobject\u5931\u8d252:" + e);
            }
        });
    }
}

