/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.util;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSObject;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.trip.util.SyncUserTypeEnum;
import kd.fi.er.business.trip.util.TripCommonUtil;

@KSObject
public class UserHelper {
    private static Log logger = LogFactory.getLog(UserHelper.class);
    public static final String entityID_user = "bos_user";
    public static final String entityID_userposition = "bos_userposition";
    public static final String entityID_userChange = "bos_userchange";
    public static final String entityID_uitheme = "bas_uitheme";
    public static final String entityID_useruitheme = "bas_useruitheme";
    public static final String USER = "user";
    public static final String ORG = "org";
    public static final String cacheKey = "userservice";
    public static final String ENTITY_BIZPARTNERUSER = "bos_bizpartneruser";
    public static final int ENERGY_ORANGE_COLOR_ID = 1;

    public static Integer getCountByTime(Date changetime, Map<String, Object> map) {
        QFilter changeTimeFilter = new QFilter("changetime", ">=", (Object)changetime);
        QFilter[] filters = new QFilter[]{changeTimeFilter};
        QFilter qFilter = UserHelper.getQfilter(USER, map);
        if (UserHelper.getSyncType(map) == SyncUserTypeEnum.SYNC_BY_ORG && qFilter == null) {
            return 0;
        }
        if (UserHelper.getSyncType(map) != SyncUserTypeEnum.SYNC_BY_INCREMENT) {
            filters = new QFilter[]{qFilter};
        }
        ORM orm = ORM.create();
        return orm.count("kd.fi.er.business.trip.util.UserHelper.getCountByTime", entityID_userChange, filters);
    }

    public static List<Map<String, Object>> getUserInfosByTimeNew(Integer pageIndex, Integer pageSize, Date changetime, Map<String, Object> paramMap) {
        Long start = System.currentTimeMillis();
        SyncUserTypeEnum userTypeEnum = UserHelper.getSyncType(paramMap);
        QFilter qFilter = null;
        Boolean deleteflag = (Boolean)paramMap.getOrDefault("deleteflag", false);
        if (userTypeEnum == SyncUserTypeEnum.SYNC_BY_USER) {
            qFilter = deleteflag.booleanValue() ? UserHelper.getQfilterNew(USER, paramMap) : UserHelper.getQfilterNew("id", paramMap);
        } else {
            if (userTypeEnum == SyncUserTypeEnum.SYNC_BY_ORG && paramMap.get("orgList") instanceof List) {
                List list = (List)paramMap.get("orgList");
                ArrayList dateList = new ArrayList();
                for (Map longDateMap : list) {
                    longDateMap.values().stream().filter(Objects::nonNull).forEach(dateList::add);
                }
                changetime = dateList.stream().filter(Objects::nonNull).min(Comparator.comparing(v -> v)).orElse(changetime);
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(changetime);
            int subAccount = (Integer)paramMap.getOrDefault("params_sbaccount", 0);
            if (subAccount > 0) {
                cal.add(5, -subAccount);
            }
            cal.add(5, -1);
            QFilter timeFilter = new QFilter("modifytime", ">=", (Object)cal.getTime());
            qFilter = UserHelper.getQfilterNew("entryentity.dpt.id", paramMap);
            if (null == qFilter) {
                qFilter = timeFilter;
            } else {
                qFilter.and(timeFilter);
            }
        }
        String selectFields = "id ,gender,disabledate,fuid,number,name,phone,email,enable,entryentity.dpt.id dpt,entryentity.dpt.number dptnumber,entryentity.dpt.name dptname, country.name country,modifytime,isforbidden,entryentity.superior.number supernumber";
        String entryname = entityID_user;
        QFilter userTypeFilter = new QFilter("usertypes.fbasedataid", "in", (Object)1);
        QFilter ispartjobFilter = new QFilter("entryentity.ispartjob", "=", (Object)"0");
        ispartjobFilter = ispartjobFilter.or(QFilter.isNull((String)"entryentity.ispartjob"));
        QFilter[] filters = new QFilter[]{qFilter, userTypeFilter, ispartjobFilter};
        ORM orm = ORM.create();
        DataSet dataSet = orm.queryDataSet("kd.fi.er.business.trip.util.UserHelper.getUserInfosByTimeNew", entryname, selectFields, filters, "id", UserHelper.getStart(pageIndex, pageSize).intValue(), pageSize.intValue());
        ArrayList<Long> userIds = new ArrayList<Long>();
        ArrayList<Map<String, Object>> userMapList = new ArrayList<Map<String, Object>>();
        HashMap<String, Long> orgCompanyMap = new HashMap<String, Long>();
        HashMap<String, Long> orgCostCompanyMap = new HashMap<String, Long>();
        try {
            Iterator iterator = dataSet.iterator();
            if (dataSet.hasNext()) {
                paramMap.put("isover", false);
            } else {
                paramMap.put("isover", true);
            }
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                Long userId = 0L;
                userId = deleteflag != false ? row.getLong(USER) : row.getLong("id");
                if (userIds.contains(userId)) continue;
                userIds.add(userId);
                if (deleteflag.booleanValue() && QueryServiceHelper.exists((String)entityID_user, (Object)userId)) continue;
                HashMap<String, Object> baseMap = new HashMap<String, Object>(20);
                baseMap.put("id", userId);
                baseMap.put("number", row.getString("number"));
                baseMap.put("name", row.getString("name"));
                baseMap.put("phone", row.getString("phone"));
                baseMap.put("email", row.getString("email"));
                baseMap.put("country", row.getString("country"));
                baseMap.put("gender", row.getString("gender"));
                baseMap.put("dptId", row.getString("dpt"));
                baseMap.put("dptName", row.getString("dptname"));
                baseMap.put("dptNumber", row.getString("dptnumber"));
                baseMap.put("enable", row.getString("enable"));
                baseMap.put("isforbidden", row.getString("isforbidden"));
                baseMap.put("supernumber", row.getString("supernumber"));
                Long companyId = (Long)orgCompanyMap.get(row.getString("dpt"));
                if (companyId == null) {
                    companyId = CoreBaseBillServiceHelper.initCompanyByDept(row.getLong("dpt"));
                }
                if (companyId != null) {
                    baseMap.put("companyId", companyId);
                }
                orgCompanyMap.put(row.getString("dpt"), companyId);
                Long costcompanyId = (Long)orgCostCompanyMap.get(row.getString("dpt"));
                if (costcompanyId == null) {
                    costcompanyId = CoreBaseBillServiceHelper.getAccountOrgId(row.getLong("dpt"));
                }
                if (costcompanyId != null) {
                    baseMap.put("costCompanyId", costcompanyId);
                }
                orgCostCompanyMap.put(row.getString("dpt"), costcompanyId);
                baseMap.put("deleteflag", deleteflag);
                baseMap.put("modifytime", row.getDate("modifytime"));
                userMapList.add(baseMap);
            }
            logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u67e5\u8be2\u4eba\u5458\uff0c\u8bb0\u5f55 \u67e5\u8be2\u6570\u91cf\uff1a{}", (Object)userMapList.size());
        }
        catch (KDBizException e) {
            throw new KDBizException(new ErrorCode("500", ResManager.loadKDString((String)"\u4eba\u5458\u83b7\u53d6\u5931\u8d25\u3002", (String)"userHelper_01", (String)"fi-er-business", (Object[])new Object[0])), new Object[0]);
        }
        finally {
            if (dataSet != null) {
                dataSet.close();
            }
        }
        logger.info("kd.fi.er.business.trip.util.UserHelper.getUserInfosByTimeNew bytime \u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
        logger.info("kd.fi.er.business.trip.util.UserHelper.getUserInfosByTimeNew \u5546\u65c5\u96c6\u6210\uff0c\u67e5\u8be2\u4eba\u5458\uff0c\u589e\u91cf\u4eba\u5458\u6570\u91cf\uff1a{}", (Object)userMapList.size());
        return userMapList;
    }

    public static List<Map<String, Object>> getUserChangeInfosByTime(Integer pageIndex, Integer pageSize, Date changetime, Map<String, Object> paramMap) {
        Long start = System.currentTimeMillis();
        boolean includeDptAdmin = true;
        boolean includeCompany = true;
        ArrayList<Map<String, Object>> userChangeList = new ArrayList<Map<String, Object>>();
        String selectChangeFields = "id,type,user,changetime";
        Calendar cal = Calendar.getInstance();
        cal.setTime(changetime);
        int subAccount = (Integer)paramMap.getOrDefault("params_sbaccount", 0);
        if (subAccount > 0) {
            cal.add(5, -subAccount);
        }
        cal.add(5, -1);
        QFilter changeTimeFilter = new QFilter("changetime", ">=", (Object)cal.getTime());
        QFilter[] filters = new QFilter[]{changeTimeFilter};
        QFilter qFilter = UserHelper.getQfilter(USER, paramMap);
        if (UserHelper.getSyncType(paramMap) == SyncUserTypeEnum.SYNC_BY_ORG && qFilter == null) {
            return new ArrayList<Map<String, Object>>();
        }
        if (UserHelper.getSyncType(paramMap) != SyncUserTypeEnum.SYNC_BY_INCREMENT) {
            filters = new QFilter[]{qFilter};
        }
        HashSet<Long> changeUserIds = new HashSet<Long>();
        LinkedHashMap<Long, Map<String, Object>> changeInfoMap = new LinkedHashMap<Long, Map<String, Object>>();
        ORM orm = ORM.create();
        try (DataSet dataSet = orm.queryDataSet("kd.fi.er.business.trip.util.UserHelper.getUserChangeInfosByTime", entityID_userChange, selectChangeFields, filters, "changetime", UserHelper.getStart(pageIndex, pageSize).intValue(), pageSize.intValue());){
            for (Row row : dataSet) {
                long id = row.getLong("id");
                long userId = row.getLong(USER);
                changeUserIds.add(userId);
                HashMap<String, Object> allUserInfoMap = new HashMap<String, Object>();
                allUserInfoMap.put("id", id);
                allUserInfoMap.put(USER, userId);
                allUserInfoMap.put("type", row.get("type"));
                allUserInfoMap.put("changetime", row.get("changetime"));
                changeInfoMap.put(id, allUserInfoMap);
            }
        }
        logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u67e5\u8be2\u4eba\u5458\uff0c\u589e\u91cf\u64cd\u4f5c\u8bb0\u5f55\u67e5\u8be2\u6570\u91cf\uff1a{}", (Object)changeInfoMap.size());
        return UserHelper.getList(pageIndex, pageSize, start, includeDptAdmin, includeCompany, userChangeList, changeUserIds, changeInfoMap);
    }

    private static void genUserChangeInfo(List<Map<String, Object>> userChangeList, Map<Long, Map<String, Object>> changeInfoMap, Map<Long, Map<String, Object>> allUserInfoMap) {
        Map<String, Object> userInfoMap = null;
        HashMap<String, Object> userChangeInfoMap = null;
        for (Map.Entry<Long, Map<String, Object>> changeEntry : changeInfoMap.entrySet()) {
            Map<String, Object> changeRow = changeEntry.getValue();
            userChangeInfoMap = new HashMap<String, Object>();
            userChangeInfoMap.put("id", changeRow.get(USER));
            userChangeInfoMap.put("type", changeRow.get("type"));
            userChangeInfoMap.put("changetime", changeRow.get("changetime"));
            long userId = Long.parseLong(changeRow.get(USER).toString());
            userInfoMap = allUserInfoMap.get(userId);
            if (userInfoMap == null) continue;
            userChangeInfoMap.putAll(userInfoMap);
            userChangeList.add(userChangeInfoMap);
        }
    }

    private static Map<String, Object> genChangedUserInfo(Row userRow, Map<Long, Map<String, Object>> dptChargerMap, Map<Long, Map<String, Object>> orgCompanyMap, boolean includeDptAdmin, boolean includeCompany) {
        HashMap<String, Object> userChangeInfoMap = new HashMap<String, Object>();
        if (userRow != null) {
            userChangeInfoMap.put("uid", userRow.getString("fuid"));
            userChangeInfoMap.put("number", userRow.getString("number"));
            userChangeInfoMap.put("name", userRow.getString("name"));
            userChangeInfoMap.put("phone", userRow.getString("phone"));
            userChangeInfoMap.put("email", userRow.getString("email"));
            userChangeInfoMap.put("country", userRow.getString("country"));
            userChangeInfoMap.put("supernumber", userRow.getString("supernumber"));
            UserHelper.genUserChangeDeptInfo(userChangeInfoMap, userRow, dptChargerMap, orgCompanyMap, includeDptAdmin, includeCompany);
        }
        return userChangeInfoMap;
    }

    private static void genUserChangeDeptInfo(Map<String, Object> mapUser, Row row, Map<Long, Map<String, Object>> dptChargerMap, Map<Long, Map<String, Object>> orgCompanyMap, boolean includeDptAdmin, boolean includeCompany) {
        long dptId = row.getLong("dpt");
        if (dptId != 0L) {
            Map<String, Object> charger;
            mapUser.put("dptId", dptId);
            mapUser.put("dpt", row.getString("dptname"));
            if (includeDptAdmin && (charger = dptChargerMap.get(dptId)) != null) {
                mapUser.put("chargerName", charger.get("name"));
                mapUser.put("chargerNumber", charger.get("number"));
            }
            if (includeCompany) {
                HashMap company = orgCompanyMap.get(dptId);
                if (company == null) {
                    company = OrgUnitServiceHelper.getCompanyfromOrg((Long)dptId);
                }
                if (company != null && !company.isEmpty()) {
                    mapUser.put("companyName", company.get("name"));
                    mapUser.put("companyId", company.get("id"));
                } else {
                    company = new HashMap(0);
                }
                orgCompanyMap.put(dptId, company);
            }
        }
    }

    private static Map<Long, Map<String, Object>> getDepartmentAdminMap() {
        HashMap<Long, Map<String, Object>> dptChargerMap = new HashMap<Long, Map<String, Object>>();
        String selectFields = "id,user,user.number number,user.name name,org";
        QFilter filter = new QFilter("isincharge", "=", (Object)"1");
        QFilter[] filters = new QFilter[]{filter};
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.fi.er.business.trip.util.UserHelper.getDepartmentAdminMap", (String)entityID_userposition, (String)selectFields, (QFilter[])filters, (String)"");){
            for (Row row : ds) {
                HashMap<String, Object> charger = new HashMap<String, Object>();
                charger.put("id", row.getLong(USER));
                charger.put("number", row.getString("number"));
                charger.put("name", row.getString("name"));
                dptChargerMap.put(row.getLong(ORG), charger);
            }
        }
        return dptChargerMap;
    }

    public static Integer getCount(Map<String, Object> map) {
        QFilter[] qFilters = new QFilter[]{};
        ORM orm = ORM.create();
        QFilter qFilter = UserHelper.getQfilter("id", map);
        if (UserHelper.getSyncType(map) == SyncUserTypeEnum.SYNC_BY_ORG && qFilter == null) {
            return 0;
        }
        if (UserHelper.getSyncType(map) != SyncUserTypeEnum.SYNC_BY_INCREMENT) {
            qFilters = new QFilter[]{qFilter};
        }
        return orm.count("kd.fi.er.business.trip.util.UserHelper.getCount", entityID_user, qFilters);
    }

    public static List<Map<String, Object>> getAllUserChangeInfos(Integer pageIndex, Integer pageSize, Map<String, Object> map) {
        Long start = System.currentTimeMillis();
        boolean includeDptAdmin = true;
        boolean includeCompany = true;
        ArrayList<Map<String, Object>> userChangeList = new ArrayList<Map<String, Object>>();
        String selectFields = "'1' as type,id,id user, gender,createtime changetime,disabledate,fuid,number,name,phone,email,enable,entryentity.dpt.id dpt,entryentity.dpt.number dptnumber,entryentity.dpt.name dptname, country.name country,entryentity.superior.number supernumber";
        QFilter userTypeFilter = new QFilter("usertypes.fbasedataid", "in", (Object)1);
        QFilter ispartjobFilter = new QFilter("entryentity.ispartjob", "=", (Object)"0");
        ispartjobFilter = ispartjobFilter.or(QFilter.isNull((String)"entryentity.ispartjob"));
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(userTypeFilter);
        list.add(ispartjobFilter);
        QFilter userQfilter = UserHelper.getQfilter("id", map);
        if (UserHelper.getSyncType(map) == SyncUserTypeEnum.SYNC_BY_ORG && userQfilter == null) {
            return new ArrayList<Map<String, Object>>();
        }
        QFilter[] filters = list.toArray(new QFilter[0]);
        if (UserHelper.getSyncType(map) != SyncUserTypeEnum.SYNC_BY_INCREMENT) {
            filters = new QFilter[]{userQfilter, ispartjobFilter};
        }
        Map<Long, Map<String, Object>> dptChargerMap = UserHelper.getDepartmentAdminMap();
        ORM orm = ORM.create();
        try (DataSet dataSet = orm.queryDataSet("kd.fi.er.business.trip.util.UserHelper.getAllUserChangeInfos", entityID_user, selectFields, filters, "", UserHelper.getStart(pageIndex, pageSize).intValue(), pageSize.intValue());){
            UserHelper.genAllUserChangeInfo(userChangeList, dataSet, dptChargerMap, includeDptAdmin, includeCompany);
            logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u5168\u91cf\u4eba\u5458\u67e5\u8be2\u6570\u91cf\uff1a{}", (Object)userChangeList.size());
        }
        logger.info("getAllUserChangeInfos\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
        return userChangeList;
    }

    private static void genAllUserChangeInfo(List<Map<String, Object>> userChangeList, DataSet dataSet, Map<Long, Map<String, Object>> dptChargerMap, boolean includeDptAdmin, boolean includeCompany) {
        HashMap<Long, Map<String, Object>> orgCompanyMap = new HashMap<Long, Map<String, Object>>();
        HashMap<Long, Map<String, Object>> allUserChangeMap = new HashMap<Long, Map<String, Object>>();
        Map<String, Object> userChangeInfoMap = null;
        for (Row row : dataSet) {
            long changeInfoId = row.getLong("id");
            if (allUserChangeMap.containsKey(changeInfoId)) continue;
            userChangeInfoMap = UserHelper.genChangedUserInfo(row, dptChargerMap, orgCompanyMap, includeDptAdmin, includeCompany);
            userChangeInfoMap.put("id", row.getString(USER));
            userChangeInfoMap.put("type", row.getString("type"));
            userChangeInfoMap.put("changetime", row.getDate("changetime"));
            userChangeInfoMap.put("gender", row.getString("gender"));
            allUserChangeMap.put(changeInfoId, userChangeInfoMap);
            if (!row.getBoolean("enable").booleanValue()) {
                HashMap<String, Object> disableUserMap = new HashMap<String, Object>(userChangeInfoMap);
                disableUserMap.put("type", "4");
                Date disabledate = row.getDate("disabledate");
                if (disabledate == null) {
                    disabledate = new Date();
                }
                disableUserMap.put("changetime", disabledate);
                userChangeList.add(disableUserMap);
                continue;
            }
            userChangeList.add(userChangeInfoMap);
        }
    }

    private static Integer getStart(Integer pageIndex, Integer pageSize) {
        return (pageIndex - 1) * pageSize;
    }

    private static QFilter getQfilter(String userOrId, Map<String, Object> map) {
        if (map != null && map.get("userList") != null && map.get("userList") instanceof List) {
            return new QFilter(userOrId, "in", (Object)((List)map.get("userList")));
        }
        if (map != null && map.get("orgList") != null && map.get("orgList") instanceof List) {
            return UserHelper.getUserListByOrgs(userOrId, (List)map.get("orgList"));
        }
        return null;
    }

    private static QFilter getQfilterNew(String userOrId, Map<String, Object> map) {
        if (map != null && map.get("userList") != null && map.get("userList") instanceof List) {
            return new QFilter(userOrId, "in", (Object)((List)map.get("userList")));
        }
        if (map != null && map.get("orgList") != null && map.get("orgList") instanceof List) {
            List list = (List)map.get("orgList");
            ArrayList ids = new ArrayList(list.size());
            for (Map longDateMap : list) {
                for (Map.Entry longDateEntry : longDateMap.entrySet()) {
                    if (null == longDateEntry.getKey()) continue;
                    ids.add(longDateEntry.getKey());
                }
            }
            return new QFilter(userOrId, "in", ids);
        }
        return null;
    }

    private static QFilter getUserListByOrgs(String userOrId, List<Map<Long, Date>> orgs) {
        boolean firstQfi = true;
        QFilter firstQfilter = null;
        for (Map<Long, Date> m : orgs) {
            QFilter changeTimeFilter;
            Long id = (Long)m.keySet().toArray()[0];
            QFilter filter = new QFilter("entryentity.dpt.id", "=", (Object)id);
            DynamicObjectCollection collection = QueryServiceHelper.query((String)entityID_user, (String)"id", (QFilter[])new QFilter[]{filter});
            List userIds = collection.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
            QFilter qFilter = new QFilter(userOrId, "in", userIds);
            if (!TripCommonUtil.isInitTime(m.get(id)) && USER.equals(userOrId)) {
                changeTimeFilter = new QFilter("changetime", ">=", (Object)m.get(id));
                qFilter.and(changeTimeFilter);
            } else if ("id".equals(userOrId) && !TripCommonUtil.isInitTime(m.get(id))) {
                changeTimeFilter = new QFilter("changetime", ">=", (Object)m.get(id));
                QFilter userQfilter = new QFilter(USER, "in", userIds);
                QFilter[] filters = new QFilter[]{userQfilter, changeTimeFilter};
                DynamicObjectCollection users = QueryServiceHelper.query((String)entityID_userChange, (String)USER, (QFilter[])filters);
                userIds = users.stream().map(e -> e.getLong(USER)).distinct().collect(Collectors.toList());
                qFilter = new QFilter(userOrId, "in", userIds);
            }
            if (userIds.size() <= 0) continue;
            if (firstQfi) {
                firstQfilter = qFilter;
                firstQfi = false;
                continue;
            }
            if (firstQfilter == null) continue;
            firstQfilter.or(qFilter);
        }
        return firstQfilter;
    }

    public static SyncUserTypeEnum getSyncType(Map<String, Object> map) {
        if (map == null) {
            return SyncUserTypeEnum.SYNC_BY_INCREMENT;
        }
        if (map.get("userList") != null) {
            return SyncUserTypeEnum.SYNC_BY_USER;
        }
        if (map.get("orgList") != null) {
            return SyncUserTypeEnum.SYNC_BY_ORG;
        }
        return SyncUserTypeEnum.SYNC_BY_INCREMENT;
    }

    private static List<Map<String, Object>> getList(Integer pageIndex, Integer pageSize, Long start, boolean includeDptAdmin, boolean includeCompany, List<Map<String, Object>> userChangeList, Set<Long> changeUserIds, Map<Long, Map<String, Object>> changeInfoMap) {
        Map<String, Object> map;
        long userId;
        ArrayList<Long> selectedUserIds;
        if (changeUserIds.isEmpty()) {
            return userChangeList;
        }
        Map<Long, Map<String, Object>> dptChargerMap = UserHelper.getDepartmentAdminMap();
        int count = changeUserIds.size();
        HashMap<Long, Map<String, Object>> orgCompanyMap = new HashMap<Long, Map<String, Object>>(count);
        HashMap<Long, Map<String, Object>> allUserInfoMap = new HashMap<Long, Map<String, Object>>(count);
        String commonFields = "disabledate,fuid,number,name,phone,email,enable,entryentity.dpt.id dpt,entryentity.dpt.number dptnumber,entryentity.dpt.name dptname, country.name country,entryentity.superior.number supernumber";
        String selectFields = "id,id user," + commonFields;
        QFilter idFilter = new QFilter("id", "in", changeUserIds);
        QFilter userTypeFilter = new QFilter("usertype", "=", (Object)"1");
        QFilter[] filters = new QFilter[]{idFilter, userTypeFilter};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.er.business.trip.util.UserHelper.getUserChangeInfosByTime.user", (String)entityID_user, (String)selectFields, (QFilter[])filters, (String)"entryentity.ispartjob");){
            selectedUserIds = new ArrayList<Long>(count);
            Iterator var22 = dataSet.iterator();
            while (true) {
                if (!var22.hasNext()) break;
                Row row = (Row)var22.next();
                userId = row.getLong(USER);
                if (selectedUserIds.contains(userId)) continue;
                selectedUserIds.add(userId);
                map = UserHelper.genChangedUserInfo(row, dptChargerMap, orgCompanyMap, includeDptAdmin, includeCompany);
                allUserInfoMap.put(userId, map);
            }
            changeUserIds.removeAll(selectedUserIds);
            logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u67e5\u8be2\u4eba\u5458\uff0c\u8bb0\u5f55 \u67e5\u8be2\u6570\u91cf\uff1a{}", (Object)allUserInfoMap.size());
        }
        if (!changeUserIds.isEmpty()) {
            selectFields = "id,user user," + commonFields;
            idFilter = new QFilter(USER, "in", changeUserIds);
            userTypeFilter = new QFilter("usertype", "=", (Object)"1");
            filters = new QFilter[]{idFilter, userTypeFilter};
            dataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.er.business.trip.util.UserHelper.getUserChangeInfosByTime.userHistory", (String)"bos_user_history", (String)selectFields, (QFilter[])filters, (String)"modifytime desc,entryentity.ispartjob");
            var20 = null;
            try {
                selectedUserIds = new ArrayList(count);
                for (Row row : dataSet) {
                    userId = row.getLong(USER);
                    if (selectedUserIds.contains(userId)) continue;
                    selectedUserIds.add(userId);
                    map = UserHelper.genChangedUserInfo(row, dptChargerMap, orgCompanyMap, includeDptAdmin, includeCompany);
                    allUserInfoMap.put(userId, map);
                }
                logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u67e5\u8be2\u4eba\u5458\uff0c\u4eba\u5458\u8bb0\u5f55\u67e5\u8be2\u6570\u91cf\uff1a{}", (Object)allUserInfoMap.size());
            }
            catch (Throwable var66) {
                var20 = var66;
                throw var66;
            }
            finally {
                if (dataSet != null) {
                    if (var20 != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable var65) {
                            var20.addSuppressed(var65);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
        }
        UserHelper.genUserChangeInfo(userChangeList, changeInfoMap, allUserInfoMap);
        logger.info("bytime \u8017\u65f6\uff1a{}\uff0c\u6570\u91cf\uff1a", (Object)(System.currentTimeMillis() - start), (Object)userChangeList.size());
        return userChangeList;
    }
}

