/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.v2.plugin;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.util.order.TripGetOrderTripIdUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class OrderPlugin {
    public static OrderPlugin getInstance() {
        return loadClass.service;
    }

    public Object getVehicleType(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        if (null != map.get("jsonvalue") && !map.get("jsonvalue").toString().trim().isEmpty() && NumberUtils.isCreatable((String)map.get("jsonvalue").toString()) && Long.parseLong(map.get("jsonvalue").toString()) != 0L) {
            return map.get("jsonvalue");
        }
        DynamicObject dynamicObject = (DynamicObject)map.get("dynamicObject");
        if (null == dynamicObject) {
            return "3";
        }
        if (null == map.get("params")) {
            return "3";
        }
        Map params = (Map)map.get("params");
        if (null == params.get("billMapping")) {
            return "3";
        }
        Map billMapping = (Map)params.get("billMapping");
        DynamicObject bill = (DynamicObject)billMapping.get(dynamicObject.getString("oabillnum"));
        if (null == bill) {
            return "3";
        }
        if (ErEntityTypeUtils.isTripReqBill(bill.getDataEntityType().getName())) {
            return "1";
        }
        if (ErEntityTypeUtils.isDailyVehicleBill(bill.getDataEntityType().getName()) && bill.containsProperty("vehicletype")) {
            return bill.getString("vehicletype");
        }
        if (ErEntityTypeUtils.isMealApplicationBill(bill.getDataEntityType().getName()) && bill.containsProperty("reimbursetype")) {
            String vehicleType = TripCommonUtil.getReimburseType(bill.getString("reimbursetype"));
            return vehicleType;
        }
        if (ErEntityTypeUtils.isDailyApplyBill(bill.getDataEntityType().getName()) && bill.containsProperty("reimbursetype")) {
            String vehicleType = TripCommonUtil.getReimburseType(bill.getString("reimbursetype"));
            return vehicleType;
        }
        return "3";
    }

    public Object getTripId(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        if (null != map.get("jsonvalue") && !map.get("jsonvalue").toString().trim().isEmpty() && NumberUtils.isCreatable((String)map.get("jsonvalue").toString()) && Long.parseLong(map.get("jsonvalue").toString()) != 0L) {
            return map.get("jsonvalue");
        }
        DynamicObject dynamicObject = (DynamicObject)map.get("dynamicObject");
        if (null == dynamicObject) {
            return null;
        }
        if (null == map.get("params")) {
            return null;
        }
        Map params = (Map)map.get("params");
        if (null == params.get("billMapping")) {
            return null;
        }
        Map billMapping = (Map)params.get("billMapping");
        DynamicObject appbill = (DynamicObject)billMapping.get(dynamicObject.getString("oabillnum"));
        if (null == appbill) {
            return null;
        }
        if (!ErEntityTypeUtils.isTripReqBill(appbill.getDataEntityType().getName())) {
            return null;
        }
        Object tripPK = TripGetOrderTripIdUtil.getOrderTripId(dynamicObject.getDataEntityType().getName(), dynamicObject, appbill.getDynamicObjectCollection("tripentry"));
        return tripPK;
    }

    public Object getOabillformid(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject dynamicObject = (DynamicObject)map.get("dynamicObject");
        if (null == dynamicObject) {
            return null;
        }
        if (null == map.get("params")) {
            return null;
        }
        Map params = (Map)map.get("params");
        if (null == params.get("billMapping")) {
            return null;
        }
        Map billMapping = (Map)params.get("billMapping");
        DynamicObject bill = (DynamicObject)billMapping.get(dynamicObject.getString("oabillnum"));
        if (null == bill) {
            return null;
        }
        return bill.getDataEntityType().getName();
    }

    public Object getProject(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject dynamicObject = (DynamicObject)map.get("dynamicObject");
        if (null == dynamicObject) {
            return 0L;
        }
        if (null == map.get("params")) {
            return 0L;
        }
        Map params = (Map)map.get("params");
        if (null == params.get("billMapping")) {
            return 0L;
        }
        Map billMapping = (Map)params.get("billMapping");
        DynamicObject bill = (DynamicObject)billMapping.get(dynamicObject.getString("oabillnum"));
        if (null == bill) {
            return 0L;
        }
        if (ErEntityTypeUtils.isTripReqBill(bill.getDataEntityType().getName())) {
            String tripId = dynamicObject.getString("tripid");
            if (StringUtils.isNotBlank((CharSequence)tripId)) {
                DynamicObjectCollection tripEntry = bill.getDynamicObjectCollection("tripentry");
                for (DynamicObject entry : tripEntry) {
                    String entryPk = String.valueOf(ErCommonUtils.getPk(entry));
                    if (!StringUtils.equals((CharSequence)entryPk, (CharSequence)tripId) || !entry.containsProperty("std_project")) continue;
                    return ErCommonUtils.getPk(entry.get("std_project"));
                }
            }
        } else if (bill.containsProperty("headproject")) {
            return ErCommonUtils.getPk(bill.get("headproject"));
        }
        return 0L;
    }

    private static class loadClass {
        private static OrderPlugin service = new OrderPlugin();

        private loadClass() {
        }
    }
}

