/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.v2.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.v2.plugin.UserPlugin;
import kd.fi.er.business.utils.ActionLocalCache;
import kd.fi.er.business.utils.ErCommonUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class OrgPlugin {
    private static final Log logger = LogFactory.getLog(OrgPlugin.class);
    public static final String USER_DYNAMIC_OBJECT_MAP = "kd.fi.er.business.trip.v2.plugin.OrgPlugin.USER_DYNAMIC_OBJECT_MAP";
    public static final String USER_COMPANY_DYNAMIC_OBJECT_MAP = "kd.fi.er.business.trip.v2.plugin.OrgPlugin.USER_DYNAMIC_OBJECT_MAP";
    public static final String ORG_COMPANY_DYNAMIC_OBJECT_ORG = "kd.fi.er.business.trip.v2.plugin.OrgPlugin.ORG_COMPANY_DYNAMIC_OBJECT_ORG";

    public static OrgPlugin getInstance() {
        return loadClass.service;
    }

    public Long getCompany(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        String usernumber = map.getOrDefault("billvalue", 0).toString();
        Map params = (Map)map.get("params");
        UserPlugin userPlugin = UserPlugin.getInstance();
        DynamicObject user = (DynamicObject)ActionLocalCache.get().get("kd.fi.er.business.trip.v2.plugin.OrgPlugin.USER_DYNAMIC_OBJECT_MAP", usernumber, () -> userPlugin.getUser(usernumber, params));
        Long deptId = UserPlugin.getDept(user);
        return OrgPlugin.getCompanyByDeptId(deptId, tripSyncLogParam.getTraceid());
    }

    public static Long getCompanyByDeptId(Long deptId, String traceid) {
        Long companyId = (Long)ActionLocalCache.get().get("kd.fi.er.business.trip.v2.plugin.OrgPlugin.USER_DYNAMIC_OBJECT_MAP", deptId + traceid, () -> CoreBaseBillServiceHelper.initCompanyByDept(deptId));
        return companyId;
    }

    public Long getDept(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        String usernumber = map.getOrDefault("billvalue", 0).toString();
        Map params = (Map)map.get("params");
        UserPlugin userPlugin = UserPlugin.getInstance();
        DynamicObject user = (DynamicObject)ActionLocalCache.get().get("kd.fi.er.business.trip.v2.plugin.OrgPlugin.USER_DYNAMIC_OBJECT_MAP", RequestContext.get().getTraceId() + usernumber, () -> userPlugin.getUser(usernumber, params));
        return UserPlugin.getDept(user);
    }

    public static DynamicObject getOrgByNumber(String number) {
        return (DynamicObject)ActionLocalCache.get().get(ORG_COMPANY_DYNAMIC_OBJECT_ORG, RequestContext.get().getTraceId() + number, () -> BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_structure", (QFilter[])new QFilter[]{new QFilter("org.name", "=", (Object)number)}));
    }

    public Object getSettleDept(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Long settleDeptId = 0L;
        if (null == map.get("dynamicObject")) {
            tripSyncLogParam.setStatus("B");
            String msg = ResManager.loadKDString((String)"\u5b57\u6bb5\u6620\u5c04\uff0c\u661f\u701a\u5bf9\u63a5\u529f\u80fd\u5bf9\u8c61\u672a\u751f\u6210\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u3002", (String)"CheckingPlugin_08", (String)"fi-er-business", (Object[])new Object[0]);
            tripSyncLogParam.setMessage(msg);
            return settleDeptId;
        }
        settleDeptId = OrgPlugin.getApplyBillOrgId(map, "costdept");
        if (0L != settleDeptId) {
            return settleDeptId;
        }
        if (null != map.get("jsonvalue") && !map.get("jsonvalue").toString().trim().isEmpty()) {
            if (NumberUtils.isCreatable((String)map.get("jsonvalue").toString())) {
                return Long.parseLong(map.get("jsonvalue").toString());
            }
            String jsonvalue = map.get("jsonvalue").toString();
            if (jsonvalue.contains("deptId") && jsonvalue.contains("{")) {
                JSONObject json = JSON.parseObject((String)jsonvalue);
                return json.get((Object)"deptId");
            }
            DynamicObject org = OrgPlugin.getOrgByNumber(jsonvalue);
            return org == null ? settleDeptId : ErCommonUtils.getPk(org);
        }
        settleDeptId = OrgPlugin.getUserDeptId(map, false);
        return settleDeptId;
    }

    public static Long getUserDeptId(Map<String, Object> map, Boolean isBookUserId) {
        DynamicObject user;
        Long pk;
        Map params = (Map)map.get("params");
        DynamicObject dynamicObject = (DynamicObject)map.get("dynamicObject");
        String userid = null;
        UserPlugin userPlugin = UserPlugin.getInstance();
        if (!isBookUserId.booleanValue() && dynamicObject.containsProperty("passeger") && null != dynamicObject.get("passeger")) {
            logger.info("\u5b57\u6bb5\u6620\u5c04\uff0c\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4e58\u5ba2\u5de5\u53f7\u6216ID\uff1a{}", dynamicObject.get("passeger"));
            pk = ErCommonUtils.getPk(dynamicObject.get("passeger"));
            String string = userid = pk == null ? null : pk.toString();
        }
        if (!isBookUserId.booleanValue() && (null == userid || userid.equals("0")) && dynamicObject.containsProperty("sourcetravelerid") && null != dynamicObject.get("sourcetravelerid")) {
            logger.info("\u5b57\u6bb5\u6620\u5c04\uff0c\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4e58\u673a\u4eba\u5de5\u53f7\u6216ID\uff1a{}", dynamicObject.get("sourcetravelerid"));
            pk = ErCommonUtils.getPk(dynamicObject.get("sourcetravelerid"));
            String string = userid = pk == null ? null : pk.toString();
        }
        if ((null == userid || userid.equals("0")) && dynamicObject.containsProperty("sourcebookedid") && null != dynamicObject.get("sourcebookedid")) {
            logger.info("\u5b57\u6bb5\u6620\u5c04\uff0c\u8d39\u7528\u627f\u62c5\u516c\u53f8\u9884\u8ba2\u4eba\u5de5\u53f7\u6216ID\uff1a{}", dynamicObject.get("sourcebookedid"));
            pk = ErCommonUtils.getPk(dynamicObject.get("sourcebookedid"));
            String string = userid = pk == null ? null : pk.toString();
        }
        if (null != (user = userPlugin.getUserById(userid, params))) {
            return UserPlugin.getDept(user);
        }
        return 0L;
    }

    public Object getSettleMain(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Long settleMainId = 0L;
        if (null == map.get("dynamicObject")) {
            tripSyncLogParam.setStatus("B");
            String msg = ResManager.loadKDString((String)"\u5b57\u6bb5\u6620\u5c04\uff0c\u661f\u701a\u5bf9\u63a5\u529f\u80fd\u5bf9\u8c61\u672a\u751f\u6210\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u3002", (String)"CheckingPlugin_08", (String)"fi-er-business", (Object[])new Object[0]);
            tripSyncLogParam.setMessage(msg);
            return 0L;
        }
        settleMainId = OrgPlugin.getApplyBillOrgId(map, "costcompany");
        if (0L != settleMainId) {
            return settleMainId;
        }
        if (null != map.get("jsonvalue") && !map.get("jsonvalue").toString().trim().isEmpty()) {
            if (NumberUtils.isCreatable((String)map.get("jsonvalue").toString())) {
                return Long.parseLong(map.get("jsonvalue").toString());
            }
            String jsonvalue = map.get("jsonvalue").toString();
            if (jsonvalue.contains("costCompanyId") && jsonvalue.contains("{")) {
                JSONObject json = JSON.parseObject((String)jsonvalue);
                return json.get((Object)"costCompanyId");
            }
            DynamicObject org = OrgPlugin.getOrgByNumber(jsonvalue);
            return org == null ? settleMainId : ErCommonUtils.getPk(org);
        }
        Object id = this.getSettleDept(map, tripSyncLogParam);
        if (id == null) {
            return 0L;
        }
        return CoreBaseBillServiceHelper.getAccountOrgId(Long.parseLong(id.toString()), true);
    }

    public static Long getApplyBillOrgId(Map<String, Object> map, String billfield) {
        Map params = (Map)map.get("params");
        Long orgId = 0L;
        DynamicObject dynamicObject = (DynamicObject)map.get("dynamicObject");
        if (null != params && null != params.get("billMapping") && dynamicObject.containsProperty("oabillnum") && null != dynamicObject.get("oabillnum") && !dynamicObject.getString("oabillnum").trim().isEmpty()) {
            logger.info("\u5b57\u6bb5\u6620\u5c04\uff0c\u8d39\u7528\u627f\u62c5\u516c\u53f8\u7533\u8bf7\u5355\u53f7_getBillOrgId\uff1a{}", (Object)dynamicObject.getString("oabillnum"));
            Map dynamicObjectMap = (Map)params.get("billMapping");
            DynamicObject appbill = (DynamicObject)dynamicObjectMap.get(dynamicObject.getString("oabillnum").trim());
            if (null != appbill && appbill.containsProperty(billfield) && null != appbill.get(billfield)) {
                Long pk = ErCommonUtils.getPk(appbill.get(billfield));
                return pk == null ? orgId : pk;
            }
        }
        return orgId;
    }

    public static DynamicObject getOrg(Object orgid, Map<String, Object> params) {
        if (null == orgid || orgid.toString().trim().isEmpty()) {
            return null;
        }
        if (null == params || params.get("orgMapping") == null) {
            return BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (QFilter[])new QFilter[]{new QFilter("id", "=", orgid)});
        }
        Map orgMapping = (Map)params.get("orgMapping");
        return (DynamicObject)orgMapping.get(orgid);
    }

    private static class loadClass {
        private static OrgPlugin service = new OrgPlugin();

        private loadClass() {
        }
    }
}

