/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.v2.plugin.dtrip;

import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import org.apache.commons.lang3.StringUtils;

public class DtripPlugin {
    private static final Log logger = LogFactory.getLog(DtripPlugin.class);

    public static DtripPlugin getInstance() {
        return loadClass.service;
    }

    public Object getLastId(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject fieldmapping = TripCommonUtil.getFieldmap(map, tripSyncLogParam);
        String last_id = "9999";
        if (null == fieldmapping) {
            return last_id;
        }
        Map params = (Map)map.get("params");
        if (null == params) {
            return last_id;
        }
        String lastidkey = fieldmapping.getString("number") + "_" + tripSyncLogParam.getTraceid() + params.get("bill_id") + params.get("operationtype");
        last_id = ErCommonUtils.getKeyValueFromAppCache(lastidkey, String.class);
        if (StringUtils.isNotBlank((CharSequence)last_id)) {
            return last_id;
        }
        return null;
    }

    public Object getOffset(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        String index = TripCommonUtil.getTraceidIndex(map, tripSyncLogParam);
        Integer offsetIndex = 0;
        String offsetKey = index + "_offset";
        String lengthKey = index + "_length";
        String offsetcache = ErCommonUtils.getKeyValueFromAppCache(offsetKey, String.class);
        String lengthcache = ErCommonUtils.getKeyValueFromAppCache(lengthKey, String.class);
        Integer lengthIndex = 100;
        if (StringUtils.isNotBlank((CharSequence)lengthcache)) {
            lengthIndex = Integer.parseInt(lengthcache);
        }
        if (StringUtils.isNotBlank((CharSequence)offsetcache)) {
            offsetIndex = Integer.parseInt(offsetcache) + lengthIndex;
        }
        ErCommonUtils.putKeyValueToAppCache(offsetKey, offsetIndex);
        return offsetIndex;
    }

    public Object putLength(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        String index = TripCommonUtil.getTraceidIndex(map, tripSyncLogParam);
        Integer lengthIndex = 100;
        String lengthKey = index + "_length";
        String lengthcache = ErCommonUtils.getKeyValueFromAppCache(lengthKey, String.class);
        if (StringUtils.isNotBlank((CharSequence)lengthcache)) {
            ErCommonUtils.putKeyValueToAppCache(lengthKey, lengthIndex);
        }
        return lengthIndex;
    }

    public Object getBillId(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        logger.info(tripSyncLogParam.getTraceid());
        Map params = (Map)map.get("params");
        if (null == params) {
            return "";
        }
        DynamicObject fieldmapping = TripCommonUtil.getFieldmap(map, tripSyncLogParam);
        if (null == fieldmapping) {
            logger.info("\u5b57\u6bb5\u6620\u5c04\u672a\u914d\u7f6e\u3002");
            tripSyncLogParam.setStatus("B");
            tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u5b57\u6bb5\u6620\u5c04\u672a\u914d\u7f6e\u3002", (String)"AbstractPushInvoke_01", (String)"fi-er-business", (Object[])new Object[0]));
            return "";
        }
        if (null == map.get("jsonfield")) {
            logger.info("\u67e5\u8be2\u6761\u4ef6 jsonfield \u4e3a\u7a7a\u3002");
            tripSyncLogParam.setStatus("B");
            tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u67e5\u8be2\u6761\u4ef6 jsonfield \u4e3a\u7a7a\u3002", (String)"ParamsPlugin_02", (String)"fi-er-business", (Object[])new Object[0]));
            return "";
        }
        if (null != params.get(map.get("jsonfield").toString()) && !params.get(map.get("jsonfield").toString()).toString().trim().isEmpty()) {
            return params.get(map.get("jsonfield").toString()).toString().trim();
        }
        if (!params.containsKey("checkMapping") || null == params.get("checkMapping")) {
            return "";
        }
        Map checkMapping = (Map)params.get("checkMapping");
        if (null == checkMapping) {
            return "";
        }
        String bill_id = "";
        for (DynamicObject o : checkMapping.values()) {
            if (!params.get("operationtype").equals(o.getString("operationtype"))) continue;
            bill_id = o.getString("billnum").split("-")[0];
        }
        return bill_id;
    }

    public Object getBillIdByJsonValue(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        logger.info(tripSyncLogParam.getTraceid());
        Map params = (Map)map.get("params");
        if (null == params) {
            return "";
        }
        DynamicObject fieldmapping = TripCommonUtil.getFieldmap(map, tripSyncLogParam);
        if (null == fieldmapping) {
            logger.info("\u5b57\u6bb5\u6620\u5c04\u672a\u914d\u7f6e\u3002");
            tripSyncLogParam.setStatus("B");
            tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u5b57\u6bb5\u6620\u5c04\u672a\u914d\u7f6e\u3002", (String)"AbstractPushInvoke_01", (String)"fi-er-business", (Object[])new Object[0]));
            return "";
        }
        if (null == map.get("jsonvalue") || map.get("jsonvalue").toString().trim().isEmpty()) {
            return "";
        }
        String jsonvalue = map.get("jsonvalue").toString().trim();
        if (!map.containsKey("dynamicObject") || null == map.get("dynamicObject")) {
            return null;
        }
        DynamicObject dynamicObject = (DynamicObject)map.get("dynamicObject");
        if (null == dynamicObject) {
            return "";
        }
        if (!dynamicObject.containsProperty("operationtype") || null == dynamicObject.getString("operationtype")) {
            tripSyncLogParam.setStatus("B");
            String msg = ResManager.loadKDString((String)"\u5b57\u6bb5\u6620\u5c04\uff0c\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7a7a\u6216\u8005\u672a\u63d0\u524d\u83b7\u53d6\uff0c\u8bf7\u68c0\u67e5\u5b57\u6bb5\u6620\u5c04\u3010\u4e1a\u52a1\u7c7b\u578b\u3011\uff0c\u5e76\u4fdd\u8bc1\u5728\u3010\u7ed3\u7b97\u6279\u6b21\u53f7\u3011\u524d\u9762\u6267\u884c\u3002", (String)"DtripPlugin_01", (String)"fi-er-business", (Object[])new Object[0]);
            tripSyncLogParam.setMessage(msg);
            return "";
        }
        return jsonvalue + "-" + dynamicObject.getString("operationtype");
    }

    public Object getHappenddate(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        String happenddate = map.getOrDefault("jsonvalue", 0).toString();
        Date date = TripCommonUtil.convertToDate(happenddate);
        if (TripSyncConfigUtil.getBoolean("ttrip_period_value", Boolean.TRUE).booleanValue()) {
            return date;
        }
        Map params = (Map)map.get("params");
        if (null == params) {
            return null;
        }
        if (!params.containsKey("happenddate") || null == params.get("happenddate")) {
            logger.info("\u6708\u7ed3\u8d26\u5355\u672a\u83b7\u53d6\uff0c\u672a\u83b7\u53d6\u5230\u8d26\u671f\u3002");
            return null;
        }
        return params.get("happenddate");
    }

    public Object getPeriodStart(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Map params = (Map)map.get("params");
        if (null == params) {
            return null;
        }
        Object beginDate = params.get("beginDate");
        if (beginDate == null) {
            tripSyncLogParam.setStatus("B");
            tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u6ef4\u6ef4\uff0c\u83b7\u53d6\u6708\u7ed3\u8d26\u5355\u63a5\u53e3\uff0c\u7ed3\u7b97\u5468\u671f\u83b7\u53d6\u4e3a\u7a7a\u3002", (String)"DtripPlugin_03", (String)"fi-er-business", (Object[])new Object[0]));
            return null;
        }
        return TripCommonUtil.date2TimeStamp((Date)beginDate, "yyyy-MM-dd");
    }

    public Object getPeriodEnd(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Map params = (Map)map.get("params");
        if (null == params) {
            return null;
        }
        Object endDate = params.get("endDate");
        if (endDate == null) {
            tripSyncLogParam.setStatus("B");
            tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u6ef4\u6ef4\uff0c\u83b7\u53d6\u6708\u7ed3\u8d26\u5355\u63a5\u53e3\uff0c\u7ed3\u7b97\u5468\u671f\u83b7\u53d6\u4e3a\u7a7a\u3002", (String)"DtripPlugin_03", (String)"fi-er-business", (Object[])new Object[0]));
            return null;
        }
        return TripCommonUtil.date2TimeStamp((Date)endDate, "yyyy-MM-dd");
    }

    public Object getPaymentPeriod(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Map params = (Map)map.get("params");
        if (null == params) {
            return null;
        }
        Object beginDate = params.get("beginDate");
        Object endDate = params.get("endDate");
        if (beginDate == null || endDate == null) {
            tripSyncLogParam.setStatus("B");
            tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u6ef4\u6ef4\uff0c\u83b7\u53d6\u6708\u7ed3\u8d26\u5355\u63a5\u53e3\uff0c\u7ed3\u7b97\u5468\u671f\u83b7\u53d6\u4e3a\u7a7a\u3002", (String)"DtripPlugin_03", (String)"fi-er-business", (Object[])new Object[0]));
            return null;
        }
        String beginDateStr = TripCommonUtil.date2TimeStamp((Date)beginDate, "yyyy-MM-dd");
        String endDateStr = TripCommonUtil.date2TimeStamp((Date)endDate, "yyyy-MM-dd");
        return beginDateStr + "~" + endDateStr;
    }

    public Object getBillNum(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        if (map == null) {
            return null;
        }
        if (map.containsKey("jsonvalue")) {
            Object jsonValue = map.get("jsonvalue");
            Object billField = map.get("billfield");
            DynamicObject dynamicObject = (DynamicObject)map.get("dynamicObject");
            if (null == dynamicObject) {
                return jsonValue;
            }
            if (billField != null && "billno".equals(billField.toString())) {
                String billnum = dynamicObject.getString("billnum");
                if (StringUtils.isBlank((CharSequence)billnum)) {
                    tripSyncLogParam.setStatus("B");
                    tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u6ef4\u6ef4\uff0c\u83b7\u53d6\u6708\u7ed3\u8d26\u5355\u63a5\u53e3\uff0cbillnum\u5b57\u6bb5\u9700\u8981\u5728billno\u4e4b\u524d\u83b7\u53d6\u3002", (String)"DtripPlugin_04", (String)"fi-er-business", (Object[])new Object[0]));
                    return null;
                }
                return billnum;
            }
            if (jsonValue != null && StringUtils.isNotBlank((CharSequence)dynamicObject.getString("operationtype"))) {
                return jsonValue + "-" + dynamicObject.get("operationtype");
            }
        }
        return null;
    }

    private static class loadClass {
        private static DtripPlugin service = new DtripPlugin();

        private loadClass() {
        }
    }
}

