/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.v2.plugin.gtrip;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.business.trip.v2.plugin.FieldMappingPlugin;
import kd.fi.er.business.trip.v2.plugin.req.ReqBillPlugin;
import kd.fi.er.business.trip.v2.server.gtrip.GtripFieldMappingInvoke;
import kd.fi.er.business.utils.ErEntityTypeUtils;

public class GtripPlugin {
    private static final Log logger = LogFactory.getLog(ReqBillPlugin.class);

    public static GtripPlugin getInstance() {
        return loadClass.service;
    }

    public Object getRegulation(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject bill = (DynamicObject)map.get("bill");
        String regulationId = "";
        if (null == bill) {
            logger.info("getRegulation bill\u4e3a\u7a7a");
            return null;
        }
        DynamicObject fieldmapping = TripCommonUtil.getFieldmap(map, tripSyncLogParam);
        if (null == fieldmapping) {
            logger.info("\u5b57\u6bb5\u6620\u5c04\u672a\u914d\u7f6e\u3002");
            tripSyncLogParam.setStatus("B");
            tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u5b57\u6bb5\u6620\u5c04\u672a\u914d\u7f6e\u3002", (String)"AbstractPushInvoke_01", (String)"fi-er-business", (Object[])new Object[0]));
            return null;
        }
        if (null == map.get("billfield")) {
            logger.info("\u5b57\u6bb5\u6620\u5c04 billfield \u4e3a\u7a7a\u3002");
            tripSyncLogParam.setStatus("B");
            tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u67e5\u8be2\u6761\u4ef6 billfield \u4e3a\u7a7a\u3002", (String)"GtripPlugin_01", (String)"fi-er-business", (Object[])new Object[0]));
            return null;
        }
        DynamicObject dynamicObject = bill.getDynamicObject("applier");
        String number = dynamicObject.getString("number");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", number);
        String name = bill.getDataEntityType().getName();
        String sceneTypeStr = map.get("billfield").toString();
        String[] split = sceneTypeStr.split(",");
        String fieldMappingNumber = split[0];
        String sceneType = split[1];
        params.put("sceneType", sceneType);
        Map<String, Object> mappingMap = GtripFieldMappingInvoke.getRegulation(fieldMappingNumber, params);
        if (mappingMap.size() == 0 || !((Boolean)mappingMap.getOrDefault("success", false)).booleanValue()) {
            logger.info("GtripPlugin getRegulation\u5931\u8d25");
            tripSyncLogParam.setStatus("B");
            tripSyncLogParam.setMessage("GtripPlugin getRegulation fail success=false");
            return regulationId;
        }
        List fieldMappingData = mappingMap.getOrDefault("data", new ArrayList());
        for (JSONObject result : fieldMappingData) {
            if (!result.getBoolean("result").booleanValue()) {
                return regulationId;
            }
            JSONArray resultData = result.getJSONArray("data");
            if (resultData == null) {
                return regulationId;
            }
            for (Object obj : resultData) {
                JSONObject data = (JSONObject)obj;
                if (ErEntityTypeUtils.isDailyVehicleBill(name)) {
                    String approveType;
                    String vehicletype = bill.getString("vehicletype");
                    String string = approveType = "2".equals(vehicletype) ? "1" : "2";
                    if (!sceneType.equals(data.getString("sceneType")) || !approveType.equals(data.getString("approveType"))) continue;
                    return data.getString("regulationId");
                }
                if (!sceneType.equals(data.getString("sceneType"))) continue;
                return data.getString("regulationId");
            }
        }
        return regulationId;
    }

    public String getCheckingbillnum(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        String billno = "";
        if (null == map.get("dynamicObject")) {
            return billno;
        }
        DynamicObject dynamicObject = (DynamicObject)map.get("dynamicObject");
        if (null == dynamicObject) {
            return billno;
        }
        if (null == map.getOrDefault("jsonvalue", "")) {
            logger.info("GtripPlugin getCheckingbillnum jsonvalue is null");
            return billno;
        }
        Object time = map.getOrDefault("jsonvalue", "");
        Calendar cal = Calendar.getInstance();
        if (null != time && !time.toString().trim().isEmpty()) {
            cal.setTime(TripCommonUtil.convertToDate(time.toString()));
        }
        time = cal.get(1) + "" + (cal.get(2) + 1);
        Integer gtrip_bill_collection = TripSyncConfigUtil.getIntValue("Gtrip_bill_collection", 1);
        String company = "";
        if (!dynamicObject.containsProperty("operationtype") || null == dynamicObject.getString("operationtype")) {
            tripSyncLogParam.setStatus("B");
            String msg = ResManager.loadKDString((String)"\u5b57\u6bb5\u6620\u5c04\uff0c\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7a7a\u6216\u8005\u672a\u63d0\u524d\u83b7\u53d6\uff0c\u8bf7\u68c0\u67e5\u5b57\u6bb5\u6620\u5c04\u3010\u4e1a\u52a1\u7c7b\u578b\u3011\uff0c\u5e76\u4fdd\u8bc1\u5728\u3010\u8d26\u5355\u7f16\u53f7\u3011\u524d\u9762\u6267\u884c\u3002", (String)"CheckingPlugin_10", (String)"fi-er-business", (Object[])new Object[0]);
            tripSyncLogParam.setMessage(msg);
            return billno;
        }
        if (1 == gtrip_bill_collection) {
            if (!dynamicObject.containsProperty("settlemain") || null == dynamicObject.getString("settlemain")) {
                tripSyncLogParam.setStatus("B");
                String msg = ResManager.loadKDString((String)"\u5b57\u6bb5\u6620\u5c04\uff0c\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4e3a\u7a7a\u6216\u8005\u672a\u63d0\u524d\u83b7\u53d6\uff0c\u8bf7\u68c0\u67e5\u5b57\u6bb5\u6620\u5c04\u3010\u8d39\u7528\u627f\u62c5\u516c\u53f8\u3011\uff0c\u5e76\u4fdd\u8bc1\u5728\u3010\u8d26\u5355\u7f16\u53f7\u3011\u524d\u9762\u6267\u884c\u3002", (String)"CheckingPlugin_11", (String)"fi-er-business", (Object[])new Object[0]);
                tripSyncLogParam.setMessage(msg);
                return billno;
            }
            company = dynamicObject.getString("settlemain");
        } else {
            if (!dynamicObject.containsProperty("company") || null == dynamicObject.getString("company")) {
                tripSyncLogParam.setStatus("B");
                String msg = ResManager.loadKDString((String)"\u5b57\u6bb5\u6620\u5c04\uff0c\u7533\u8bf7\u4eba\u516c\u53f8\u4e3a\u7a7a\u6216\u8005\u672a\u63d0\u524d\u83b7\u53d6\uff0c\u8bf7\u68c0\u67e5\u5b57\u6bb5\u6620\u5c04\u3010\u7533\u8bf7\u4eba\u516c\u53f8\u3011\uff0c\u5e76\u4fdd\u8bc1\u5728\u3010\u8d26\u5355\u7f16\u53f7\u3011\u524d\u9762\u6267\u884c\u3002", (String)"CheckingPlugin_12", (String)"fi-er-business", (Object[])new Object[0]);
                tripSyncLogParam.setMessage(msg);
                return billno;
            }
            company = dynamicObject.getString("company");
        }
        return time + "-" + dynamicObject.getString("operationtype") + "-" + company;
    }

    public String getToken(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        map.put("function", "er_biz_info");
        JSONObject json = FieldMappingPlugin.getInstance().getFieldMapResult(map, tripSyncLogParam);
        if (null == json || null == json.get((Object)"data") || !(json.get((Object)"data") instanceof JSONObject) || null == json.getJSONObject("data").getString("token")) {
            tripSyncLogParam.setMessage(String.format(ResManager.loadKDString((String)"%1$s\u9ad8\u5fb7\u83b7\u53d6token\u5f02\u5e38\uff1a%2$s", (String)"GtripPlugin_03", (String)"fi-er-business", (Object[])new Object[0]), 4, null == json ? "" : JSON.toJSONString((Object)json)));
            tripSyncLogParam.setStatus("B");
            tripSyncLogParam.setResponsedata(json);
            return null;
        }
        return json.getJSONObject("data").getString("token");
    }

    private static class loadClass {
        private static GtripPlugin service = new GtripPlugin();

        private loadClass() {
        }
    }
}

