/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.v2.plugin.mtrip;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.trip.dao.UserDao;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.business.trip.v2.plugin.BizInfoPlugin;
import kd.fi.er.business.trip.v2.plugin.FieldMappingPlugin;
import kd.fi.er.business.trip.v2.plugin.UserPlugin;
import kd.fi.er.business.trip.v2.plugin.req.ReqBillPlugin;
import kd.fi.er.business.utils.ActionLocalCache;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.common.utils.ThrowableHelper;
import org.apache.commons.lang3.StringUtils;

public class MTripPlugin {
    public static final String MEIYA_SESSION_ID_MAP = "MTripPlugin.MEIYA_SESSION_ID_MAP";
    public static final String MEIYA_COSTCENTER_NAME_MAP = "MTripPlugin.MEIYA_COSTCENTER_NAME_MAP";
    public static final String TWO_COUNTRY_CODE_MAP = "MTripPlugin.MEIYA_COSTCENTER_NAME_MAP";
    private static final String yyyyMMddHHmmssffff = "yyyyMMddHHmmssSSSS";
    private static final Log logger = LogFactory.getLog(MTripPlugin.class);

    public String getSessionId(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Long accountOrgId = this.getUserAccountOrgId(map, tripSyncLogParam);
        Boolean multiCompanyId = (Boolean)BizInfoPlugin.getInstance().getMultiCompanyId(map, tripSyncLogParam);
        Map params = (Map)map.get("params");
        DynamicObject fieldmap = (DynamicObject)params.get("fieldmap");
        String function = ((DynamicObject)fieldmap.get("function")).getString("number");
        if (multiCompanyId.booleanValue() && null == accountOrgId) {
            DynamicObject user = this.getUser(map, tripSyncLogParam);
            String number = user == null ? ResManager.loadKDString((String)"\u6ca1\u6709\u83b7\u53d6\u5230\u7528\u6237", (String)"MTripPlugin_0", (String)"fi-er-business", (Object[])new Object[0]) : user.getString("number");
            tripSyncLogParam.setStatus("B");
            tripSyncLogParam.setMessage(String.format(ResManager.loadKDString((String)"\u7f8e\u4e9a\u83b7\u53d6SessionId\u5931\u8d25\uff0c\u539f\u56e0\u4e3a\u5728\u670d\u52a1\u5546\u8bbe\u7f6e\u4e2d\u5f00\u542f\u591a\u516c\u53f8\u8d26\u53f7\u65f6\uff0c\u5f53\u524d\u7528\u6237\u627e\u4e0d\u5230\u5bf9\u5e94\u6838\u7b97\u7ec4\u7ec7\uff0c\u7528\u6237\u5de5\u53f7\u4e3a\uff1a%1$s\u3002", (String)"MTripPlugin_02", (String)"fi-er-business", (Object[])new Object[0]), number));
            return "";
        }
        String sessionId = (String)ActionLocalCache.get().get(MEIYA_SESSION_ID_MAP, multiCompanyId == false ? Long.valueOf(-100L) : accountOrgId, () -> {
            Map<String, Object> companyInfo = BizInfoPlugin.getInstance().getCompanyInfo(map, tripSyncLogParam, accountOrgId);
            if ("er_tripreqbill".equals(function) || "er_triplogin".equals(function)) {
                DynamicObject user = this.getUser(map, tripSyncLogParam);
                String number = user.getString("number");
                String name = user.getString("name");
                companyInfo.put("staffCode", number);
                companyInfo.put("realName", name);
            }
            logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u7f8e\u4e9a\u83b7\u53d6SessionId\uff0cstaffCode:{},realName:{}", companyInfo.get("staffCode"), companyInfo.get("realName"));
            return this.getSession(map, tripSyncLogParam, companyInfo);
        });
        return sessionId;
    }

    public String getSession(Map<String, Object> map, TripSyncLogParam tripSyncLogParam, Map<String, Object> paramsMap) {
        map.put("function", "er_biz_info");
        map.put("paramsMap", paramsMap);
        JSONObject json = FieldMappingPlugin.getInstance().getFieldMapResult(map, tripSyncLogParam);
        if (null == json || null == json.get((Object)"sessionId") || StringUtils.isBlank((CharSequence)json.getString("sessionId"))) {
            tripSyncLogParam.setMessage(String.format(ResManager.loadKDString((String)"\u7f8e\u4e9a\u83b7\u53d6token\u5f02\u5e38\uff1a%1$s", (String)"MTripPlugin_01", (String)"fi-er-business", (Object[])new Object[0]), null == json ? "" : JSON.toJSONString((Object)json)));
            tripSyncLogParam.setStatus("B");
            tripSyncLogParam.setResponsedata(json);
            return "";
        }
        return json.getString("sessionId");
    }

    public String getCompanyIdByCostCompany(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Long accountOrgId = (Long)map.getOrDefault("billValue", 0L);
        Map<String, Object> companyInfo = BizInfoPlugin.getInstance().getCompanyInfo(map, tripSyncLogParam, accountOrgId);
        return (String)companyInfo.getOrDefault("companyId", "");
    }

    public String getCompanyId(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Long accountOrgId = this.getUserAccountOrgId(map, tripSyncLogParam);
        Map<String, Object> companyInfo = BizInfoPlugin.getInstance().getCompanyInfo(map, tripSyncLogParam, accountOrgId);
        return (String)companyInfo.getOrDefault("companyId", "");
    }

    private Long getUserAccountOrgId(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Long accountOrgId = 0L;
        DynamicObject user = this.getUser(map, tripSyncLogParam);
        if (user == null) {
            logger.info("MTripPlugin.getUserAccountOrgId user\u4e3a\u7a7a");
            tripSyncLogParam.setStatus("B");
            tripSyncLogParam.setMessage("");
            return accountOrgId;
        }
        Long dept = UserPlugin.getDept(user);
        accountOrgId = CoreBaseBillServiceHelper.getAccountOrgId(dept, true);
        return accountOrgId;
    }

    public Object getPositionLevelName(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject company;
        Object paramsUser = ((Map)map.get("params")).get("paramsUser");
        DynamicObject user = null != paramsUser ? (DynamicObject)paramsUser : (DynamicObject)map.get("bill");
        String employeeNumber = user.getString("number");
        Long dept = UserPlugin.getDept(user);
        if (employeeNumber == null || dept == null) {
            logger.info("\u672a\u83b7\u53d6\u5230\u5458\u5de5{}\u6216\u8005\u90e8\u95e8{}", (Object)employeeNumber, (Object)dept);
            return "";
        }
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)2);
        long userId = user.getLong("id");
        paramMap.put("id", userId);
        Long companyId = CoreBaseBillServiceHelper.initCompanyByDept(dept);
        paramMap.put("companyId", companyId);
        Map<Long, String> reimburseLevelMap = UserDao.getReimburseLevelNew(Collections.singletonList(paramMap));
        if (reimburseLevelMap.isEmpty()) {
            logger.info("\u65e5\u5fd7\u8bb0\u5f55\u6392\u67e5:\u5bf9\u5e94\u5458\u5de5ID{}\u516c\u53f8ID{}\u672a\u83b7\u53d6\u5230\u62a5\u9500\u7ea7\u522b\u6570\u636e", (Object)userId, (Object)companyId);
        }
        if ((company = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)companyId)})) == null) {
            logger.info("\u65e5\u5fd7\u8bb0\u5f55\u6392\u67e5:\u5458\u5de5{}\u6839\u636e\u516c\u53f8ID{}\u672a\u83b7\u53d6\u5230\u516c\u53f8\u6570\u636e", (Object)employeeNumber, (Object)companyId);
        }
        String result = "";
        int intValue = (Integer)ActionLocalCache.get().get("meiya_personnel_rank", "meiya_personnel_rank", () -> TripSyncConfigUtil.getIntValue("meiya_personnel_rank", 2));
        switch (intValue) {
            case 1: {
                if (reimburseLevelMap.isEmpty() || !StringUtils.isNotEmpty((CharSequence)reimburseLevelMap.get(userId)) || company == null) break;
                result = company.getString("number") + "-" + reimburseLevelMap.get(userId);
                break;
            }
            case 2: {
                if (reimburseLevelMap.isEmpty() || !StringUtils.isNotEmpty((CharSequence)reimburseLevelMap.get(userId))) break;
                result = reimburseLevelMap.get(userId);
                break;
            }
            case 3: {
                if (!reimburseLevelMap.isEmpty() && StringUtils.isNotEmpty((CharSequence)reimburseLevelMap.get(userId)) && company != null) {
                    result = company.getString("number") + "-" + reimburseLevelMap.get(userId);
                    break;
                }
                if (company == null) break;
                result = String.format(ResManager.loadKDString((String)"%s-\u666e\u901a\u5458\u5de5", (String)"UserPlugin_0", (String)"fi-er-business", (Object[])new Object[0]), company.getString("number"));
                break;
            }
            case 4: {
                if (!reimburseLevelMap.isEmpty() && StringUtils.isNotEmpty((CharSequence)reimburseLevelMap.get(userId))) {
                    result = reimburseLevelMap.get(userId);
                    break;
                }
                result = ResManager.loadKDString((String)"\u666e\u901a\u5458\u5de5", (String)"MTripPlugin_1", (String)"fi-er-business", (Object[])new Object[0]);
                break;
            }
            case 5: {
                if (!reimburseLevelMap.isEmpty() && StringUtils.isNotEmpty((CharSequence)reimburseLevelMap.get(userId)) && company != null) {
                    result = company.getString("number") + "-" + reimburseLevelMap.get(userId);
                    break;
                }
                result = ResManager.loadKDString((String)"\u666e\u901a\u5458\u5de5", (String)"MTripPlugin_1", (String)"fi-er-business", (Object[])new Object[0]);
                break;
            }
            default: {
                if (reimburseLevelMap.isEmpty() || !StringUtils.isNotEmpty((CharSequence)reimburseLevelMap.get(userId))) break;
                result = reimburseLevelMap.get(userId);
            }
        }
        return result;
    }

    public Object getCostCenterName(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Long accountOrgId = this.getUserAccountOrgId(map, tripSyncLogParam);
        Object costCenterName = ActionLocalCache.get().get("MTripPlugin.MEIYA_COSTCENTER_NAME_MAP", accountOrgId, () -> {
            DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)accountOrgId)});
            if (org == null) {
                return "";
            }
            return org.getString("name");
        });
        return costCenterName + "(" + accountOrgId + ")";
    }

    public Object getPassword(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Object o = map.get("params");
        Object c = map.get("context");
        if (!(c instanceof Map)) {
            logger.info("\u7f8e\u4e9agetPw\uff0ccontext\u4e3a\u7a7a");
            tripSyncLogParam.setMessage("");
            tripSyncLogParam.setStatus("B");
            return "";
        }
        if (!(o instanceof Map)) {
            logger.info("\u7f8e\u4e9agetPw\uff0cparams\u4e3a\u7a7a");
            tripSyncLogParam.setMessage("");
            tripSyncLogParam.setStatus("B");
            return "";
        }
        Map params = (Map)o;
        String staffCode = params.getOrDefault("staffCode", "");
        String realName = params.getOrDefault("realName", "");
        String companyId = params.getOrDefault("companyId", "");
        String signKey = params.getOrDefault("signKey", "");
        String timeStamp = ((Map)c).getOrDefault("timeStamp", "");
        Object[] infos = new String[]{companyId, realName, staffCode, timeStamp, signKey};
        Arrays.sort(infos, String.CASE_INSENSITIVE_ORDER);
        String input = String.format("%s%s%s%s%s", infos);
        String psw = "";
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            MessageDigest mdTemp = MessageDigest.getInstance("SHA1");
            mdTemp.update(input.getBytes("ISO-8859-1"));
            byte[] md = mdTemp.digest();
            int j = md.length;
            char[] buf = new char[j * 2];
            int k = 0;
            for (int i = 0; i < j; ++i) {
                byte byte0 = md[i];
                buf[k++] = hexDigits[byte0 >>> 4 & 0xF];
                buf[k++] = hexDigits[byte0 & 0xF];
            }
            psw = new String(buf);
        }
        catch (Exception e) {
            logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u7f8e\u4e9a\u52a0\u5bc6\u5f02\u5e38\uff1a{}", (Object)ThrowableHelper.toString((Exception)e));
            tripSyncLogParam.setMessage(ThrowableHelper.toString((Exception)e));
            tripSyncLogParam.setStatus("B");
        }
        return psw;
    }

    public Object getLongNowTimeStr(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        SimpleDateFormat sdf = new SimpleDateFormat(yyyyMMddHHmmssffff);
        String timeStamp = sdf.format(new Date());
        return timeStamp;
    }

    private DynamicObject getUser(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Map params = (Map)map.get("params");
        DynamicObject fieldmap = (DynamicObject)params.get("fieldmap");
        String function = ((DynamicObject)fieldmap.get("function")).getString("number");
        Object user = null;
        switch (function) {
            case "bos_user": {
                user = map.get("bill");
                break;
            }
            case "er_tripreqbill": {
                DynamicObject billValue = (DynamicObject)map.get("billValue");
                user = billValue;
                break;
            }
            case "er_triplogin": {
                user = UserPlugin.getInstance().getCurrentUser(map, tripSyncLogParam);
            }
        }
        if (!(user instanceof DynamicObject)) {
            logger.info("MTripPlugin.getSessionId,user\u4e3a\u7a7a\uff0cfunction\uff1a" + function);
            tripSyncLogParam.setStatus("B");
            tripSyncLogParam.setMessage("");
            return null;
        }
        return (DynamicObject)user;
    }

    public Object getTripType(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Boolean isHaveForeignCity = (Boolean)ReqBillPlugin.getInstance().getIsHaveForeignCity(map, tripSyncLogParam);
        if (isHaveForeignCity.booleanValue()) {
            return 1;
        }
        return 0;
    }

    public Object getPassengerInfoList(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        JSONArray result = new JSONArray();
        DynamicObjectCollection travelers = (DynamicObjectCollection)map.get("billValue");
        for (DynamicObject o : travelers) {
            DynamicObject traveler = o.getDynamicObject("fbasedataid");
            JSONObject jsonObject = this.covertPassengerInfo(traveler, map, tripSyncLogParam);
            result.add((Object)jsonObject);
        }
        return result;
    }

    public Object getApplyPassengerInfoList(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject user = (DynamicObject)map.get("billValue");
        JSONObject jsonObject = this.covertPassengerInfo(user, map, tripSyncLogParam);
        return jsonObject;
    }

    private JSONObject covertPassengerInfo(DynamicObject user, Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        JSONObject jsonObject = new JSONObject();
        Object o = map.get("bill");
        Long accountOrgId = 0L;
        if (o != null) {
            DynamicObject reqBill = (DynamicObject)o;
            DynamicObject dynamicObject = reqBill.getDynamicObject("costcompany");
            accountOrgId = ErCommonUtils.getPk(dynamicObject);
        }
        Map<String, Object> companyInfo = BizInfoPlugin.getInstance().getCompanyInfo(map, tripSyncLogParam, accountOrgId);
        jsonObject.put("companyId", companyInfo.getOrDefault("companyId", ""));
        jsonObject.put("staffCode", (Object)user.getString("number"));
        jsonObject.put("cnName", (Object)user.getLocaleString("name").getLocaleValue_zh_CN());
        jsonObject.put("sex", (Object)("2".equals(user.getString("gender")) ? ResManager.loadKDString((String)"\u5973", (String)"MTripPlugin_3", (String)"fi-er-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7537", (String)"MTripPlugin_2", (String)"fi-er-business", (Object[])new Object[0])));
        Long countryId = ErCommonUtils.getPk(user.getDynamicObject("country"));
        String countryCode = (String)ActionLocalCache.get().get("MTripPlugin.MEIYA_COSTCENTER_NAME_MAP", countryId, () -> {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_country", (String)"twocountrycode", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)countryId)});
            return dynamicObject == null ? "CN" : dynamicObject.getString("twocountrycode");
        });
        jsonObject.put("nationality", (Object)countryCode);
        jsonObject.put("mobile", (Object)user.getString("phone"));
        jsonObject.put("passengerType", (Object)ResManager.loadKDString((String)"\u6210\u4eba", (String)"MTripPlugin_4", (String)"fi-er-business", (Object[])new Object[0]));
        ((Map)map.get("params")).put("paramsUser", user);
        jsonObject.put("holderId", this.getPositionLevelName(map, tripSyncLogParam));
        jsonObject.put("dName", (Object)this.getDeptLongName(user));
        Long dept = UserPlugin.getDept(user);
        Long costCompanyId = CoreBaseBillServiceHelper.getAccountOrgId(dept, true);
        Object costCenterName = ActionLocalCache.get().get("MTripPlugin.MEIYA_COSTCENTER_NAME_MAP", costCompanyId, () -> {
            DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)costCompanyId)});
            if (org == null) {
                return "";
            }
            return org.getString("name");
        });
        jsonObject.put("costCenterID", (Object)(costCenterName + "(" + costCompanyId + ")"));
        return jsonObject;
    }

    public String getUserDeptLongName(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject user = (DynamicObject)map.get("bill");
        if (null == user || !(user instanceof DynamicObject) || !"bos_user".equals(user.getDataEntityType().getName())) {
            return "";
        }
        return this.getDeptLongName(user);
    }

    private String getDeptLongName(DynamicObject traveler) {
        String deptLongName = "";
        DynamicObjectCollection userEntrys = traveler.getDynamicObjectCollection("entryentity");
        if (null == userEntrys) {
            return deptLongName;
        }
        for (DynamicObject userEntry : userEntrys) {
            DynamicObject orgstructure = userEntry.getDynamicObject("orgstructure");
            boolean isPartjob = userEntry.getBoolean("ispartjob");
            if (isPartjob || null == orgstructure) continue;
            deptLongName = orgstructure.getString("fullname");
            break;
        }
        if (deptLongName.contains("_")) {
            deptLongName = deptLongName.replaceAll("_", "/");
        }
        return deptLongName;
    }

    public Object getStApplyOrderNo(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        String outDataNumber = "";
        Long billId = (Long)map.getOrDefault("billValue", 0L);
        DynamicObject datamapping = BusinessDataServiceHelper.loadSingleFromCache((String)"er_tripsync_datamapping", (String)"outdatanumber", (QFilter[])new QFilter[]{new QFilter("innerdataid", "=", (Object)billId)});
        if (null != datamapping) {
            outDataNumber = datamapping.getString("outdatanumber");
        }
        return outDataNumber;
    }
}

