/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.v2.plugin.qtrip;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.v2.plugin.BizInfoPlugin;
import kd.fi.er.business.trip.v2.plugin.FieldMappingPlugin;
import kd.fi.er.business.trip.v2.plugin.UserPlugin;
import kd.fi.er.business.trip.v2.plugin.req.ReqBillPlugin;
import kd.fi.er.common.utils.MD5;
import org.apache.commons.lang3.StringUtils;

public class QtripPlugin {
    private static final Log logger = LogFactory.getLog(ReqBillPlugin.class);

    public static QtripPlugin getInstance() {
        return loadClass.service;
    }

    public Object getVehicle(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        String result = "plane";
        if (null == map.get("billValue") || null == map.getOrDefault("billValue", "")) {
            return result;
        }
        String billvalue = map.getOrDefault("billValue", "").toString();
        if (billvalue.contains("1")) {
            return result;
        }
        if (billvalue.contains("2")) {
            return "train";
        }
        if (billvalue.contains("3")) {
            return "bus";
        }
        if (billvalue.contains("4")) {
            return "boat";
        }
        if (billvalue.contains("5") || billvalue.contains("6")) {
            return "other";
        }
        return result;
    }

    public Object getPassengerList(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        String billfield;
        if (null == map.get("bill")) {
            return null;
        }
        DynamicObject req = (DynamicObject)map.get("bill");
        Object ctx = TripCommonUtil.getDValueByfield(req, billfield = map.getOrDefault("billfield", "").toString());
        if (!(ctx instanceof Object[])) {
            return null;
        }
        ArrayList listname = new ArrayList(64);
        Object[] os = (Object[])ctx;
        ArrayList<String> set = new ArrayList<String>(64);
        for (Object o : os) {
            if (!(o instanceof DynamicObjectCollection)) continue;
            DynamicObjectCollection travelers = (DynamicObjectCollection)o;
            for (DynamicObject traveler : travelers) {
                HashMap<String, String> listmap = new HashMap<String, String>(2);
                DynamicObject user = traveler.getDynamicObject("fbasedataid");
                if (set.contains(user.getString("number")) || user.getString("number").trim().isEmpty()) continue;
                set.add(user.getString("number"));
                listmap.put("personnelType", "EMPLOYEE");
                listmap.put("empNum", user.getString("number"));
                listmap.put("personnelName", user.getString("name"));
                listmap.put("mobilePhone", user.getString("phone"));
                listname.add(listmap);
            }
        }
        return listname;
    }

    public Object getHotelTripSetting(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject ctrlSettingObject;
        if (null == map.get("bill")) {
            return null;
        }
        DynamicObject bill = (DynamicObject)map.get("bill");
        DynamicObjectCollection tripentrys = bill.getDynamicObjectCollection("tripentry");
        if (tripentrys.isEmpty()) {
            return null;
        }
        Object paramsob = map.get("params");
        if (!(paramsob instanceof Map)) {
            tripSyncLogParam.setMessage("");
            tripSyncLogParam.setStatus("B");
            return null;
        }
        Map params = (Map)paramsob;
        DynamicObject fieldmapping = (DynamicObject)params.get("fieldmap");
        DynamicObject company = bill.getDynamicObject("company");
        if (null == company) {
            tripSyncLogParam.setMessage("");
            tripSyncLogParam.setStatus("B");
            return null;
        }
        Long orgId = company.getLong("id");
        String server = fieldmapping.getDynamicObject("server").getString("number");
        List<Object> result = new ArrayList(8);
        if (orgId != null && (ctrlSettingObject = TripCommonUtil.getTripControlSettings(orgId, server)) != null) {
            String hoteldatectrl = ctrlSettingObject.getString("hoteldatectrl");
            result = "2".equals(hoteldatectrl) ? this.setHotelWholeBillErrandPolicy(ctrlSettingObject, tripentrys) : this.setHotelErrandPolicy(ctrlSettingObject, tripentrys);
            return result;
        }
        return null;
    }

    public Object getPlaneTripSetting(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject ctrlSettingObject;
        if (null == map.get("bill")) {
            return null;
        }
        DynamicObject bill = (DynamicObject)map.get("bill");
        DynamicObjectCollection tripentrys = bill.getDynamicObjectCollection("tripentry");
        if (tripentrys.isEmpty()) {
            return null;
        }
        Object paramsob = map.get("params");
        if (!(paramsob instanceof Map)) {
            tripSyncLogParam.setMessage("");
            tripSyncLogParam.setStatus("B");
            return null;
        }
        Map params = (Map)paramsob;
        DynamicObject fieldmapping = (DynamicObject)params.get("fieldmap");
        DynamicObject company = bill.getDynamicObject("company");
        if (null == company) {
            tripSyncLogParam.setMessage("");
            tripSyncLogParam.setStatus("B");
            return null;
        }
        Long orgId = company.getLong("id");
        String server = fieldmapping.getDynamicObject("server").getString("number");
        List<Object> result = new ArrayList(8);
        if (orgId != null && (ctrlSettingObject = TripCommonUtil.getTripControlSettings(orgId, server)) != null) {
            String domairdatectrl = ctrlSettingObject.getString("domairdatectrl");
            String domaircityctrl = ctrlSettingObject.getString("domaircityctrl");
            result = "2".equals(domairdatectrl) && "2".equals(domaircityctrl) ? this.setPlaneWholeBillErrandPolicy(ctrlSettingObject, tripentrys) : this.setPlaneErrandPolicy(ctrlSettingObject, tripentrys);
            return result;
        }
        return null;
    }

    private List<Map<String, Object>> setHotelErrandPolicy(DynamicObject ctrlSettingObject, DynamicObjectCollection tripentrys) {
        String hoteldatectrl = ctrlSettingObject.getString("hoteldatectrl");
        String hotelcityctrl = ctrlSettingObject.getString("hotelcityctrl");
        Map<String, Object> tripentryInfo = this.getTripentryInfo(tripentrys);
        ArrayList<Map<String, Object>> hotelErrandPolicys = new ArrayList<Map<String, Object>>(8);
        for (DynamicObject tripentry : tripentrys) {
            HashMap<String, Object> hotelErrandPolicy = new HashMap<String, Object>(8);
            Date startdate = tripentry.getDate("startdate");
            Date enddate = tripentry.getDate("enddate");
            String startDateStr = TripCommonUtil.DateToStr(startdate).substring(0, 10);
            String endDateStr = TripCommonUtil.DateToStr(enddate).substring(0, 10);
            DynamicObjectCollection travelers = tripentry.getDynamicObjectCollection("travelers");
            HashSet passengers = new HashSet(8);
            if (!travelers.isEmpty()) {
                for (DynamicObject traveler : travelers) {
                    HashMap<String, String> passenger = new HashMap<String, String>(1);
                    DynamicObject user = traveler.getDynamicObject("fbasedataid");
                    passenger.put("passengerName", user.getString("name"));
                    passengers.add(passenger);
                }
            }
            String toCityStr = tripentry.getDynamicObject("to").getString("name");
            hotelErrandPolicy.put("type", "HOTEL");
            if ("1".equals(hoteldatectrl)) {
                hotelErrandPolicy.put("checkinDateStart", startDateStr);
                hotelErrandPolicy.put("checkinDateEnd", endDateStr);
                hotelErrandPolicy.put("checkoutDateStart", startDateStr);
                hotelErrandPolicy.put("checkoutDateEnd", endDateStr);
            } else if ("2".equals(hoteldatectrl)) {
                hotelErrandPolicy.put("checkinDateStart", tripentryInfo.get("minStartDate"));
                hotelErrandPolicy.put("checkinDateEnd", tripentryInfo.get("maxEndDate"));
                hotelErrandPolicy.put("checkoutDateStart", tripentryInfo.get("minStartDate"));
                hotelErrandPolicy.put("checkoutDateEnd", tripentryInfo.get("maxEndDate"));
            }
            if ("1".equals(hotelcityctrl)) {
                hotelErrandPolicy.put("toCityNames", toCityStr);
            } else if ("2".equals(hotelcityctrl)) {
                hotelErrandPolicy.put("toCityNames", tripentryInfo.get("cityStr"));
            }
            hotelErrandPolicy.put("minStar", ctrlSettingObject.getInt("mixstarclass"));
            hotelErrandPolicy.put("maxStar", ctrlSettingObject.getInt("maxstarclass"));
            hotelErrandPolicy.put("roomCount", ctrlSettingObject.getInt("dayroomcount"));
            hotelErrandPolicy.put("passengers", passengers);
            hotelErrandPolicys.add(hotelErrandPolicy);
        }
        return hotelErrandPolicys;
    }

    private List<Map<String, Object>> setHotelWholeBillErrandPolicy(DynamicObject ctrlSettingObject, DynamicObjectCollection tripentrys) {
        Map<String, Object> tripentryInfo = this.getTripentryInfo(tripentrys);
        ArrayList<Map<String, Object>> hotelErrandPolicys = new ArrayList<Map<String, Object>>(8);
        HashMap<String, Object> hotelErrandPolicy = new HashMap<String, Object>(10);
        hotelErrandPolicy.put("type", "HOTEL");
        hotelErrandPolicy.put("checkinDateStart", tripentryInfo.get("minStartDate"));
        hotelErrandPolicy.put("checkinDateEnd", tripentryInfo.get("maxEndDate"));
        hotelErrandPolicy.put("checkoutDateStart", tripentryInfo.get("minStartDate"));
        hotelErrandPolicy.put("checkoutDateEnd", tripentryInfo.get("maxEndDate"));
        hotelErrandPolicy.put("toCityNames", tripentryInfo.get("cityStr"));
        hotelErrandPolicy.put("minStar", ctrlSettingObject.getInt("mixstarclass"));
        hotelErrandPolicy.put("maxStar", ctrlSettingObject.getInt("maxstarclass"));
        hotelErrandPolicy.put("roomCount", ctrlSettingObject.getInt("dayroomcount"));
        hotelErrandPolicy.put("passengers", tripentryInfo.get("passengers"));
        hotelErrandPolicys.add(hotelErrandPolicy);
        return hotelErrandPolicys;
    }

    private List<Map<String, Object>> setPlaneWholeBillErrandPolicy(DynamicObject ctrlSettingObject, DynamicObjectCollection tripentry) {
        Map<String, Object> tripentryInfo = this.getTripentryInfo(tripentry);
        ArrayList<Map<String, Object>> airErrandPolicys = new ArrayList<Map<String, Object>>(8);
        HashMap<String, Object> airErrandPolicy = new HashMap<String, Object>(8);
        airErrandPolicy.put("type", "DOMAIR");
        BigDecimal discount = ctrlSettingObject.getBigDecimal("domairdiscountctrl").multiply(new BigDecimal(10));
        airErrandPolicy.put("discount", discount.intValue());
        airErrandPolicy.put("flightType", "1".equals(ctrlSettingObject.getString("domairroundtripctrl")) ? "OW" : "RT");
        airErrandPolicy.put("takeoffDateStart", tripentryInfo.get("minStartDate"));
        airErrandPolicy.put("takeoffDateEnd", tripentryInfo.get("maxEndDate"));
        airErrandPolicy.put("returnDateStart", tripentryInfo.get("minStartDate"));
        airErrandPolicy.put("returnDateEnd", tripentryInfo.get("maxEndDate"));
        airErrandPolicy.put("fromCityNames", tripentryInfo.get("cityStr"));
        airErrandPolicy.put("toCityNames", tripentryInfo.get("cityStr"));
        airErrandPolicy.put("passengers", tripentryInfo.get("passengers"));
        airErrandPolicys.add(airErrandPolicy);
        return airErrandPolicys;
    }

    private Map<String, Object> getTripentryInfo(DynamicObjectCollection tripentrys) {
        HashSet<Date> startDates = new HashSet<Date>(8);
        HashSet<Date> endDates = new HashSet<Date>(8);
        HashSet passengers = new HashSet(8);
        String cityStr = "";
        for (DynamicObject tripentry : tripentrys) {
            Date startdate = tripentry.getDate("startdate");
            Date enddate = tripentry.getDate("enddate");
            startDates.add(startdate);
            endDates.add(enddate);
            DynamicObjectCollection travelers = tripentry.getDynamicObjectCollection("travelers");
            if (!travelers.isEmpty()) {
                for (DynamicObject traveler : travelers) {
                    HashMap<String, String> passenger = new HashMap<String, String>(1);
                    DynamicObject user = traveler.getDynamicObject("fbasedataid");
                    passenger.put("passengerName", user.getString("name"));
                    passengers.add(passenger);
                }
            }
            String fromCityStr = tripentry.getDynamicObject("from").getString("name");
            String toCityStr = tripentry.getDynamicObject("to").getString("name");
            if (StringUtils.isEmpty((CharSequence)cityStr)) {
                cityStr = fromCityStr;
            }
            if (!cityStr.contains(fromCityStr)) {
                cityStr = cityStr + "," + toCityStr;
            }
            if (cityStr.contains(toCityStr)) continue;
            cityStr = cityStr + "," + toCityStr;
        }
        Date startdate = (Date)Collections.min(startDates);
        Date enddate = (Date)Collections.max(endDates);
        String startDate = TripCommonUtil.DateToStr(startdate).substring(0, 10);
        String endDate = TripCommonUtil.DateToStr(enddate).substring(0, 10);
        HashMap<String, Object> info = new HashMap<String, Object>(8);
        info.put("minStartDate", startDate);
        info.put("maxEndDate", endDate);
        info.put("cityStr", cityStr);
        info.put("passengers", passengers);
        return info;
    }

    private List<Map<String, Object>> setPlaneErrandPolicy(DynamicObject ctrlSettingObject, DynamicObjectCollection tripentrys) {
        String domairdatectrl = ctrlSettingObject.getString("domairdatectrl");
        String domaircityctrl = ctrlSettingObject.getString("domaircityctrl");
        Map<String, Object> tripentryInfo = this.getTripentryInfo(tripentrys);
        ArrayList<Map<String, Object>> airErrandPolicys = new ArrayList<Map<String, Object>>(8);
        for (DynamicObject tripentry : tripentrys) {
            HashMap<String, Object> airErrandPolicy = new HashMap<String, Object>(8);
            Date startdate = tripentry.getDate("startdate");
            Date enddate = tripentry.getDate("enddate");
            DynamicObjectCollection travelers = tripentry.getDynamicObjectCollection("travelers");
            HashSet passengers = new HashSet(8);
            if (!travelers.isEmpty()) {
                for (DynamicObject traveler : travelers) {
                    HashMap<String, String> passenger = new HashMap<String, String>(1);
                    DynamicObject user = traveler.getDynamicObject("fbasedataid");
                    passenger.put("passengerName", user.getString("name"));
                    passengers.add(passenger);
                }
            }
            String startDateStr = TripCommonUtil.DateToStr(startdate).substring(0, 10);
            String endDateStr = TripCommonUtil.DateToStr(enddate).substring(0, 10);
            String fromCityStr = tripentry.getDynamicObject("from").getString("name");
            String toCityStr = tripentry.getDynamicObject("to").getString("name");
            airErrandPolicy.put("type", "DOMAIR");
            BigDecimal discount = ctrlSettingObject.getBigDecimal("domairdiscountctrl").multiply(new BigDecimal(10));
            airErrandPolicy.put("discount", discount.intValue());
            airErrandPolicy.put("flightType", "1".equals(ctrlSettingObject.getString("domairroundtripctrl")) ? "OW" : "RT");
            if ("1".equals(domairdatectrl)) {
                airErrandPolicy.put("takeoffDateStart", startDateStr);
                airErrandPolicy.put("takeoffDateEnd", endDateStr);
                airErrandPolicy.put("returnDateStart", startDateStr);
                airErrandPolicy.put("returnDateEnd", endDateStr);
            } else if ("2".equals(domairdatectrl)) {
                airErrandPolicy.put("takeoffDateStart", tripentryInfo.get("minStartDate"));
                airErrandPolicy.put("takeoffDateEnd", tripentryInfo.get("maxEndDate"));
                airErrandPolicy.put("returnDateStart", tripentryInfo.get("minStartDate"));
                airErrandPolicy.put("returnDateEnd", tripentryInfo.get("maxEndDate"));
            }
            if ("1".equals(domaircityctrl)) {
                airErrandPolicy.put("fromCityNames", fromCityStr);
                airErrandPolicy.put("toCityNames", toCityStr);
            } else if ("2".equals(domaircityctrl)) {
                airErrandPolicy.put("fromCityNames", tripentryInfo.get("cityStr"));
                airErrandPolicy.put("toCityNames", tripentryInfo.get("cityStr"));
            }
            airErrandPolicy.put("passengers", passengers);
            airErrandPolicys.add(airErrandPolicy);
        }
        return airErrandPolicys;
    }

    public Object getSign(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Map context;
        String appKey = (String)BizInfoPlugin.getInstance().getAppKey(map, tripSyncLogParam);
        String authCode = "";
        String appSecurity = (String)BizInfoPlugin.getInstance().getAppsecurity(map, tripSyncLogParam);
        if (map.get("context") != null && null != (context = (Map)map.get("context")).get("authCode")) {
            authCode = (String)context.get("authCode");
        }
        String currentUserNumber = UserPlugin.getInstance().getCurrentUserNumber(map, tripSyncLogParam);
        return MD5.getMD5Sign((String)(appKey + currentUserNumber + authCode + appSecurity)).toUpperCase();
    }

    public String getAuth(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        map.put("function", "er_biz_info");
        JSONObject json = FieldMappingPlugin.getInstance().getFieldMapResult(map, tripSyncLogParam);
        if (null == json || null == json.get((Object)"data") || !(json.get((Object)"data") instanceof String)) {
            tripSyncLogParam.setMessage(String.format(ResManager.loadKDString((String)"%1$s\u4f01\u6a59\u83b7\u53d6token\u5f02\u5e38\uff1a%2$s", (String)"QtripPlugin_01", (String)"fi-er-business", (Object[])new Object[0]), 4, null == json ? "" : JSON.toJSONString((Object)json)));
            tripSyncLogParam.setStatus("B");
            tripSyncLogParam.setResponsedata(json);
            return null;
        }
        return json.getString("data");
    }

    public Object getIsHaveForeignCity(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Object isHaveForeignCity = ReqBillPlugin.getInstance().getIsHaveForeignCity(map, tripSyncLogParam);
        if (null != isHaveForeignCity && Boolean.parseBoolean(isHaveForeignCity.toString())) {
            return "OVERSEAS";
        }
        return "INLAND";
    }

    public Object getStatusByParams(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Map params = (Map)map.get("params");
        if (null == params || null == params.get("status") || "1".equals(params.get("status").toString())) {
            return "300_WAIT_SUMMARY";
        }
        return "800_FINISH";
    }

    private static class loadClass {
        private static QtripPlugin service = new QtripPlugin();

        private loadClass() {
        }
    }
}

