/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.v2.server;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.dao.impl.ErOrm;
import kd.fi.er.business.servicehelper.invoice.GenerateInvoicerAssistant;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.business.trip.v2.function.PullInvoke;
import kd.fi.er.business.utils.ActionLocalCache;
import kd.fi.er.business.utils.JsonHelper;
import org.apache.commons.lang.StringUtils;

public abstract class CheckingCommonInvoke
extends PullInvoke {
    private static final Log logger = LogFactory.getLog(CheckingCommonInvoke.class);
    public static final String SERVER_INVOICE_MAP = "kd.fi.er.business.trip.util.TripCommonUtil.SERVER_INVOICE_MAP";

    @Override
    public Object execute(Map<String, Object> params) {
        Object execute = super.execute(params);
        this.params.remove("userMapping");
        this.params.remove("billMapping");
        this.params.remove("allorderMapping");
        this.params.remove("allcheckingMapping");
        this.params.remove("orderMapping");
        this.params.remove("checkingMapping");
        this.params.remove("checkMapping");
        return execute;
    }

    @Override
    protected Object fieldmapping(Object data) {
        Long time = System.currentTimeMillis();
        this.beforeCheckingQuery(data);
        logger.info("\u5b57\u6bb5\u6620\u5c04\u4fdd\u5b58\u7ed3\u7b97\u5355\u57fa\u7840\u6570\u636e\u67e5\u8be2\u8017\u8d39\uff1a{}", (Object)(System.currentTimeMillis() - time));
        return super.fieldmapping(data);
    }

    @Override
    protected List<DynamicObject> saveInfos(Object infos) {
        Long time = System.currentTimeMillis();
        List<DynamicObject> list = null;
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                list = super.saveInfos(infos);
                this.saveAllChecking(list);
                this.saveOrder(list);
            }
            catch (Exception e) {
                txHandle.markRollback();
                throw new RuntimeException(e);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.params != null && null == this.params.get("input_data") && "1".equals(this.params.getOrDefault("needCreateCheckingBill", "1"))) {
            this.saveCheckBill(list);
        }
        logger.info("\u5b57\u6bb5\u6620\u5c04\u4fdd\u5b58\u7ed3\u7b97\u5355\u5168\u90e8\u8017\u8d39\uff1a{}", (Object)(System.currentTimeMillis() - time));
        return list;
    }

    @Override
    public boolean isComfirmUpdate(DynamicObject object) {
        Boolean confirmed_data_modified = TripSyncConfigUtil.getBoolean("confirmed_data_modified");
        Boolean comfirmUpdate = confirmed_data_modified != false || !"C".equalsIgnoreCase(object.getString("billstatus"));
        if (!comfirmUpdate.booleanValue()) {
            logger.info("\u5546\u65c5\u96c6\u6210,\u7ed3\u7b97\u5355\u4fdd\u5b58,\u5df2\u5ba1\u6838\u7684\u7ed3\u7b97\u5355,\u4e0d\u518d\u91cd\u65b0\u63a5\u6536,\u7ed3\u7b97\u5355\u7f16\u53f7:" + object.getString("ordernum"));
        }
        return comfirmUpdate;
    }

    public void beforeCheckingQuery(Object data) {
        QFilter userQFilter;
        DynamicObject[] users;
        DynamicObject[] checkbills;
        QFilter qFilter;
        if (!CheckingCommonInvoke.checkFieldmap(data, this.tripSyncLogParam, this.params).booleanValue()) {
            return;
        }
        DynamicObject fieldmapping = (DynamicObject)this.params.get("fieldmap");
        String number = fieldmapping.getString("number");
        DynamicObjectCollection fieldmapentry = fieldmapping.getDynamicObjectCollection("fieldmapentry");
        DynamicObject server = fieldmapping.getDynamicObject("server");
        DynamicObject dfunction = fieldmapping.getDynamicObject("function");
        String function = dfunction.getString("id");
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)function);
        String primarykey = TripCommonUtil.getPkeyByMapsource(fieldmapentry);
        if (null == primarykey) {
            this.tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u5546\u65c5\u5b57\u6bb5\u6620\u5c04[%s]\uff0c\u672a\u8bbe\u7f6e\u4e3b\u952e\u3002", (String)"AbstractPullInvoke_01", (String)"fi-er-business", (Object[])new Object[]{number}));
            this.tripSyncLogParam.setStatus("B");
            return;
        }
        String lastkey = "";
        String pkey = JsonHelper.getZeroKey(primarykey);
        if (pkey.contains("]")) {
            lastkey = pkey.substring(0, pkey.lastIndexOf(".["));
        }
        LinkedHashMap<String, Object> jsonToMap = new LinkedHashMap<String, Object>();
        JsonHelper.convertJsonToMap(data, "", jsonToMap);
        if (null == jsonToMap.get(pkey)) {
            logger.info("\u5b57\u6bb5\u6620\u5c04\u7684\u6570\u636e\u5185\u5bb9\uff0c\u4e0d\u542b\u4e3b\u952e:{}", (Object)pkey);
            this.tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u5546\u65c5\u5b57\u6bb5\u6620\u5c04[%s]\uff0c\u6ca1\u6709\u67e5\u8be2\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u3002", (String)"AbstractPullInvoke_14", (String)"fi-er-business", (Object[])new Object[]{number}));
            this.tripSyncLogParam.setStatus("B");
            return;
        }
        HashSet<String> oaBillNoSet = new HashSet<String>();
        HashSet<String> userNumSet = new HashSet<String>();
        HashSet orderNumSet = new HashSet();
        do {
            if (CheckingCommonInvoke.discontinue().booleanValue()) {
                return;
            }
            DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)type);
            String pkValue = "";
            for (DynamicObject fieldmap : fieldmapentry) {
                if (!"1".equals(fieldmap.getString("mapstatus"))) continue;
                String maptargetfield = fieldmap.getString("maptargetfield");
                String mapsourcefield = fieldmap.getString("mapsourcefield");
                String maptype = fieldmap.getString("maptype");
                if (null != fieldmap.getString("maptypeext") && !fieldmap.getString("maptypeext").isEmpty() || null != fieldmap.getString("mapsourcefieldext") && !fieldmap.getString("mapsourcefieldext").isEmpty()) {
                    mapsourcefield = fieldmap.getString("mapsourcefieldext");
                }
                if (StringUtils.isEmpty((String)maptargetfield) || "1".equals(maptype) && StringUtils.isBlank((String)mapsourcefield)) continue;
                switch (maptargetfield) {
                    case "oabillnum": {
                        DynamicObject[] field = JsonHelper.getJkey(lastkey, pkey, mapsourcefield);
                        Object dvalue = jsonToMap.get(field);
                        if (!(dvalue instanceof String) || !org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((String)dvalue).trim())) break;
                        oaBillNoSet.add(((String)dvalue).trim());
                        break;
                    }
                    case "sourcebookedid": 
                    case "passeger": 
                    case "sourcetravelerid": {
                        DynamicObject[] field = JsonHelper.getJkey(lastkey, pkey, mapsourcefield);
                        Object dvalue = jsonToMap.get(field);
                        if (!(dvalue instanceof String) || !org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((String)dvalue).trim())) break;
                        userNumSet.add(((String)dvalue).trim());
                        break;
                    }
                    case "ordernum": {
                        Object dvalue = this.getDvalue(lastkey, pkey, jsonToMap, pkValue, dynamicObject, fieldmap);
                        Object v = this.getObjectByType(type, maptargetfield, dvalue);
                        dynamicObject.set(maptargetfield, v);
                        if (dvalue == null || !(dvalue instanceof String) || !org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((String)dvalue))) break;
                        orderNumSet.add(dvalue);
                    }
                }
            }
        } while (null != (pkey = JsonHelper.getAddKey(pkey, jsonToMap, JsonHelper.getPatch(pkey, ""))) && !pkey.isEmpty());
        HashMap<String, DynamicObject> userMapping = new HashMap<String, DynamicObject>();
        HashMap<String, DynamicObject> billMapping = new HashMap<String, DynamicObject>();
        HashMap<String, DynamicObject> allorderMapping = new HashMap<String, DynamicObject>();
        HashMap orderMapping = new HashMap();
        HashMap<String, DynamicObject> allcheckingMapping = new HashMap<String, DynamicObject>();
        HashMap checkingMapping = new HashMap();
        HashMap<String, DynamicObject> checkMapping = new HashMap<String, DynamicObject>();
        if (!orderNumSet.isEmpty()) {
            DynamicObject[] allcheckingbills;
            qFilter = new QFilter("ordernum", "in", orderNumSet);
            DynamicObject[] allorderbills = ErOrm.load("er_allorderbill", new QFilter[]{qFilter});
            if (null != allorderbills) {
                for (DynamicObject orderbill : allorderbills) {
                    allorderMapping.put(orderbill.getString("ordernum"), orderbill);
                }
                QFilter finalQFilter = qFilter;
                Arrays.stream(allorderbills).collect(Collectors.groupingBy(dynamic -> dynamic.get("orderformid"))).forEach((key, dynamicObjects) -> {
                    DynamicObject[] orders;
                    for (DynamicObject order : orders = ErOrm.load((String)key, new QFilter[]{finalQFilter})) {
                        orderMapping.put(order.getString("orderNum"), order);
                    }
                });
            }
            if (null != (allcheckingbills = ErOrm.load("er_allcheckingbill", new QFilter[]{qFilter}))) {
                for (DynamicObject checkingbill : allcheckingbills) {
                    allcheckingMapping.put(checkingbill.getString("ordernum"), checkingbill);
                }
                QFilter finalQFilter = qFilter;
                Arrays.stream(allcheckingbills).collect(Collectors.groupingBy(dynamic -> dynamic.getString("checkingformid"))).forEach((key, dynamicObjects) -> {
                    DynamicObject[] checkings;
                    for (DynamicObject checking : checkings = ErOrm.load(key, new QFilter[]{finalQFilter})) {
                        checkingMapping.put(checking.getString("ordernum"), checking);
                    }
                });
            }
        }
        qFilter = new QFilter("server", "=", (Object)server.getString("number"));
        if (null != this.params.get("bill_id")) {
            qFilter.and("billnum", "like", (Object)(this.params.get("bill_id") + "%"));
        }
        if (null != this.params.get("beginDate")) {
            Date beginDate = null;
            DynamicObject[] beginDateStr = this.params.get("beginDate").toString();
            if (this.params.get("beginDate") instanceof Date) {
                beginDate = (Date)this.params.get("beginDate");
            }
            if (this.params.get("beginDate") instanceof String) {
                if (beginDateStr.contains("-")) {
                    beginDate = TripCommonUtil.convertToDate((String)beginDateStr);
                } else if (beginDateStr.length() == 8) {
                    Calendar cal = Calendar.getInstance();
                    cal.set(1, Integer.parseInt(beginDateStr.substring(0, 4)));
                    cal.set(2, Integer.parseInt(beginDateStr.substring(5, 6)) - 1);
                    cal.set(5, Integer.parseInt(beginDateStr.substring(7, 8)));
                    beginDate = cal.getTime();
                }
            }
            if (null != beginDate) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(beginDate);
                cal.set(5, cal.getActualMinimum(5));
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                qFilter.and("periodstartdate", "=", (Object)cal.getTime());
            }
        }
        if (null != (checkbills = ErOrm.load("er_checkingbill", new QFilter[]{qFilter}))) {
            for (DynamicObject checkbill : checkbills) {
                checkMapping.put(checkbill.getString("billnum"), checkbill);
            }
        }
        if (!oaBillNoSet.isEmpty()) {
            DynamicObject[] applyBills;
            DynamicObject[] mealApplyBills;
            DynamicObject[] dailyApplyBills;
            DynamicObject[] dailyVehicleBills;
            qFilter = new QFilter("billno", "in", oaBillNoSet);
            DynamicObject[] reqbills = ErOrm.load("er_tripreqbill", new QFilter[]{qFilter});
            if (null != reqbills) {
                for (DynamicObject reqbill : reqbills) {
                    billMapping.put(reqbill.getString("billno"), reqbill);
                    oaBillNoSet.remove(reqbill.getString("billno"));
                }
            }
            if (null != (dailyVehicleBills = ErOrm.load("er_dailyvehiclebill", new QFilter[]{qFilter}))) {
                for (DynamicObject dailyVehicleBill : dailyVehicleBills) {
                    if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)dailyVehicleBill.getString("billno"))) continue;
                    billMapping.put(dailyVehicleBill.getString("billno"), dailyVehicleBill);
                    oaBillNoSet.remove(dailyVehicleBill.getString("billno"));
                }
            }
            if (null != (dailyApplyBills = ErOrm.load("er_dailyapplybill", new QFilter[]{qFilter}))) {
                for (DynamicObject dailyApplybill : dailyApplyBills) {
                    if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)dailyApplybill.getString("billno"))) continue;
                    billMapping.put(dailyApplybill.getString("billno"), dailyApplybill);
                    oaBillNoSet.remove(dailyApplybill.getString("billno"));
                }
            }
            if (null != (mealApplyBills = ErOrm.load("er_mealapplication_bill", new QFilter[]{qFilter}))) {
                for (DynamicObject mealApplyBill : mealApplyBills) {
                    if (!StringUtils.isNotBlank((String)mealApplyBill.getString("billno"))) continue;
                    billMapping.put(mealApplyBill.getString("billno"), mealApplyBill);
                }
            }
            if (null != (applyBills = ErOrm.load("er_dailyapplybill", new QFilter[]{qFilter}))) {
                for (DynamicObject applyBill : applyBills) {
                    if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)applyBill.getString("billno"))) continue;
                    billMapping.put(applyBill.getString("billno"), applyBill);
                }
            }
        }
        if (!userNumSet.isEmpty() && null != (users = ErOrm.load("bos_user", new QFilter[]{userQFilter = new QFilter("number", "in", userNumSet)}))) {
            for (DynamicObject user : users) {
                userMapping.put(user.getString("number"), user);
                userMapping.put(user.getString("id"), user);
            }
        }
        this.params.put("userMapping", userMapping);
        this.params.put("billMapping", billMapping);
        this.params.put("allorderMapping", allorderMapping);
        this.params.put("allcheckingMapping", allcheckingMapping);
        this.params.put("orderMapping", orderMapping);
        this.params.put("checkingMapping", checkingMapping);
        List invoiceSetting = (List)ActionLocalCache.get().get(SERVER_INVOICE_MAP, server.getString("number") + this.tripSyncLogParam.getTraceid(), () -> GenerateInvoicerAssistant.getInvoiceSetting(server.getString("number"), null));
        this.params.put("invoiceSetting", invoiceSetting);
        this.params.put("checkMapping", checkMapping);
    }

    public void saveOrder(List<DynamicObject> list) {
        Map orderMapping = (Map)this.params.get("orderMapping");
        Map allorderMapping = (Map)this.params.get("allorderMapping");
        if (null == list || list.isEmpty()) {
            return;
        }
        for (DynamicObject checking : list) {
            DynamicObject order;
            if (null != orderMapping && null != (order = (DynamicObject)orderMapping.get(checking.getString("ordernum")))) {
                order.set("isreconciliation", (Object)"1".equals(checking.getString("isbalance")));
            }
            if (null == allorderMapping || null == (order = (DynamicObject)allorderMapping.get(checking.getString("ordernum")))) continue;
            order.set("isreconciliation", (Object)"1".equals(checking.getString("isbalance")));
        }
        if (null != orderMapping) {
            SaveServiceHelper.save((DynamicObject[])orderMapping.values().toArray(new DynamicObject[0]));
        }
        if (null != allorderMapping) {
            SaveServiceHelper.save((DynamicObject[])allorderMapping.values().toArray(new DynamicObject[0]));
        }
    }

    public List<DynamicObject> saveAllChecking(List<DynamicObject> list) {
        DynamicObject fieldmapping = (DynamicObject)this.params.get("fieldmap");
        if (null == fieldmapping) {
            this.tripSyncLogParam.setStatus("B");
            this.tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u5546\u65c5\u5b57\u6bb5\u6620\u5c04\u672a\u914d\u7f6e\u3002", (String)"AbstractPullInvoke_07", (String)"fi-er-business", (Object[])new Object[0]));
            return new ArrayList<DynamicObject>();
        }
        String number = fieldmapping.getString("number");
        DynamicObjectCollection fieldmapentry = fieldmapping.getDynamicObjectCollection("fieldmapentry");
        if (null == fieldmapentry) {
            this.tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u5546\u65c5\u5b57\u6bb5\u6620\u5c04\u201c%s\u201d\uff0c\u672a\u8bbe\u7f6e\u5b57\u6bb5\u6620\u5c04\u5206\u5f55\u3002", (String)"AbstractPullInvoke_11", (String)"fi-er-business", (Object[])new Object[]{number}));
            this.tripSyncLogParam.setStatus("B");
            return new ArrayList<DynamicObject>();
        }
        DynamicObject server = fieldmapping.getDynamicObject("server");
        if (null == server) {
            this.tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u5546\u65c5\u5b57\u6bb5\u6620\u5c04\u201c%s\u201d\uff0c\u672a\u8bbe\u7f6e\u670d\u52a1\u5546\u3002", (String)"AbstractPullInvoke_12", (String)"fi-er-business", (Object[])new Object[]{number}));
            this.tripSyncLogParam.setStatus("B");
            return new ArrayList<DynamicObject>();
        }
        if (!(list instanceof List)) {
            logger.info("\u5546\u65c5\u5b57\u6bb5\u6620\u5c04\uff0c\u5b57\u6bb5\u6620\u5c04\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (Object)number);
            return new ArrayList<DynamicObject>();
        }
        String primarykey = null;
        HashSet<String> billfields = new HashSet<String>(fieldmapentry.size());
        for (DynamicObject dynamicObject : fieldmapentry) {
            if (!"1".equals(dynamicObject.getString("mapstatus"))) continue;
            String field = dynamicObject.getString("maptargetfield");
            Boolean mapprimarykey = dynamicObject.getBoolean("mapprimarykey");
            if (mapprimarykey.booleanValue()) {
                primarykey = field;
            }
            billfields.add(field);
        }
        if (null == primarykey) {
            this.tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u5546\u65c5\u5b57\u6bb5\u6620\u5c04[%s]\uff0c\u672a\u8bbe\u7f6e\u4e3b\u952e\u3002", (String)"AbstractPullInvoke_01", (String)"fi-er-business", (Object[])new Object[]{number}));
            this.tripSyncLogParam.setStatus("B");
            return new ArrayList<DynamicObject>();
        }
        if (list.isEmpty()) {
            logger.info("\u5546\u65c5\u5b57\u6bb5\u6620\u5c04{}\uff0c\u5b57\u6bb5\u6620\u5c04\u6570\u636e\u4e3a\u7a7a\u3002", (Object)number);
            return new ArrayList<DynamicObject>();
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"er_allcheckingbill");
        String tableName = type.getAlias();
        long[] ids = DBServiceHelper.genLongIds((String)tableName, (int)list.size());
        Map exsitDynamicObjectMap = (Map)this.params.get("allcheckingMapping");
        ArrayList<DynamicObject> saves = new ArrayList<DynamicObject>(list.size());
        DataEntityPropertyCollection allCheckingProperties = type.getProperties();
        for (int i = 0; i < list.size(); ++i) {
            DynamicObject allchecking = new DynamicObject((DynamicObjectType)type);
            DynamicObject checking = list.get(i);
            for (IDataEntityProperty checkingProperty : allCheckingProperties) {
                String orderPropName = checkingProperty.getName();
                if (!checking.containsProperty(orderPropName)) continue;
                if (allchecking.getDataEntityType().getProperties().get((Object)orderPropName) instanceof BasedataProp) {
                    allchecking.set(orderPropName, checking.get(orderPropName));
                    allchecking.set(orderPropName + "_id", checking.get(orderPropName));
                    continue;
                }
                allchecking.set(orderPropName, checking.get(orderPropName.endsWith("_id") ? orderPropName.replace("_id", "") : orderPropName));
            }
            allchecking.set("checkingformid", (Object)checking.getDynamicObjectType().getName());
            allchecking.set("checkingid", checking.get("id"));
            if (exsitDynamicObjectMap == null || exsitDynamicObjectMap.isEmpty()) {
                allchecking.set("id", (Object)ids[i]);
                saves.add(allchecking);
                continue;
            }
            DynamicObject exsitDynamicObject = (DynamicObject)exsitDynamicObjectMap.get(allchecking.getString(primarykey));
            if (null == exsitDynamicObject || null == exsitDynamicObject.getString(primarykey) || null == allchecking.getString(primarykey)) {
                allchecking.set("id", (Object)ids[i]);
                saves.add(allchecking);
                continue;
            }
            logger.info("\u5546\u65c5\u96c6\u6210\u5b57\u6bb5\u6620\u5c04-{}-{}-\u4fee\u6539id:{},primarykey:{}", new Object[]{exsitDynamicObject.getDataEntityType().getName(), allchecking.getDataEntityType().getName(), exsitDynamicObject.get("id"), allchecking.getString(primarykey)});
            for (String propertyName : billfields) {
                if (TripCommonUtil.NotCopyField.contains(propertyName) || !exsitDynamicObject.containsProperty(propertyName) || allchecking.get(propertyName) == null) continue;
                if (exsitDynamicObject.getDataEntityType().getProperties().get((Object)propertyName) instanceof BasedataProp) {
                    exsitDynamicObject.set(propertyName, allchecking.get(propertyName));
                    exsitDynamicObject.set(propertyName + "_id", allchecking.get(propertyName));
                    continue;
                }
                exsitDynamicObject.set(propertyName, allchecking.get(propertyName.endsWith("_id") ? propertyName.replace("_id", "") : propertyName));
            }
            saves.add(exsitDynamicObject);
        }
        SaveServiceHelper.save((DynamicObject[])saves.toArray(new DynamicObject[0]));
        return saves;
    }

    public List<DynamicObject> saveCheckBill(List<DynamicObject> list) {
        logger.info("\u6708\u7ed3\u8d26\u5355\u6784\u5efa");
        if (null == list || list.isEmpty()) {
            return new ArrayList<DynamicObject>();
        }
        DynamicObject fieldmapping = (DynamicObject)this.params.get("fieldmap");
        if (null == fieldmapping) {
            this.tripSyncLogParam.setStatus("B");
            this.tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u5546\u65c5\u5b57\u6bb5\u6620\u5c04\u672a\u914d\u7f6e\u3002", (String)"AbstractPullInvoke_07", (String)"fi-er-business", (Object[])new Object[0]));
            return new ArrayList<DynamicObject>();
        }
        String number = fieldmapping.getString("number");
        DynamicObject server = fieldmapping.getDynamicObject("server");
        if (null == server) {
            this.tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u5546\u65c5\u5b57\u6bb5\u6620\u5c04\u201c%s\u201d\uff0c\u672a\u8bbe\u7f6e\u670d\u52a1\u5546\u3002", (String)"AbstractPullInvoke_12", (String)"fi-er-business", (Object[])new Object[]{number}));
            this.tripSyncLogParam.setStatus("B");
            return new ArrayList<DynamicObject>();
        }
        HashSet<String> checknums = new HashSet<String>(list.size());
        HashMap checkmap = new HashMap(list.size());
        for (DynamicObject dynamicObject : list) {
            String checkingbillnum = dynamicObject.getString("checkingbillnum");
            String checknum = this.getChecknum(dynamicObject);
            if (null != checkmap.get(checknum)) {
                ((List)checkmap.get(checknum)).add(dynamicObject);
            } else {
                ArrayList<DynamicObject> fcheckings = new ArrayList<DynamicObject>();
                fcheckings.add(dynamicObject);
                checkmap.put(checknum, fcheckings);
            }
            checknums.add(checkingbillnum);
        }
        if (checkmap.isEmpty()) {
            return new ArrayList<DynamicObject>();
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"er_checkingbill");
        String tableName = type.getAlias();
        long[] ids = DBServiceHelper.genLongIds((String)tableName, (int)list.size());
        DynamicObject[] dy = ErOrm.load("er_checkingbill", new QFilter[]{new QFilter("billnum", "in", checknums), new QFilter("server", "=", (Object)server.getString("number"))});
        HashMap exsitDynamicObjectMap = null;
        if (null != dy && dy.length > 0) {
            exsitDynamicObjectMap = Maps.newHashMapWithExpectedSize((int)dy.length);
            for (DynamicObject dynamicObject : dy) {
                exsitDynamicObjectMap.put(dynamicObject.getString("billnum"), dynamicObject);
            }
        }
        DynamicObjectCollection allcheckinglist = QueryServiceHelper.query((String)"er_allcheckingbill", (String)"id,checkingbillnum,totalamount", (QFilter[])new QFilter[]{new QFilter("checkingbillnum", "in", checknums), new QFilter("server", "=", (Object)server.getString("number"))});
        HashMap<String, BigDecimal> allcheckingamountMap = new HashMap<String, BigDecimal>(allcheckinglist.size());
        if (null != allcheckinglist && !allcheckinglist.isEmpty()) {
            for (DynamicObject dynamicObject : allcheckinglist) {
                String checkingbillnum = dynamicObject.getString("checkingbillnum");
                BigDecimal totalamount = dynamicObject.getBigDecimal("totalamount");
                allcheckingamountMap.merge(checkingbillnum, totalamount, BigDecimal::add);
            }
        }
        ArrayList<DynamicObject> saves = new ArrayList<DynamicObject>(list.size());
        Iterator iterator = checkmap.entrySet().iterator();
        Date date = new Date();
        Integer i = -1;
        Map<String, Object> notExpectedValueMap = TripCommonUtil.notExpectedValueMap;
        List<String> notCopyField = TripCommonUtil.NotCopyField;
        Boolean confirmed_data_modified = TripSyncConfigUtil.getBoolean("confirmed_data_modified");
        while (iterator.hasNext()) {
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
            Map.Entry next = iterator.next();
            String key = (String)next.getKey();
            List dynamicObjects = (List)checkmap.get(key);
            if (null == dynamicObjects || dynamicObjects.isEmpty()) continue;
            DynamicObject check = new DynamicObject((DynamicObjectType)type);
            DynamicObject fchecking = (DynamicObject)dynamicObjects.get(0);
            DataEntityPropertyCollection checkProperties = check.getDataEntityType().getProperties();
            for (IDataEntityProperty checkingProperty : checkProperties) {
                String orderPropName = checkingProperty.getName();
                if (!fchecking.containsProperty(orderPropName)) continue;
                if (check.getDataEntityType().getProperties().get((Object)orderPropName) instanceof BasedataProp) {
                    check.set(orderPropName, fchecking.get(orderPropName));
                    check.set(orderPropName + "_id", fchecking.get(orderPropName));
                    continue;
                }
                check.set(orderPropName, fchecking.get(orderPropName.endsWith("_id") ? orderPropName.replace("_id", "") : orderPropName));
            }
            this.collectionByCompany(check, fchecking);
            check.set("creator", (Object)RequestContext.get().getCurrUserId());
            check.set("createtime", (Object)date);
            check.set("modifier", (Object)RequestContext.get().getCurrUserId());
            check.set("modifytime", (Object)date);
            check.set("billstatusname", (Object)"1");
            check.set("billno", (Object)fchecking.getString("checkingbillnum"));
            check.set("billnum", (Object)fchecking.getString("checkingbillnum"));
            check.set("settlementamount", (Object)allcheckingamountMap.getOrDefault(fchecking.getString("checkingbillnum"), BigDecimal.ZERO));
            if (null != this.params.get("perioddate") && this.params.get("perioddate") instanceof Date) {
                check.set("periodstartdate", (Object)TripCommonUtil.strToDate(TripCommonUtil.getMonthFirstDay((Date)this.params.get("perioddate")), "yyyy-MM-dd"));
                check.set("periodenddate", (Object)TripCommonUtil.strToDate(TripCommonUtil.getMonthLastDay((Date)this.params.get("perioddate")), "yyyy-MM-dd"));
            } else {
                check.set("periodstartdate", (Object)TripCommonUtil.strToDate(TripCommonUtil.getLastMonthFirstDay(fchecking.getDate("happenddate")), "yyyy-MM-dd"));
                check.set("periodenddate", (Object)TripCommonUtil.strToDate(TripCommonUtil.getLastMonthLastDay(fchecking.getDate("happenddate")), "yyyy-MM-dd"));
            }
            if (exsitDynamicObjectMap == null || exsitDynamicObjectMap.isEmpty()) {
                check.set("id", (Object)ids[i]);
                saves.add(check);
                continue;
            }
            DynamicObject exsitDynamicObject = (DynamicObject)exsitDynamicObjectMap.get(fchecking.getString("checkingbillnum"));
            if (null == exsitDynamicObject || !key.startsWith(exsitDynamicObject.getString("billnum")) || !fchecking.getString("operationtype").equals(exsitDynamicObject.getString("operationtype"))) {
                check.set("id", (Object)ids[i]);
                saves.add(check);
                continue;
            }
            if (!key.startsWith(exsitDynamicObject.getString("billnum")) || !fchecking.getString("operationtype").equals(exsitDynamicObject.getString("operationtype"))) continue;
            if (!confirmed_data_modified.booleanValue() && ("2".equalsIgnoreCase(exsitDynamicObject.getString("billstatusname")) || "3".equalsIgnoreCase(exsitDynamicObject.getString("billstatusname")))) {
                logger.info("\u5546\u65c5\u96c6\u6210,\u7ed3\u7b97\u5355\u4fdd\u5b58,\u5df2\u5ba1\u6838\u6216\u5df2\u786e\u8ba4\u7684\u6708\u7ed3\u8d26\u5355,\u4e0d\u518d\u91cd\u65b0\u63a5\u6536,\u6708\u7ed3\u8d26\u5355\u7f16\u53f7:" + exsitDynamicObject.getString("billnum"));
                continue;
            }
            for (IDataEntityProperty property : checkProperties) {
                Object o;
                String propertyName = property.getName();
                boolean needUpdate = Boolean.FALSE;
                if (notCopyField.contains(propertyName) && exsitDynamicObject.containsProperty(propertyName) && ((o = exsitDynamicObject.get(propertyName)) == null || StringUtils.isBlank((String)o.toString()))) {
                    needUpdate = Boolean.TRUE;
                }
                if (notCopyField.contains(propertyName) && !needUpdate || !exsitDynamicObject.containsProperty(propertyName) || check.get(propertyName) == null) continue;
                if (exsitDynamicObject.getDataEntityType().getProperties().get((Object)propertyName) instanceof BasedataProp) {
                    exsitDynamicObject.set(propertyName, check.get(propertyName));
                    exsitDynamicObject.set(propertyName + "_id", check.get(propertyName));
                    continue;
                }
                exsitDynamicObject.set(propertyName, check.get(propertyName.endsWith("_id") ? propertyName.replace("_id", "") : propertyName));
            }
            saves.add(exsitDynamicObject);
        }
        SaveServiceHelper.save((DynamicObject[])saves.toArray(new DynamicObject[0]));
        return saves;
    }

    public void collectionByCompany(DynamicObject check, DynamicObject fchecking) {
    }

    public String getChecknum(DynamicObject dynamicObject) {
        return dynamicObject.getString("checkingbillnum");
    }
}

