/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.v2.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.er.business.dao.impl.ErOrm;
import kd.fi.er.business.message.ErMessageServiceHelper;
import kd.fi.er.business.trip.supplier.ctrip.invoke.convert.ConvertUtil;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.v2.function.PullInvoke;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.JsonHelper;
import org.apache.commons.lang.StringUtils;

public class OrderCommonInvoke
extends PullInvoke {
    private static final Log logger = LogFactory.getLog(OrderCommonInvoke.class);

    @Override
    public Object execute(Map<String, Object> params) {
        Object execute = super.execute(params);
        this.params.remove("userMapping");
        this.params.remove("billMapping");
        return execute;
    }

    @Override
    protected Object fieldmapping(Object data) {
        Long time = System.currentTimeMillis();
        this.beforeOrderQuery(data);
        logger.info("\u5b57\u6bb5\u6620\u5c04\u4fdd\u5b58\u5168\u90e8\u8ba2\u5355\u57fa\u7840\u6570\u636e\u67e5\u8be2\u8017\u8d39\uff1a{}", (Object)(System.currentTimeMillis() - time));
        return super.fieldmapping(data);
    }

    @Override
    protected List<DynamicObject> saveInfos(Object infos) {
        Long time = System.currentTimeMillis();
        List<DynamicObject> list = null;
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                list = super.saveInfos(infos);
                this.saveAllOrder(list);
            }
            catch (Exception e) {
                txHandle.markRollback();
                throw new RuntimeException(e);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        logger.info("\u5b57\u6bb5\u6620\u5c04\u4fdd\u5b58\u5168\u90e8\u8ba2\u5355\u8017\u8d39\uff1a{}", (Object)(System.currentTimeMillis() - time));
        final List<DynamicObject> finalList = list;
        ThreadService.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                logger.info("\u5b57\u6bb5\u6620\u5c04\u53d1\u9001\u6d88\u606ftraceid \uff1a{}", (Object)OrderCommonInvoke.this.tripSyncLogParam.getTraceid());
                OrderCommonInvoke.this.sendMessageToReimburser(finalList);
                OrderCommonInvoke.this.sendConfrimMessage(finalList);
            }
        }, (TaskType)TaskType.ER_TRIP_TASK, (RequestContext)RequestContext.get());
        return list;
    }

    private void sendMessageToReimburser(List<DynamicObject> list) {
        try {
            String msgTime;
            if (list == null || list.size() < 1) {
                return;
            }
            Map allOrder = new HashMap(list.size());
            if (null != this.params.get("allorderMapping")) {
                allOrder = (Map)this.params.get("allorderMapping");
            }
            String string = msgTime = (msgTime = (String)ErCommonUtils.getEMParameter(OrgUnitServiceHelper.getRootOrgId(), "tripmsgtype")) == null ? "none" : msgTime;
            if (msgTime == null || "none".equals(msgTime)) {
                return;
            }
            for (DynamicObject dynamicObject : list) {
                if ("update".equals(msgTime) && null == allOrder.get(dynamicObject.getString("ordernum")) || "addnew".equals(msgTime) && null != allOrder.get(dynamicObject.getString("ordernum"))) continue;
                ErMessageServiceHelper.sendMessageByBillDO("trip_order_change", dynamicObject.getDataEntityType().getName(), new DynamicObject[]{dynamicObject}, "sourceBookedId");
            }
        }
        catch (Exception e) {
            logger.error("\u5546\u65c5\u96c6\u6210,\u8ba2\u5355\u4fdd\u5b58,\u53d1\u9001\u6d88\u606f\u5931\u8d25:", (Throwable)e);
        }
    }

    private void sendConfrimMessage(List<DynamicObject> list) {
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(list.size());
        String key = list.get(0).getDataEntityType().getName();
        for (DynamicObject dynamicObject : list) {
            if ("er_planebill".equals(key) || "er_hotelbill".equals(key) || "er_vehiclebill".equals(key)) {
                if (dynamicObject.getBigDecimal("totalamount") == null || ConvertUtil.getOrderAmountInit().compareTo(dynamicObject.getBigDecimal("totalamount")) == 0 || dynamicObject.getBoolean("isconfirm") || dynamicObject.getInt("noticetimes") >= 1) continue;
                dynamicObjects.add(dynamicObject);
                continue;
            }
            if (dynamicObject.getBoolean("isconfirm") || dynamicObject.getInt("noticetimes") >= 1) continue;
            dynamicObjects.add(dynamicObject);
        }
        if (dynamicObjects.size() > 0) {
            ErMessageServiceHelper.sendTripOrderConfrimMessage(dynamicObjects.toArray(new DynamicObject[0]), key, true, true);
        } else {
            logger.info("\u6ca1\u6709\u9700\u8981\u53d1\u9001\u6d88\u606f\u7684\u8ba2\u5355");
        }
    }

    public void beforeOrderQuery(Object data) {
        QFilter userQFilter;
        DynamicObject[] users;
        QFilter qFilter;
        DynamicObject[] allorderbills;
        if (!OrderCommonInvoke.checkFieldmap(data, this.tripSyncLogParam, this.params).booleanValue()) {
            return;
        }
        DynamicObject fieldmapping = (DynamicObject)this.params.get("fieldmap");
        String number = fieldmapping.getString("number");
        DynamicObjectCollection fieldmapentry = fieldmapping.getDynamicObjectCollection("fieldmapentry");
        DynamicObject dfunction = fieldmapping.getDynamicObject("function");
        String function = dfunction.getString("id");
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)function);
        String primarykey = TripCommonUtil.getPkeyByMapsource(fieldmapentry);
        if (null == primarykey) {
            this.tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u5546\u65c5\u5b57\u6bb5\u6620\u5c04[%s]\uff0c\u672a\u8bbe\u7f6e\u4e3b\u952e\u3002", (String)"AbstractPullInvoke_01", (String)"fi-er-business", (Object[])new Object[]{number}));
            this.tripSyncLogParam.setStatus("B");
            return;
        }
        String lastkey = "";
        String pkey = JsonHelper.getZeroKey(primarykey);
        if (pkey.contains("]")) {
            lastkey = pkey.substring(0, pkey.lastIndexOf(".["));
        }
        LinkedHashMap<String, Object> jsonToMap = new LinkedHashMap<String, Object>();
        JsonHelper.convertJsonToMap(data, "", jsonToMap);
        if (null == jsonToMap.get(pkey)) {
            this.tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u5546\u65c5\u5b57\u6bb5\u6620\u5c04[%s]\uff0c\u6ca1\u6709\u67e5\u8be2\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u3002", (String)"AbstractPullInvoke_14", (String)"fi-er-business", (Object[])new Object[]{number}));
            this.tripSyncLogParam.setStatus("B");
            return;
        }
        HashSet<String> oaBillNoSet = new HashSet<String>();
        HashSet<String> userNumSet = new HashSet<String>();
        HashSet orderNumSet = new HashSet();
        do {
            if (OrderCommonInvoke.discontinue().booleanValue()) {
                return;
            }
            DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)type);
            String pkValue = "";
            for (DynamicObject fieldmap : fieldmapentry) {
                if (!"1".equals(fieldmap.getString("mapstatus"))) continue;
                String maptargetfield = fieldmap.getString("maptargetfield");
                DynamicObject[] mapsourcefield = fieldmap.getString("mapsourcefield");
                String maptype = fieldmap.getString("maptype");
                if (null != fieldmap.getString("maptypeext") && !fieldmap.getString("maptypeext").isEmpty() || null != fieldmap.getString("mapsourcefieldext") && !fieldmap.getString("mapsourcefieldext").isEmpty()) {
                    mapsourcefield = fieldmap.getString("mapsourcefieldext");
                }
                if (StringUtils.isEmpty((String)maptargetfield) || "1".equals(maptype) && StringUtils.isBlank((String)mapsourcefield)) continue;
                switch (maptargetfield) {
                    case "oabillnum": {
                        String field = JsonHelper.getJkey(lastkey, pkey, (String)mapsourcefield);
                        Object dvalue = jsonToMap.get(field);
                        if (!(dvalue instanceof String) || !org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((String)dvalue).trim())) break;
                        oaBillNoSet.add(((String)dvalue).trim());
                        break;
                    }
                    case "sourcebookedid": 
                    case "passeger": 
                    case "sourcetravelerid": {
                        String field = JsonHelper.getJkey(lastkey, pkey, (String)mapsourcefield);
                        Object dvalue = jsonToMap.get(field);
                        if (!(dvalue instanceof String) || !org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((String)dvalue).trim())) break;
                        userNumSet.add(((String)dvalue).trim());
                        break;
                    }
                    case "ordernum": {
                        Object dvalue = this.getDvalue(lastkey, pkey, jsonToMap, pkValue, dynamicObject, fieldmap);
                        Object v = this.getObjectByType(type, maptargetfield, dvalue);
                        dynamicObject.set(maptargetfield, v);
                        if (dvalue == null || !(dvalue instanceof String) || !org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((String)dvalue))) break;
                        orderNumSet.add(dvalue);
                    }
                }
            }
        } while (null != (pkey = JsonHelper.getAddKey(pkey, jsonToMap, JsonHelper.getPatch(pkey, ""))) && !pkey.isEmpty());
        HashMap<String, DynamicObject> userMapping = new HashMap<String, DynamicObject>();
        HashMap<String, DynamicObject> billMapping = new HashMap<String, DynamicObject>();
        HashMap<String, DynamicObject> allorderMapping = new HashMap<String, DynamicObject>();
        if (!orderNumSet.isEmpty() && null != (allorderbills = ErOrm.load("er_allorderbill", new QFilter[]{qFilter = new QFilter("ordernum", "in", orderNumSet)}))) {
            for (DynamicObject orderbill : allorderbills) {
                allorderMapping.put(orderbill.getString("ordernum"), orderbill);
            }
        }
        if (!oaBillNoSet.isEmpty()) {
            DynamicObject[] applyBills;
            DynamicObject[] mealApplyBills;
            DynamicObject[] dailyVehicleBills;
            qFilter = new QFilter("billno", "in", oaBillNoSet);
            DynamicObject[] reqbills = ErOrm.load("er_tripreqbill", new QFilter[]{qFilter});
            if (null != reqbills) {
                for (DynamicObject reqbill : reqbills) {
                    billMapping.put(reqbill.getString("billno"), reqbill);
                    oaBillNoSet.remove(reqbill.getString("billno"));
                }
            }
            if (null != (dailyVehicleBills = ErOrm.load("er_dailyvehiclebill", new QFilter[]{qFilter}))) {
                for (DynamicObject dailyVehicleBill : dailyVehicleBills) {
                    if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)dailyVehicleBill.getString("billno"))) continue;
                    billMapping.put(dailyVehicleBill.getString("billno"), dailyVehicleBill);
                    oaBillNoSet.remove(dailyVehicleBill.getString("billno"));
                }
            }
            if (null != (mealApplyBills = ErOrm.load("er_mealapplication_bill", new QFilter[]{qFilter}))) {
                for (DynamicObject mealApplyBill : mealApplyBills) {
                    if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)mealApplyBill.getString("billno"))) continue;
                    billMapping.put(mealApplyBill.getString("billno"), mealApplyBill);
                }
            }
            if (null != (applyBills = ErOrm.load("er_dailyapplybill", new QFilter[]{qFilter}))) {
                for (DynamicObject applyBill : applyBills) {
                    if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)applyBill.getString("billno"))) continue;
                    billMapping.put(applyBill.getString("billno"), applyBill);
                }
            }
        }
        if (!userNumSet.isEmpty() && null != (users = ErOrm.load("bos_user", new QFilter[]{userQFilter = new QFilter("number", "in", userNumSet)}))) {
            for (DynamicObject user : users) {
                userMapping.put(user.getString("number"), user);
                userMapping.put(user.getString("id"), user);
            }
        }
        this.params.put("userMapping", userMapping);
        this.params.put("billMapping", billMapping);
        this.params.put("allorderMapping", allorderMapping);
    }

    public List<DynamicObject> saveAllOrder(List<DynamicObject> list) {
        DynamicObject fieldmapping = (DynamicObject)this.params.get("fieldmap");
        if (null == fieldmapping) {
            this.tripSyncLogParam.setStatus("B");
            this.tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u5546\u65c5\u5b57\u6bb5\u6620\u5c04\u672a\u914d\u7f6e\u3002", (String)"AbstractPullInvoke_07", (String)"fi-er-business", (Object[])new Object[0]));
            return new ArrayList<DynamicObject>();
        }
        String number = fieldmapping.getString("number");
        DynamicObjectCollection fieldmapentry = fieldmapping.getDynamicObjectCollection("fieldmapentry");
        if (null == fieldmapentry) {
            this.tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u5546\u65c5\u5b57\u6bb5\u6620\u5c04\u201c%s\u201d\uff0c\u672a\u8bbe\u7f6e\u5b57\u6bb5\u6620\u5c04\u5206\u5f55\u3002", (String)"AbstractPullInvoke_11", (String)"fi-er-business", (Object[])new Object[]{number}));
            this.tripSyncLogParam.setStatus("B");
            return new ArrayList<DynamicObject>();
        }
        DynamicObject server = fieldmapping.getDynamicObject("server");
        if (null == server) {
            this.tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u5546\u65c5\u5b57\u6bb5\u6620\u5c04\u201c%s\u201d\uff0c\u672a\u8bbe\u7f6e\u670d\u52a1\u5546\u3002", (String)"AbstractPullInvoke_12", (String)"fi-er-business", (Object[])new Object[]{number}));
            this.tripSyncLogParam.setStatus("B");
            return new ArrayList<DynamicObject>();
        }
        if (!(list instanceof List)) {
            logger.info("\u5546\u65c5\u5b57\u6bb5\u6620\u5c04\uff0c\u5b57\u6bb5\u6620\u5c04\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (Object)number);
            return new ArrayList<DynamicObject>();
        }
        String primarykey = null;
        HashSet<String> billfields = new HashSet<String>(fieldmapentry.size());
        for (DynamicObject dynamicObject : fieldmapentry) {
            if (!"1".equals(dynamicObject.getString("mapstatus"))) continue;
            String field = dynamicObject.getString("maptargetfield");
            Boolean mapprimarykey = dynamicObject.getBoolean("mapprimarykey");
            if (mapprimarykey.booleanValue()) {
                primarykey = field;
            }
            billfields.add(field);
        }
        if (null == primarykey) {
            this.tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u5546\u65c5\u5b57\u6bb5\u6620\u5c04[%s]\uff0c\u672a\u8bbe\u7f6e\u4e3b\u952e\u3002", (String)"AbstractPullInvoke_01", (String)"fi-er-business", (Object[])new Object[]{number}));
            this.tripSyncLogParam.setStatus("B");
            return new ArrayList<DynamicObject>();
        }
        if (list.isEmpty()) {
            logger.info("\u5546\u65c5\u5b57\u6bb5\u6620\u5c04{}\uff0c\u5b57\u6bb5\u6620\u5c04\u6570\u636e\u4e3a\u7a7a\u3002", (Object)number);
            return new ArrayList<DynamicObject>();
        }
        HashSet<String> keys = new HashSet<String>(list.size());
        Iterator<DynamicObject> iterator = list.iterator();
        while (iterator.hasNext()) {
            DynamicObject dynamicObject = iterator.next();
            if (keys.contains(dynamicObject.getString(primarykey))) {
                iterator.remove();
                continue;
            }
            keys.add(dynamicObject.getString(primarykey));
        }
        Map billMapping = (Map)this.params.get("billMapping");
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"er_allorderbill");
        String tableName = type.getAlias();
        long[] ids = DBServiceHelper.genLongIds((String)tableName, (int)list.size());
        Map exsitDynamicObjectMap = (Map)this.params.get("allorderMapping");
        ArrayList<DynamicObject> saves = new ArrayList<DynamicObject>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            DynamicObject allorder = new DynamicObject((DynamicObjectType)type);
            DynamicObject order = list.get(i);
            DataEntityPropertyCollection allOrderProperties = allorder.getDataEntityType().getProperties();
            for (IDataEntityProperty orderProperty : allOrderProperties) {
                String orderPropName = orderProperty.getName();
                if (!order.containsProperty(orderPropName)) continue;
                if (allorder.getDataEntityType().getProperties().get((Object)orderPropName) instanceof BasedataProp) {
                    allorder.set(orderPropName, order.get(orderPropName));
                    allorder.set(orderPropName + "_id", order.get(orderPropName));
                    continue;
                }
                allorder.set(orderPropName, order.get(orderPropName.endsWith("_id") ? orderPropName.replace("_id", "") : orderPropName));
            }
            allorder.set("orderformid", (Object)order.getDynamicObjectType().getName());
            allorder.set("orderid", order.get("id"));
            if (null != billMapping && null != order.getString(primarykey) && !order.getString(primarykey).trim().isEmpty() && null != billMapping.get(order.getString(primarykey).trim())) {
                DynamicObject bill = (DynamicObject)billMapping.get(order.getString(primarykey).trim());
                allorder.set("billauditstatus", (Object)("E".equals(bill.get("billstatus")) ? ResManager.loadKDString((String)"\u5ba1\u6838\u901a\u8fc7", (String)"AbstractOrderDao_1", (String)"fi-er-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5ba1\u6838\u672a\u901a\u8fc7", (String)"AbstractOrderDao_2", (String)"fi-er-business", (Object[])new Object[0])));
            }
            if (order.get("expcommitdepnum") instanceof Long) {
                allorder.set("dept", (Object)order.getLong("expcommitdepnum"));
            }
            if (order.get("expcommitdepnum") instanceof DynamicObject) {
                allorder.set("dept", (Object)order.getDynamicObject("expcommitdepnum").getLong("id"));
            }
            if (exsitDynamicObjectMap == null || exsitDynamicObjectMap.isEmpty()) {
                allorder.set("id", (Object)ids[i]);
                saves.add(allorder);
                continue;
            }
            DynamicObject exsitDynamicObject = (DynamicObject)exsitDynamicObjectMap.get(allorder.getString(primarykey));
            if (null == exsitDynamicObject || null == exsitDynamicObject.getString(primarykey) || null == allorder.getString(primarykey)) {
                allorder.set("id", (Object)ids[i]);
                saves.add(allorder);
                continue;
            }
            for (String propertyName : billfields) {
                if (TripCommonUtil.NotCopyField.contains(propertyName) || !exsitDynamicObject.containsProperty(propertyName) || allorder.get(propertyName) == null) continue;
                if (exsitDynamicObject.getDataEntityType().getProperties().get((Object)propertyName) instanceof BasedataProp) {
                    exsitDynamicObject.set(propertyName, allorder.get(propertyName));
                    exsitDynamicObject.set(propertyName + "_id", allorder.get(propertyName));
                    continue;
                }
                exsitDynamicObject.set(propertyName, allorder.get(propertyName.endsWith("_id") ? propertyName.replace("_id", "") : propertyName));
            }
            saves.add(exsitDynamicObject);
        }
        SaveServiceHelper.save((DynamicObject[])saves.toArray(new DynamicObject[0]));
        return saves;
    }
}

