/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.v2.server.gtrip;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.servicehelper.HttpRetryServiceHelper;
import kd.fi.er.business.trip.supplier.gaode.GaoDeServiceUtil;
import kd.fi.er.business.trip.v2.server.OrderCommonInvoke;
import org.apache.commons.lang.StringUtils;

public class GtripSyncOrderInvoke
extends OrderCommonInvoke {
    private static final Log logger = LogFactory.getLog(GtripSyncOrderInvoke.class);

    @Override
    public Object execute(Map<String, Object> params) {
        return super.execute(params);
    }

    @Override
    protected JSONObject querycriteria() {
        JSONObject querycriteria = super.querycriteria();
        if (null != this.params.get("ordernum") && !this.params.get("ordernum").toString().trim().isEmpty()) {
            querycriteria.put("amapOrderId", this.params.get("ordernum"));
            querycriteria.remove((Object)"startTime");
            querycriteria.remove((Object)"endTime");
            querycriteria.remove((Object)"orderStatus");
        }
        return querycriteria;
    }

    @Override
    protected Object filterdata(Object data) {
        if (null == data) {
            logger.info("GtripSyncOrderInvoke infos is null");
            return null;
        }
        JSONObject jsonData = (JSONObject)data;
        JSONArray orderArray = jsonData.getJSONArray("orders");
        if (null == orderArray) {
            logger.info("GtripSyncOrderInvoke orderArray is null");
            return null;
        }
        for (Object o : orderArray) {
            String regulationContent;
            String refundItems;
            String feeDetail;
            String originalFeeDetail;
            JSONObject order = (JSONObject)o;
            String applyRecord = order.getString("applyRecord");
            if (StringUtils.isNotBlank((String)applyRecord)) {
                JSONObject applyRecordO = JSON.parseObject((String)applyRecord);
                order.put("applyRecord", (Object)applyRecordO);
            }
            if (StringUtils.isNotBlank((String)(originalFeeDetail = order.getString("originalFeeDetail")))) {
                JSONArray originalFeeDetailS = JSON.parseArray((String)originalFeeDetail);
                order.put("originalFeeDetail", (Object)originalFeeDetailS);
            }
            if (StringUtils.isNotBlank((String)(feeDetail = order.getString("feeDetail")))) {
                JSONArray feeDetailS = JSON.parseArray((String)feeDetail);
                order.put("feeDetail", (Object)feeDetailS);
            }
            if (StringUtils.isNotBlank((String)(refundItems = order.getString("refundItems")))) {
                JSONArray refundItemsS = JSON.parseArray((String)refundItems);
                order.put("refundItems", (Object)refundItemsS);
            }
            if (!StringUtils.isNotBlank((String)(regulationContent = order.getString("regulationContent")))) continue;
            JSONArray regulationContentS = JSON.parseArray((String)regulationContent);
            order.put("regulationContent", (Object)regulationContentS);
        }
        return super.filterdata(data);
    }

    @Override
    protected Object fieldmapping(Object data) {
        return super.fieldmapping(data);
    }

    @Override
    protected List<DynamicObject> saveInfos(Object infos) {
        return super.saveInfos(infos);
    }

    @Override
    public Object batpull(Object t) {
        Map signMap = (Map)JSON.parseObject((String)t.toString(), Map.class);
        String signkey = signMap.getOrDefault("sign", "").toString();
        signMap.put("sign", GaoDeServiceUtil.genSign(signMap, signkey));
        Object batpush = super.batpull(JSON.parseObject((String)JSON.toJSONString((Object)signMap)));
        return batpush;
    }

    @Override
    public String httpPost(String url, Object o) {
        Map<String, Object> resultMap = HttpRetryServiceHelper.httpPost(url, GaoDeServiceUtil.getPostParams(o), 30000);
        return JSON.toJSONString(resultMap);
    }
}

