/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.v2.utils;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.utils.ActionLocalCache;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.TripUserGrantUtils;

public class SyncUserUtils {
    private static final Log logger = LogFactory.getLog(SyncUserUtils.class);

    public static Object checkGrantUser(String serverNum, Object datas, TripSyncLogParam tripSyncLogParam) {
        DynamicObjectCollection servers = TripUserGrantUtils.getServers(serverNum);
        if (CollectionUtils.isEmpty((Collection)servers) || datas == null) {
            return datas;
        }
        if (datas instanceof DynamicObject[]) {
            DynamicObject[] dynamicObjects = (DynamicObject[])datas;
            Set userIdSet = (Set)ActionLocalCache.get().get(serverNum + "checkGrantUserSet", serverNum, () -> {
                DynamicObjectCollection alreadyGrantUsers = TripUserGrantUtils.queryUserGrantInfosByServer(Collections.singletonList(serverNum));
                return alreadyGrantUsers.stream().map(dynamicObject -> ErCommonUtils.getPk(dynamicObject.get("grantuser"))).collect(Collectors.toSet());
            });
            List needRemoveData = Arrays.stream(dynamicObjects).filter(user -> !userIdSet.contains(user.getLong("id"))).collect(Collectors.toList());
            try {
                if (CollectionUtils.isNotEmpty(needRemoveData)) {
                    HashSet notGrantUserSet = Sets.newHashSetWithExpectedSize((int)16);
                    for (DynamicObject datum : needRemoveData) {
                        notGrantUserSet.add(datum.getString("name") + "(" + datum.get("number") + ")");
                    }
                    String msg = String.join((CharSequence)",", notGrantUserSet);
                    tripSyncLogParam.setMessage(String.format(ResManager.loadKDString((String)"\u7528\u6237\u672a\u6388\u6743\u5546\u65c5\u5e73\u53f0,\u5f85\u7528\u6237\u81ea\u884c\u6388\u6743\u540e\u53ef\u91cd\u65b0\u540c\u6b65\u4eba\u5458\uff1a%s", (String)"SyncUserUtils_1", (String)"fi-er-business", (Object[])new Object[0]), msg));
                    tripSyncLogParam.setStatus("A");
                }
            }
            catch (Exception ex) {
                logger.error("\u4fdd\u5b58\u6388\u6743\u672a\u540c\u6b65\u4eba\u5458\u5931\u8d25:", (Throwable)ex);
            }
            List totalData = Arrays.stream(dynamicObjects).collect(Collectors.toList());
            totalData.removeAll(needRemoveData);
            DynamicObject[] returnData = new DynamicObject[totalData.size()];
            if (CollectionUtils.isNotEmpty(totalData)) {
                int size = totalData.size();
                for (int i = 0; i < size; ++i) {
                    returnData[i] = (DynamicObject)totalData.get(i);
                }
            }
            if (returnData.length == 0) {
                return null;
            }
            return returnData;
        }
        return datas;
    }
}

