/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.upgrade;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.servicehelper.ReimburseAmountServiceHelper;

public class ReimburseAmountDepartmentUpgrade
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(ReimburseAmountDepartmentUpgrade.class);
    public static final String UPDATED_FLAG = "flagForReimburseAmountDepartment201812-BT1230894";

    public void afterBindData(EventObject eventObj) {
        IAppCache emCache = AppCache.get((String)"em");
        Boolean isUpgrade = (Boolean)emCache.get(UPDATED_FLAG, Boolean.class);
        if (isUpgrade != null && isUpgrade.booleanValue()) {
            return;
        }
        try (TXHandle h = TX.required();){
            try {
                DynamicObject isUpgradedDO = BusinessDataServiceHelper.loadSingle((String)"er_config_webservice", (String)"id,username", (QFilter[])new QFilter[]{QFilter.of((String)"username=?", (Object[])new Object[]{UPDATED_FLAG})});
                if (isUpgradedDO == null) {
                    this.upgrade();
                    DynamicObject configDO = ORM.create().newDynamicObject("er_config_webservice");
                    configDO.set("username", (Object)UPDATED_FLAG);
                    Object[] objects = BusinessDataServiceHelper.save((IDataEntityType)configDO.getDataEntityType(), (Object[])new Object[]{configDO});
                    log.info("\u989d\u5ea6\u8868\u7ef4\u62a4\u7684\u90e8\u95e8\u5b57\u6bb5\u5347\u7ea7\u6210\u529f, \u5347\u7ea7\u7ed3\u679c\u4e3a:" + SerializationUtils.toJsonString((Object)objects));
                }
                emCache.put(UPDATED_FLAG, (Object)true);
            }
            catch (Throwable e) {
                h.markRollback();
                log.error(e);
                throw e;
            }
        }
    }

    private void upgrade() {
        Object[] reimburseAmounts = BusinessDataServiceHelper.load((String)"er_reimburseamount", (String)"id,dept,employee,company", (QFilter[])new QFilter[]{QFilter.of((String)"dept=?", (Object[])new Object[]{0})});
        if (reimburseAmounts != null && reimburseAmounts.length > 0) {
            for (int i = 0; i < reimburseAmounts.length; ++i) {
                DynamicObject reimburseAmount = reimburseAmounts[i];
                reimburseAmount.set("dept", (Object)ReimburseAmountServiceHelper.getDept(reimburseAmount));
            }
            Object[] result = BusinessDataServiceHelper.save((IDataEntityType)reimburseAmounts[0].getDataEntityType(), (Object[])reimburseAmounts);
            log.info("\u90e8\u95e8\u5b57\u6bb5\u4fdd\u5b58\u6210\u529f:" + SerializationUtils.toJsonString((Object)result));
        }
    }
}

