/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.utils;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.ext.fi.ai.AbstractDapWriteBackImpl;
import kd.bos.ext.fi.ai.Voucher;
import kd.bos.ext.fi.ai.VoucherOperation;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.dao.impl.ErOrm;
import kd.fi.er.business.utils.ErEntityTypeUtils;

public abstract class AbstractErDAPWriteBackUtils
extends AbstractDapWriteBackImpl {
    private static Log logger = LogFactory.getLog(AbstractErDAPWriteBackUtils.class);
    private static final List<String> FORM_IDS = Collections.unmodifiableList(Lists.newArrayList((Object[])new String[]{"er_tripreqbill", "er_repaymentbill", "er_dailyreimbursebill", "er_dailyloanbill", "er_tripreimbursebill", "er_publicreimbursebill", "er_expensesharebill", "er_prepaybill", "er_withholdingbill", "er_applypaybill", "er_costestimatebill", "er_costestimatebill", "er_tripreimbill_grid", "er_checkingpaybill"}));

    protected String getVchStatusField() {
        return "fhasvoucher";
    }

    protected Object getVchEnableStatus() {
        return true;
    }

    protected Object getVchDisableStatus() {
        return false;
    }

    protected DBRoute getDBRoute() {
        return DBRoute.of((String)"er");
    }

    /*
     * WARNING - void declaration
     */
    public void writeBack(VoucherOperation operation, String billEntityNumber, Map<Long, Voucher> billToVch) {
        super.writeBack(operation, billEntityNumber, billToVch);
        if (!FORM_IDS.contains(billEntityNumber)) {
            logger.info("AbstractErDAPWriteBackUtils billEntityNumber:{}", JSON.toJSON((Object)billEntityNumber));
            return;
        }
        MainEntityType mt = EntityMetadataCache.getDataEntityType((String)billEntityNumber);
        logger.info("AbstractErDAPWriteBackUtils operation:{}", JSON.toJSON((Object)operation));
        if (VoucherOperation.Create == operation || VoucherOperation.Submit == operation || VoucherOperation.AdjustBillno == operation) {
            ArrayList<Object[]> params = new ArrayList<Object[]>(billToVch.size());
            HashMap<Long, Date> billmap = new HashMap<Long, Date>(billToVch.size());
            ArrayList<Long> ids = new ArrayList<Long>(billToVch.size());
            HashSet<Long> voucherIds = new HashSet<Long>(billToVch.size());
            for (Map.Entry<Long, Voucher> entry : billToVch.entrySet()) {
                Voucher voucher = entry.getValue();
                Long id = voucher.getId();
                voucherIds.add(id);
            }
            DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"gl_voucher", (String)"id,bookeddate", (QFilter[])new QFilter[]{new QFilter("id", "in", voucherIds)});
            if (null == dynamicObjectCollection) {
                logger.info("gl_voucher \u67e5\u8be2\u4e0d\u5230");
                return;
            }
            for (Map.Entry<Long, Voucher> entry : billToVch.entrySet()) {
                Long billId = entry.getKey();
                Voucher voucher = entry.getValue();
                Long id = voucher.getId();
                for (DynamicObject dynamicObject : dynamicObjectCollection) {
                    if (!id.equals(dynamicObject.getLong("id"))) continue;
                    Object[] param = new Object[]{dynamicObject.getDate("bookeddate"), billId};
                    params.add(param);
                    billmap.put(billId, dynamicObject.getDate("bookeddate"));
                    ids.add(billId);
                }
            }
            logger.info("AbstractErDAPWriteBackUtils params:{}", JSON.toJSON(params));
            logger.info("AbstractErDAPWriteBackUtils update", (Object)("update " + mt.getAlias() + " set Fbookeddate = ?  where fid =?"));
            DB.executeBatch((DBRoute)this.getDBRoute(), (String)("update " + mt.getAlias() + " set Fbookeddate = ?  where fid =?"), params);
            if (("er_tripreimbursebill".equals(billEntityNumber) || "er_tripreimbill_grid".equals(billEntityNumber) || ErEntityTypeUtils.isPublicReimburseBill(billEntityNumber) || ErEntityTypeUtils.isDailyReimburseBill(billEntityNumber)) && ids.size() > 0) {
                void var11_25;
                QFilter qFilter = new QFilter("id", "in", ids);
                String entityName = "er_tripreimbursebill";
                if ("er_tripreimbursebill".equals(billEntityNumber) || "er_tripreimbill_grid".equals(billEntityNumber)) {
                    DynamicObjectCollection dynamicObjectCollection2 = QueryServiceHelper.query((String)entityName, (String)"id,bookeddate,tripentry.entryentity.ordernum,tripentry.entryentity.orderformid", (QFilter[])new QFilter[]{qFilter});
                } else {
                    entityName = billEntityNumber;
                    DynamicObjectCollection dynamicObjectCollection3 = QueryServiceHelper.query((String)entityName, (String)"id,bookeddate,orderentry.ordernumber,orderentry.orderformid", (QFilter[])new QFilter[]{qFilter});
                }
                if (null == var11_25 || var11_25.size() == 0) {
                    return;
                }
                HashSet<String> ordernums = new HashSet<String>(var11_25.size());
                for (Object dynamicObject : var11_25) {
                    String formid;
                    String ordernum;
                    if ("er_tripreimbursebill".equals(entityName)) {
                        ordernum = dynamicObject.getString("tripentry.entryentity.ordernum");
                        formid = dynamicObject.getString("tripentry.entryentity.orderformid");
                    } else {
                        ordernum = dynamicObject.getString("orderentry.ordernumber");
                        formid = dynamicObject.getString("orderentry.orderformid");
                    }
                    Long id = dynamicObject.getLong("id");
                    if (null == ordernum || ordernum.trim().length() == 0 || formid.indexOf(",") != -1 || null == billmap.get(id)) continue;
                    ordernums.add(ordernum);
                    MainEntityType ordermt = EntityMetadataCache.getDataEntityType((String)formid);
                    Object[] orderparam = new Object[]{dynamicObject.getDate("bookeddate"), ordernum};
                    params = new ArrayList(1);
                    params.add(orderparam);
                    DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)("update " + ordermt.getAlias() + " set Fbookeddate = ?  where fordernum = ?"), params);
                }
                DynamicObject[] allorders = ErOrm.load("er_allorderbill", new QFilter[]{new QFilter("ordernum", "in", ordernums)});
                if (null == allorders || allorders.length == 0) {
                    return;
                }
                for (DynamicObject dynamicObject : var11_25) {
                    String ordernum = "er_tripreimbursebill".equals(entityName) ? dynamicObject.getString("tripentry.entryentity.ordernum") : dynamicObject.getString("orderentry.ordernumber");
                    for (DynamicObject allorder : allorders) {
                        if (null == ordernum || !ordernum.equals(allorder.getString("ordernum"))) continue;
                        allorder.set("bookeddate", (Object)dynamicObject.getDate("bookeddate"));
                    }
                }
                SaveServiceHelper.save((DynamicObject[])allorders);
            }
        } else if (VoucherOperation.Delete == operation) {
            logger.info("AbstractErDAPWriteBackUtils update", (Object)("update " + mt.getAlias() + " set Fbookeddate = null  where fid in (" + StringUtils.join((Object[])billToVch.keySet().toArray(), (char)',') + ")"));
            DB.execute((DBRoute)this.getDBRoute(), (String)("update " + mt.getAlias() + " set Fbookeddate = null  where fid in (" + StringUtils.join((Object[])billToVch.keySet().toArray(), (char)',') + ")"), (Object[])new Object[0]);
            ArrayList<Long> ids = new ArrayList<Long>(billToVch.keySet());
            if (("er_tripreimbursebill".equals(billEntityNumber) || ErEntityTypeUtils.isPublicReimburseBill(billEntityNumber) || ErEntityTypeUtils.isDailyReimburseBill(billEntityNumber)) && ids.size() > 0) {
                QFilter qFilter = new QFilter("id", "in", ids);
                DynamicObjectCollection dynamicObjects = "er_tripreimbursebill".equals(billEntityNumber) ? QueryServiceHelper.query((String)billEntityNumber, (String)"id,bookeddate,tripentry.entryentity.ordernum,tripentry.entryentity.orderformid", (QFilter[])new QFilter[]{qFilter}) : QueryServiceHelper.query((String)billEntityNumber, (String)"id,bookeddate,orderentry.ordernumber,orderentry.orderformid", (QFilter[])new QFilter[]{qFilter});
                if (null == dynamicObjects || dynamicObjects.size() == 0) {
                    return;
                }
                HashSet<void> ordernums = new HashSet<void>(dynamicObjects.size());
                for (DynamicObject dynamicObject : dynamicObjects) {
                    void var11_26;
                    String formid;
                    if ("er_tripreimbursebill".equals(billEntityNumber)) {
                        String string = dynamicObject.getString("tripentry.entryentity.ordernum");
                        formid = dynamicObject.getString("tripentry.entryentity.orderformid");
                    } else {
                        String string = dynamicObject.getString("orderentry.ordernumber");
                        formid = dynamicObject.getString("orderentry.orderformid");
                    }
                    if (null == formid || formid.trim().isEmpty() || formid.indexOf(",") != -1) continue;
                    ordernums.add(var11_26);
                    MainEntityType ordermt = EntityMetadataCache.getDataEntityType((String)formid);
                    Object[] orderparam = new Object[]{var11_26};
                    ArrayList<Object[]> params = new ArrayList<Object[]>(billToVch.size());
                    params.add(orderparam);
                    DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)("update " + ordermt.getAlias() + " set Fbookeddate = null  where fordernum = ?"), params);
                }
                DynamicObject[] allorders = ErOrm.load("er_allorderbill", new QFilter[]{new QFilter("ordernum", "in", ordernums)});
                if (null == allorders || allorders.length == 0) {
                    return;
                }
                for (DynamicObject dynamicObject : dynamicObjects) {
                    String ordernum = "er_tripreimbursebill".equals(billEntityNumber) ? dynamicObject.getString("tripentry.entryentity.ordernum") : dynamicObject.getString("orderentry.ordernumber");
                    for (DynamicObject allorder : allorders) {
                        if (null == ordernum || !ordernum.equals(allorder.getString("ordernum"))) continue;
                        allorder.set("bookeddate", null);
                    }
                }
                SaveServiceHelper.save((DynamicObject[])allorders);
            }
        }
    }

    protected abstract void handleDeleteField(Map<String, Object> var1, DynamicObject var2, long var3);

    protected abstract void handleCreateField(Map<String, Object> var1, DynamicObject var2, long var3);
}

