/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.utils;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.Format;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.format.NumberFormat;
import kd.bos.entity.property.AmountProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.fi.er.business.daily.reimburse.AmountObject;
import kd.fi.er.business.utils.ActionLocalCache;
import kd.fi.er.business.utils.ErCommonUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class AmountUtils {
    private static Log logger = LogFactory.getLog(AmountUtils.class);
    private static final int DEFAULT_AMOUNT_PRECISION = 10;
    private static final String AMOUNT_FORMATTER = "kd.fi.er.business.utils.AmountUtils.AMOUNT_FORMATTER";

    public static BigDecimal getEntryAmount(IDataModel dataModel, String entryName, String amountPropName) {
        return AmountUtils.getEntryAmount(dataModel.getEntryEntity(entryName), amountPropName);
    }

    public static BigDecimal getEntryAmount(DynamicObjectCollection entrys, String amountPropName) {
        if (entrys != null && !entrys.isEmpty()) {
            return entrys.stream().map(v -> v.getBigDecimal(amountPropName)).reduce((b1, b2) -> b1.add((BigDecimal)b2)).orElse(BigDecimal.ZERO);
        }
        return BigDecimal.ZERO;
    }

    public static BigDecimal getCurrencyAmount(BigDecimal oriAmount, BigDecimal exchangeRate, int currencyPrecision, String quoteType) {
        if (StringUtils.equals((CharSequence)"0", (CharSequence)quoteType)) {
            return oriAmount.multiply(exchangeRate).setScale(currencyPrecision, 4);
        }
        if (StringUtils.equals((CharSequence)"1", (CharSequence)quoteType)) {
            exchangeRate = exchangeRate.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : exchangeRate;
            return oriAmount.divide(exchangeRate, currencyPrecision, 4);
        }
        return BigDecimal.ZERO;
    }

    public static BigDecimal getOriAmount(BigDecimal currencyAmount, BigDecimal exchangeRate, int currencyPrecision, String quoteType) {
        quoteType = StringUtils.equals((CharSequence)"0", (CharSequence)quoteType) ? "1" : "0";
        return AmountUtils.getCurrencyAmount(currencyAmount, exchangeRate, currencyPrecision, quoteType);
    }

    public static Set<Long> getCurrencyIdSet(IDataModel dataModel, String entryName, String currencyName) {
        DynamicObjectCollection entries;
        if (dataModel.getProperty(entryName) != null && !(entries = dataModel.getEntryEntity(entryName)).isEmpty()) {
            return entries.stream().map(v -> v.getDynamicObject(currencyName) != null ? (Long)v.getDynamicObject(currencyName).getPkValue() : 0L).collect(Collectors.toSet());
        }
        return Sets.newHashSet();
    }

    public static Set<BigDecimal> getExchangeRateSet(IDataModel dataModel, String entryName, String exchangeRateName) {
        if (dataModel.getProperty(entryName) != null) {
            DynamicObjectCollection entries = dataModel.getEntryEntity(entryName);
            if (dataModel.getProperty(exchangeRateName) != null && !entries.isEmpty()) {
                return entries.stream().map(v -> v.getBigDecimal(exchangeRateName) == null ? BigDecimal.ONE : v.getBigDecimal(exchangeRateName)).collect(Collectors.toSet());
            }
        }
        return Sets.newHashSet();
    }

    public static BigDecimal getExchangeRate(IDataModel dataModel, String entryName, String subEntryPropName, String subCurrencyName, Long currency, String subExchangeRateName) {
        DynamicObjectCollection collection = dataModel.getDataEntity(true).getDynamicObjectCollection(entryName);
        for (int j = 0; j < collection.size(); ++j) {
            DynamicObjectCollection subEntrys = ((DynamicObject)collection.get(j)).getDynamicObjectCollection(subEntryPropName);
            for (int i = 0; i < subEntrys.size(); ++i) {
                if (subEntrys.getDynamicObjectType().getProperty("orientryamount") != null && (subEntrys.getDynamicObjectType().getProperty("orientryamount") == null || ((DynamicObject)subEntrys.get(i)).getBigDecimal("orientryamount").compareTo(BigDecimal.ZERO) <= 0 || currency.compareTo((Long)((DynamicObject)subEntrys.get(i)).getDynamicObject(subCurrencyName).getPkValue()) != 0)) continue;
                return ((DynamicObject)subEntrys.get(i)).getBigDecimal(subExchangeRateName);
            }
        }
        return BigDecimal.ONE;
    }

    public static Set<Long> getCurrencyIdSet(IDataModel dataModel, String entryName, String subCurrencyName, String subEntryPropName) {
        DynamicObjectCollection collection = dataModel.getDataEntity(true).getDynamicObjectCollection(entryName);
        HashSet<Long> set = new HashSet<Long>();
        for (int j = 0; j < collection.size(); ++j) {
            DynamicObjectCollection subEntrys = ((DynamicObject)collection.get(j)).getDynamicObjectCollection(subEntryPropName);
            for (int i = 0; i < subEntrys.size(); ++i) {
                if (subEntrys.getDynamicObjectType().getProperty("orientryamount") != null && (subEntrys.getDynamicObjectType().getProperty("orientryamount") == null || ((DynamicObject)subEntrys.get(i)).getBigDecimal("orientryamount").compareTo(BigDecimal.ZERO) <= 0)) continue;
                Long subCurrencyId = ErCommonUtils.getPk(((DynamicObject)subEntrys.get(i)).getDynamicObject(subCurrencyName));
                set.add(subCurrencyId);
            }
        }
        return set;
    }

    public static Map<String, BigDecimal> groupByCurrency(DynamicObjectCollection collection, String currencyPropName, String amountPropName) {
        HashMap currencyAmount = Maps.newHashMap();
        if (collection == null || collection.isEmpty()) {
            return currencyAmount;
        }
        collection.stream().forEach(v -> {
            DynamicObject currency = (DynamicObject)v.get(currencyPropName);
            if (currency != null) {
                String currencyId = currency.getPkValue().toString();
                BigDecimal amount = (BigDecimal)currencyAmount.get(currencyId);
                if (amount != null) {
                    currencyAmount.put(currencyId, amount.add(v.getBigDecimal(amountPropName)));
                } else {
                    currencyAmount.put(currencyId, v.getBigDecimal(amountPropName));
                }
            }
        });
        return currencyAmount;
    }

    public static Map<String, BigDecimal> groupByCurrency(DynamicObjectCollection collection, String subEntryPropName, String currencyPropName, String amountPropName) {
        Map[] currencyAmountMap = new Map[]{Maps.newHashMap()};
        HashMap tempmap = Maps.newHashMap();
        collection.stream().forEach(v -> {
            DynamicObjectCollection entrys = v.getDynamicObjectCollection(subEntryPropName);
            DynamicObjectCollection entrysClone = new DynamicObjectCollection();
            if (StringUtils.equals((CharSequence)"entryentity", (CharSequence)subEntryPropName)) {
                List tripNotOrderEntrys = entrys.stream().filter(entry -> !"2".equals(entry.getString("settlementtype"))).collect(Collectors.toList());
                entrysClone.addAll(tripNotOrderEntrys);
            }
            currencyAmountMap[0] = AmountUtils.groupByCurrency(entrysClone, currencyPropName, amountPropName);
            for (String subCurrency : currencyAmountMap[0].keySet()) {
                if (tempmap.get(subCurrency) == null) continue;
                BigDecimal subCurrencyAmount = ((BigDecimal)currencyAmountMap[0].get(subCurrency)).add((BigDecimal)tempmap.get(subCurrency));
                currencyAmountMap[0].put(subCurrency, subCurrencyAmount);
            }
            tempmap.putAll(currencyAmountMap[0]);
        });
        return tempmap;
    }

    @Deprecated
    public static Map<String, AmountObject> groupByCurrencyToObject(DynamicObjectCollection collection, String oriAmountProp, String curAmountProp, String entryCurrencyKey, String entryExchangerateKey) {
        return AmountUtils.groupByCurrencyToObject(null, collection, oriAmountProp, curAmountProp, entryCurrencyKey, entryExchangerateKey);
    }

    public static Map<String, AmountObject> groupByCurrencyToObject(String quoteTypeProp, DynamicObjectCollection collection, String oriAmountProp, String curAmountProp, String entryCurrencyKey, String entryExchangerateProp) {
        HashMap currencyAmount = Maps.newHashMap();
        collection.stream().forEach(v -> {
            String quoteType = quoteTypeProp == null ? "0" : (String)ObjectUtils.defaultIfNull((Object)v.getString(quoteTypeProp), (Object)"0");
            DynamicObject currency = (DynamicObject)v.get(entryCurrencyKey);
            if (currency != null) {
                String currencyId = currency.getPkValue().toString();
                if (currencyAmount.get(currencyId) != null) {
                    AmountObject amount = (AmountObject)currencyAmount.get(currencyId);
                    amount.setOrgiAmount(amount.getOrgiAmount().add(v.getBigDecimal(oriAmountProp)));
                    if (curAmountProp != null) {
                        amount.setCurrAmount(amount.getCurrAmount().add(v.getBigDecimal(curAmountProp)));
                    }
                    currencyAmount.put(currencyId, amount);
                } else {
                    AmountObject amount = new AmountObject(currencyId, v.getBigDecimal(oriAmountProp), v.getBigDecimal(entryExchangerateProp), quoteType);
                    if (curAmountProp != null) {
                        amount.setCurrAmount(v.getBigDecimal(curAmountProp));
                    }
                    currencyAmount.put(currencyId, amount);
                }
            }
        });
        return currencyAmount;
    }

    @Deprecated
    public static Map<String, AmountObject> groupByCurrencyToObject(DynamicObjectCollection collection, String subEntryPropName, String oriAmountProp, String curAmountProp, String entryCurrencyKey, String entryExchangerateKey) {
        return AmountUtils.groupByCurrencyToObject(collection, subEntryPropName, oriAmountProp, curAmountProp, entryCurrencyKey, entryExchangerateKey, null);
    }

    public static Map<String, AmountObject> groupByCurrencyToObject(DynamicObjectCollection collection, String subEntryPropName, String oriAmountProp, String curAmountProp, String entryCurrencyProp, String entryExchangerateProp, String quoteTypeProp) {
        Map[] subCurrencyAmountMap = new Map[]{Maps.newHashMap()};
        HashMap tempmap = Maps.newHashMap();
        collection.stream().forEach(v -> {
            DynamicObjectCollection entrys = v.getDynamicObjectCollection(subEntryPropName);
            subCurrencyAmountMap[0] = AmountUtils.groupByCurrencyToObject(quoteTypeProp, entrys, oriAmountProp, curAmountProp, entryCurrencyProp, entryExchangerateProp);
            for (String subCurrency : subCurrencyAmountMap[0].keySet()) {
                if (tempmap.get(subCurrency) == null) continue;
                AmountObject subCurrencyAmountObj = (AmountObject)subCurrencyAmountMap[0].get(subCurrency);
                AmountObject tempObj = (AmountObject)tempmap.get(subCurrency);
                if (subCurrencyAmountObj != null && tempObj != null && tempObj.getCurrcyId().compareTo(subCurrencyAmountObj.getCurrcyId()) == 0) {
                    subCurrencyAmountObj.setCurrAmount(tempObj.getCurrAmount().add(subCurrencyAmountObj.getCurrAmount()));
                    subCurrencyAmountObj.setOrgiAmount(tempObj.getOrgiAmount().add(subCurrencyAmountObj.getOrgiAmount()));
                }
                subCurrencyAmountMap[0].put(subCurrency, subCurrencyAmountObj);
            }
            tempmap.putAll(subCurrencyAmountMap[0]);
        });
        logger.info("\u7ed3\u675f\u5faa\u73af");
        return tempmap;
    }

    @Deprecated
    public static void refreshCurrAmount(IDataModel dataModel, BigDecimal orgiAmount, String currAmountProp, String exchangeRateProp, int index) {
        BigDecimal exchangeRate = null;
        exchangeRate = StringUtils.isEmpty((CharSequence)exchangeRateProp) ? BigDecimal.ONE : (BigDecimal)dataModel.getValue(exchangeRateProp, index);
        if (exchangeRate == null) {
            exchangeRate = BigDecimal.ONE;
            logger.warn(exchangeRateProp + "\u7684\u6c47\u7387\u4e3a\u7a7a");
        }
        BigDecimal currAmount = orgiAmount.multiply(exchangeRate).setScale(AmountUtils.getCurrencyPrecision(dataModel, "currency"), RoundingMode.HALF_UP);
        logger.info("refreshCurrAmount5 " + currAmountProp + " " + currAmount);
        dataModel.setValue(currAmountProp, (Object)currAmount, index);
    }

    public static void refreshCurrAmount(IDataModel dataModel, BigDecimal orgiAmount, String currAmountProp, String exchangeRateProp, String quoteTypeProp, int index) {
        AmountUtils.refreshCurrAmount(dataModel, orgiAmount, currAmountProp, exchangeRateProp, quoteTypeProp, index, -1);
    }

    public static void refreshCurrAmount(IDataModel dataModel, BigDecimal orgiAmount, String currAmountProp, String exchangeRateProp, String quoteTypeProp, int index, int parentIndex) {
        BigDecimal exchangeRate = StringUtils.isEmpty((CharSequence)exchangeRateProp) || dataModel.getProperty(exchangeRateProp) == null ? BigDecimal.ONE : (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)dataModel.getValue(exchangeRateProp, index, parentIndex)), (Object)BigDecimal.ONE);
        String quoteType = StringUtils.isEmpty((CharSequence)quoteTypeProp) || dataModel.getProperty(quoteTypeProp) == null ? "0" : (String)ObjectUtils.defaultIfNull((Object)((String)dataModel.getValue(quoteTypeProp, index, parentIndex)), (Object)"0");
        BigDecimal currAmount = BigDecimal.ZERO;
        if (StringUtils.equals((CharSequence)"0", (CharSequence)quoteType)) {
            currAmount = orgiAmount.multiply(exchangeRate).setScale(AmountUtils.getCurrencyPrecision(dataModel, "currency"), RoundingMode.HALF_UP);
        } else {
            exchangeRate = exchangeRate.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : exchangeRate;
            currAmount = orgiAmount.divide(exchangeRate, AmountUtils.getCurrencyPrecision(dataModel, "currency"), RoundingMode.HALF_UP);
        }
        logger.info("refreshCurrAmount7 " + currAmountProp + " " + currAmount);
        dataModel.setValue(currAmountProp, (Object)currAmount, index, parentIndex);
    }

    public static void refreshCurrAmount(IDataModel dataModel, BigDecimal orgiAmount, String currAmountProp, String exchangeRateProp, String currencyProp, String quoteTypeProp, int index) {
        BigDecimal exchangeRate = StringUtils.isEmpty((CharSequence)exchangeRateProp) || dataModel.getProperty(exchangeRateProp) == null ? BigDecimal.ONE : (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)dataModel.getValue(exchangeRateProp, index)), (Object)BigDecimal.ONE);
        String quoteType = StringUtils.isEmpty((CharSequence)quoteTypeProp) || dataModel.getProperty(quoteTypeProp) == null ? "0" : (String)ObjectUtils.defaultIfNull((Object)((String)dataModel.getValue(quoteTypeProp, index)), (Object)"0");
        BigDecimal currAmount = BigDecimal.ZERO;
        if (StringUtils.equals((CharSequence)"0", (CharSequence)quoteType)) {
            currAmount = orgiAmount.multiply(exchangeRate).setScale(AmountUtils.getCurrencyPrecision(dataModel, currencyProp), RoundingMode.HALF_UP);
        } else {
            exchangeRate = exchangeRate.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : exchangeRate;
            currAmount = orgiAmount.divide(exchangeRate, AmountUtils.getCurrencyPrecision(dataModel, currencyProp), RoundingMode.HALF_UP);
        }
        logger.info("refreshCurrAmount7 " + currAmountProp + " " + currAmount);
        dataModel.setValue(currAmountProp, (Object)currAmount, index);
    }

    public static void refreshCurrAmount(IDataModel dataModel, BigDecimal orgiAmount, String currAmountProp, String exchangeRateProp, String currencyProp, String quoteTypeProp) {
        BigDecimal currAmount;
        String quoteType;
        BigDecimal exchangeRate = StringUtils.isEmpty((CharSequence)exchangeRateProp) || dataModel.getProperty(exchangeRateProp) == null ? BigDecimal.ONE : (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)dataModel.getValue(exchangeRateProp)), (Object)BigDecimal.ONE);
        String string = quoteType = StringUtils.isEmpty((CharSequence)quoteTypeProp) || dataModel.getProperty(quoteTypeProp) == null ? "0" : (String)ObjectUtils.defaultIfNull((Object)((String)dataModel.getValue(quoteTypeProp)), (Object)"0");
        if (StringUtils.equals((CharSequence)"0", (CharSequence)quoteType)) {
            currAmount = orgiAmount.multiply(exchangeRate).setScale(AmountUtils.getCurrencyPrecision(dataModel, currencyProp), RoundingMode.HALF_UP);
        } else {
            exchangeRate = exchangeRate.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : exchangeRate;
            currAmount = orgiAmount.divide(exchangeRate, AmountUtils.getCurrencyPrecision(dataModel, currencyProp), RoundingMode.HALF_UP);
        }
        logger.info("refreshCurrAmount6 " + currAmountProp + " " + currAmount);
        dataModel.setValue(currAmountProp, (Object)currAmount);
    }

    public static String formatMoneyByUser(Long userId, String currencyBOSymbol, int precision, BigDecimal money) {
        Format format = AmountUtils.getMoneyFormatter(userId, currencyBOSymbol, precision);
        return format.format(money);
    }

    public static Format getMoneyFormatter(Long userId, String currencyBOSymbol, int precision) {
        if (precision < 0 || precision > 10) {
            precision = 2;
        }
        String key2 = String.format("%s,%s,%s", userId, currencyBOSymbol, precision);
        int precision2 = precision;
        Format format = (Format)ActionLocalCache.get().get(AMOUNT_FORMATTER, key2, () -> {
            FormatObject fobj = InteServiceHelper.getUserFormat((Long)userId);
            fobj.getCurrencyFormat().setCurrencySymbols(currencyBOSymbol);
            fobj.getCurrencyFormat().setMinimumFractionDigits(precision2);
            return FormatFactory.get((FormatTypes)FormatTypes.Currency).getFormat(fobj);
        });
        return format;
    }

    public static int getCurrencyPrecision(IDataModel model, String currencyCode) {
        DynamicObject dataEntity = model.getDataEntity();
        return AmountUtils.getCurrencyPrecision(dataEntity, currencyCode);
    }

    public static int getCurrencyPrecision(DynamicObject dataEntity, String currencyCode) {
        DynamicObject currency;
        IDataEntityType dataEntityType = dataEntity.getDataEntityType();
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        IDataEntityProperty currencyProp = (IDataEntityProperty)properties.get((Object)currencyCode);
        int amtprecision = 10;
        if (currencyProp != null && (currency = dataEntity.getDynamicObject(currencyCode)) != null) {
            amtprecision = currency.getInt("amtprecision");
        }
        return amtprecision;
    }

    public static int getAmountFieldPrecision(DynamicObject entity, String amountFieldName) {
        DataEntityPropertyCollection properties = entity.getDataEntityType().getProperties();
        AmountProp amoutProp = (AmountProp)properties.get((Object)amountFieldName);
        String currencyFieldName = amoutProp.getControlPropName();
        DynamicObject currencyDO = (DynamicObject)AmountUtils.getValueByRecursive(entity, currencyFieldName);
        return currencyDO != null ? currencyDO.getInt("amtprecision") : 10;
    }

    private static Object getValueByRecursive(DynamicObject entity, String fieldName) {
        if (entity == null) {
            return null;
        }
        if (entity.getDataEntityType().getProperties().containsKey((Object)fieldName)) {
            return entity.get(fieldName);
        }
        return AmountUtils.getValueByRecursive((DynamicObject)entity.getParent(), fieldName);
    }

    public static int getCurrencyPrecision(String currencyNumber) {
        DataEntityPropertyCollection currencyProps;
        DynamicObject currency = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_currency", (String)"number, amtprecision", (QFilter[])new QFilter("number", "=", (Object)currencyNumber).toArray());
        int amtprecision = 4;
        if (currency != null && (currencyProps = currency.getDataEntityType().getProperties()).get((Object)"amtprecision") != null) {
            amtprecision = currency.getInt("amtprecision");
        }
        return amtprecision;
    }

    public static int getCurrencyPrecision(Object currencyId) {
        DataEntityPropertyCollection currencyProps;
        DynamicObject currency = BusinessDataServiceHelper.loadSingleFromCache((Object)currencyId, (String)"bd_currency", (String)"number, amtprecision");
        int amtprecision = 4;
        if (currency != null && (currencyProps = currency.getDataEntityType().getProperties()).get((Object)"amtprecision") != null) {
            amtprecision = currency.getInt("amtprecision");
        }
        return amtprecision;
    }

    public static String getFormattedAmount(Long currencyId, BigDecimal amount) {
        return amount.setScale(AmountUtils.getCurrencyPrecision(currencyId), RoundingMode.HALF_EVEN).toString();
    }

    public static String getThousandthFormat(Long userId, int roundingMode, BigDecimal amount) {
        FormatObject userFormat = InteServiceHelper.getUserFormat((Long)userId);
        userFormat.getNumberFormat().setMinimumFractionDigits(roundingMode);
        return new NumberFormat().getFormat(userFormat).format(amount);
    }

    public static String getFormattedAmountWithSymbol(Long currencyId, BigDecimal amount) {
        DynamicObject currency = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_currency", (String)"number, amtprecision, sign", (QFilter[])new QFilter("id", "=", (Object)currencyId).toArray());
        int amtprecision = 4;
        String sign = "";
        if (currency != null) {
            DataEntityPropertyCollection currencyProps = currency.getDataEntityType().getProperties();
            if (currencyProps.get((Object)"amtprecision") != null) {
                amtprecision = currency.getInt("amtprecision");
            }
            sign = currency.getString("sign");
        }
        return sign + amount.setScale(amtprecision, RoundingMode.HALF_EVEN).toString();
    }

    public static Set<Long> getCurrencyIdSet(DynamicObject bill, String entryName, String currencyName) {
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection(entryName);
        if (entrys != null && !entrys.isEmpty()) {
            return entrys.stream().map(v -> v.getDynamicObject(currencyName) != null ? (Long)v.getDynamicObject(currencyName).getPkValue() : 0L).collect(Collectors.toSet());
        }
        return Sets.newHashSet();
    }
}

