/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.utils;

import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.utils.Utils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.business.utils.ActionLocalCache;
import kd.fi.er.business.utils.ErCommonUtils;
import org.apache.curator.shaded.com.google.common.collect.Lists;

public class CorpAccountSettingUtils {
    private static Log logger = LogFactory.getLog(CorpAccountSettingUtils.class);

    public static String generateCorpAccount(List<DynamicObject> subAccountList, List<Integer> selectRows, DynamicObjectCollection subAccountEntry, Boolean isTask) {
        HashSet<Long> userIds = new HashSet<Long>();
        HashSet<Long> updateUserIds = new HashSet<Long>();
        int sucessCount = 0;
        StringBuilder operationInfos = new StringBuilder();
        SimpleDateFormat longformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (selectRows.size() == 0) {
            return String.format(ResManager.loadKDString((String)"\u603b\u5171\u6279\u91cf\u6210\u529f\u751f\u6210%1$s\u6761\uff0c\u751f\u6210\u5931\u8d25%2$s\u6761", (String)"CorpAccountSettingEdit_1", (String)"fi-er-formplugin", (Object[])new Object[0]), sucessCount, 0);
        }
        ArrayList<ChooseEntry> accountUserids = new ArrayList<ChooseEntry>(subAccountList.size());
        for (DynamicObject d : subAccountList) {
            ChooseEntry entry = new ChooseEntry();
            entry.setSubName(d.getString("subaccountname"));
            entry.setOrgId(d.getLong("accountrelorg.id"));
            accountUserids.add(entry);
        }
        CorpAccountSettingUtils.innerusere();
        ArrayList adminOrgUsersnull = Lists.newArrayList();
        int value = TripSyncConfigUtil.getIntValue("Access_range_subaccount", 0);
        Date date = new Date();
        if (isTask.booleanValue()) {
            Serializable time;
            QFilter qFilter = new QFilter("subaccountname", "=", (Object)Character.valueOf(' '));
            if (value > 0) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(date);
                cal.add(5, -value);
                time = cal.getTime();
                qFilter.or(new QFilter("modifytime", ">=", (Object)time));
            }
            DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.fi.er.business.utils.CorpAccountSettingUtils.generateCorpAccount", (String)"er_corpusersubaccount", (String)"id", (QFilter[])new QFilter[]{qFilter}, null);
            time = null;
            try {
                for (Row data : ds) {
                    Long userId = data.getLong("id");
                    adminOrgUsersnull.add(userId);
                }
            }
            catch (Throwable throwable) {
                time = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (time != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)time).addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
            if (adminOrgUsersnull.isEmpty()) {
                return String.format(ResManager.loadKDString((String)"\u603b\u5171\u6279\u91cf\u6210\u529f\u751f\u6210%1$s\u6761\uff0c\u751f\u6210\u5931\u8d25%2$s\u6761", (String)"CorpAccountSettingEdit_1", (String)"fi-er-formplugin", (Object[])new Object[0]), sucessCount, 0);
            }
        }
        accountUserids.forEach(e -> {
            List<Long> orgsList = Collections.singletonList(e.getOrgId());
            ArrayList adminOrgUsers = CorpAccountSettingUtils.getPerson(orgsList, false, true);
            List<Long> fromOrgs = CorpAccountSettingUtils.getFromOrgs("01", orgsList, "01");
            if (Utils.isListNotEmpty(fromOrgs)) {
                List<Long> fromOrgUsers = CorpAccountSettingUtils.getPerson(fromOrgs, false, false);
                adminOrgUsers.addAll(fromOrgUsers);
            }
            if (isTask.booleanValue()) {
                ArrayList adminOrgUserList = Lists.newArrayList();
                for (Long id : adminOrgUsersnull) {
                    if (!adminOrgUsers.contains(id)) continue;
                    adminOrgUserList.add(id);
                }
                adminOrgUsers = adminOrgUserList;
            }
            try (DataSet rows = null;){
                QFilter qfilter = new QFilter("id", "in", adminOrgUsers).and("manualmodify", "=", (Object)Character.valueOf('0'));
                rows = QueryServiceHelper.queryDataSet((String)"kd.fi.er.business.utils.CorpAccountSettingUtils.generateCorpAccount1", (String)"er_corpusersubaccount", (String)"id", (QFilter[])new QFilter[]{qfilter}, null);
                Iterator iterator = rows.iterator();
                adminOrgUsers.clear();
                while (iterator.hasNext()) {
                    Row data = (Row)iterator.next();
                    Long userId = data.getLong("id");
                    adminOrgUsers.add(userId);
                }
            }
            e.setUserIds(adminOrgUsers);
        });
        logger.info("\u4eba\u5458\u5173\u8054\u5b50\u8d26\u6237map" + JSONObject.toJSONString(accountUserids));
        if (!accountUserids.isEmpty()) {
            HashSet<String> subAccountNameSet = new HashSet<String>(16);
            Boolean barSavesubaccount = (Boolean)ActionLocalCache.get().getDefaultIfNull("bar_savesubaccount", false);
            boolean needUpdatedTime = isTask != false && value == 0 || barSavesubaccount != false;
            for (ChooseEntry entry : accountUserids) {
                CharSequence[] idsArray;
                Throwable throwable;
                TXHandle h;
                List<Long> accountRelOrgids;
                block42: {
                    block43: {
                        if (!Utils.isListNotEmpty(entry.getUserIds())) continue;
                        accountRelOrgids = Collections.singletonList(entry.getOrgId());
                        h = TX.required();
                        throwable = null;
                        idsArray = CorpAccountSettingUtils.toStringArray(entry.getUserIds().toArray());
                        if (idsArray.length >= 1) break block42;
                        if (h == null) continue;
                        if (throwable == null) break block43;
                        try {
                            h.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        continue;
                    }
                    h.close();
                    continue;
                }
                try {
                    try {
                        String updateSql = "UPDATE T_SEC_USER_E SET FSUBACCOUNTNAME = ? WHERE FID IN ('" + String.join((CharSequence)"','", idsArray) + "')";
                        boolean execute = DB.execute((DBRoute)DBRoute.base, (String)updateSql, (Object[])new Object[]{entry.getSubName()});
                        if (needUpdatedTime && execute) {
                            updateSql = "UPDATE T_SEC_USER SET FMODIFYTIME = ? WHERE FID IN ('" + String.join((CharSequence)"','", idsArray) + "')";
                            DB.execute((DBRoute)DBRoute.base, (String)updateSql, (Object[])new Object[]{date});
                        }
                        updateUserIds.addAll(entry.getUserIds());
                        subAccountNameSet.add(entry.getSubName());
                        if (Utils.isListNotEmpty(accountRelOrgids)) {
                            operationInfos.append(CorpAccountSettingUtils.operationInfo("sucess", entry.getSubName(), accountRelOrgids, entry.getUserIds().size()));
                        }
                    }
                    catch (Exception e2) {
                        h.markRollback();
                        logger.error("\u5b50\u8d26\u6237\u751f\u6210\u5f02\u5e38\uff1a", (Throwable)e2);
                        if (Utils.isListNotEmpty(accountRelOrgids)) {
                            operationInfos.append(CorpAccountSettingUtils.operationInfo("fail", entry.getSubName(), accountRelOrgids, entry.getUserIds().size()));
                        }
                    }
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    throw throwable4;
                }
                finally {
                    if (h != null) {
                        if (throwable != null) {
                            try {
                                h.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            h.close();
                        }
                    }
                }
                userIds.addAll(entry.getUserIds());
            }
            Iterator<Object> iterator = selectRows.iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                DynamicObject dynamicObject = (DynamicObject)subAccountEntry.get(index);
                if (!subAccountNameSet.contains(dynamicObject.getString("subaccountname"))) continue;
                dynamicObject.set("generatetimestr", (Object)longformat.format(date));
                dynamicObject.set("generatetime", (Object)date);
            }
        }
        sucessCount = updateUserIds.size();
        return String.format(ResManager.loadKDString((String)"\u603b\u5171\u6279\u91cf\u6210\u529f\u751f\u6210%1$s\u6761\uff0c\u751f\u6210\u5931\u8d25%2$s\u6761", (String)"CorpAccountSettingEdit_1", (String)"fi-er-formplugin", (Object[])new Object[0]), sucessCount, userIds.size() - sucessCount);
    }

    public static void innerusere() {
        List idList = (List)DB.query((DBRoute)DBRoute.base, (String)"select fid from t_sec_user where fid not in (select fid from t_sec_user_e)", (ResultSetHandler)new ResultSetHandler<List<Object[]>>(){

            public List<Object[]> handle(ResultSet rs) throws Exception {
                ArrayList<Object[]> list = new ArrayList<Object[]>(2);
                while (rs.next()) {
                    list.add(new Object[]{rs.getLong("fid")});
                }
                return list;
            }
        });
        if (idList != null && !idList.isEmpty()) {
            String insertSql = "insert into t_sec_user_e (fid, fauditstatus) values (?, 'A')";
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql, (List)idList);
        }
    }

    private static String operationInfo(String opResult, String subAccountName, List<Long> orglist, int i) {
        String operationInfo = "";
        if (Utils.isListNotEmpty(orglist)) {
            QFilter idFilter = new QFilter("id", "in", orglist);
            QFilter[] filters = new QFilter[]{idFilter};
            DynamicObjectCollection orgList = QueryServiceHelper.query((String)"bos_org", (String)"id,name", (QFilter[])filters);
            if (orgList == null || orgList.size() == 0) {
                return operationInfo;
            }
            String orgnames = "";
            for (DynamicObject orgObj : orgList) {
                String orgname = orgObj.getString("name");
                if (StringUtils.isEmpty((CharSequence)orgname)) continue;
                orgnames = orgname + "\uff0c" + orgnames;
            }
            String result = opResult.equals("fail") ? ResManager.loadKDString((String)"\u5931\u8d25", (String)"CorpAccountSettingEdit_5", (String)"fi-er-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6210\u529f", (String)"CorpAccountSettingEdit_6", (String)"fi-er-formplugin", (Object[])new Object[0]);
            operationInfo = String.format(ResManager.loadKDString((String)"%1$s\uff1a%2$s\u751f\u6210%3$s%4$s\u6761\u3002\n", (String)"CorpAccountSettingEdit_7", (String)"fi-er-formplugin", (Object[])new Object[0]), subAccountName, orgnames, result, i);
        }
        return operationInfo;
    }

    private static String[] toStringArray(Object[] longArray) {
        if (longArray == null || longArray.length < 1) {
            return new String[0];
        }
        String[] stringArray = new String[longArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                stringArray[i] = String.valueOf(longArray[i]);
                continue;
            }
            catch (NumberFormatException e) {
                stringArray[i] = null;
            }
        }
        return stringArray;
    }

    private static List<Long> getPerson(List<Long> orgIds, boolean isIncludeDisable, boolean isIncludeSubOrg) {
        QFilter filter = new QFilter("entryentity.ispartjob", "=", (Object)false);
        if (!isIncludeDisable) {
            QFilter enableFilter = new QFilter("enable", "=", (Object)true);
            filter = filter.and(enableFilter);
        }
        if (Utils.isListNotEmpty(orgIds)) {
            QFilter orgFilter = null;
            orgFilter = isIncludeSubOrg ? new QFilter("entryentity.dpt", "in", (Object)OrgUnitServiceHelper.getAllSubordinateOrgs((Long)1L, orgIds, (boolean)true)) : new QFilter("entryentity.dpt", "in", orgIds);
            filter = filter.and(orgFilter);
        }
        return CorpAccountSettingUtils.getPerson(filter);
    }

    private static List<Long> getPerson(QFilter filter) {
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection userCol = QueryServiceHelper.query((String)"bos_user", (String)"id,usertypes.fbasedataid", (QFilter[])filters);
        if (Utils.isListEmpty((List)userCol)) {
            return new ArrayList<Long>(0);
        }
        HashSet<Long> userIds = new HashSet<Long>(userCol.size());
        for (DynamicObject userObj : userCol) {
            if (1L != userObj.getLong("usertypes.fbasedataid")) continue;
            userIds.add(userObj.getLong("id"));
        }
        return new ArrayList<Long>(userIds);
    }

    private static List<Long> getFromOrgs(String toOrgType, List<Long> toOrgIds, String fromOrgType) {
        if (StringUtils.isEmpty((CharSequence)toOrgType) || toOrgIds.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u6307\u5b9a\u534f\u4f5c\u7ec4\u7ec7\u7c7b\u578b\u6216\u53d7\u6258\u7ec4\u7ec7\uff0c\u53c2\u6570\u5f02\u5e38\u3002", (String)"CorpAccountSettingEdit_9", (String)"fi-er-formplugin", (Object[])new Object[0]));
        }
        long relationOrgId = CorpAccountSettingUtils.getOrgRelationId(fromOrgType, toOrgType);
        if (relationOrgId == 0L) {
            return new ArrayList<Long>(0);
        }
        List<Long> fromOrgs = CorpAccountSettingUtils.getFromOrgs(relationOrgId, toOrgIds);
        return fromOrgs;
    }

    private static List<Long> getFromOrgs(long relationOrgId, List<Long> toOrgIds) {
        QFilter toOrgIdFilter;
        ArrayList<Long> fromOrgs = new ArrayList<Long>();
        String selectProperties = "id,fromorg";
        QFilter relationTypeFilter = new QFilter("typerelation", "=", (Object)relationOrgId);
        QFilter[] filters = new QFilter[]{relationTypeFilter, toOrgIdFilter = new QFilter("toorg", "in", toOrgIds)};
        DynamicObjectCollection orgRelationList = QueryServiceHelper.query((String)"bos_org_orgrelation", (String)selectProperties, (QFilter[])filters, (String)"isdefaultfromorg desc");
        if (orgRelationList == null || orgRelationList.size() == 0) {
            return fromOrgs;
        }
        for (DynamicObject relationObj : orgRelationList) {
            if (relationObj.get("fromorg") == null) continue;
            fromOrgs.add(ErCommonUtils.getPk(relationObj.get("fromorg")));
        }
        return fromOrgs;
    }

    private static long getOrgRelationId(String fromOrgType, String toOrgType) {
        QFilter fromTypeFilter;
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        QFilter toTypeFilter = new QFilter("totype", "=", (Object)toOrgType);
        filterList.add(toTypeFilter);
        if (StringUtils.isEmpty((CharSequence)fromOrgType)) {
            fromTypeFilter = new QFilter("fromtype", "=", (Object)" ");
            filterList.add(fromTypeFilter);
        } else {
            fromTypeFilter = new QFilter("fromtype", "=", (Object)fromOrgType);
            filterList.add(fromTypeFilter);
        }
        QFilter[] filters = new QFilter[filterList.size()];
        for (int i = 0; i < filterList.size(); ++i) {
            filters[i] = (QFilter)filterList.get(i);
        }
        String selectProperties = "id";
        DynamicObjectCollection relationTypeList = QueryServiceHelper.query((String)"bos_org_typerelation", (String)selectProperties, (QFilter[])filters);
        if (relationTypeList == null || relationTypeList.size() == 0) {
            return 0L;
        }
        return ((DynamicObject)relationTypeList.get(0)).getLong("id");
    }

    private static class ChooseEntry {
        private String subName;
        private Long orgId;
        private List<Long> userIds;

        private ChooseEntry() {
        }

        public String getSubName() {
            return this.subName;
        }

        public void setSubName(String subName) {
            this.subName = subName;
        }

        public Long getOrgId() {
            return this.orgId;
        }

        public void setOrgId(Long orgId) {
            this.orgId = orgId;
        }

        public List<Long> getUserIds() {
            return this.userIds;
        }

        public void setUserIds(List<Long> userIds) {
            this.userIds = userIds;
        }
    }
}

