/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.utils;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class EntrustReimburseUtils {
    private static final Log logger = LogFactory.getLog(EntrustReimburseUtils.class);

    public static Set<Long> addConsignor(Long applierId, String billtype) {
        DynamicObject billType = EntrustReimburseUtils.queryBilltype(billtype);
        HashSet<Long> applierIds = new HashSet<Long>();
        applierIds.add(applierId);
        if (billType == null) {
            return applierIds;
        }
        QFilter qFilter = new QFilter("trustee", "=", (Object)applierId);
        QFilter pFilter = new QFilter("enable", "=", (Object)"1");
        Date nowTime = new Date();
        QFilter qFilterDate = QFilter.of((String)"startdate <= ? and enddate >= ?", (Object[])new Object[]{nowTime, nowTime});
        QFilter[] qFilters = new QFilter[]{qFilter, pFilter, qFilterDate};
        Map result = BusinessDataServiceHelper.loadFromCache((String)"er_entrustreimburse", (String)"id,consignor,rentrustedscope,entrustedscope.FBaseDataId.number", (QFilter[])qFilters);
        if (result != null && result.size() > 0) {
            for (Map.Entry entry : result.entrySet()) {
                DynamicObject dynamicObject = (DynamicObject)entry.getValue();
                String rentrustedscope = (String)dynamicObject.get("rentrustedscope");
                boolean entrustedscope = dynamicObject.getDynamicObjectCollection("entrustedscope").stream().anyMatch(v -> v.getDynamicObject("FBaseDataId").getPkValue() == billType.getPkValue());
                DynamicObject consignor = dynamicObject.getDynamicObject("consignor");
                if (consignor == null || !entrustedscope && !Stream.of(rentrustedscope.split(";")).anyMatch(v -> v.equals(billType.getString("name")))) continue;
                applierIds.add(Long.valueOf(consignor.getPkValue().toString()));
            }
        }
        return applierIds;
    }

    private static DynamicObject queryBilltype(String curBilltype) {
        QFilter qFilter = new QFilter("number", "=", (Object)curBilltype);
        return BusinessDataServiceHelper.loadSingleFromCache((String)"er_billtype", (String)"number,name", (QFilter[])new QFilter[]{qFilter});
    }

    public static QFilter getScopeFilter(String entityId, Long userId) {
        logger.info("EntrustReimburseUtils>getScopeFilter>>: entityId: " + entityId + "; userId: " + userId);
        if (entityId == null || userId == null || userId == 0L) {
            return null;
        }
        QFilter entityFilter = new QFilter("number", "=", (Object)entityId);
        DynamicObject billType = BusinessDataServiceHelper.loadSingleFromCache((String)"er_billtype", (String)"number, name", (QFilter[])entityFilter.toArray());
        if (billType == null) {
            return null;
        }
        String billTypeStr = billType.getLocaleString("name").getLocaleValue_zh_CN();
        QFilter entrustFilter = new QFilter("trustee", "=", (Object)userId);
        DynamicObject[] entrustConfig = BusinessDataServiceHelper.load((String)"er_entrustreimburse", (String)"trustee, consignor, entrustdate, startdate, enddate, rentrustedscope", (QFilter[])entrustFilter.toArray());
        QFilter returnFilter = null;
        for (DynamicObject config : entrustConfig) {
            DynamicObject consignorDym;
            String scope = config.getString("rentrustedscope");
            String[] split = scope.split(";");
            if (!Arrays.asList(split).contains(billTypeStr) || (consignorDym = config.getDynamicObject("consignor")) == null) continue;
            Long consignor = (Long)consignorDym.getPkValue();
            Date startDate = config.getDate("startdate");
            Date endDate = config.getDate("enddate");
            QFilter timeScope = new QFilter("bizdate", ">=", (Object)startDate);
            timeScope.and(new QFilter("bizdate", "<=", (Object)endDate));
            QFilter userScope = new QFilter("applier", "=", (Object)consignor);
            userScope.and(timeScope);
            returnFilter = returnFilter == null ? userScope : returnFilter.or(userScope);
        }
        logger.info("EntrustReimburseUtils>getScopeFilter>>>" + returnFilter);
        return returnFilter;
    }
}

