/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.utils;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.common.EntityTypeEnum;
import kd.fi.er.common.model.invoice.bill.BillExpenseInfoFildKeyType;
import org.apache.commons.lang3.StringUtils;

public class ErEntityTypeUtils {
    private static final Map<String, EntityTypeEnum> map = new HashMap<String, EntityTypeEnum>(30);
    private static QFilter qFilter;

    public static EntityTypeEnum getEntityType(String entityId) {
        EntityTypeEnum entityTypeEnum = null;
        if (StringUtils.isNotBlank((CharSequence)entityId) && (entityTypeEnum = map.get(entityId)) == null) {
            if (entityId.endsWith("_mob")) {
                entityId = entityId.replace("_mob", "");
                entityTypeEnum = map.get(entityId);
            }
            if (entityTypeEnum == null) {
                entityTypeEnum = ErEntityTypeUtils.loadFromDB(entityId);
            }
        }
        return entityTypeEnum;
    }

    public static EntityTypeEnum getEntityType(IFormView view) {
        IFormView ppView;
        IFormView pView;
        String entityId = view.getEntityId();
        EntityTypeEnum entityTypeEnum = ErEntityTypeUtils.getEntityType(entityId);
        if (entityTypeEnum == null && (pView = view.getViewNoPlugin(view.getFormShowParameter().getParentPageId())) != null && (entityTypeEnum = ErEntityTypeUtils.getEntityType(entityId = pView.getEntityId())) == null && (ppView = pView.getViewNoPlugin(pView.getFormShowParameter().getParentPageId())) != null) {
            entityId = ppView.getEntityId();
            entityTypeEnum = ErEntityTypeUtils.getEntityType(entityId);
        }
        return entityTypeEnum;
    }

    private static EntityTypeEnum loadFromDB(String entityId) {
        DynamicObject setting = BusinessDataServiceHelper.loadSingleFromCache((String)"er_entitytype_setting", (String)"id,entryentity.entitytype,entryentity.entityid", (QFilter[])new QFilter[]{qFilter});
        if (setting != null) {
            DynamicObjectCollection collection = setting.getDynamicObjectCollection("entryentity");
            for (int i = 0; i < collection.size(); ++i) {
                DynamicObject entry = (DynamicObject)collection.get(i);
                if (!entityId.equals(entry.getString("entityid").replaceAll(" ", ""))) continue;
                return ErEntityTypeUtils.convertEnum(entry.getString("entitytype"));
            }
        }
        return null;
    }

    private static EntityTypeEnum convertEnum(String entityType) {
        return EntityTypeEnum.valueOf((String)entityType);
    }

    private static void initEntityType() {
        map.put("er_tripreqbill", EntityTypeEnum.TRIPREQBILL);
        map.put("er_tripreimbursebill", EntityTypeEnum.TRIPREIMBURSEBILL);
        map.put("er_dailyapplybill", EntityTypeEnum.DAILYAPPLYBILL);
        map.put("er_dailyloanbill", EntityTypeEnum.DAILYLOANBILL);
        map.put("er_dailyreimbursebill", EntityTypeEnum.DAILYREIMBURSEBILL);
        map.put("er_publicreimbursebill", EntityTypeEnum.PUBLICREIMBURSEBILL);
        map.put("er_repaymentbill", EntityTypeEnum.REPAYMENTBILL);
        map.put("er_prepaybill", EntityTypeEnum.PREPAYBILL);
        map.put("er_applyprojectbill", EntityTypeEnum.APPLYPROJECTBILL);
        map.put("er_withholdingbill", EntityTypeEnum.WITHHOLDINGBILL);
        map.put("er_expense_recordbill", EntityTypeEnum.EXPENSERECORDBILL);
        map.put("er_trip_recordbill", EntityTypeEnum.TRIPRECORDBILL);
        map.put("er_applypaybill", EntityTypeEnum.ER_APPLYPAYBILL);
        map.put("er_reimctlapplybill", EntityTypeEnum.REIMCTLAPPLYBILL);
        map.put("er_costestimatebill", EntityTypeEnum.COSTESTIMATEBILL);
        map.put("er_expensesharebill", EntityTypeEnum.EXPENSESHAREBILL);
        map.put("er_dailyvehiclebill", EntityTypeEnum.DAILYVEHICLEBILL);
        map.put("er_checkingpaybill", EntityTypeEnum.CHECKINGPAYBILL);
        map.put("er_contractbill", EntityTypeEnum.CONTRACTBILL);
        map.put("er_mealapplication_bill", EntityTypeEnum.MEAL_APPLICATION_BILL);
        map.put("er_accountchangebill", EntityTypeEnum.ACCOUNTCHANGEBILL);
    }

    public static boolean isDailyReimburseBill(String entityId) {
        return EntityTypeEnum.DAILYREIMBURSEBILL == ErEntityTypeUtils.getEntityType(entityId);
    }

    public static boolean isDailyReimburseBillShare(String entityId) {
        return "er_dailyreimbursebil_ssc".equals(entityId);
    }

    public static boolean isDailyLoanBill(String entityId) {
        return EntityTypeEnum.DAILYLOANBILL == ErEntityTypeUtils.getEntityType(entityId);
    }

    public static boolean isDailyApplyBill(String entityId) {
        return EntityTypeEnum.DAILYAPPLYBILL == ErEntityTypeUtils.getEntityType(entityId);
    }

    public static boolean isPublicReimburseBill(String entityId) {
        return EntityTypeEnum.PUBLICREIMBURSEBILL == ErEntityTypeUtils.getEntityType(entityId);
    }

    public static boolean isPublicReimburseBillShare(String entityId) {
        return "er_publicreimburse_ssc".equals(entityId);
    }

    public static boolean isTripReqBill(String entityId) {
        return EntityTypeEnum.TRIPREQBILL == ErEntityTypeUtils.getEntityType(entityId);
    }

    public static boolean isTripReimburseBill(String entityId) {
        return EntityTypeEnum.TRIPREIMBURSEBILL == ErEntityTypeUtils.getEntityType(entityId);
    }

    public static boolean isRepaymentBill(String entityId) {
        return EntityTypeEnum.REPAYMENTBILL == ErEntityTypeUtils.getEntityType(entityId);
    }

    public static boolean isPrePayBill(String entityId) {
        return EntityTypeEnum.PREPAYBILL == ErEntityTypeUtils.getEntityType(entityId);
    }

    public static boolean isApplyProjectBill(String entityId) {
        return EntityTypeEnum.APPLYPROJECTBILL == ErEntityTypeUtils.getEntityType(entityId);
    }

    public static boolean isWithholdingBill(String entityId) {
        return EntityTypeEnum.WITHHOLDINGBILL == ErEntityTypeUtils.getEntityType(entityId);
    }

    public static boolean isExpenseRecordBill(String entityId) {
        return EntityTypeEnum.EXPENSERECORDBILL == ErEntityTypeUtils.getEntityType(entityId);
    }

    public static boolean isTripRecordBill(String entityId) {
        return EntityTypeEnum.TRIPRECORDBILL == ErEntityTypeUtils.getEntityType(entityId);
    }

    public static boolean isApplyPayBill(String entityId) {
        return EntityTypeEnum.ER_APPLYPAYBILL == ErEntityTypeUtils.getEntityType(entityId);
    }

    public static boolean isReimCtlApplyBill(String entityId) {
        return EntityTypeEnum.REIMCTLAPPLYBILL == ErEntityTypeUtils.getEntityType(entityId);
    }

    public static boolean isCostEstimateBill(String entityId) {
        return EntityTypeEnum.COSTESTIMATEBILL == ErEntityTypeUtils.getEntityType(entityId);
    }

    public static boolean isDailyVehicleBill(String entityId) {
        return EntityTypeEnum.DAILYVEHICLEBILL == ErEntityTypeUtils.getEntityType(entityId);
    }

    public static boolean isShareBill(String entityId) {
        return EntityTypeEnum.EXPENSESHAREBILL == ErEntityTypeUtils.getEntityType(entityId);
    }

    public static boolean isCheckingpayBill(String entityId) {
        return EntityTypeEnum.CHECKINGPAYBILL == ErEntityTypeUtils.getEntityType(entityId);
    }

    public static boolean isContractBill(String entityId) {
        return EntityTypeEnum.CONTRACTBILL == ErEntityTypeUtils.getEntityType(entityId);
    }

    public static boolean isMealApplicationBill(String entityId) {
        return EntityTypeEnum.MEAL_APPLICATION_BILL == ErEntityTypeUtils.getEntityType(entityId);
    }

    public static boolean isAccountChangeBill(String entityId) {
        return EntityTypeEnum.ACCOUNTCHANGEBILL == ErEntityTypeUtils.getEntityType(entityId);
    }

    public static boolean isStakeholderChangeBill(String entityId) {
        return EntityTypeEnum.STAKEHOLDERCHANGEBILL == ErEntityTypeUtils.getEntityType(entityId);
    }

    public static boolean isCostEstimatebill(String entityId) {
        return EntityTypeEnum.COSTESTIMATEBILL == ErEntityTypeUtils.getEntityType(entityId);
    }

    public static boolean isReimBill(String entityId) {
        return EntityTypeEnum.TRIPREIMBURSEBILL == ErEntityTypeUtils.getEntityType(entityId) || EntityTypeEnum.DAILYREIMBURSEBILL == ErEntityTypeUtils.getEntityType(entityId) || EntityTypeEnum.PUBLICREIMBURSEBILL == ErEntityTypeUtils.getEntityType(entityId);
    }

    public static boolean isReimBill(EntityTypeEnum entityType) {
        return EntityTypeEnum.TRIPREIMBURSEBILL == entityType || EntityTypeEnum.DAILYREIMBURSEBILL == entityType || EntityTypeEnum.PUBLICREIMBURSEBILL == entityType;
    }

    public static boolean isDailyOrPubReimBill(String entityId) {
        return EntityTypeEnum.DAILYREIMBURSEBILL == ErEntityTypeUtils.getEntityType(entityId) || EntityTypeEnum.PUBLICREIMBURSEBILL == ErEntityTypeUtils.getEntityType(entityId);
    }

    public static BillExpenseInfoFildKeyType getBillType(String entityId) {
        BillExpenseInfoFildKeyType type = null;
        if (ErEntityTypeUtils.isDailyReimburseBill(entityId)) {
            type = BillExpenseInfoFildKeyType.DailyReimburse;
        } else if (ErEntityTypeUtils.isPublicReimburseBill(entityId)) {
            type = BillExpenseInfoFildKeyType.PublicReimburse;
        } else if (ErEntityTypeUtils.isTripReimburseBill(entityId)) {
            type = BillExpenseInfoFildKeyType.TripReimburse;
        } else if (ErEntityTypeUtils.isCheckingpayBill(entityId)) {
            type = BillExpenseInfoFildKeyType.CheckingPayBill;
        } else {
            if (ErEntityTypeUtils.isWithholdingBill(entityId)) {
                return BillExpenseInfoFildKeyType.WithholdingBill;
            }
            if (ErEntityTypeUtils.isCostEstimateBill(entityId)) {
                return BillExpenseInfoFildKeyType.CostEstimateBill;
            }
            if (ErEntityTypeUtils.isPrePayBill(entityId)) {
                return BillExpenseInfoFildKeyType.PrePayBill;
            }
        }
        return type;
    }

    static {
        ErEntityTypeUtils.initEntityType();
        qFilter = new QFilter("number", "=", (Object)"setting");
    }
}

