/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.invoicecloud.cache.model.ErCacheUtils;
import kd.fi.er.business.invoicecloud.v2.util.AllInvoiceUrl;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.constant.StdConfigConstant;
import kd.fi.er.common.model.invoice.merge.ItemEnum;
import org.apache.commons.lang3.StringUtils;

public class ErStdConfig {
    private static final String REGION = "er_stdconfig";
    private static final Object NULL_OBJECT = new Object();
    private static final Log log = LogFactory.getLog(ErStdConfig.class);
    public static final String REPAYMENTBILL_RELATE_CASRECBILL = "repaymentbill_relate_casrecbill";
    public static final PageSize DEFAULT_IMPORT_INVOICE_PAGESIZE = new PageSize(900, 640);

    public static String get(String key) {
        String threadCacheKey = String.format("kd.fi.er.business.utils.ErStdConfig.get(%s)", key);
        String value = null;
        if (ThreadCache.exists((Object)threadCacheKey)) {
            Object rawValue = ThreadCache.get((Object)threadCacheKey);
            value = rawValue == NULL_OBJECT ? null : (String)rawValue;
        } else {
            value = ErStdConfig._get(key);
            if (value == null) {
                ThreadCache.put((Object)threadCacheKey, (Object)NULL_OBJECT);
            } else {
                ThreadCache.put((Object)threadCacheKey, (Object)value);
            }
            log.info("ErStdConfig--key:" + key + ",value:" + (value == null ? "" : value));
        }
        return value;
    }

    private static String _get(String key) {
        String value = ErCacheUtils.get(REGION, key, String.class);
        if (StringUtils.equalsIgnoreCase((CharSequence)value, (CharSequence)"NULL")) {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return value;
        }
        DynamicObject queryOne = QueryServiceHelper.queryOne((String)REGION, (String)"value", (QFilter[])new QFilter[]{new QFilter("key", "=", (Object)key)});
        if (queryOne == null) {
            ErCacheUtils.put(REGION, key, "NULL");
            return null;
        }
        value = queryOne.getString("value");
        if (value == null || value.trim().equals("")) {
            ErCacheUtils.put(REGION, key, "NULL");
            return null;
        }
        ErCacheUtils.put(REGION, key, value);
        return value;
    }

    public static void set(String key, String value) {
        if (!ErStdConfig.isUnitTest()) {
            return;
        }
        DynamicObject[] configs = BusinessDataServiceHelper.load((String)REGION, (String)"value", (QFilter[])new QFilter("key", "=", (Object)key).toArray());
        if (configs.length > 0) {
            configs[0].set("value", (Object)value);
            SaveServiceHelper.save((DynamicObject[])configs);
            ErCacheUtils.put(REGION, key, value);
        }
    }

    public static boolean getBoolean(String key) {
        String value = ErStdConfig.get(key);
        if (value == null) {
            return false;
        }
        return Boolean.parseBoolean(value);
    }

    public static boolean isDev() {
        return ErStdConfig.getBoolean("intranet");
    }

    public static boolean isExportLog() {
        return ErStdConfig.getBoolean("isexportlog");
    }

    public static boolean isUnitTest() {
        return ErStdConfig._isUnitTest() && !ErStdConfig.getBoolean("disableUnitTest");
    }

    private static boolean _isUnitTest() {
        StackTraceElement[] stackTraces = Thread.currentThread().getStackTrace();
        String rootTrace = stackTraces[stackTraces.length - 1].toString();
        return rootTrace.indexOf("kd.bos.unittest") == 0 ? Boolean.TRUE : Boolean.FALSE;
    }

    public static boolean isProduct() {
        String notProduct = ErStdConfig.get("invoicecloud.not_prod");
        if (StringUtils.isBlank((CharSequence)notProduct)) {
            return true;
        }
        return !Boolean.parseBoolean(notProduct);
    }

    public static String gridParam() {
        String defaultGridParam = "1100";
        String result = ErStdConfig.get("invoicecloud.gridParam");
        if (result != null) {
            return result.trim();
        }
        return defaultGridParam;
    }

    public static boolean isMergedWhenSpecialInvoice() {
        String isMerged = ErStdConfig.get("invoicecloud.specialinvoicemerge");
        if (StringUtils.isBlank((CharSequence)isMerged)) {
            return true;
        }
        return Boolean.parseBoolean(isMerged);
    }

    public static boolean isMergeNegtiveInvoiceItem() {
        String isMergeNegtiveItem = ErStdConfig.get("invoicecloud.mergenegtiveinvoiceitem");
        if (StringUtils.isBlank((CharSequence)isMergeNegtiveItem)) {
            return true;
        }
        return Boolean.parseBoolean(isMergeNegtiveItem);
    }

    public static boolean isMergedWhenAirplaneInvoice() {
        String isMerged = ErStdConfig.get("invoicecloud.airplaneinvoicemerge");
        if (StringUtils.isBlank((CharSequence)isMerged)) {
            return true;
        }
        return Boolean.parseBoolean(isMerged);
    }

    public static boolean isCompanyMultiReimburser() {
        return ErStdConfig.isValueTrue("scope_of_multi_reimburser", false);
    }

    public static boolean isValueTrue(String key, boolean defaultValue) {
        String value = ErStdConfig.get(key);
        if (StringUtils.isBlank((CharSequence)value)) {
            return defaultValue;
        }
        if ("0".equalsIgnoreCase(value)) {
            return false;
        }
        if ("1".equalsIgnoreCase(value)) {
            return true;
        }
        return defaultValue;
    }

    public static int getIntValue(String key, int defaultValue) {
        String intValue = ErStdConfig.get(key);
        if (StringUtils.isBlank((CharSequence)intValue)) {
            return defaultValue;
        }
        return Integer.parseInt(intValue);
    }

    public static boolean isImageNotify() {
        String imageNotify = ErStdConfig.get("invoicecloud.imageNotify");
        return StringUtils.equals((CharSequence)"true", (CharSequence)imageNotify);
    }

    public static String isHttpOfPC() {
        String httpOfPC = ErStdConfig.get("invoicecloud.httpOfPC");
        if (StringUtils.isBlank((CharSequence)httpOfPC) || !StringUtils.equals((CharSequence)httpOfPC, (CharSequence)"http://")) {
            return "https://";
        }
        return httpOfPC;
    }

    public static String queryInvoic() {
        return ErStdConfig.get("invoicecloud.queryInvoice");
    }

    public static boolean isShowInvoiceInH5() {
        String isShowInvoiceInH5Str = ErStdConfig.get("invoicecloud.isShowInvoiceInH5");
        if (StringUtils.isBlank((CharSequence)isShowInvoiceInH5Str)) {
            return false;
        }
        return Boolean.parseBoolean(isShowInvoiceInH5Str);
    }

    public static String getInvoiceCloudApiDomain() {
        if (ErStdConfig.isProduct()) {
            return ErStdConfig.get("invoicecloud.domain_prod");
        }
        return ErStdConfig.get("invoicecloud.domain_test");
    }

    public static String getEventCodeUrl() {
        return AllInvoiceUrl.eventCodeUrl();
    }

    public static String getInvoiceMobH5Domain() {
        if (ErStdConfig.isProduct()) {
            return ErStdConfig.get("invoicecloud.prod.mobh5.domain");
        }
        return ErStdConfig.get("invoicecloud.test.mobh5.domain");
    }

    public static String getShowInvoiceListInMobH5Url() {
        String domain = ErStdConfig.getInvoiceMobH5Domain();
        String relativeUrl = ErStdConfig.get("invoicecloud.mobh5.invoicelisturl");
        return ErStdConfig.getInvoiceIframeUrlProtocal() + domain + relativeUrl;
    }

    public static String getShowAllInvoiceListInMobH4Url() {
        String domain = ErStdConfig.getInvoiceMobH5Domain();
        String relativeUrl = ErStdConfig.get("invoicecloud.mobh5.allinvoicelisturl");
        return ErStdConfig.getInvoiceIframeUrlProtocal() + domain + relativeUrl;
    }

    public static String getBudgetPropExt() {
        String budgetPropExt = ErStdConfig.get("budget_prop_ext");
        if (StringUtils.isBlank((CharSequence)budgetPropExt)) {
            return "";
        }
        return budgetPropExt;
    }

    public static String getInvoiceUnbindAuthCode() {
        if (ErStdConfig.isProduct()) {
            return ErStdConfig.get("invoicecloud_auth_code");
        }
        return ErStdConfig.get("invoicecloud_auth_code_test");
    }

    public static String getInvoiceUnbind() {
        if (ErStdConfig.isProduct()) {
            return ErStdConfig.get("invoicecloud_unbind_src");
        }
        return ErStdConfig.get("invoicecloud_unbind_src_test");
    }

    public static boolean getInvoiceCloudDeductible() {
        String invoiceCloudDeductible = ErStdConfig.get("invoicecloud.Deductible");
        return StringUtils.equals((CharSequence)invoiceCloudDeductible, (CharSequence)"true");
    }

    public static Long getInvoiceCloudOtherCharges(ItemEnum itemEnum) {
        String invoiceCloudDeductible = ErStdConfig.get("invoicecloud.othercharges");
        if (StringUtils.isNotBlank((CharSequence)invoiceCloudDeductible) && !StringUtils.equals((CharSequence)invoiceCloudDeductible, (CharSequence)"false")) {
            QFilter qf1 = new QFilter(itemEnum.getNumberName(), "=", (Object)invoiceCloudDeductible);
            QFilter qf2 = new QFilter("enable", "=", (Object)"1");
            DynamicObjectCollection dc = QueryServiceHelper.query((String)itemEnum.getEntityName(), (String)"id", (QFilter[])new QFilter[]{qf1, qf2});
            if (dc.size() > 0) {
                DynamicObject dobj = (DynamicObject)dc.get(0);
                return dobj.getLong("id");
            }
        }
        return null;
    }

    public static String getApp() {
        return (String)StringUtils.defaultIfBlank((CharSequence)ErStdConfig.get("invoicecloud.app"), (CharSequence)"yunzhijia");
    }

    public static String getImportInvoiceUrlInMobH5() {
        String domain = ErStdConfig.getInvoiceMobH5Domain();
        return ErStdConfig.getInvoiceIframeUrlProtocal() + domain + ErStdConfig.get("invoicecloud.mobh5.importinvoice");
    }

    public static String getImportInvoiceFromInvoicePackage() {
        String domain = ErStdConfig.getInvoiceMobH5Domain();
        return ErStdConfig.getInvoiceIframeUrlProtocal() + domain + ErStdConfig.get("invoicecloud.mobh5.invoicePackage");
    }

    public static boolean getIncludeSubCompanyForReimburseAmount() {
        String includeSubCompany = ErStdConfig.get("er_reimburseamount.includeSubCompany");
        if (StringUtils.isBlank((CharSequence)includeSubCompany)) {
            return false;
        }
        return Boolean.parseBoolean(includeSubCompany);
    }

    @Deprecated
    public static String getInvoiceValidateUrl() {
        String domain = ErStdConfig.getInvoiceCloudApiDomain();
        return "https://" + domain + ErStdConfig.get("invoicecloud.validate.url");
    }

    public static PageSize getImportInvoicePageSize() {
        String pageSize = ErStdConfig.get("invoicecloud.importinvoice.pagesize");
        if (StringUtils.isBlank((CharSequence)pageSize)) {
            return DEFAULT_IMPORT_INVOICE_PAGESIZE;
        }
        if (pageSize == null) {
            return new PageSize(0, 0);
        }
        String[] pageSizeParam = pageSize.split(",");
        return new PageSize(Integer.parseInt(pageSizeParam[0].trim()), Integer.parseInt(pageSizeParam[1].trim()));
    }

    public static boolean getInvoiceMustWithExpense() {
        String value = ErStdConfig.get("invoiceinfo.without.expenseitem.must");
        return !StringUtils.equals((CharSequence)value, (CharSequence)"false");
    }

    public static String getInvoiceRelationItemFactor() {
        return ErStdConfig.get("invoice.relation.item.factor");
    }

    public static ProxyAddr getHttpProxy() {
        String httpProxy = ErStdConfig.get("httpProxy");
        if (httpProxy == null || httpProxy.trim().equals("")) {
            return null;
        }
        String[] values = httpProxy.trim().split(":");
        if (values.length != 2) {
            throw new RuntimeException(ResManager.loadKDString((String)"er_stdconfig\u540e\u53f0\u8868\u4e2d\uff0chttpProxy\u53c2\u6570\u683c\u5f0f\u4e0d\u5bf9\uff0c\u5e94\u5f53\u4e3a\uff1ahostname:port\u3002", (String)"ErStdConfig_0", (String)"fi-er-business", (Object[])new Object[0]));
        }
        ProxyAddr proxyAddr = new ProxyAddr(values[0], Integer.parseInt(values[1]));
        return proxyAddr;
    }

    public static boolean isMustSameInvoiceTypeInRelatingInvoice() {
        String isMustSameTypeStr = ErStdConfig.get("invoicecloud.isMustSameInvoiceTypeInRelatingInvoice");
        if (StringUtils.isBlank((CharSequence)isMustSameTypeStr)) {
            return false;
        }
        return Boolean.parseBoolean(isMustSameTypeStr);
    }

    public static List<String> getBillLockAppId() {
        ArrayList<String> appIds = new ArrayList<String>(2);
        String billlockappid = ErStdConfig.get("billlockappid");
        if (StringUtils.isNotBlank((CharSequence)billlockappid)) {
            String[] appIdStrs;
            for (String appIdStr : appIdStrs = billlockappid.split(",|\uff0c")) {
                appIds.add(appIdStr.trim());
            }
            return appIds;
        }
        return appIds;
    }

    public static boolean isEnableGridStyleInTripReimMob() {
        return StringUtils.equals((CharSequence)SystemParamterUtil.getTripReimburseTypeByCurrentUser(), (CharSequence)"grid");
    }

    public static boolean quotaZeroIsCtrl() {
        String style = ErStdConfig.get("reimctl.quotaIsZero.noCtrl");
        boolean result = StringUtils.equals((CharSequence)style, (CharSequence)"false");
        return result;
    }

    public static boolean isSetInvoiceStatusUnusedWhenUnsubmit() {
        String isSetStr = ErStdConfig.get("invoicecloud.isSetInvoiceStatusUnusedWhenUnsubmit");
        if (StringUtils.isNotBlank((CharSequence)isSetStr)) {
            return Boolean.parseBoolean(isSetStr);
        }
        return true;
    }

    public static BigDecimal taxDifferenceClear() {
        String isTaxDifferenceValidate = ErStdConfig.get("invoice.tax.difference.clear");
        return new BigDecimal(isTaxDifferenceValidate);
    }

    public static boolean isTaxDifferenceValidate() {
        String isTaxDifferenceValidate = ErStdConfig.get("invoice.tax.difference");
        return StringUtils.equals((CharSequence)"true", (CharSequence)isTaxDifferenceValidate);
    }

    public static String taxShareType() {
        String taxShareType = ErStdConfig.get("invoicecloud.tax.distribution");
        if (StringUtils.isBlank((CharSequence)taxShareType)) {
            return "1";
        }
        return taxShareType;
    }

    public static boolean standardQuotaQuery() {
        String standardQuotaQuery = ErStdConfig.get("Standardquotaquery");
        return !StringUtils.equals((CharSequence)"false", (CharSequence)standardQuotaQuery);
    }

    public static String getDockingMode() {
        String dockingMode = ErStdConfig.get("invoicecloud.mobh5.dockingMode");
        if (dockingMode == null || StringUtils.isBlank((CharSequence)dockingMode)) {
            return "false";
        }
        return dockingMode.trim();
    }

    public static String includeWechatCardInInvoicePackage() {
        String includeWechatCard = ErStdConfig.get("invoicecloud.mobh5.wechatCard");
        if (includeWechatCard != null && StringUtils.isNotBlank((CharSequence)includeWechatCard)) {
            return includeWechatCard.trim();
        }
        return "false";
    }

    public static String getRecordPoolDrawFilter() {
        String value = ErStdConfig.get("record.pool.draw.filter");
        if (StringUtils.equals((CharSequence)value, (CharSequence)"1") || StringUtils.equals((CharSequence)value, (CharSequence)"2")) {
            return value;
        }
        return "0";
    }

    public static String getInvoiceIframeUrlProtocal() {
        String protocol = ErStdConfig.get("invoicecloud.httpOfIframUrl");
        protocol = ((String)StringUtils.defaultIfBlank((CharSequence)protocol, (CharSequence)"https://")).trim();
        return protocol;
    }

    public static Boolean isInvokeMiniProgramInImportInvoice() {
        String invokeMiniStr = ErStdConfig.get("invokeMiniProgram");
        if (invokeMiniStr == null || StringUtils.isBlank((CharSequence)invokeMiniStr)) {
            return Boolean.TRUE;
        }
        return Boolean.valueOf(invokeMiniStr.trim());
    }

    public static String getExtTripReimFormId(String formId) {
        String extFormId = ErStdConfig.get(formId);
        if (StringUtils.isBlank((CharSequence)extFormId)) {
            return formId;
        }
        return extFormId;
    }

    public static String getDeductibleOfTaxPayerType() {
        String deductibleOfTaxPayerType = ErStdConfig.get("deductible.of.tax.payer.type");
        if (StringUtils.isBlank((CharSequence)deductibleOfTaxPayerType)) {
            return "all";
        }
        return deductibleOfTaxPayerType;
    }

    public static BigDecimal getAccentryDiffRange() {
        String getAccentryDiffRange = ErStdConfig.get("accentryDiffRange");
        return new BigDecimal(getAccentryDiffRange);
    }

    public static Integer getPostBackTeype() {
        String postBackTeype = ErStdConfig.get("invoice.postback.offsetamount");
        if (StringUtils.equals((CharSequence)postBackTeype, (CharSequence)"3") || StringUtils.equals((CharSequence)postBackTeype, (CharSequence)"1")) {
            return Integer.parseInt(postBackTeype);
        }
        return 2;
    }

    public static String getApproveTaxFormulaType() {
        return ErStdConfig.get("approvetax.formula");
    }

    public static String getInvoiceZeroAmountCreateItem() {
        String invoiceZeroAmountCreateItem = ErStdConfig.get("invoice.zeroamount.createitem");
        if (StringUtils.equals((CharSequence)invoiceZeroAmountCreateItem, (CharSequence)"1")) {
            return invoiceZeroAmountCreateItem;
        }
        return "0";
    }

    public static boolean getShowImportInvoiceDataSimulatorPC() {
        String invoiceShowSimulator = ErStdConfig.get("invoice.show.simulator.pc");
        return StringUtils.equals((CharSequence)"true", (CharSequence)invoiceShowSimulator);
    }

    public static boolean getShowImportInvoiceDataSimulatorMOB() {
        String invoiceShowSimulator = ErStdConfig.get("invoice.show.simulator.mob");
        return StringUtils.equals((CharSequence)"true", (CharSequence)invoiceShowSimulator);
    }

    public static boolean getIsCoverAuditForReimburseAmount() {
        String iscover = ErStdConfig.get("er_reimburseamount.iscover");
        if (StringUtils.isBlank((CharSequence)iscover)) {
            return false;
        }
        return Boolean.parseBoolean(iscover);
    }

    public static int getNumCopyAccountEntry() {
        String copyNum = ErStdConfig.get("iscopyaccountentry");
        if (StringUtils.isBlank((CharSequence)copyNum)) {
            return 1;
        }
        return Integer.parseInt(copyNum);
    }

    public static final boolean getInvoicesCredits() {
        String invoicesCredits = ErStdConfig.get("Invoices.credits");
        if (StringUtils.isBlank((CharSequence)invoicesCredits)) {
            return true;
        }
        return Boolean.parseBoolean(invoicesCredits);
    }

    public static final Integer getExpenseDateValue() {
        String expenseDate = ErStdConfig.get("ExpenseDateValue");
        if (StringUtils.isBlank((CharSequence)expenseDate)) {
            return StdConfigConstant.EXPENSE_DATE_VALUE_INVOICE;
        }
        return Integer.parseInt(expenseDate);
    }

    public static String getApplyprojectbillRelated() {
        String value = ErStdConfig.get("ApplyprojectbillRelated");
        if (value != null) {
            return value.trim();
        }
        return "1";
    }

    public static String getQuotaDateField() {
        String quotaDateField = "expenseentryentity.happendate";
        if ("2".equals(ErStdConfig.get("quotaDateField"))) {
            quotaDateField = "bizdate";
        }
        return quotaDateField;
    }

    public static boolean getFrameworkcontractpushtopub() {
        String value = ErStdConfig.get("frameworkcontractpushtopub");
        return StringUtils.equals((CharSequence)value, (CharSequence)"true");
    }

    public static boolean getContractDeadlineControl() {
        String value = ErStdConfig.get("contractdeadlinecontrol");
        return StringUtils.equals((CharSequence)value, (CharSequence)"true");
    }

    public static boolean getPurcontractIscErcontract() {
        String value = ErStdConfig.get("isreserveiscclounm_contract");
        return StringUtils.equals((CharSequence)value, (CharSequence)"true");
    }

    public static boolean isSaveInvokeImage() {
        String value = ErStdConfig.get("saveInvokeImage");
        return !StringUtils.equals((CharSequence)value, (CharSequence)"false");
    }

    public static boolean isShowBindingInvoice() {
        String value = ErStdConfig.get("showBindingInvoice");
        return !StringUtils.equals((CharSequence)value, (CharSequence)"false");
    }

    public static final Integer getSynImportInvoiceValue() {
        String synImportInvoiceValue = ErStdConfig.get("SynImportInvoiceValue");
        if (StringUtils.isBlank((CharSequence)synImportInvoiceValue)) {
            return StdConfigConstant.SYNIMPORT_INVOICE_VALUE_DEFAULT;
        }
        return Integer.parseInt(synImportInvoiceValue);
    }

    public static String getExtInvoiceServiceClass() {
        String extInvoiceServiceClass = ErStdConfig.get("invoice.service.ext.class");
        return extInvoiceServiceClass;
    }

    public static boolean getInvoiceAutoMappingItem() {
        String autoMapping = ErStdConfig.get("MappingItem.AutoExpenseitem");
        return StringUtils.equals((CharSequence)autoMapping, (CharSequence)"2");
    }

    public static boolean getImportInvoiceOutLog() {
        String autoMapping = ErStdConfig.get("import.invoice.out.log");
        return !StringUtils.equals((CharSequence)autoMapping, (CharSequence)"false");
    }

    public static class ProxyAddr {
        public final String hostname;
        public final int port;

        public ProxyAddr(String hostname, int port) {
            this.hostname = hostname;
            this.port = port;
        }
    }

    public static class PageSize {
        private final int width;
        private final int height;

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public PageSize(int width, int height) {
            this.width = width;
            this.height = height;
        }
    }
}

