/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.utils;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.InvoiceService;
import kd.fi.er.business.invoicecloud.kingdee.APIHelper;
import kd.fi.er.business.invoicecloud.provider.param.req.RecognitionCheckReqParam;
import kd.fi.er.business.invoicecloud.provider.param.resp.ValidateInvocieRespParam;
import kd.fi.er.business.utils.TripInvoiceUtils;
import kd.fi.er.common.exception.invoice.InvoiceCloudException;
import org.apache.commons.lang3.StringUtils;

public class ImageUtils {
    private static Log log = LogFactory.getLog(ImageUtils.class);

    public static String pushInvoiceCloud(DynamicObject bill, Long costcompany, Long reimbursebillPK) throws InvoiceCloudException {
        if (costcompany == null || costcompany == 0L) {
            log.info("\u8ba2\u5355\uff1a{}\u5f71\u50cf\u4fe1\u606f\u63a8\u9001\u53d1\u7968\u4e91\u8ba2\u5355\u5173\u8054\u7684\u5dee\u65c5\u62a5\u9500\u5355\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4e3a\u7a7a\u3002", (Object)bill.getString("ordernum"));
            return "";
        }
        String bxd_key = "er_tripreimbursebill_" + reimbursebillPK;
        String billno = bill.getString("reimbursenum");
        String downloadlink = bill.getString("downloadlink");
        String userKey = APIHelper.getCommonUserKey(costcompany, bxd_key, billno);
        String serialNo = APIHelper.uploadImage(downloadlink, userKey);
        return serialNo;
    }

    public static Set<String> fetchInvoiceData(Set<String> urls, Long costCompany, String bxdKey, String billNo) {
        HashSet result = Sets.newHashSetWithExpectedSize((int)urls.size());
        try {
            String userKey = APIHelper.getCommonUserKey(costCompany, bxdKey, billNo);
            for (String url : urls) {
                result.add(APIHelper.uploadImage(url, userKey));
            }
        }
        catch (InvoiceCloudException e) {
            log.error("\u3010\u53d1\u7968\u4e91\u3011" + (Object)((Object)e));
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return result;
    }

    public static Set<String> fetchXhInvoiceData(Set<String> urls, Long costCompany) {
        HashSet result = Sets.newHashSetWithExpectedSize((int)urls.size());
        try {
            for (String url : urls) {
                RecognitionCheckReqParam reqParam = new RecognitionCheckReqParam();
                String fileType = TripInvoiceUtils.getFileType(url);
                reqParam.setFileDownUrl(url);
                reqParam.setFileType(fileType);
                reqParam.setOrgId(costCompany);
                ValidateInvocieRespParam response = InvoiceService.getInstanceService().recognitionCheckInvoice(reqParam);
                if (response == null || !response.isPass() || response.getInvoiceVO() == null || StringUtils.isBlank((CharSequence)response.getInvoiceVO().getSerialNo())) {
                    String msg = response == null ? "" : response.getMsg();
                    log.info(String.format("fetchXhInvoiceData failed, url: %s, reason: %s", url, msg));
                    continue;
                }
                result.add(response.getInvoiceVO().getSerialNo());
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return result;
    }
}

