/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.ItemFrom;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.invoicecloud.util.InvoiceTypeUtils;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.business.utils.model.ChangeField;
import kd.fi.er.common.invoice.utils.InvoiceUtils2;
import kd.fi.er.common.model.invoice.ItemInvoiceRelationEnum;
import kd.fi.er.common.model.invoice.bill.BillExpenseInfoFildKeyType;
import kd.fi.er.common.model.invoice.bill.BillOfInvoice;
import kd.fi.er.formplugin.util.OffsetUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.shaded.com.google.common.collect.Maps;

public class InvoiceOffsetUtils {
    private static final Log logger = LogFactory.getLog(InvoiceOffsetUtils.class);

    public static boolean deductibleOfTaxPayer(Long companyId, Long costCompanyId) {
        boolean costCompanyOffset = true;
        if (costCompanyId != null) {
            costCompanyOffset = KingdeeInvoiceCloudConfig.getDeductibleOfTaxPayer(costCompanyId);
        }
        boolean companyOffset = true;
        if (companyId != null) {
            companyOffset = SystemParamterUtil.getDeductibleOfTaxpayer(companyId);
        }
        String deductibleOfTaxPayerType = ErStdConfig.getDeductibleOfTaxPayerType();
        logger.info(String.format("InvoiceOffsetUtils.deductibleOfTaxPayer:companyId=%s,costCompanyId=%s,costCompanyOffset=%s,companyOffset=%s,deductibleOfTaxPayerType=%s", companyId, costCompanyId, costCompanyOffset, companyOffset, deductibleOfTaxPayerType));
        if (StringUtils.equals((CharSequence)deductibleOfTaxPayerType, (CharSequence)"all")) {
            return costCompanyOffset && companyOffset;
        }
        if (StringUtils.equals((CharSequence)deductibleOfTaxPayerType, (CharSequence)"applyCompany")) {
            return companyOffset;
        }
        if (StringUtils.equals((CharSequence)deductibleOfTaxPayerType, (CharSequence)"costCompany")) {
            return costCompanyOffset;
        }
        return true;
    }

    public static boolean deductibleOfTaxPayer(IDataModel modle) {
        return InvoiceOffsetUtils.deductibleOfTaxPayer(modle.getDataEntity());
    }

    public static boolean deductibleOfTaxPayer(DynamicObject dataEntity) {
        Long companyId = null;
        Long costCompanyId = null;
        if (dataEntity.getDynamicObjectType().getProperty("company") != null) {
            companyId = ErCommonUtils.getPk(dataEntity.get("company"));
        }
        if (dataEntity.getDynamicObjectType().getProperty("costcompany") != null) {
            costCompanyId = ErCommonUtils.getPk(dataEntity.get("costcompany"));
        }
        return InvoiceOffsetUtils.deductibleOfTaxPayer(companyId, costCompanyId);
    }

    public static void refreshItemsOffset(DynamicObject dataEntity, BillExpenseInfoFildKeyType type, int currentIndex, int parentIndex) {
        DynamicObjectCollection expenseEntry = type.getExpenseEntryEntities(dataEntity, parentIndex);
        if (expenseEntry.isEmpty()) {
            logger.info("\u8d39\u7528\u660e\u7ec6\u5206\u5f55\u4e3a\u7a7a");
            return;
        }
        DynamicObject itemEntity = (DynamicObject)expenseEntry.get(currentIndex);
        Map<String, Object> keyValueMap = InvoiceOffsetUtils.getItemsOffset(dataEntity, type, currentIndex, parentIndex);
        for (Map.Entry<String, Object> entry : keyValueMap.entrySet()) {
            itemEntity.set(entry.getKey(), entry.getValue());
        }
    }

    public static void refresh(DynamicObject dataEntity, DynamicObject itemEntity, List<DynamicObject> invoiceList, int itemIndex, int parentIndex) {
        boolean isNonOffsetImportTaxAmout = false;
        if (dataEntity.getDynamicObjectType().getProperty("costcompany") != null) {
            isNonOffsetImportTaxAmout = KingdeeInvoiceCloudConfig.isNonOffsetImportTaxAmout(ErCommonUtils.getPk(dataEntity.getDynamicObject("costcompany")));
        }
        BigDecimal taxRate = itemEntity.getBigDecimal("taxrate");
        logger.info("\u5f53\u524d\u660e\u7ec6\u884ctaxRate:" + taxRate);
        if (BigDecimal.ZERO.compareTo(taxRate) == 0) {
            Set<Long> invoiceItemIdOfInvoiceItemEntry = InvoiceUtils.autoMapInvoiceItemMappingInfo(dataEntity).get(ErCommonUtils.getPk(itemEntity));
            List<Object> invoiceItemList = Lists.newArrayList();
            if (invoiceItemIdOfInvoiceItemEntry != null) {
                invoiceItemList = dataEntity.getDynamicObjectCollection("invoiceitementry").stream().filter(invoiceItem -> invoiceItemIdOfInvoiceItemEntry.contains(ErCommonUtils.getPk(itemEntity))).collect(Collectors.toList());
            }
            if (!invoiceItemList.isEmpty()) {
                BigDecimal tax = ((DynamicObject)invoiceItemList.get(0)).getBigDecimal("invoiceitemtaxrate");
                BigDecimal taxAmount = invoiceItemList.stream().map(item -> (BigDecimal)ObjectUtils.defaultIfNull((Object)item.getBigDecimal("invoiceitemtaxamout"), (Object)BigDecimal.ZERO)).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                if (!isNonOffsetImportTaxAmout) {
                    taxAmount = InvoiceOffsetUtils.getOffsetInvoiceItem((Collection<DynamicObject>)invoiceItemList).map(item -> (BigDecimal)ObjectUtils.defaultIfNull((Object)item.getBigDecimal("invoiceitemtaxamout"), (Object)BigDecimal.ZERO)).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                }
                if (invoiceItemList.stream().allMatch(invoiceItem -> tax.compareTo(invoiceItem.getBigDecimal("invoiceitemtaxrate")) == 0)) {
                    if (!isNonOffsetImportTaxAmout && !InvoiceOffsetUtils.isInvoiceItemAllOffset(invoiceItemList)) {
                        itemEntity.set("taxrate", (Object)BigDecimal.ZERO);
                    } else {
                        itemEntity.set("taxrate", (Object)tax.multiply(BigDecimal.valueOf(100L)));
                    }
                }
                itemEntity.set("taxamount", (Object)taxAmount);
            }
        }
    }

    public static void refresh(IDataModel dataModel, DynamicObject itemEntity, List<DynamicObject> invoiceList, int itemIndex, int parentIndex) {
        DynamicObject dataEntity = dataModel.getDataEntity();
        boolean isNonOffsetImportTaxAmout = false;
        if (dataEntity.getDynamicObjectType().getProperty("costcompany") != null) {
            isNonOffsetImportTaxAmout = KingdeeInvoiceCloudConfig.isNonOffsetImportTaxAmout(ErCommonUtils.getPk(dataEntity.getDynamicObject("costcompany")));
        }
        BigDecimal taxRate = itemEntity.getBigDecimal("taxrate");
        logger.info("\u5f53\u524d\u660e\u7ec6\u884ctaxRate:" + taxRate);
        if (BigDecimal.ZERO.compareTo(taxRate) == 0) {
            Set<Long> invoiceItemIdOfInvoiceItemEntry = InvoiceUtils.getInvoiceItemColl(dataModel, "invoiceitementry", "itementryid", "id").get(ErCommonUtils.getPk(itemEntity));
            List<Object> invoiceItemList = Lists.newArrayList();
            if (invoiceItemIdOfInvoiceItemEntry != null) {
                invoiceItemList = dataModel.getEntryEntity("invoiceitementry").stream().filter(invoiceItem -> invoiceItemIdOfInvoiceItemEntry.contains(ErCommonUtils.getPk(itemEntity))).collect(Collectors.toList());
            }
            if (!invoiceItemList.isEmpty()) {
                BigDecimal tax = ((DynamicObject)invoiceItemList.get(0)).getBigDecimal("invoiceitemtaxrate");
                BigDecimal taxAmount = invoiceItemList.stream().map(item -> (BigDecimal)ObjectUtils.defaultIfNull((Object)item.getBigDecimal("invoiceitemtaxamout"), (Object)BigDecimal.ZERO)).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                if (!isNonOffsetImportTaxAmout) {
                    taxAmount = InvoiceOffsetUtils.getOffsetInvoiceItem((Collection<DynamicObject>)invoiceItemList).map(item -> (BigDecimal)ObjectUtils.defaultIfNull((Object)item.getBigDecimal("invoiceitemtaxamout"), (Object)BigDecimal.ZERO)).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                }
                if (invoiceItemList.stream().allMatch(invoiceItem -> tax.compareTo(invoiceItem.getBigDecimal("invoiceitemtaxrate")) == 0)) {
                    if (!isNonOffsetImportTaxAmout && !InvoiceOffsetUtils.isInvoiceItemAllOffset(invoiceItemList)) {
                        itemEntity.set("taxrate", (Object)BigDecimal.ZERO);
                    } else {
                        itemEntity.set("taxrate", (Object)tax.multiply(BigDecimal.valueOf(100L)));
                    }
                }
                itemEntity.set("taxamount", (Object)taxAmount);
            }
        }
    }

    public static void refreshPage(IDataModel model) {
        DynamicObject dataEntity = model.getDataEntity(true);
        if (model.getProperty("expenseentryentity") != null) {
            DynamicObjectCollection expenseEntry = dataEntity.getDynamicObjectCollection("expenseentryentity");
            for (int currentIndex = 0; currentIndex < expenseEntry.size(); ++currentIndex) {
                InvoiceOffsetUtils.setModelValue(model, BillExpenseInfoFildKeyType.DailyReimburse, currentIndex, 0);
            }
        }
    }

    private static void setValue(IDataModel model, Map<String, Object> keyValueMap, int currentIndex, int parentIndex) {
        for (Map.Entry<String, Object> entry : keyValueMap.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Boolean) {
                model.beginInit();
                model.setValue(entry.getKey(), (Object)((Boolean)value == false ? 1 : 0), currentIndex, parentIndex);
                model.endInit();
            }
            model.setValue(entry.getKey(), value, currentIndex, parentIndex);
        }
    }

    private static void setListValue(IDataModel model, List<Map<String, Object>> keyValueList, int parentIndex, BillExpenseInfoFildKeyType type) {
        for (Map<String, Object> keyValueMap : keyValueList) {
            int currentIndex = (Integer)keyValueMap.get("currentIndex");
            BigDecimal taxRate = (BigDecimal)keyValueMap.get("taxrate");
            BigDecimal taxAmount = (BigDecimal)keyValueMap.get("taxamount");
            Boolean offset = (Boolean)keyValueMap.get("offset");
            BigDecimal deductibleTax = (BigDecimal)keyValueMap.get("deductibletax");
            BigDecimal itemInOutAmount = (BigDecimal)keyValueMap.get("iteminoutamount");
            BigDecimal price = (BigDecimal)keyValueMap.get("price");
            String isSpecialInvoiceKey = type.getSpecialKey();
            Boolean isSpecialInvoice = (Boolean)keyValueMap.get(isSpecialInvoiceKey);
            String noTaxAmountKey = type.getNoTaxAmountKey();
            BigDecimal noTaxAmount = (BigDecimal)keyValueMap.get(noTaxAmountKey);
            model.beginInit();
            if (taxRate != null) {
                model.setValue("taxrate", (Object)taxRate, currentIndex, parentIndex);
            }
            if (taxAmount != null) {
                model.setValue("taxamount", (Object)taxAmount, currentIndex, parentIndex);
                model.setValue("approvetax", (Object)taxAmount, currentIndex, parentIndex);
            }
            if (noTaxAmount != null) {
                model.setValue(noTaxAmountKey, (Object)noTaxAmount, currentIndex, parentIndex);
            }
            if (offset != null) {
                model.setValue("offset", (Object)offset, currentIndex, parentIndex);
            }
            if (deductibleTax != null) {
                model.setValue("deductibletax", (Object)deductibleTax, currentIndex, parentIndex);
            }
            if (itemInOutAmount != null) {
                model.setValue("iteminoutamount", (Object)itemInOutAmount, currentIndex, parentIndex);
            }
            if (isSpecialInvoice != null) {
                model.setValue(isSpecialInvoiceKey, (Object)isSpecialInvoice, currentIndex, parentIndex);
            }
            model.endInit();
            if (price == null) continue;
            model.setValue("price", (Object)price, currentIndex, parentIndex);
        }
    }

    public static void computeAllItemOffsetAndSpecial(IDataModel model) {
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection tripEntries = dataEntity.getDynamicObjectCollection("tripentry");
        for (int parentIndex = 0; parentIndex < tripEntries.size(); ++parentIndex) {
            DynamicObjectCollection expenItem = ((DynamicObject)tripEntries.get(parentIndex)).getDynamicObjectCollection("entryentity");
            for (int index = 0; index < expenItem.size(); ++index) {
                InvoiceOffsetUtils.setModelValue(model, BillExpenseInfoFildKeyType.TripReimburse, index, parentIndex);
            }
        }
        logger.info("\u7ed3\u675f\u5faa\u73af");
    }

    public static void refreshSingle(IDataModel model) {
        DynamicObject dataEntity = model.getDataEntity(true);
        String entityId = dataEntity.getDynamicObjectType().getName();
        if (ErEntityTypeUtils.isDailyReimburseBill(entityId)) {
            int parentIndex = 0;
            int currentIndex = model.getEntryCurrentRowIndex("expenseentryentity");
            InvoiceOffsetUtils.setModelValue(model, BillExpenseInfoFildKeyType.DailyReimburse, currentIndex, parentIndex);
        } else if (ErEntityTypeUtils.isPublicReimburseBill(entityId)) {
            int parentIndex = 0;
            int currentIndex = model.getEntryCurrentRowIndex("expenseentryentity");
            InvoiceOffsetUtils.setModelValue(model, BillExpenseInfoFildKeyType.PublicReimburse, currentIndex, parentIndex);
        } else if (ErEntityTypeUtils.isTripReimburseBill(entityId)) {
            int parentIndex = model.getEntryCurrentRowIndex("tripentry");
            int currentIndex = model.getEntryCurrentRowIndex("entryentity");
            InvoiceOffsetUtils.setModelValue(model, BillExpenseInfoFildKeyType.TripReimburse, currentIndex, parentIndex);
        }
    }

    public static void refreshSingle(IDataModel model, int currentIndex, int parentIndex) {
        DynamicObject dataEntity = model.getDataEntity(true);
        String entityId = dataEntity.getDynamicObjectType().getName();
        if (ErEntityTypeUtils.isDailyReimburseBill(entityId)) {
            InvoiceOffsetUtils.setModelValue(model, BillExpenseInfoFildKeyType.DailyReimburse, currentIndex, parentIndex);
        } else if (ErEntityTypeUtils.isPublicReimburseBill(entityId)) {
            InvoiceOffsetUtils.setModelValue(model, BillExpenseInfoFildKeyType.PublicReimburse, currentIndex, parentIndex);
        } else if (ErEntityTypeUtils.isTripReimburseBill(entityId)) {
            InvoiceOffsetUtils.setModelValue(model, BillExpenseInfoFildKeyType.TripReimburse, currentIndex, parentIndex);
        }
    }

    public static void refreshAll(IDataModel model, int parentIndex) {
        DynamicObject dataEntity = model.getDataEntity(true);
        String entityId = dataEntity.getDynamicObjectType().getName();
        if (ErEntityTypeUtils.isDailyReimburseBill(entityId)) {
            InvoiceOffsetUtils.setModelAllValue(model, BillExpenseInfoFildKeyType.DailyReimburse, parentIndex);
        } else if (ErEntityTypeUtils.isPublicReimburseBill(entityId)) {
            InvoiceOffsetUtils.setModelAllValue(model, BillExpenseInfoFildKeyType.PublicReimburse, parentIndex);
        } else if (ErEntityTypeUtils.isTripReimburseBill(entityId)) {
            InvoiceOffsetUtils.setModelAllValue(model, BillExpenseInfoFildKeyType.TripReimburse, parentIndex);
        }
    }

    public static void setModelAllValue(IDataModel model, BillExpenseInfoFildKeyType type, int parentIndex) {
        InvoiceOffsetUtils.setItemsOffset(model, type, parentIndex);
    }

    public static void setModelValue(IDataModel model, BillExpenseInfoFildKeyType type, int currentIndex, int parentIndex) {
        DynamicObject dataEntity = model.getDataEntity(true);
        Map<String, Object> keyValueMap = InvoiceOffsetUtils.getItemsOffset(dataEntity, type, currentIndex, parentIndex);
        InvoiceOffsetUtils.setValue(model, keyValueMap, currentIndex, parentIndex);
    }

    public static void setModelValue(IDataModel model, IDataModel pModel, BillExpenseInfoFildKeyType type, Integer currentIndex, Integer pCurrentIndex, Integer parentIndex) {
        BigDecimal deductibletaxParent;
        Boolean offsetParent;
        Boolean specialParent;
        logger.info(String.format("setModelValue \u5165\u53c2 currentIndex: %d, pCurrentIndex\uff1a %d, parentIndex: %d", currentIndex, pCurrentIndex, parentIndex));
        Map<String, Object> keyValueMap = InvoiceOffsetUtils.getItemsOffset(model.getDataEntity(true), type, currentIndex == null ? 0 : currentIndex, parentIndex);
        Map<String, Object> keyValueMapParent = currentIndex == null || pCurrentIndex == null ? null : InvoiceOffsetUtils.getItemsOffset(pModel.getDataEntity(true), type, pCurrentIndex, parentIndex);
        Boolean special = (Boolean)keyValueMap.get(type.getSpecialKey());
        Boolean bl = specialParent = keyValueMapParent == null ? null : (Boolean)keyValueMapParent.get(type.getSpecialKey());
        if (special == null && specialParent != null) {
            keyValueMap.put(type.getSpecialKey(), specialParent);
        } else if (special != null && specialParent != null && special.booleanValue() && specialParent.booleanValue()) {
            keyValueMap.put(type.getSpecialKey(), true);
        } else if (special != null && specialParent == null) {
            keyValueMap.put(type.getSpecialKey(), special);
        } else {
            keyValueMap.put(type.getSpecialKey(), false);
        }
        Boolean offset = (Boolean)keyValueMap.get("offset");
        Boolean bl2 = offsetParent = keyValueMapParent == null ? null : (Boolean)keyValueMapParent.get("offset");
        if (offset == null && offsetParent != null) {
            keyValueMap.put("offset", offsetParent);
        } else if (offset != null && offsetParent != null && (offset.booleanValue() || offsetParent.booleanValue())) {
            keyValueMap.put("offset", true);
        } else if (offset != null && offsetParent == null) {
            keyValueMap.put("offset", offset);
        } else {
            keyValueMap.put("offset", false);
        }
        BigDecimal deductibletax = (BigDecimal)keyValueMap.get("deductibletax");
        BigDecimal bigDecimal = deductibletaxParent = keyValueMapParent == null ? null : (BigDecimal)keyValueMapParent.get("deductibletax");
        if (deductibletax == null && deductibletaxParent != null) {
            keyValueMap.put("deductibletax", deductibletaxParent);
        } else if (deductibletax != null && deductibletaxParent != null) {
            keyValueMap.put("deductibletax", deductibletaxParent.add(deductibletax));
        }
        InvoiceOffsetUtils.setValue(model, keyValueMap, currentIndex == null ? 0 : currentIndex, parentIndex);
    }

    public static void setDmoValue(IDataModel model, DynamicObject dataEntity, BillExpenseInfoFildKeyType type, int currentIndex, int parentIndex) {
        Map<String, Object> keyValueMap = InvoiceOffsetUtils.getItemsOffset(dataEntity, type, currentIndex, parentIndex);
        InvoiceOffsetUtils.setValue(model, keyValueMap, currentIndex, parentIndex);
    }

    private static Map<String, Object> getItemsOffset(DynamicObject dataEntity, BillExpenseInfoFildKeyType type, int currentIndex, int parentIndex) {
        boolean isSpecialInvoice;
        HashMap keyValueMap = Maps.newHashMapWithExpectedSize((int)4);
        DynamicObjectCollection expenseEntry = type.getExpenseEntryEntities(dataEntity, parentIndex);
        if (expenseEntry.isEmpty()) {
            logger.info("\u8d39\u7528\u660e\u7ec6\u5206\u5f55\u4e3a\u7a7a");
            return keyValueMap;
        }
        logger.info(String.format("\u8d39\u7528\u660e\u7ec6\u884c size: %d, currentIndex: %d, parentIndex: %d", expenseEntry.size(), currentIndex, parentIndex));
        DynamicObject itemEntity = (DynamicObject)expenseEntry.get(currentIndex);
        String itemfrom = itemEntity.getString("itemfrom");
        if (ItemFrom.TripBusiness.getValue().equals(itemfrom)) {
            logger.info("\u5546\u65c5\u4e0d\u505a\u5173\u8054");
            return keyValueMap;
        }
        DynamicObject item = itemEntity.getDynamicObject(type.getItemKey());
        HashSet invoiceIds = Sets.newHashSet();
        Boolean isAutomapinvoice = dataEntity.getBoolean("automapinvoice");
        if (isAutomapinvoice.booleanValue()) {
            Map<Long, Set<Long>> autoMapInvoiceMappingInfo = InvoiceUtils.autoMapInvoiceMappingInfo(dataEntity);
            Set<Long> invoiceIdsOfInvoiceItemEntry = autoMapInvoiceMappingInfo.get(ErCommonUtils.getPk(itemEntity));
            if (invoiceIdsOfInvoiceItemEntry != null) {
                invoiceIds.addAll(invoiceIdsOfInvoiceItemEntry);
            }
        } else {
            Map<Long, Set<Long>> nonAutoMapInvoiceMappingInfo = InvoiceUtils.nonAutoMapInvoiceMappingInfo(dataEntity);
            Set<Long> invoiceIdsOfExpenseAndInvoiceEntry = nonAutoMapInvoiceMappingInfo.get(ErCommonUtils.getPk(itemEntity));
            if (invoiceIdsOfExpenseAndInvoiceEntry != null) {
                invoiceIds.addAll(invoiceIdsOfExpenseAndInvoiceEntry);
            }
        }
        logger.info("\u5f53\u524d\u9009\u4e2d\u884c\uff1a" + currentIndex + "\uff0c\u5173\u8054\u7684\u53d1\u7968id\uff1a" + invoiceIds);
        boolean itemInfoOffset = false;
        boolean isOrgOffset = InvoiceOffsetUtils.deductibleOfTaxPayer(dataEntity);
        boolean itemOffset = false;
        if (invoiceIds.isEmpty()) {
            DynamicObject company;
            if (dataEntity.getDynamicObjectType().getProperty("company") != null && (company = dataEntity.getDynamicObject("company")) != null) {
                itemOffset = SystemParamterUtil.manuallyaddexpenseoffset((Long)company.getPkValue());
            }
            if (itemOffset && item != null) {
                itemInfoOffset = item.getBoolean(type.getItem().getIsOffsetKey());
            }
            isSpecialInvoice = false;
        } else {
            List<DynamicObject> invoiceList;
            if (item != null) {
                itemOffset = item.getBoolean(type.getItem().getIsOffsetKey());
            }
            if ((invoiceList = dataEntity.getDynamicObjectCollection("invoiceentry").stream().filter(invoiceItem -> invoiceIds.contains(invoiceItem.getPkValue())).collect(Collectors.toList())).isEmpty()) {
                return keyValueMap;
            }
            List<DynamicObject> invoiceItemList = dataEntity.getDynamicObjectCollection("invoiceitementry").stream().filter(invoiceItem -> invoiceIds.contains(invoiceItem.get("invoiceheadentryid"))).collect(Collectors.toList());
            Set<String> set = InvoiceTypeUtils.loadSpecialInvoiceTypes();
            isSpecialInvoice = invoiceList.stream().allMatch(invoiceItem -> set.contains(invoiceItem.getString("invoicetype")));
            boolean isInvoiceOffset = InvoiceOffsetUtils.isInvoiceOffset(invoiceItemList);
            InvoiceOffsetUtils.refresh(dataEntity, itemEntity, invoiceList, currentIndex, parentIndex);
            boolean bl = itemInfoOffset = isInvoiceOffset && itemOffset;
            if (!isOrgOffset) {
                keyValueMap.put("taxrate", BigDecimal.ZERO);
                keyValueMap.put("taxamount", BigDecimal.ZERO);
            }
        }
        itemInfoOffset = itemInfoOffset && isOrgOffset;
        keyValueMap.put("offset", itemInfoOffset);
        logger.info("\u8bbe\u7f6e\u660e\u7ec6\u7684\u5c5e\u6027\uff0coffset\uff1a" + itemInfoOffset + "\uff0cisSpecialInvoice" + isSpecialInvoice);
        if (!itemInfoOffset) {
            keyValueMap.put("deductibletax", BigDecimal.ZERO);
        } else {
            keyValueMap.put("deductibletax", itemEntity.getBigDecimal("taxamount"));
        }
        keyValueMap.put(type.getSpecialKey(), isSpecialInvoice);
        BigDecimal expeapproveAmount = itemEntity.getBigDecimal(type.getApproveAmountKey());
        BigDecimal price = AmountChangeUtil.getNoTaxAmount(expeapproveAmount, (BigDecimal)keyValueMap.get("deductibletax"), itemEntity.getBigDecimal("approvetax"));
        logger.info("\u6838\u5b9a\u91d1\u989d:" + expeapproveAmount + ",\u6838\u5b9a\u7a0e\u989d:" + itemEntity.getBigDecimal("approvetax") + ",\u62b5\u6263\u7a0e\u989d:" + keyValueMap.get("deductibletax"));
        keyValueMap.put("price", price);
        logger.info("getItemsOffset: " + keyValueMap);
        return keyValueMap;
    }

    private static void setItemsOffset(IDataModel dataModel, BillExpenseInfoFildKeyType type, int parentIndex) {
        DynamicObject dataEntity = dataModel.getDataEntity();
        DynamicObjectCollection expenseEntry = type.getExpenseEntryEntities(dataModel, parentIndex);
        if (expenseEntry.isEmpty()) {
            logger.info("\u8d39\u7528\u660e\u7ec6\u5206\u5f55\u4e3a\u7a7a");
            return;
        }
        logger.info(String.format("\u8d39\u7528\u660e\u7ec6\u884c size: %d, parentIndex: %d", expenseEntry.size(), parentIndex));
        ArrayList<Map<String, Object>> valueList = new ArrayList<Map<String, Object>>(expenseEntry.size());
        boolean isOrgOffset = InvoiceOffsetUtils.deductibleOfTaxPayer(dataModel);
        Boolean autoInvoice = (Boolean)dataModel.getValue("automapinvoice");
        Map autoMapInvoiceMappingInfo = InvoiceUtils2.getInvoiceItemCollCache((Object)dataModel, (String)"invoiceitementry", (String)"itementryid", (String)"invoiceheadentryid", (String)"autoMapInvoiceMappingInfo");
        Map nonAutoMapInvoiceMappingInfo = InvoiceUtils2.getInvoiceItemCollCache((Object)dataModel, (String)"invoiceandexpense", (String)"expenseentryid", (String)"invoiceentryid", (String)"nonAutoMapInvoiceMappingInfo");
        Set<String> set = InvoiceTypeUtils.loadSpecialInvoiceTypes();
        for (int currentIndex = 0; currentIndex < expenseEntry.size(); ++currentIndex) {
            boolean isSpecialInvoice;
            HashMap keyValueMap = Maps.newHashMapWithExpectedSize((int)4);
            DynamicObject itemEntity = (DynamicObject)expenseEntry.get(currentIndex);
            String itemfrom = itemEntity.getString("itemfrom");
            if (ItemFrom.TripBusiness.getValue().equals(itemfrom)) {
                logger.info("\u5546\u65c5\u4e0d\u505a\u5173\u8054");
                return;
            }
            DynamicObject item = itemEntity.getDynamicObject(type.getItemKey());
            HashSet invoiceIds = Sets.newHashSet();
            if (autoInvoice.booleanValue()) {
                Set invoiceIdsOfInvoiceItemEntry = (Set)autoMapInvoiceMappingInfo.get(ErCommonUtils.getPk(itemEntity));
                if (invoiceIdsOfInvoiceItemEntry != null) {
                    invoiceIds.addAll(invoiceIdsOfInvoiceItemEntry);
                }
            } else {
                Set invoiceIdsOfExpenseAndInvoiceEntry = (Set)nonAutoMapInvoiceMappingInfo.get(ErCommonUtils.getPk(itemEntity));
                if (invoiceIdsOfExpenseAndInvoiceEntry != null) {
                    invoiceIds.addAll(invoiceIdsOfExpenseAndInvoiceEntry);
                }
            }
            logger.info("\u5f53\u524d\u9009\u4e2d\u884c\uff1a" + currentIndex + "\uff0c\u5173\u8054\u7684\u53d1\u7968id\uff1a" + invoiceIds);
            boolean itemInfoOffset = false;
            boolean itemOffset = false;
            if (invoiceIds.isEmpty()) {
                DynamicObject company;
                if (dataEntity.getDynamicObjectType().getProperty("company") != null && (company = dataEntity.getDynamicObject("company")) != null) {
                    itemOffset = SystemParamterUtil.manuallyaddexpenseoffset((Long)company.getPkValue());
                }
                if (itemOffset && item != null) {
                    itemInfoOffset = item.getBoolean(type.getItem().getIsOffsetKey());
                }
                isSpecialInvoice = false;
            } else {
                List<DynamicObject> invoiceList;
                if (item != null) {
                    itemOffset = item.getBoolean(type.getItem().getIsOffsetKey());
                }
                if ((invoiceList = dataModel.getEntryEntity("invoiceentry").stream().filter(invoiceItem -> invoiceIds.contains(invoiceItem.getPkValue())).collect(Collectors.toList())).isEmpty()) {
                    return;
                }
                List<DynamicObject> invoiceItemList = dataModel.getEntryEntity("invoiceitementry").stream().filter(invoiceItem -> invoiceIds.contains(invoiceItem.get("invoiceheadentryid"))).collect(Collectors.toList());
                isSpecialInvoice = invoiceList.stream().allMatch(invoiceItem -> set.contains(invoiceItem.getString("invoicetype")));
                boolean isInvoiceOffset = InvoiceOffsetUtils.isInvoiceOffset(invoiceItemList);
                boolean bl = itemInfoOffset = isInvoiceOffset && itemOffset;
                if (!isOrgOffset) {
                    keyValueMap.put("taxrate", BigDecimal.ZERO);
                    keyValueMap.put("taxamount", BigDecimal.ZERO);
                    keyValueMap.put(type.getNoTaxAmountKey(), itemEntity.getBigDecimal(type.getAmountKey()));
                } else {
                    InvoiceOffsetUtils.refresh(dataModel, itemEntity, invoiceList, currentIndex, parentIndex);
                }
            }
            itemInfoOffset = itemInfoOffset && isOrgOffset;
            keyValueMap.put("offset", itemInfoOffset);
            logger.info("\u8bbe\u7f6e\u660e\u7ec6\u7684\u5c5e\u6027\uff0coffset\uff1a" + itemInfoOffset + "\uff0cisSpecialInvoice" + isSpecialInvoice);
            if (!itemInfoOffset) {
                keyValueMap.put("deductibletax", BigDecimal.ZERO);
                keyValueMap.put("iteminoutamount", itemEntity.getBigDecimal("taxamount"));
            } else {
                keyValueMap.put("deductibletax", itemEntity.getBigDecimal("taxamount"));
                keyValueMap.put("iteminoutamount", BigDecimal.ZERO);
            }
            keyValueMap.put(type.getSpecialKey(), isSpecialInvoice);
            BigDecimal expeapproveAmount = itemEntity.getBigDecimal(type.getApproveAmountKey());
            BigDecimal price = AmountChangeUtil.getNoTaxAmount(expeapproveAmount, (BigDecimal)keyValueMap.get("deductibletax"), itemEntity.getBigDecimal("approvetax"));
            logger.info("\u6838\u5b9a\u91d1\u989d:" + expeapproveAmount + ",\u6838\u5b9a\u7a0e\u989d:" + itemEntity.getBigDecimal("approvetax") + ",\u62b5\u6263\u7a0e\u989d:" + keyValueMap.get("deductibletax"));
            keyValueMap.put("price", price);
            keyValueMap.put("currentIndex", currentIndex);
            logger.info("getItemsOffset: " + keyValueMap);
            valueList.add(keyValueMap);
        }
        long startTime = System.currentTimeMillis();
        InvoiceOffsetUtils.setListValue(dataModel, valueList, parentIndex, type);
        long endTime = System.currentTimeMillis();
        logger.info("\u3010\u53d1\u7968\u3011\u5173\u8054\u8d4b\u503c\u8017\u65f6" + (endTime - startTime));
    }

    public static void refreshInvoiceOffsetAndOutAmount(IFormView view, int index, int parentIndex) {
        String entityId = view.getModel().getDataEntity(true).getDynamicObjectType().getName();
        if (ErEntityTypeUtils.isDailyReimburseBill(entityId)) {
            InvoiceOffsetUtils.refreshInvoiceOffsetAndOutAmount(view, index, parentIndex, BillExpenseInfoFildKeyType.DailyReimburse);
        } else if (ErEntityTypeUtils.isPublicReimburseBill(entityId)) {
            InvoiceOffsetUtils.refreshInvoiceOffsetAndOutAmount(view, index, parentIndex, BillExpenseInfoFildKeyType.PublicReimburse);
        } else if (ErEntityTypeUtils.isTripReimburseBill(entityId)) {
            InvoiceOffsetUtils.refreshInvoiceOffsetAndOutAmount(view, index, parentIndex, BillExpenseInfoFildKeyType.TripReimburse);
        }
    }

    public static void refreshAllInvoiceOffsetAndOutAmount(IFormView view, int parentIndex) {
        String entityId = view.getModel().getDataEntity(true).getDynamicObjectType().getName();
        if (ErEntityTypeUtils.isDailyReimburseBill(entityId)) {
            InvoiceOffsetUtils.refreshAllInvoiceOffsetAndOutAmount(view, parentIndex, BillExpenseInfoFildKeyType.DailyReimburse);
        } else if (ErEntityTypeUtils.isPublicReimburseBill(entityId)) {
            InvoiceOffsetUtils.refreshAllInvoiceOffsetAndOutAmount(view, parentIndex, BillExpenseInfoFildKeyType.PublicReimburse);
        } else if (ErEntityTypeUtils.isTripReimburseBill(entityId)) {
            InvoiceOffsetUtils.refreshAllInvoiceOffsetAndOutAmount(view, parentIndex, BillExpenseInfoFildKeyType.TripReimburse);
        }
    }

    public static void refreshInvoiceOffsetAndOutAmount(IFormView view, int index, int parentIndex, BillExpenseInfoFildKeyType type) {
        boolean invoiceCloudDeductible = ErStdConfig.getInvoiceCloudDeductible();
        if (!invoiceCloudDeductible) {
            logger.info("\u4e0d\u8054\u52a8\u53d1\u7968\u4fe1\u606f\u5206\u5f55");
            return;
        }
        IDataModel model = view.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        DynamicObjectCollection expenseEntry = type.getExpenseEntryEntities(dataEntity, parentIndex);
        if (expenseEntry.isEmpty()) {
            logger.info("\u8d39\u7528\u660e\u7ec6\u5206\u5f55\u4e3a\u7a7a");
            return;
        }
        DynamicObject itemEntity = (DynamicObject)expenseEntry.get(index);
        Long pkValue = (Long)itemEntity.getPkValue();
        Set<Long> invoiceHeadIds = InvoiceUtils.mapInvoiceSetCache(model, pkValue);
        logger.info("\u660e\u7ec6" + pkValue + "\u5173\u8054\u53d1\u7968: " + invoiceHeadIds);
        if (invoiceHeadIds.size() < 1) {
            logger.info(pkValue + "\u53d1\u7968\u884c<1\u4e0d\u66f4\u65b0");
            return;
        }
        InvoiceOffsetUtils.refreshInvoiceOffsetAndOutAmount(view, invoiceHeadIds, type);
    }

    public static void refreshInvoiceOffsetAndOutAmount(IFormView view, Set<Long> invoiceHeadIds, BillExpenseInfoFildKeyType type) {
        IDataModel model = view.getModel();
        DynamicObject costcompany = null;
        if (model.getProperty("costcompany") != null) {
            costcompany = model.getDataEntity().getDynamicObject("costcompany");
        }
        DynamicObject company = null;
        if (model.getProperty("company") != null) {
            company = model.getDataEntity().getDynamicObject("company");
        }
        boolean isOrgOffset = InvoiceOffsetUtils.deductibleOfTaxPayer(ErCommonUtils.getPk(company), ErCommonUtils.getPk(costcompany));
        Boolean autoInvoice = (Boolean)model.getValue("automapinvoice");
        DynamicObjectCollection invoiceEntry = model.getEntryEntity("invoiceentry");
        ItemInvoiceRelationEnum relationEnum = OffsetUtils.getItemInvoiceRelation(view, model, invoiceHeadIds);
        for (int i = 0; i < invoiceEntry.size(); ++i) {
            boolean invoiceOffset;
            Map autoMapItem;
            Set itemIds;
            Map<String, Object> itemsOffsetInfoMap;
            Long invoiceObjID = (Long)((DynamicObject)invoiceEntry.get(i)).getPkValue();
            if (!invoiceHeadIds.contains(invoiceObjID) || MapUtils.isEmpty(itemsOffsetInfoMap = OffsetUtils.getExpenseItemsOffsetInfoMap(model, itemIds = (Set)(autoMapItem = autoInvoice != false ? InvoiceUtils2.autoMapItemMappingInfoCache((IFormView)view, (IDataModel)model, (String)"autoMapItemMappingInfo") : InvoiceUtils2.nonAutoMapItemMappingInfoCache((IFormView)view, (IDataModel)model, (String)"nonAutoMapItemMappingInfo")).get(invoiceObjID), type))) continue;
            boolean curInvoiceOffset = InvoiceOffsetUtils.isInvoiceOffset(model, invoiceObjID);
            boolean itemOffset = (Boolean)itemsOffsetInfoMap.get("offset");
            boolean bl = invoiceOffset = itemOffset && curInvoiceOffset && isOrgOffset;
            if (invoiceOffset) {
                if (ItemInvoiceRelationEnum.IsOneForOne == relationEnum || ItemInvoiceRelationEnum.IsNForOne == relationEnum) {
                    model.setValue("offset_invoice", (Object)true, i);
                    model.setValue("offsetamount", itemsOffsetInfoMap.get("deductibletax"), i);
                    model.setValue("inoutamount", itemsOffsetInfoMap.get("iteminoutamount"), i);
                } else if (ItemInvoiceRelationEnum.IsOneForN == relationEnum) {
                    model.setValue("offset_invoice", (Object)true, i);
                    model.setValue("offsetamount", (Object)OffsetUtils.invoiceOffsetAmount(model, invoiceObjID), i);
                    model.setValue("inoutamount", (Object)BigDecimal.ZERO, i);
                }
            } else if (isOrgOffset) {
                if (curInvoiceOffset || KingdeeInvoiceCloudConfig.isNonOffsetImportTaxAmout(ErCommonUtils.getPk(costcompany))) {
                    if (ItemInvoiceRelationEnum.IsOneForOne == relationEnum || ItemInvoiceRelationEnum.IsNForOne == relationEnum) {
                        model.setValue("offset_invoice", (Object)false, i);
                        model.setValue("offsetamount", (Object)BigDecimal.ZERO, i);
                        model.setValue("inoutamount", itemsOffsetInfoMap.get("iteminoutamount"), i);
                    } else if (ItemInvoiceRelationEnum.IsOneForN == relationEnum) {
                        model.setValue("offset_invoice", (Object)false, i);
                        model.setValue("offsetamount", (Object)BigDecimal.ZERO, i);
                        model.setValue("inoutamount", (Object)OffsetUtils.invoiceTaxAmount(model, invoiceObjID), i);
                    }
                } else {
                    model.setValue("offset_invoice", (Object)false, i);
                    model.setValue("offsetamount", (Object)BigDecimal.ZERO, i);
                    model.setValue("inoutamount", (Object)BigDecimal.ZERO, i);
                }
            } else {
                model.setValue("offset_invoice", (Object)false, i);
                model.setValue("offsetamount", (Object)BigDecimal.ZERO, i);
                model.setValue("inoutamount", (Object)BigDecimal.ZERO, i);
            }
            if (ItemInvoiceRelationEnum.IsOneForOne == relationEnum) {
                model.setValue("islinkagedetail", (Object)true, i);
            }
            InvoiceOffsetUtils.updateInvoiceOffset(view, i);
        }
    }

    public static void refreshAllInvoiceOffsetAndOutAmount(IFormView view, int parentIndex, BillExpenseInfoFildKeyType type) {
        IDataModel model = view.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        DynamicObjectCollection expenseEntry = type.getExpenseEntryEntities(dataEntity, parentIndex);
        if (expenseEntry.isEmpty()) {
            logger.info("\u8d39\u7528\u660e\u7ec6\u5206\u5f55\u4e3a\u7a7a");
            return;
        }
        DynamicObject costcompany = null;
        if (dataEntity.getDynamicObjectType().getProperty("costcompany") != null) {
            costcompany = (DynamicObject)model.getValue("costcompany");
        }
        DynamicObject company = null;
        if (dataEntity.getDynamicObjectType().getProperty("company") != null) {
            company = (DynamicObject)model.getValue("company");
        }
        boolean isOrgOffset = InvoiceOffsetUtils.deductibleOfTaxPayer(ErCommonUtils.getPk(company), ErCommonUtils.getPk(costcompany));
        boolean importTaxAmount = KingdeeInvoiceCloudConfig.isNonOffsetImportTaxAmout(ErCommonUtils.getPk(costcompany));
        Boolean autoInvoice = (Boolean)model.getValue("automapinvoice");
        Map relationMapping = autoInvoice != false ? InvoiceUtils2.autoMapItemMappingInfoCache((IFormView)view, (IDataModel)model, (String)"autoMapItemMappingInfo") : InvoiceUtils2.nonAutoMapItemMappingInfoCache((IFormView)view, (IDataModel)model, (String)"nonAutoMapItemMappingInfo");
        DynamicObjectCollection invoiceEntry = model.getEntryEntity("invoiceentry");
        boolean isexportLog = ErStdConfig.isExportLog();
        boolean invoiceCloudDeductible = ErStdConfig.getInvoiceCloudDeductible();
        model.beginInit();
        for (int index = 0; index < expenseEntry.size(); ++index) {
            DynamicObject itemEntity = (DynamicObject)expenseEntry.get(index);
            AmountChangeUtil.updateInOutAmount(model, index, parentIndex, ChangeField.All);
            if (!invoiceCloudDeductible) {
                logger.info("\u4e0d\u8054\u52a8\u53d1\u7968\u4fe1\u606f\u5206\u5f55");
                continue;
            }
            Long pkValue = (Long)itemEntity.getPkValue();
            Set<Long> invoiceHeadIds = InvoiceUtils.mapInvoiceSetCache(model, pkValue);
            logger.info("\u660e\u7ec6" + pkValue + "\u5173\u8054\u53d1\u7968: " + invoiceHeadIds);
            if (invoiceHeadIds.size() < 1) {
                logger.info(pkValue + "\u53d1\u7968\u884c<1\u4e0d\u66f4\u65b0");
                continue;
            }
            boolean isOne2One = OffsetUtils.itemIsOne2One(view, model, invoiceHeadIds);
            boolean isN2One = false;
            boolean isOne2N = false;
            if (!isOne2One && !(isOne2N = OffsetUtils.itemIsOne2N(view, model, invoiceHeadIds))) {
                isN2One = OffsetUtils.itemIsN2One(view, model, invoiceHeadIds);
            }
            if (!isOne2One && !isN2One && !isOne2N) continue;
            Boolean offset = itemEntity.getBoolean("offset");
            for (int i = 0; i < invoiceEntry.size(); ++i) {
                boolean invoiceOffset;
                Map<String, Object> itemsOffsetInfoMap;
                Set itemIds;
                Long invoiceObjID = (Long)((DynamicObject)invoiceEntry.get(i)).getPkValue();
                if (!invoiceHeadIds.contains(invoiceObjID) || CollectionUtils.isEmpty((Collection)(itemIds = (Set)relationMapping.get(invoiceObjID))) || MapUtils.isEmpty(itemsOffsetInfoMap = OffsetUtils.getExpenseItemsOffsetInfoMap(model, itemIds, type))) continue;
                boolean curInvoiceOffset = InvoiceOffsetUtils.isInvoiceOffset(model, invoiceObjID);
                offset = (Boolean)itemsOffsetInfoMap.get("offset");
                boolean bl = invoiceOffset = offset != false && curInvoiceOffset && isOrgOffset;
                if (invoiceOffset) {
                    if (isOne2One || isN2One) {
                        model.setValue("offset_invoice", (Object)true, i);
                        model.setValue("offsetamount", itemsOffsetInfoMap.get("deductibletax"), i);
                        model.setValue("inoutamount", itemsOffsetInfoMap.get("iteminoutamount"), i);
                    } else if (isOne2N) {
                        model.setValue("offset_invoice", (Object)true, i);
                        model.setValue("offsetamount", (Object)OffsetUtils.invoiceOffsetAmount(model, invoiceObjID), i);
                        model.setValue("inoutamount", (Object)BigDecimal.ZERO, i);
                    }
                } else if (isOrgOffset) {
                    if (curInvoiceOffset || KingdeeInvoiceCloudConfig.isNonOffsetImportTaxAmout(ErCommonUtils.getPk(costcompany))) {
                        if (isOne2One || isN2One) {
                            model.setValue("offset_invoice", (Object)false, i);
                            model.setValue("offsetamount", itemsOffsetInfoMap.get("deductibletax"), i);
                            model.setValue("inoutamount", itemsOffsetInfoMap.get("iteminoutamount"), i);
                        } else if (isOne2N && !offset.booleanValue()) {
                            model.setValue("offset_invoice", (Object)false, i);
                            model.setValue("offsetamount", (Object)BigDecimal.ZERO, i);
                            model.setValue("inoutamount", (Object)OffsetUtils.invoiceTaxAmount(model, invoiceObjID), i);
                        }
                    } else {
                        model.setValue("offset_invoice", (Object)false, i);
                        model.setValue("offsetamount", (Object)BigDecimal.ZERO, i);
                        model.setValue("inoutamount", (Object)BigDecimal.ZERO, i);
                    }
                } else {
                    model.setValue("offset_invoice", (Object)false, i);
                    model.setValue("offsetamount", (Object)BigDecimal.ZERO, i);
                    model.setValue("inoutamount", (Object)BigDecimal.ZERO, i);
                }
                if (isOne2One) {
                    model.setValue("islinkagedetail", (Object)true, i);
                }
                if (isexportLog) {
                    logger.info("\u53d1\u7968\u4fe1\u606f\uff0coffset: " + invoiceOffset + ", offsetAmount\uff1a" + model.getValue("offsetamount", i));
                }
                InvoiceOffsetUtils.updateInvoiceOffset(view, i);
            }
        }
        boolean isNonOffsetImportTaxAmout = KingdeeInvoiceCloudConfig.isNonOffsetImportTaxAmout(ErCommonUtils.getPk(costcompany));
        if (!autoInvoice.booleanValue()) {
            for (int i = 0; i < invoiceEntry.size(); ++i) {
                DynamicObject invoiceInfo = (DynamicObject)invoiceEntry.get(i);
                Long invoiceHeadId = (Long)invoiceInfo.getPkValue();
                if (relationMapping.containsKey(invoiceHeadId)) continue;
                boolean invoiceOffset = InvoiceOffsetUtils.isInvoiceOffset(model, invoiceHeadId);
                BigDecimal invoiceTaxAmount = OffsetUtils.invoiceTaxAmount(model, invoiceHeadId);
                BigDecimal offsetAmount = OffsetUtils.invoiceOffsetAmount(model, invoiceHeadId);
                if (isOrgOffset) {
                    model.setValue("offset_invoice", (Object)invoiceOffset, i);
                    model.setValue("offsetamount", (Object)offsetAmount, i);
                    if (!isNonOffsetImportTaxAmout && !invoiceOffset) {
                        model.setValue("inoutamount", (Object)BigDecimal.ZERO, i);
                    } else {
                        model.setValue("inoutamount", (Object)invoiceTaxAmount.subtract(offsetAmount), i);
                    }
                } else {
                    model.setValue("offset_invoice", (Object)false, i);
                    model.setValue("offsetamount", (Object)BigDecimal.ZERO, i);
                    if (importTaxAmount) {
                        model.setValue("inoutamount", (Object)invoiceTaxAmount, i);
                    } else {
                        model.setValue("inoutamount", (Object)BigDecimal.ZERO, i);
                    }
                }
                InvoiceOffsetUtils.updateInvoiceOffset(view, i);
            }
        }
        model.endInit();
    }

    public static boolean isInvoiceOffset(DynamicObject bill, Long invoiceHeadId) {
        Stream<DynamicObject> objectStream = bill.getDynamicObjectCollection("invoiceitementry").stream().filter(v -> Objects.equals(invoiceHeadId, v.getLong("invoiceheadentryid")));
        return InvoiceOffsetUtils.isInvoiceOffset(objectStream);
    }

    public static boolean isInvoiceOffset(IDataModel model, Long invoiceHeadId) {
        Stream<DynamicObject> objectStream = model.getEntryEntity("invoiceitementry").stream().filter(v -> Objects.equals(invoiceHeadId, v.getLong("invoiceheadentryid")));
        return InvoiceOffsetUtils.isInvoiceOffset(objectStream);
    }

    public static boolean isInvoiceOffset(IDataModel model, Set<Long> invoiceHeadIds) {
        Stream<DynamicObject> objectStream = model.getEntryEntity("invoiceitementry").stream().filter(v -> invoiceHeadIds.contains(v.getLong("invoiceheadentryid")));
        return InvoiceOffsetUtils.isInvoiceOffset(objectStream);
    }

    public static void updateInvoiceOffset(IFormView view, int rowIndex) {
        view.updateView("offset_invoice", rowIndex);
        view.updateView("inoutamount", rowIndex);
        view.updateView("offsetamount", rowIndex);
        view.updateView("islinkagedetail", rowIndex);
    }

    @Deprecated
    public static void setHeadSumOffsetAmount(IDataModel model) {
        if (model.getProperty("invoiceoffsetamount") != null) {
            BigDecimal invoiceOffsetAmount = model.getDataEntity(true).getDynamicObjectCollection("invoiceentry").stream().map(v -> v.getBigDecimal("offsetamount")).reduce((a1, a2) -> a1.add((BigDecimal)a2)).orElse(BigDecimal.ZERO);
            model.setValue("invoiceOffsetAmount", (Object)invoiceOffsetAmount);
        }
    }

    public static void updateItemOffset(IFormView view) {
        DynamicObject dataEntity = view.getModel().getDataEntity(true);
        String entityId = dataEntity.getDynamicObjectType().getName();
        if (ErEntityTypeUtils.isDailyReimburseBill(entityId)) {
            DynamicObjectCollection coll = BillExpenseInfoFildKeyType.DailyReimburse.getExpenseEntryEntities(dataEntity, 0);
            InvoiceOffsetUtils.updateItemOffset(view, coll.size());
        } else if (ErEntityTypeUtils.isPublicReimburseBill(entityId)) {
            DynamicObjectCollection coll = BillExpenseInfoFildKeyType.PublicReimburse.getExpenseEntryEntities(dataEntity, 0);
            InvoiceOffsetUtils.updateItemOffset(view, coll.size());
        } else if (ErEntityTypeUtils.isTripReimburseBill(entityId)) {
            int index = view.getModel().getEntryCurrentRowIndex("tripentry");
            DynamicObjectCollection coll = BillExpenseInfoFildKeyType.TripReimburse.getExpenseEntryEntities(dataEntity, index);
            InvoiceOffsetUtils.updateItemOffset(view, coll.size());
        }
    }

    public static void updateItemOffset(IFormView view, int size) {
        for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
            view.updateView("offset", rowIndex);
            view.updateView("deductibletax", rowIndex);
            view.updateView("iteminoutamount", rowIndex);
        }
    }

    public static boolean getExpenseRowMapInvoicesOffset(DynamicObject bill, Long entryId, IFormView view) {
        DynamicObjectCollection invoiceItemEntry = bill.getDynamicObjectCollection("invoiceitementry");
        if (bill.getBoolean("automapinvoice")) {
            String entryKey = ErEntityTypeUtils.isTripReimburseBill(view.getEntityId()) ? "entryentity" : "expenseentryentity";
            DynamicObjectCollection expenseEntry = view.getModel().getEntryEntity(entryKey);
            List parentPkValues = expenseEntry.stream().filter(item -> item.getBoolean("invoicefromparent") && entryId.equals(item.getPkValue())).map(item -> Long.valueOf(item.getString("splitline"))).collect(Collectors.toList());
            Long pkValue = CollectionUtils.isEmpty(parentPkValues) ? entryId : (Long)parentPkValues.get(0);
            Stream<DynamicObject> objectStream = invoiceItemEntry.stream().filter(v -> Objects.equals(pkValue, v.getLong("itementryid")));
            return InvoiceOffsetUtils.isInvoiceOffset(objectStream);
        }
        Set<Long> invoiceIds = InvoiceUtils.nonAutoMapInvoiceMappingInfo(bill).get(entryId);
        logger.info("getExpenseRowMapInvoicesOffset invoiceIds:" + invoiceIds + "  invoiceItemEntry:" + invoiceItemEntry.size());
        if (invoiceItemEntry.isEmpty()) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u53d1\u7968\u6765\u6e90\u4e3a\u53d1\u7968\u4e91\uff0c\u4f46\u6ca1\u6709\u5173\u8054\u53d1\u7968\u7684\u660e\u7ec6\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"InvoiceOffsetUtils_0", (String)"fi-er-business", (Object[])new Object[0]));
        }
        if (invoiceIds == null) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u8d39\u7528\u660e\u7ec6\u5173\u8054\u7684\u53d1\u7968\u660e\u7ec6\u3002", (String)"InvoiceOffsetUtils_1", (String)"fi-er-business", (Object[])new Object[0]));
            return false;
        }
        Stream<DynamicObject> objectStream = invoiceItemEntry.stream().filter(v -> invoiceIds.contains(v.getLong("invoiceheadentryid")));
        return InvoiceOffsetUtils.isInvoiceOffset(objectStream);
    }

    public static boolean getExpenseRowMapInvoicesOffset(IDataModel model, Long entryId, IFormView view) {
        DynamicObjectCollection invoiceItemEntry = model.getEntryEntity("invoiceitementry");
        if (invoiceItemEntry.isEmpty()) {
            return false;
        }
        if (model.getProperty("automapinvoice") != null && ((Boolean)model.getValue("automapinvoice")).booleanValue()) {
            String entryKey = ErEntityTypeUtils.isTripReimburseBill(view.getEntityId()) ? "entryentity" : "expenseentryentity";
            DynamicObjectCollection expenseEntry = view.getModel().getEntryEntity(entryKey);
            List parentPkValues = expenseEntry.stream().filter(item -> item.getBoolean("invoicefromparent") && entryId.equals(item.getPkValue())).map(item -> Long.valueOf(item.getString("splitline"))).collect(Collectors.toList());
            Long pkValue = CollectionUtils.isEmpty(parentPkValues) ? entryId : (Long)parentPkValues.get(0);
            Stream<DynamicObject> objectStream = invoiceItemEntry.stream().filter(v -> Objects.equals(pkValue, v.getLong("itementryid")));
            return InvoiceOffsetUtils.isInvoiceOffset(objectStream);
        }
        Set invoiceIds = (Set)InvoiceUtils2.nonAutoMapInvoiceMappingInfoCache((IDataModel)model, (String)"nonAutoMapInvoiceMappingInfo").get(entryId);
        logger.info("getExpenseRowMapInvoicesOffset invoiceIds:" + invoiceIds + "  invoiceItemEntry:" + invoiceItemEntry.size());
        if (invoiceItemEntry.isEmpty()) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u53d1\u7968\u6765\u6e90\u4e3a\u53d1\u7968\u4e91\uff0c\u4f46\u6ca1\u6709\u5173\u8054\u53d1\u7968\u7684\u660e\u7ec6\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"InvoiceOffsetUtils_0", (String)"fi-er-business", (Object[])new Object[0]));
        }
        if (invoiceIds == null) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u8d39\u7528\u660e\u7ec6\u5173\u8054\u7684\u53d1\u7968\u660e\u7ec6\u3002", (String)"InvoiceOffsetUtils_1", (String)"fi-er-business", (Object[])new Object[0]));
            return false;
        }
        Stream<DynamicObject> objectStream = invoiceItemEntry.stream().filter(v -> invoiceIds.contains(v.getLong("invoiceheadentryid")));
        return InvoiceOffsetUtils.isInvoiceOffset(objectStream);
    }

    public static boolean isInvoiceOffset(Collection<DynamicObject> invoiceItemCollection) {
        if (invoiceItemCollection == null) {
            return false;
        }
        return InvoiceOffsetUtils.isInvoiceOffset(invoiceItemCollection.stream());
    }

    public static boolean isInvoiceOffset(Stream<DynamicObject> invoiceItemStream) {
        if (invoiceItemStream == null) {
            return false;
        }
        boolean invoicesCredits = ErStdConfig.getInvoicesCredits();
        if (invoicesCredits) {
            return invoiceItemStream.anyMatch(item -> item.getBoolean("invoiceitemoffset"));
        }
        return invoiceItemStream.anyMatch(item -> item.getBoolean("invoicecloudoffset"));
    }

    public static boolean isInvoiceItemOffset(DynamicObject invoiceItem) {
        if (invoiceItem == null) {
            return false;
        }
        boolean invoicesCredits = ErStdConfig.getInvoicesCredits();
        if (invoicesCredits) {
            return invoiceItem.getBoolean("invoiceitemoffset");
        }
        return invoiceItem.getBoolean("invoicecloudoffset");
    }

    public static boolean isInvoiceItemAllOffset(Collection<DynamicObject> invoiceItemCollection) {
        if (invoiceItemCollection == null) {
            return false;
        }
        boolean invoicesCredits = ErStdConfig.getInvoicesCredits();
        if (invoicesCredits) {
            return invoiceItemCollection.stream().allMatch(item -> item.getBoolean("invoiceitemoffset"));
        }
        return invoiceItemCollection.stream().allMatch(item -> item.getBoolean("invoicecloudoffset"));
    }

    public static boolean isInvoiceItemAllOffset(Collection<DynamicObject> invoiceItemCollection, Collection<Long> invoiceEntryIds) {
        if (invoiceItemCollection == null || invoiceEntryIds == null) {
            return false;
        }
        boolean invoicesCredits = ErStdConfig.getInvoicesCredits();
        if (invoicesCredits) {
            return invoiceItemCollection.stream().filter(item -> invoiceEntryIds.contains(item.get("invoiceheadentryid"))).allMatch(item -> item.getBoolean("invoiceitemoffset"));
        }
        return invoiceItemCollection.stream().filter(item -> invoiceEntryIds.contains(item.get("invoiceheadentryid"))).allMatch(item -> item.getBoolean("invoicecloudoffset"));
    }

    public static boolean isInvoiceAllOffset(Collection<DynamicObject> invoiceItemCollection, Collection<Long> invoiceEntryIds) {
        if (invoiceItemCollection == null || invoiceEntryIds == null) {
            return false;
        }
        boolean invoicesCredits = ErStdConfig.getInvoicesCredits();
        if (invoicesCredits) {
            return invoiceItemCollection.stream().filter(item -> invoiceEntryIds.contains(item.get("invoiceheadentryid"))).allMatch(item -> item.getBoolean("invoiceitemoffset"));
        }
        return invoiceItemCollection.stream().filter(item -> invoiceEntryIds.contains(item.get("invoiceheadentryid"))).allMatch(item -> item.getBoolean("invoicecloudoffset"));
    }

    public static boolean getInvoiceOffset(Stream<DynamicObject> invoiceItemStream) {
        if (invoiceItemStream == null) {
            return false;
        }
        boolean invoicesCredits = ErStdConfig.getInvoicesCredits();
        if (invoicesCredits) {
            return invoiceItemStream.anyMatch(item -> item.getBoolean("invoiceitemoffset"));
        }
        return invoiceItemStream.anyMatch(item -> item.getBoolean("invoicecloudoffset"));
    }

    public static boolean getInvoiceItemOffset(DynamicObject invoiceItem) {
        if (invoiceItem == null) {
            return false;
        }
        boolean invoicesCredits = ErStdConfig.getInvoicesCredits();
        if (invoicesCredits) {
            return invoiceItem.getBoolean("invoiceitemoffset");
        }
        return invoiceItem.getBoolean("invoicecloudoffset");
    }

    public static Stream<DynamicObject> getOffsetInvoiceItem(Collection<DynamicObject> invoiceItemCollection) {
        if (invoiceItemCollection == null) {
            return Stream.empty();
        }
        boolean invoicesCredits = ErStdConfig.getInvoicesCredits();
        if (invoicesCredits) {
            return invoiceItemCollection.stream().filter(v -> v.getBoolean("invoiceitemoffset"));
        }
        return invoiceItemCollection.stream().filter(v -> v.getBoolean("invoicecloudoffset"));
    }

    public static Stream<DynamicObject> getOffsetInvoiceItem(Collection<DynamicObject> invoiceItemCollection, Long invoiceHeadId) {
        if (invoiceItemCollection == null) {
            return Stream.empty();
        }
        boolean invoicesCredits = ErStdConfig.getInvoicesCredits();
        if (invoicesCredits) {
            return invoiceItemCollection.stream().filter(v -> Objects.equals(invoiceHeadId, v.get("invoiceheadentryid")) && v.getBoolean("invoiceitemoffset"));
        }
        return invoiceItemCollection.stream().filter(v -> Objects.equals(invoiceHeadId, v.get("invoiceheadentryid")) && v.getBoolean("invoicecloudoffset"));
    }

    public static Stream<DynamicObject> getOffsetInvoiceItem(Collection<DynamicObject> invoiceItemCollection, Collection<Long> invoiceHeadIds) {
        if (invoiceItemCollection == null) {
            return Stream.empty();
        }
        boolean invoicesCredits = ErStdConfig.getInvoicesCredits();
        if (invoicesCredits) {
            return invoiceItemCollection.stream().filter(v -> invoiceHeadIds.contains(v.get("invoiceheadentryid")) && v.getBoolean("invoiceitemoffset"));
        }
        return invoiceItemCollection.stream().filter(v -> invoiceHeadIds.contains(v.get("invoiceheadentryid")) && v.getBoolean("invoicecloudoffset"));
    }

    public static Stream<DynamicObject> getNotOffsetInvoiceItem(Collection<DynamicObject> invoiceItemCollection) {
        if (invoiceItemCollection == null) {
            return Stream.empty();
        }
        boolean invoicesCredits = ErStdConfig.getInvoicesCredits();
        if (invoicesCredits) {
            return invoiceItemCollection.stream().filter(v -> !v.getBoolean("invoiceitemoffset"));
        }
        return invoiceItemCollection.stream().filter(v -> !v.getBoolean("invoicecloudoffset"));
    }

    public static Stream<DynamicObject> getOffsetInvoiceItem(Stream<DynamicObject> invoiceItemStream) {
        if (invoiceItemStream == null) {
            return Stream.empty();
        }
        boolean invoicesCredits = ErStdConfig.getInvoicesCredits();
        if (invoicesCredits) {
            return invoiceItemStream.filter(v -> v.getBoolean("invoiceitemoffset"));
        }
        return invoiceItemStream.filter(v -> v.getBoolean("invoicecloudoffset"));
    }

    public static Stream<DynamicObject> getNotOffsetInvoiceItem(Stream<DynamicObject> invoiceItemStream) {
        if (invoiceItemStream == null) {
            return Stream.empty();
        }
        boolean invoicesCredits = ErStdConfig.getInvoicesCredits();
        if (invoicesCredits) {
            return invoiceItemStream.filter(v -> !v.getBoolean("invoiceitemoffset"));
        }
        return invoiceItemStream.filter(v -> !v.getBoolean("invoicecloudoffset"));
    }

    public static void refreshAllInvoiceOffsetAndOutAmount(IFormView view, List<Long> invoiceEntryIds, BillExpenseInfoFildKeyType type) {
        IDataModel model = view.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        DynamicObjectCollection expenses = type.getExpenseEntryEntities(dataEntity, 0);
        Map tripMap = new HashMap<Integer, DynamicObjectCollection>(16);
        tripMap.put(-1, expenses);
        if (BillExpenseInfoFildKeyType.TripReimburse == type) {
            tripMap = (Map)BillOfInvoice.TripReimburseBill.getExpenseEntryEntities(dataEntity);
        }
        if (tripMap.isEmpty() || tripMap.values().stream().allMatch(m -> CollectionUtils.isEmpty((Collection)m))) {
            logger.info("\u8d39\u7528\u660e\u7ec6\u5206\u5f55\u4e3a\u7a7a");
            return;
        }
        DynamicObject costcompany = null;
        if (dataEntity.getDynamicObjectType().getProperty("costcompany") != null) {
            costcompany = (DynamicObject)model.getValue("costcompany");
        }
        DynamicObject company = null;
        if (dataEntity.getDynamicObjectType().getProperty("company") != null) {
            company = (DynamicObject)model.getValue("company");
        }
        boolean isOrgOffset = InvoiceOffsetUtils.deductibleOfTaxPayer(ErCommonUtils.getPk(company), ErCommonUtils.getPk(costcompany));
        boolean importTaxAmount = KingdeeInvoiceCloudConfig.isNonOffsetImportTaxAmout(ErCommonUtils.getPk(costcompany));
        Boolean autoInvoice = (Boolean)model.getValue("automapinvoice");
        Map relationMapping = autoInvoice != false ? InvoiceUtils2.autoMapItemMappingInfoCache((IFormView)view, (IDataModel)model, (String)"autoMapItemMappingInfo") : InvoiceUtils2.nonAutoMapItemMappingInfoCache((IFormView)view, (IDataModel)model, (String)"nonAutoMapItemMappingInfo");
        DynamicObjectCollection invoiceEntry = model.getEntryEntity("invoiceentry");
        boolean invoiceCloudDeductible = ErStdConfig.getInvoiceCloudDeductible();
        model.beginInit();
        for (Map.Entry entry : tripMap.entrySet()) {
            int parentIndex = (Integer)entry.getKey();
            DynamicObjectCollection expenseEntry = (DynamicObjectCollection)entry.getValue();
            for (int index = 0; index < expenseEntry.size(); ++index) {
                AmountChangeUtil.updateInOutAmount(model, index, parentIndex, ChangeField.All);
            }
        }
        if (invoiceCloudDeductible) {
            InvoiceOffsetUtils.refreshInvoiceOffsetAndOutAmount(view, new HashSet<Long>(invoiceEntryIds), type);
        }
        if (!autoInvoice.booleanValue()) {
            for (int i = 0; i < invoiceEntry.size(); ++i) {
                DynamicObject invoiceInfo = (DynamicObject)invoiceEntry.get(i);
                Long invoiceHeadId = (Long)invoiceInfo.getPkValue();
                if (relationMapping.containsKey(invoiceHeadId)) continue;
                boolean invoiceOffset = InvoiceOffsetUtils.isInvoiceOffset(model, invoiceHeadId);
                BigDecimal invoiceTaxAmount = OffsetUtils.invoiceTaxAmount(model, invoiceHeadId);
                BigDecimal offsetAmount = OffsetUtils.invoiceOffsetAmount(model, invoiceHeadId);
                if (isOrgOffset) {
                    model.setValue("offset_invoice", (Object)invoiceOffset, i);
                    model.setValue("offsetamount", (Object)offsetAmount, i);
                    if (!importTaxAmount && !invoiceOffset) {
                        model.setValue("inoutamount", (Object)BigDecimal.ZERO, i);
                    } else {
                        model.setValue("inoutamount", (Object)invoiceTaxAmount.subtract(offsetAmount), i);
                    }
                } else {
                    model.setValue("offset_invoice", (Object)false, i);
                    model.setValue("offsetamount", (Object)BigDecimal.ZERO, i);
                    if (importTaxAmount) {
                        model.setValue("inoutamount", (Object)invoiceTaxAmount, i);
                    } else {
                        model.setValue("inoutamount", (Object)BigDecimal.ZERO, i);
                    }
                }
                InvoiceOffsetUtils.updateInvoiceOffset(view, i);
            }
        }
        model.endInit();
    }
}

