/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.utils;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.common.sysparam.RelatApplyBillFilterRangeEnum;

public class RelatApplyBillFilterUtil {
    public static QFilter getCondition(Long applierId, Long orgId, Long companyId) {
        return RelatApplyBillFilterUtil.getCondition(applierId, orgId, companyId, "expenseentryentity.orgiexpebalanceamount");
    }

    public static QFilter getCondition(Long applierId, Long orgId, Long companyId, String balanceFieldName) {
        QFilter qFilter = new QFilter("billstatus", "=", (Object)"E");
        qFilter.and(balanceFieldName, ">", (Object)BigDecimal.ZERO);
        if (companyId == null) {
            return qFilter;
        }
        String filterType = ErCommonUtils.getEMParameter(companyId, "relatapplybillfilterrange").toString();
        RelatApplyBillFilterRangeEnum rangeEnum = RelatApplyBillFilterRangeEnum.getSelectRangeByType((String)filterType);
        if (rangeEnum == RelatApplyBillFilterRangeEnum.APPLIER) {
            qFilter.and(new QFilter("applier", "=", (Object)applierId).or("projectower.FBASEDATAID_id", "in", Collections.singletonList(applierId)));
            qFilter.and(new QFilter("company", "=", (Object)companyId));
        } else if (rangeEnum == RelatApplyBillFilterRangeEnum.DEPT) {
            qFilter.and(new QFilter("org", "=", (Object)orgId));
        } else if (rangeEnum == RelatApplyBillFilterRangeEnum.COMPANY) {
            qFilter.and(new QFilter("company", "=", (Object)companyId));
        } else if (rangeEnum == RelatApplyBillFilterRangeEnum.APPLICANT) {
            qFilter.and(new QFilter("applier", "=", (Object)applierId).or("projectower.FBASEDATAID_id", "in", Collections.singletonList(applierId)));
        }
        return qFilter;
    }

    public static List checkApplyBillAfterCompanyChanged(Long applierId, Long orgId, Long companyId, List<Long> existIds) {
        QFilter qFilter = RelatApplyBillFilterUtil.getCondition(applierId, orgId, companyId);
        qFilter.and("id", "in", existIds);
        Map map = BusinessDataServiceHelper.loadFromCache((String)"er_dailyapplybill", (String)"id", (QFilter[])new QFilter[]{qFilter});
        return map.values().stream().map(e -> e.getPkValue()).collect(Collectors.toList());
    }
}

