/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class RepaymentAssociateUtil {
    public static final String RECBILLSELECTFIELDS = "billno,bizdate,receivingtype,payeebank,accountbank,currency,exchangerate,actrecamt,localamt,approveamount";

    public static void buildBOTPRelation(DynamicObjectCollection recentryCollectoin) {
        DynamicObject[] recBills = BusinessDataServiceHelper.load((Object[])recentryCollectoin.stream().map(v -> v.get("recbillid")).collect(Collectors.toList()).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_recbill"));
        ArrayList changeBills = Lists.newArrayList();
        Map<Object, Object> entryIdMap = recentryCollectoin.stream().collect(Collectors.toMap(v -> v.get("recbillid"), DataEntityBase::getPkValue));
        if (recBills.length > 0) {
            Long stableid = EntityMetadataCache.loadTableDefine((String)"er_repaymentbill", (String)"recentry").getTableId();
            for (DynamicObject recBill : recBills) {
                DynamicObjectCollection relations = recBill.getDynamicObjectCollection("billhead_lk");
                List existRelation = relations.stream().map(v -> v.get("billhead_lk_sid")).collect(Collectors.toList());
                if (existRelation.contains(entryIdMap.get(recBill.getPkValue()))) continue;
                DynamicObject relation = (DynamicObject)relations.getDynamicObjectType().createInstance();
                relation.set("billhead_lk_sbillid", ((DynamicObject)recentryCollectoin.getParent()).getPkValue());
                relation.set("billhead_lk_stableid", (Object)stableid);
                relation.set("billhead_lk_sid", entryIdMap.get(recBill.getPkValue()));
                relations.add((Object)relation);
                changeBills.add(recBill);
            }
            if (changeBills.size() > 0) {
                OperationServiceHelper.executeOperate((String)"save", (String)"cas_recbill", (DynamicObject[])changeBills.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            }
        }
    }

    public static void removeBOTPRelation(Long repayBillPk, Long[] recBillPks) {
        DynamicObject[] recBills = BusinessDataServiceHelper.load((Object[])recBillPks, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_recbill"));
        if (recBills.length > 0) {
            Long stableid = EntityMetadataCache.loadTableDefine((String)"er_repaymentbill", (String)"recentry").getTableId();
            for (DynamicObject recEntry : recBills) {
                DynamicObjectCollection relations = recEntry.getDynamicObjectCollection("billhead_lk");
                Iterator iterator = relations.iterator();
                while (iterator.hasNext()) {
                    DynamicObject relation = (DynamicObject)iterator.next();
                    if (!stableid.equals(relation.get("billhead_lk_stableid")) || !repayBillPk.equals(relation.get("billhead_lk_sbillid"))) continue;
                    iterator.remove();
                }
            }
            OperationServiceHelper.executeOperate((String)"save", (String)"cas_recbill", (DynamicObject[])recBills, (OperateOption)OperateOption.create());
        }
    }

    public static boolean hasPermissionForAssoiate(IFormView formview) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        String appId = formview.getFormShowParameter().getAppId();
        FormShowParameter formShowParameter = formview.getFormShowParameter();
        String entityNum = null;
        entityNum = formShowParameter instanceof ListShowParameter ? ((ListShowParameter)formview.getFormShowParameter()).getBillFormId() : ((BillShowParameter)formShowParameter).getFormId();
        String permItemId = "0MGZGQXNMV5H";
        return PermissionServiceHelper.hasSpecificPerm((long)userId, (String)appId, (String)entityNum, (String)permItemId);
    }

    public static boolean hasBOTPRelation(DynamicObject repaymentBill) {
        return "1".equals(repaymentBill.get("buildrelationway"));
    }

    public static DynamicObject[] getCanAssociateBills(DynamicObject repaymentBill) {
        if (repaymentBill != null) {
            QFilter q2 = new QFilter("payeracctbanknum", "=", repaymentBill.get("payeraccount"));
            QFilter q3 = new QFilter("sourcebilltype", "!=", (Object)"er_repaymentbill");
            QFilter statsFilter = new QFilter("billstatus", "in", (Object)new Object[]{"B", "C", "D"});
            return BusinessDataServiceHelper.load((String)"cas_recbill", (String)RECBILLSELECTFIELDS, (QFilter[])new QFilter[]{q2, q3, statsFilter});
        }
        return new DynamicObject[0];
    }

    public static boolean delRecEntry(DynamicObjectCollection recCollection, List<Long> del) {
        if (del.size() > 0) {
            Iterator iterator = recCollection.iterator();
            while (iterator.hasNext()) {
                DynamicObject recEntry = (DynamicObject)iterator.next();
                if (!del.contains(recEntry.getLong("recbillid"))) continue;
                iterator.remove();
            }
            return true;
        }
        return false;
    }

    public static boolean fillRecEntry(DynamicObjectCollection recCollection, List<Object> recBillInfos, List<Long> addRecBillPks) {
        if (addRecBillPks.size() > 0) {
            DynamicObjectType recEntryType = recCollection.getDynamicObjectType();
            Map<Long, DynamicObject> map = recBillInfos.stream().collect(Collectors.toMap(k -> ((DynamicObject)k).getLong("id"), v -> (DynamicObject)v));
            for (Long recBillPk : addRecBillPks) {
                DynamicObject recEntry = (DynamicObject)recEntryType.createInstance();
                DynamicObject recBillInfo = map.get(recBillPk);
                RepaymentAssociateUtil.copyVale(recEntry, recBillInfo);
                recCollection.add((Object)recEntry);
            }
            return true;
        }
        return false;
    }

    private static void copyVale(DynamicObject repayRecEntry, DynamicObject recBillInfo) {
        DataEntityPropertyCollection properties = recBillInfo.getDataEntityType().getProperties();
        DataEntityPropertyCollection recProperties = repayRecEntry.getDataEntityType().getProperties();
        for (IDataEntityProperty property : properties) {
            if (recProperties.get((Object)property.getName()) != null && !"id".equalsIgnoreCase(property.getName()) && !"seq".equalsIgnoreCase(property.getName()) && recBillInfo.get(property.getName()) != null) {
                repayRecEntry.set(property.getName(), recBillInfo.get(property.getName()));
            }
            repayRecEntry.set("recbillno", recBillInfo.get("billno"));
            repayRecEntry.set("reccurrency", recBillInfo.get("currency"));
            repayRecEntry.set("recexchangerate", recBillInfo.get("exchangerate"));
            repayRecEntry.set("oriactrecamt", recBillInfo.get("actrecamt"));
            repayRecEntry.set("actrecamt", recBillInfo.get("localamt"));
            repayRecEntry.set("payeedate", recBillInfo.get("bizdate"));
            repayRecEntry.set("recbillid", recBillInfo.get("id"));
            if (properties.get((Object)"accountbank") == null) continue;
            repayRecEntry.set("accountname", recBillInfo.get("accountbank.name"));
        }
    }

    public static List<Map<String, Object>> convertResult(DynamicObject[] recBills) {
        ArrayList result = Lists.newArrayList();
        if (recBills.length > 0) {
            for (DynamicObject recBill : recBills) {
                HashMap map = Maps.newHashMap();
                DataEntityPropertyCollection properties = recBill.getDataEntityType().getProperties();
                properties.stream().forEach(p -> map.put(p.getName(), p.getValueFast((Object)recBill)));
                result.add(map);
            }
        }
        return result;
    }
}

