/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.tripstd.service.imp.ErTripStdControlServiceImpl;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.common.constant.ErTripExpenseItemConstant;
import kd.fi.er.common.constant.formproperties.mainbill.trip.TripReimburseBill;
import org.apache.commons.lang3.StringUtils;

public class TripHighSeasonStandardUtil {
    private static Log logger = LogFactory.getLog(TripHighSeasonStandardUtil.class);
    protected static final String[] ACCD_ALLOWANCE_ATTRIBUTE = new String[]{"5", "1"};

    public static BigDecimal getHighSeasonDays(Long companyId, Date begin, Date end, DynamicObject area, DynamicObject expenseitem) {
        return TripHighSeasonStandardUtil.getHighSeasonDays(companyId, begin, end, area, expenseitem, false);
    }

    @Deprecated
    public static BigDecimal getHighSeasonDays(BigDecimal delay, Date begin, Date end, DynamicObject area, DynamicObject expenseitem) {
        return BigDecimal.ZERO;
    }

    public static BigDecimal getHighSeasonDays(Date begin, Date end, DynamicObject area) {
        return TripHighSeasonStandardUtil.getHighSeasonDays((Long)null, begin, end, area, null);
    }

    @Deprecated
    public static BigDecimal getHighSeasonDays(Long companyId, Date begin, Date end, DynamicObject tripArea, DynamicObject expenseitem, RefObject<BigDecimal> ref) {
        return BigDecimal.ZERO;
    }

    public static BigDecimal getHighSeasonDays(Long companyId, Date begin, Date end, DynamicObject tripArea, DynamicObject expenseitem, boolean isOpenTripDateControl) {
        if (TripHighSeasonStandardUtil.isNullDimensionOfHighSeasonDay(begin, end, tripArea)) {
            return BigDecimal.ZERO;
        }
        List<DateRange> leapYearDateRangeList = TripHighSeasonStandardUtil.getDateRangeByTripArea(tripArea, true);
        List<DateRange> commonYearDateRangeList = TripHighSeasonStandardUtil.getDateRangeByTripArea(tripArea, false);
        if (leapYearDateRangeList.isEmpty()) {
            return BigDecimal.ZERO;
        }
        BigDecimal highSeasonDays = BigDecimal.ZERO;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(begin);
        int startYear = calendar.get(1);
        calendar.setTime(end);
        int endYear = calendar.get(1);
        int diff = endYear - startYear;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        if (diff > 0) {
            try {
                if (diff > 1) {
                    BigDecimal isLeapYearDayCount = TripHighSeasonStandardUtil.calHighSeasonDaysByOneYearRange(2020, format.parse("2020-1-1"), format.parse("2021-1-1"), leapYearDateRangeList, commonYearDateRangeList);
                    BigDecimal isCommYearDayCount = TripHighSeasonStandardUtil.calHighSeasonDaysByOneYearRange(2021, format.parse("2021-1-1"), format.parse("2022-1-1"), leapYearDateRangeList, commonYearDateRangeList);
                    for (int midYear = startYear + 1; midYear < diff; ++midYear) {
                        highSeasonDays = highSeasonDays.add(TripHighSeasonStandardUtil.isLeapYear(midYear) ? isLeapYearDayCount : isCommYearDayCount);
                    }
                }
                highSeasonDays = highSeasonDays.add(TripHighSeasonStandardUtil.calHighSeasonDaysByOneYearRange(startYear, begin, format.parse(startYear + 1 + "-1-1"), leapYearDateRangeList, commonYearDateRangeList));
                highSeasonDays = highSeasonDays.add(TripHighSeasonStandardUtil.calHighSeasonDaysByOneYearRange(endYear, format.parse(endYear + "-1-1"), end, leapYearDateRangeList, commonYearDateRangeList));
            }
            catch (ParseException exception) {
                StringWriter out = new StringWriter();
                exception.printStackTrace(new PrintWriter((Writer)out, true));
                String errMsg = out.toString();
                logger.error(errMsg);
            }
        } else if (diff == 0) {
            highSeasonDays = TripHighSeasonStandardUtil.calHighSeasonDaysByOneYearRange(startYear, begin, end, leapYearDateRangeList, commonYearDateRangeList);
        }
        return highSeasonDays.add(TripHighSeasonStandardUtil.compensateDayCount(companyId, expenseitem, endYear, begin, end, leapYearDateRangeList, commonYearDateRangeList, isOpenTripDateControl));
    }

    public static BigDecimal getDelayDay(Long companyId) {
        int subsidiesDayControl = ErCommonUtils.getSubsidiesDays(companyId);
        ErTripStdControlServiceImpl erTripStdControlService = new ErTripStdControlServiceImpl();
        return erTripStdControlService.addDaysBySubsidiesDayControl(BigDecimal.ZERO, subsidiesDayControl);
    }

    public static BigDecimal getStandardamountTotal(boolean highSeason, DynamicObject entry) {
        BigDecimal tripSTDAmount = entry.getBigDecimal("tripstandardamount");
        BigDecimal caldaycount = entry.getBigDecimal("caldaycount");
        BigDecimal highSeasonTripSTDAmount = entry.getBigDecimal("hightripstandardamount");
        BigDecimal highSeasonDayCount = entry.getBigDecimal("highseasondaycount");
        BigDecimal oriMaxStdAmount = null;
        if (highSeason) {
            oriMaxStdAmount = tripSTDAmount.multiply(caldaycount.subtract(highSeasonDayCount));
            oriMaxStdAmount = oriMaxStdAmount.add(highSeasonTripSTDAmount.multiply(highSeasonDayCount));
        } else {
            oriMaxStdAmount = tripSTDAmount.multiply(caldaycount);
        }
        return oriMaxStdAmount;
    }

    public static boolean checkAndSetHighSeasonDays(IFormView view, IDataModel dataModel, int rowIndex, int parentIndex, BigDecimal oldDayCount) {
        BigDecimal caldayCount = (BigDecimal)dataModel.getValue("caldaycount", rowIndex, parentIndex);
        BigDecimal highSeasonDayCount = (BigDecimal)dataModel.getValue("highseasondaycount", rowIndex, parentIndex);
        if (caldayCount == null || highSeasonDayCount == null) {
            return false;
        }
        List<String> accAttributeList = Arrays.asList(ACCD_ALLOWANCE_ATTRIBUTE);
        DynamicObject tripExp = (DynamicObject)dataModel.getValue("expenseitem", rowIndex, parentIndex);
        if (tripExp != null && accAttributeList.contains(tripExp.getString("attribute")) && highSeasonDayCount.compareTo(caldayCount) > 0) {
            dataModel.setValue("highseasondaycount", (Object)oldDayCount, rowIndex, parentIndex);
            view.showTipNotification(ResManager.loadKDString((String)"\u65fa\u5b63\u5929\u6570\u4e0d\u5141\u8bb8\u5927\u4e8e\u6807\u51c6\u5929\u6570\u3002", (String)"TripHighSeasonStandardUtil_0", (String)"fi-er-business", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public static boolean checkAndSetHighSeasonDays(IFormView view, IDataModel dataModel, int rowIndex, BigDecimal oldDayCount) {
        BigDecimal caldayCount = (BigDecimal)dataModel.getValue("caldaycount", rowIndex);
        BigDecimal highSeasonDayCount = (BigDecimal)dataModel.getValue("highseasondaycount", rowIndex);
        if (caldayCount == null || highSeasonDayCount == null) {
            return false;
        }
        if (highSeasonDayCount.compareTo(caldayCount) > 0) {
            dataModel.beginInit();
            dataModel.setValue("highseasondaycount", (Object)oldDayCount, rowIndex);
            dataModel.beginInit();
            view.showTipNotification(ResManager.loadKDString((String)"\u65fa\u5b63\u5929\u6570\u4e0d\u5141\u8bb8\u5927\u4e8e\u6807\u51c6\u5929\u6570\u3002", (String)"TripHighSeasonStandardUtil_0", (String)"fi-er-business", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public static boolean checkAndSetHighSeasonDay(IDataModel dataModel, int rowIndex, int parentIndex) {
        BigDecimal caldayCount = (BigDecimal)dataModel.getValue("caldaycount", rowIndex, parentIndex);
        BigDecimal highSeasonDayCount = (BigDecimal)dataModel.getValue("highseasondaycount", rowIndex, parentIndex);
        if (caldayCount == null || highSeasonDayCount == null) {
            return false;
        }
        if (highSeasonDayCount.compareTo(caldayCount) > 0) {
            dataModel.setValue("highseasondaycount", (Object)caldayCount, rowIndex, parentIndex);
            return true;
        }
        return false;
    }

    public static boolean checkAndSetHighSeasonDay(IDataModel dataModel, int rowIndex) {
        BigDecimal caldayCount = (BigDecimal)dataModel.getValue("caldaycount", rowIndex);
        BigDecimal highSeasonDayCount = (BigDecimal)dataModel.getValue("highseasondaycount", rowIndex);
        if (caldayCount == null || highSeasonDayCount == null) {
            return false;
        }
        if (highSeasonDayCount.compareTo(caldayCount) > 0) {
            dataModel.setValue("highseasondaycount", (Object)caldayCount, rowIndex);
            return true;
        }
        return false;
    }

    private static boolean isNullDimensionOfHighSeasonDay(Date begin, Date end, DynamicObject area) {
        return begin == null || end == null || area == null;
    }

    public static boolean isHighSeason(Date begin, Date end, DynamicObject tripArea) {
        if (begin == null || end == null || tripArea == null) {
            return false;
        }
        List<DateRange> isLeapDateRangeList = TripHighSeasonStandardUtil.getDateRangeByTripArea(tripArea, true);
        List<DateRange> isCommonDateRangeList = TripHighSeasonStandardUtil.getDateRangeByTripArea(tripArea, false);
        if (isLeapDateRangeList.isEmpty()) {
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(begin);
        int startYear = calendar.get(1);
        calendar.setTime(end);
        int endYear = calendar.get(1);
        int diff = endYear - startYear;
        if (diff > 1) {
            return true;
        }
        if (diff > 0) {
            List<DateRange> dateRanges = TripHighSeasonStandardUtil.isLeapYear(startYear) ? isLeapDateRangeList : isCommonDateRangeList;
            dateRanges.stream().forEach(record -> record.incrementToDesYear(startYear));
            boolean isHighSeason = dateRanges.stream().anyMatch(dateRange -> begin.getTime() <= dateRange.getEndDate().getTime());
            if (isHighSeason) {
                return isHighSeason;
            }
            dateRanges = TripHighSeasonStandardUtil.isLeapYear(endYear) ? isLeapDateRangeList : isCommonDateRangeList;
            dateRanges.stream().forEach(record -> record.incrementToDesYear(endYear));
            return dateRanges.stream().anyMatch(dateRange -> end.getTime() >= dateRange.getStartDate().getTime());
        }
        if (diff == 0) {
            List<DateRange> dateRanges = TripHighSeasonStandardUtil.isLeapYear(startYear) ? isLeapDateRangeList : isCommonDateRangeList;
            dateRanges.stream().forEach(record -> record.incrementToDesYear(startYear));
            return dateRanges.stream().anyMatch(dateRange -> begin.getTime() <= dateRange.getEndDate().getTime() && end.getTime() >= dateRange.getStartDate().getTime());
        }
        return false;
    }

    @Deprecated
    public static Set getMonths(Date begin, Date end) {
        HashSet<Integer> months = new HashSet<Integer>(2);
        if (begin == null || end == null) {
            return months;
        }
        Calendar cbegin = Calendar.getInstance();
        cbegin.setTime(begin);
        cbegin.set(5, 1);
        Calendar cend = Calendar.getInstance();
        cend.setTime(end);
        while (cbegin.before(cend)) {
            int m = TripHighSeasonStandardUtil.getMonthByDate(cbegin.getTime());
            months.add(m);
            cbegin.add(2, 1);
        }
        months.add(TripHighSeasonStandardUtil.getMonthByDate(end));
        return months;
    }

    @Deprecated
    public static Set getHighMonthsStandard(DynamicObject tripArea) {
        String[] months;
        HashSet<Integer> highMonthsStandard = new HashSet<Integer>();
        DynamicObject area = tripArea;
        if (area == null || StringUtils.isBlank((CharSequence)area.getString("mulcombofield"))) {
            logger.info("\u51fa\u5dee\u5730\u57df\u65e0\u6570\u636e,\u5730\u57df");
            return highMonthsStandard;
        }
        String mulcombofield = area.getString("mulcombofield");
        for (String m : months = mulcombofield.split(",")) {
            if (StringUtils.isEmpty((CharSequence)m)) continue;
            highMonthsStandard.add(Integer.parseInt(m));
        }
        return highMonthsStandard;
    }

    @Deprecated
    protected static BigDecimal getHighSeasonDays(Date begin, Date end, BigDecimal delay, DynamicObject tripArea) {
        return BigDecimal.ZERO;
    }

    @Deprecated
    private static void splitByMonth(Date begin, Date end, List<DatePeriod> datePeriodList) {
        Date newBegin = TripHighSeasonStandardUtil.getNextMonthFirstDay(begin);
        if (newBegin.before(end)) {
            DatePeriod datePeriod = new DatePeriod(begin, newBegin);
            datePeriodList.add(datePeriod);
            TripHighSeasonStandardUtil.splitByMonth(newBegin, end, datePeriodList);
        } else {
            DatePeriod datePeriod = new DatePeriod(begin, end);
            datePeriodList.add(datePeriod);
        }
    }

    @Deprecated
    protected static Date getNextMonthFirstDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        calendar.add(2, 1);
        return calendar.getTime();
    }

    @Deprecated
    protected static Integer getMonthByDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(2) + 1;
    }

    public static BigDecimal getHighSeasonDays(Long companyId, Date preRowEndDate, Date begin, Date end, DynamicObject tripArea, DynamicObject expenseItem, boolean isOpenTripDateControl) {
        if (TripHighSeasonStandardUtil.isNullDimensionOfHighSeasonDay(begin, end, tripArea)) {
            return BigDecimal.ZERO;
        }
        BigDecimal highSeasonDays = TripHighSeasonStandardUtil.getHighSeasonDays(companyId, begin, end, tripArea, expenseItem, isOpenTripDateControl);
        if (isOpenTripDateControl && TripHighSeasonStandardUtil.isHighSeason(end, end, tripArea) && expenseItem != null && preRowEndDate != null && StringUtils.equals((CharSequence)ErTripExpenseItemConstant.Attribute.Subsidy.getValue(), (CharSequence)expenseItem.getString("attribute")) && preRowEndDate.getTime() >= begin.getTime()) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(end);
            int endYear = calendar.get(1);
            List<DateRange> leapYearDateRangeList = TripHighSeasonStandardUtil.getDateRangeByTripArea(tripArea, true);
            List<DateRange> commonYearDateRangeList = TripHighSeasonStandardUtil.getDateRangeByTripArea(tripArea, false);
            highSeasonDays = highSeasonDays.subtract(TripHighSeasonStandardUtil.compensateDayCount(companyId, expenseItem, endYear, begin, end, leapYearDateRangeList, commonYearDateRangeList, isOpenTripDateControl));
        }
        return highSeasonDays;
    }

    private static BigDecimal calHighSeasonDaysByOneYearRange(int year, Date begin, Date end, List<DateRange> leapDateRange, List<DateRange> commDateRange) {
        List<DateRange> dateRanges = TripHighSeasonStandardUtil.isLeapYear(year) ? leapDateRange : commDateRange;
        dateRanges.stream().forEach(record -> record.incrementToDesYear(year));
        long beginTime = begin.getTime();
        end = TripCommonUtil.timeStamp2Date(String.valueOf(end.getTime()), "yyyy-MM-dd");
        long endTime = end.getTime() + 86400000L - 1L;
        long dayCount = 0L;
        for (DateRange range : dateRanges) {
            long rangeStartTime = range.getStartDate().getTime();
            long rangeEndTime = range.getEndDate().getTime() + 86400000L - 1L;
            if (beginTime > rangeStartTime && endTime >= rangeEndTime && beginTime <= rangeEndTime) {
                dayCount += TripHighSeasonStandardUtil.calcDays(beginTime, rangeEndTime).longValue();
                continue;
            }
            if (beginTime <= rangeStartTime && endTime >= rangeEndTime) {
                dayCount += TripHighSeasonStandardUtil.calcDays(rangeStartTime, rangeEndTime).longValue();
                continue;
            }
            if (beginTime <= rangeStartTime && endTime < rangeEndTime && rangeStartTime <= endTime) {
                dayCount += TripHighSeasonStandardUtil.calcDays(rangeStartTime, endTime).longValue();
                continue;
            }
            if (beginTime > rangeStartTime && endTime < rangeEndTime) {
                dayCount += TripHighSeasonStandardUtil.calcDays(beginTime, endTime).longValue();
                continue;
            }
            if (endTime >= rangeStartTime) continue;
            break;
        }
        return new BigDecimal(dayCount);
    }

    private static BigDecimal compensateDayCount(Long companyId, DynamicObject expenseitem, int year, Date end, List<DateRange> leapDateRange, List<DateRange> commDateRange, boolean isOpenTripDateControl) {
        BigDecimal delay = BigDecimal.ZERO;
        List<DateRange> dateRanges = TripHighSeasonStandardUtil.isLeapYear(year) ? leapDateRange : commDateRange;
        dateRanges.stream().forEach(record -> record.incrementToDesYear(year));
        for (DateRange dateRange : dateRanges) {
            if (end.getTime() < dateRange.getStartDate().getTime() || end.getTime() > dateRange.getEndDate().getTime() || TripReimburseBill.objectThreadLocal.get() == null) continue;
            TripReimburseBill.objectThreadLocal.set(true);
        }
        if (companyId != null && expenseitem != null && StringUtils.equals((CharSequence)ErTripExpenseItemConstant.Attribute.Subsidy.getValue(), (CharSequence)expenseitem.getString("attribute"))) {
            delay = TripHighSeasonStandardUtil.getDelayDay(companyId);
            for (DateRange dateRange : dateRanges) {
                if (end.getTime() < dateRange.getStartDate().getTime() || end.getTime() > dateRange.getEndDate().getTime()) continue;
                return delay;
            }
        }
        return BigDecimal.ZERO;
    }

    private static BigDecimal compensateDayCount(Long companyId, DynamicObject expenseitem, int year, Date begin, Date end, List<DateRange> leapDateRange, List<DateRange> commDateRange, boolean isOpenTripDateControl) {
        BigDecimal delay = BigDecimal.ZERO;
        List<DateRange> dateRanges = TripHighSeasonStandardUtil.isLeapYear(year) ? leapDateRange : commDateRange;
        dateRanges.stream().forEach(record -> record.incrementToDesYear(year));
        for (DateRange dateRange : dateRanges) {
            if (end.getTime() < dateRange.getStartDate().getTime() || end.getTime() > dateRange.getEndDate().getTime() || TripReimburseBill.objectThreadLocal.get() == null) continue;
            TripReimburseBill.objectThreadLocal.set(true);
        }
        Long oneDayM = 86400000L;
        Date begins = TripCommonUtil.timeStamp2Date(String.valueOf(begin.getTime()), "yyyy-MM-dd");
        Date ends = TripCommonUtil.timeStamp2Date(String.valueOf(end.getTime()), "yyyy-MM-dd");
        Long diff = 0L;
        long beginTime = begins.getTime();
        long endTime = ends.getTime() + oneDayM - 1L;
        for (DateRange dateRange : dateRanges) {
            long rangeStartTime = dateRange.getStartDate().getTime();
            long rangeEndTime = dateRange.getEndDate().getTime() + oneDayM - 1L;
            if (beginTime > rangeStartTime && endTime > rangeEndTime && beginTime <= rangeEndTime) {
                diff = rangeEndTime - beginTime;
                delay = BigDecimal.ONE;
            } else if (beginTime <= rangeStartTime && endTime >= rangeEndTime) {
                diff = rangeEndTime - rangeStartTime;
                delay = BigDecimal.ONE;
            } else if (beginTime <= rangeStartTime && endTime < rangeEndTime && rangeStartTime <= endTime) {
                diff = endTime - rangeStartTime;
            } else if (beginTime > rangeStartTime && endTime < rangeEndTime) {
                diff = endTime - beginTime;
            } else if (endTime < rangeStartTime) break;
            if ((begin.getTime() < dateRange.getStartDate().getTime() || begin.getTime() > dateRange.getEndDate().getTime()) && (ends.getTime() < dateRange.getStartDate().getTime() || ends.getTime() > dateRange.getEndDate().getTime()) || diff <= oneDayM) continue;
            return delay;
        }
        return BigDecimal.ZERO;
    }

    private static Long calcDays(long startDate, long endDate) {
        Long dayCount = 0L;
        Long oneDayM = 86400000L;
        Long diff = endDate - startDate;
        if (diff == 0L) {
            return dayCount;
        }
        if (diff <= oneDayM) {
            return 1L;
        }
        Date start = TripCommonUtil.timeStamp2Date(String.valueOf(startDate), "yyyy-MM-dd");
        Date end = TripCommonUtil.timeStamp2Date(String.valueOf(endDate), "yyyy-MM-dd");
        dayCount = (end.getTime() - start.getTime()) / oneDayM;
        return dayCount;
    }

    private static List<DateRange> getDateRangeByTripArea(DynamicObject tripArea, boolean isLeapYear) {
        DynamicObject tripAreaDy = BusinessDataServiceHelper.loadSingleFromCache((String)"er_triparea", (String)"dateentry.startmonth,dateentry.startday,dateentry.endmonth,dateentry.endday,", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)ErCommonUtils.getPk(tripArea))});
        DynamicObjectCollection dateEntry = tripAreaDy.getDynamicObjectCollection("dateentry");
        ArrayList<DateRange> dateRangeList = new ArrayList<DateRange>();
        String year = isLeapYear ? "2020" : "2021";
        for (int i = 0; i < dateEntry.size(); ++i) {
            DynamicObject record = (DynamicObject)dateEntry.get(i);
            try {
                String startMonth = record.getString("startmonth");
                String startDay = record.getString("startday");
                String endMonth = record.getString("endmonth");
                String endDay = record.getString("endday");
                dateRangeList.add(new DateRange(year, startMonth, startDay, endMonth, endDay));
                continue;
            }
            catch (ParseException exception) {
                StringWriter out = new StringWriter();
                exception.printStackTrace(new PrintWriter((Writer)out, true));
                String errMsg = out.toString();
                logger.error(errMsg);
            }
        }
        Comparator<DateRange> rangeCompar = new Comparator<DateRange>(){

            @Override
            public int compare(DateRange o1, DateRange o2) {
                return o1.startDate.compareTo(o2.startDate);
            }
        };
        dateRangeList.sort(rangeCompar);
        return dateRangeList;
    }

    private static boolean isLeapYear(int year) {
        return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    private static class DateRange {
        private Date startDate;
        private Date endDate;

        public Date getStartDate() {
            return this.startDate;
        }

        public Date getEndDate() {
            return this.endDate;
        }

        public DateRange(String year, String startMonth, String startDay, String endMonth, String endDay) throws ParseException {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            if (TripHighSeasonStandardUtil.isLeapYear(Integer.parseInt(year))) {
                if (StringUtils.equals((CharSequence)startMonth, (CharSequence)"2") && StringUtils.equals((CharSequence)startDay, (CharSequence)"29")) {
                    startDay = "28";
                }
                if (StringUtils.equals((CharSequence)endMonth, (CharSequence)"2") && StringUtils.equals((CharSequence)endMonth, (CharSequence)"29")) {
                    endDay = "28";
                }
            }
            this.startDate = format.parse(year + "-" + startMonth + "-" + startDay);
            this.endDate = format.parse(year + "-" + endMonth + "-" + endDay);
        }

        public void incrementToDesYear(int desYear) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.startDate);
            calendar.add(1, desYear - calendar.get(1));
            this.startDate = calendar.getTime();
            calendar.setTime(this.endDate);
            calendar.add(1, desYear - calendar.get(1));
            this.endDate = calendar.getTime();
        }
    }

    @Deprecated
    private static class DatePeriod {
        private Date begin;
        private Date end;

        public DatePeriod(Date begin, Date end) {
            this.begin = begin;
            this.end = end;
        }

        public Date getBegin() {
            return this.begin;
        }

        public void setBegin(Date begin) {
            this.begin = begin;
        }

        public Date getEnd() {
            return this.end;
        }

        public void setEnd(Date end) {
            this.end = end;
        }
    }
}

