/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.utils;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.servicehelper.LoanBalanceServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.common.ErBillStatusEnum;
import org.apache.commons.lang3.StringUtils;

public class UnRepaymentAmountUtil {
    public static void setUnrepaymentAmountAndBillPayerAmount(IFormView billView, FormOperate operate) {
        String operateKey = operate.getOperateKey();
        IDataModel model = billView.getModel();
        if ((StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)"save") || StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)"submit")) && (ErBillStatusEnum.A.name().equals(model.getValue("billstatus")) || ErBillStatusEnum.D.name().equals(model.getValue("billstatus")))) {
            if (model.getProperty("unrepaymentamount") != null) {
                model.setValue("unrepaymentamount", (Object)UnRepaymentAmountUtil.getUnrepaymentAmount(billView));
            }
            if (model.getProperty("billpayeramount") != null) {
                model.setValue("billpayeramount", (Object)UnRepaymentAmountUtil.getBillPayerAmount(billView));
            }
        }
    }

    public static BigDecimal getUnrepaymentAmount(String entityId, Object pkid) {
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)pkid, (String)entityId);
        return UnRepaymentAmountUtil.getUnrepaymentAmount(bill);
    }

    public static BigDecimal getUnrepaymentAmount(IFormView billView) {
        DynamicObject bill = billView.getModel().getDataEntity(true);
        return UnRepaymentAmountUtil.getUnrepaymentAmount(bill);
    }

    private static BigDecimal getUnrepaymentAmount(DynamicObject bill) {
        boolean isloan;
        DataEntityPropertyCollection properties = bill.getDataEntityType().getProperties();
        if (!properties.containsKey((Object)"applier") || !properties.containsKey((Object)"currency")) {
            return BigDecimal.ZERO;
        }
        Object user = bill.get("applier");
        String entityId = bill.getDynamicObjectType().getName();
        Object currency = bill.get("currency");
        if (user == null || entityId == null || currency == null) {
            return BigDecimal.ZERO;
        }
        if (ErEntityTypeUtils.isTripReqBill(entityId) && !(isloan = ((Boolean)bill.get("isloan")).booleanValue())) {
            return BigDecimal.ZERO;
        }
        BigDecimal amount = LoanBalanceServiceHelper.getPersonalLoanBalance(ErCommonUtils.getPk(user), ErCommonUtils.getPk(currency));
        return amount;
    }

    private static BigDecimal getBillPayerAmount(DynamicObject bill) {
        DataEntityPropertyCollection properties = bill.getDataEntityType().getProperties();
        if (!properties.containsKey((Object)"billpayerid") || !properties.containsKey((Object)"costcompany")) {
            return BigDecimal.ZERO;
        }
        Object billPayerId = bill.get("billpayerid");
        Object costcompany = bill.get("costcompany");
        if (billPayerId == null || costcompany == null) {
            return BigDecimal.ZERO;
        }
        QFilter qFilter = new QFilter("billpayerid", "=", (Object)ErCommonUtils.getPk(billPayerId));
        qFilter.and("costcompany", "=", (Object)ErCommonUtils.getPk(costcompany));
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"er_prepaybill", (String)"balanceamount", (QFilter[])new QFilter[]{qFilter});
        BigDecimal balanceamount = collection.stream().map(m -> m.getBigDecimal("balanceamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        return balanceamount;
    }

    public static BigDecimal getBillPayerAmount(String entityId, Object pkid) {
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)pkid, (String)entityId);
        return UnRepaymentAmountUtil.getBillPayerAmount(bill);
    }

    public static BigDecimal getBillPayerAmount(IFormView billView) {
        DynamicObject bill = billView.getModel().getDataEntity(true);
        return UnRepaymentAmountUtil.getBillPayerAmount(bill);
    }
}

