/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.voucher.mq;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.invoicecloud.InvoiceService;
import kd.fi.er.business.invoicecloud.cache.model.InvoiceCloudCfgBO;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.invoicecloud.provider.param.req.DeleteVoucherRequestParam;
import kd.fi.er.business.invoicecloud.provider.param.req.SaveVoucherRequestParam;
import kd.fi.er.business.invoicecloud.v2.InvoiceFrom;
import kd.fi.er.business.log.InvoiceLogUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.InvoiceUtils;
import org.apache.commons.lang3.StringUtils;

public class ErDapWbInvoiceConsumer
implements MessageConsumer {
    private static final int OFFSET = 100;
    private static Log logger = LogFactory.getLog(ErDapWbInvoiceConsumer.class);
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMM");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Object message, String messageId, boolean resend, MessageAcker acker) {
        try {
            if (message instanceof Map) {
                logger.info("\u540c\u6b65\u51ed\u8bc1\u6570\u636e\u5230\u53d1\u7968\u4e91\uff0c\u63a5\u6536\u5230mq\u6d88\u606f\uff1a{}", JSON.toJSON((Object)message));
                Map param = (Map)message;
                String voucherOpValue = (String)param.get("voucherOpValue");
                String billEntityNumber = (String)param.get("billEntityNumber");
                InvoiceLogUtils.insertLog(InvoiceLogUtils.InvoiceOpType.VOUCHER_WRITE_BACK, billEntityNumber, InvoiceLogUtils.InvoiceOpType.VOUCHER_WRITE_BACK.getDesc(), message.toString());
                HashMap<Long, List<Long>> billPkMap = null;
                Map rawBillPkMap = (Map)param.get("billPkMap");
                if (rawBillPkMap.isEmpty()) {
                    return;
                }
                Object obj = rawBillPkMap.entrySet().iterator().next().getValue();
                if (obj instanceof Long) {
                    logger.info("\u8fd9\u662f\u4e8c\u5f00\u7684\u8001\u4ee3\u7801\u8c03\u7528");
                    billPkMap = new HashMap<Long, List<Long>>(rawBillPkMap.size());
                    for (Map.Entry mapEntry : rawBillPkMap.entrySet()) {
                        Long billId = (Long)mapEntry.getKey();
                        Long voucherId = (Long)mapEntry.getValue();
                        ArrayList<Long> voucherIds = new ArrayList<Long>(1);
                        voucherIds.add(voucherId);
                        billPkMap.put(billId, voucherIds);
                    }
                } else {
                    billPkMap = (HashMap<Long, List<Long>>)param.get("billPkMap");
                }
                Map vchMap = (Map)param.get("vchMap");
                List<Voucher> voucherInfoList = this.getVoucherInfoList(billPkMap, vchMap);
                logger.info("getVoucherInfoList\u540e\u7684\u6570\u636e: {}", (Object)JSON.toJSONString(voucherInfoList));
                this.fillBillInfos(billEntityNumber, voucherInfoList);
                logger.info("fillBillInfos\u540e\u7684\u6570\u636e: {}", (Object)JSON.toJSONString(voucherInfoList));
                for (int i = 0; i < voucherInfoList.size(); ++i) {
                    Voucher voucher = voucherInfoList.get(i);
                    if ("2".equals(voucherOpValue)) {
                        this.deleteVoucher(billEntityNumber, voucher);
                        continue;
                    }
                    this.saveVoucher(billEntityNumber, voucher);
                }
            } else {
                logger.error("\u51ed\u8bc1\u53cd\u5199\u53d1\u7968\u4e91consumer\u6267\u884c,\u5931\u8d25:\u53c2\u6570\u4e0d\u6b63\u786e");
            }
        }
        catch (Exception e) {
            logger.error("\u51ed\u8bc1\u53cd\u5199\u53d1\u7968\u4e91consumer\u6267\u884c,\u5931\u8d25:", (Throwable)e);
        }
        finally {
            acker.ack(messageId);
        }
    }

    private void fillBillInfos(String entityName, List<Voucher> voucherInfoList) {
        Set billIds = voucherInfoList.stream().flatMap(v -> v.billPks.stream()).collect(Collectors.toSet());
        QFilter idQfilter = new QFilter("id", "in", billIds);
        QFilter serialNoQFilter = QFilter.of((String)"invoiceentry.serialno != null or invoiceentry.serialno != '' or invoiceentry.serialno != ' '", (Object[])new Object[0]);
        QFilter invoiceFromQFilter = QFilter.of((String)"invoiceentry.invoicefrom = ?", (Object[])new Object[]{InvoiceFrom.InvoiceCloud.getValue()});
        invoiceFromQFilter = invoiceFromQFilter.or(QFilter.of((String)"invoiceentry.invoicefrom = ?", (Object[])new Object[]{InvoiceFrom.ManualAdd.getValue()}));
        String costCompanyField = "costcompany";
        if ("er_checkingpaybill".equalsIgnoreCase(entityName)) {
            costCompanyField = "company";
        }
        boolean isPublicBill = ErEntityTypeUtils.isPublicReimburseBill(entityName);
        String entryBillingIdField = "invoiceentry.billingpoolid billingpoolid,";
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)ErDapWbInvoiceConsumer.class.getCanonicalName(), (String)entityName, (String)String.format("id, billno, invoiceentry.id entryid, invoiceentry.serialno serialno, %s %s.id costcompanyid", isPublicBill ? entryBillingIdField : "", costCompanyField), (QFilter[])new QFilter[]{idQfilter, serialNoQFilter, invoiceFromQFilter}, null);
        HashMap<Long, BillInfo> billInfoByPkId = new HashMap<Long, BillInfo>();
        for (Row row : dataSet) {
            Long billingPoolId;
            Long billId = row.getLong("id");
            Long costCompanyId = row.getLong("costcompanyid");
            String serialNo = row.getString("serialno");
            BillInfo billInfo = billInfoByPkId.getOrDefault(billId, new BillInfo());
            if (isPublicBill && (billingPoolId = row.getLong("billingpoolid")) != null && billingPoolId != 0L) {
                billInfo.billingIds.add(billingPoolId);
            }
            billInfo.billId = billId;
            billInfo.billNo = row.getString("billno");
            billInfo.entityName = entityName;
            billInfo.invoiceOrgId = costCompanyId;
            billInfo.serialNos.add(serialNo);
            billInfoByPkId.put(billId, billInfo);
        }
        Set pkIdsHasInvoice = billInfoByPkId.keySet();
        for (Voucher voucher2 : voucherInfoList) {
            voucher2.billPks.removeIf(pkid -> !pkIdsHasInvoice.contains(pkid));
        }
        voucherInfoList.removeIf(voucher -> voucher.billPks.isEmpty());
        voucherInfoList.forEach(voucher -> voucher.billInfos.addAll(voucher.billPks.stream().map(pkid -> (BillInfo)billInfoByPkId.get(pkid)).collect(Collectors.toList())));
    }

    private void updateBillHeadVoucherInfo(Set<Long> billingIds, Voucher voucher) {
        QFilter filter = new QFilter("id", "in", billingIds);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)ErDapWbInvoiceConsumer.class.getCanonicalName(), (String)"er_billingpool", (String)"id, voucherentity.vouchernum vouchernum", (QFilter[])new QFilter[]{filter}, null);
        HashMap voucherMap = new HashMap(1);
        for (Row row : dataSet) {
            String num;
            Long billId = row.getLong("id");
            HashSet<String> voucherNums = (HashSet<String>)voucherMap.get(billId);
            if (voucherNums == null) {
                voucherNums = new HashSet<String>(1);
            }
            if ((num = row.getString("vouchernum")) != null && num.length() > 0) {
                voucherNums.add(num);
            }
            voucherMap.put(billId, voucherNums);
        }
        ArrayList<Object[]> headVoucherUpdateParams = new ArrayList<Object[]>(0);
        ArrayList<Object[]> headExtendTableParams = new ArrayList<Object[]>(0);
        for (Map.Entry entry : voucherMap.entrySet()) {
            Long billId = (Long)entry.getKey();
            boolean isGenVoucher = ((Set)entry.getValue()).size() > 0;
            headVoucherUpdateParams.add(new Object[]{Character.valueOf(isGenVoucher ? (char)'1' : '0'), billId});
            String voucherNums = InvoiceUtils.getLimitedLenStr(StringUtils.join((Iterable)((Iterable)entry.getValue()), (String)","), 500);
            headExtendTableParams.add(new Object[]{voucherNums, billId});
        }
        if (headVoucherUpdateParams.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)"update t_er_billingpool set fisgenvoucher = ? where fid =?", headVoucherUpdateParams);
            DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)"update t_er_billingpool_E set fvoucherno = ? where fid =?", headExtendTableParams);
        }
    }

    private void saveBillingPoolVoucherInfo(Voucher voucher) {
        block10: {
            try {
                Set<Long> billingIds = voucher.getBillInfos().stream().flatMap(v -> v.getBillingIds().stream()).collect(Collectors.toSet());
                if (billingIds.size() <= 0) break block10;
                QFilter idFilter = new QFilter("id", "in", billingIds);
                DataSet dataSet = QueryServiceHelper.queryDataSet((String)ErDapWbInvoiceConsumer.class.getCanonicalName(), (String)"er_billingpool", (String)"voucherentity.relbillid relbillid", (QFilter[])new QFilter[]{idFilter}, null);
                HashSet<Long> existIds = new HashSet<Long>(0);
                for (Row row : dataSet) {
                    Long id = row.getLong("relbillid");
                    if (id == null || id == 0L) continue;
                    existIds.add(id);
                }
                ArrayList<Object[]> insertParams = new ArrayList<Object[]>(billingIds.size());
                ArrayList<Object[]> updateParams = new ArrayList<Object[]>(billingIds.size());
                for (BillInfo billInfo : voucher.getBillInfos()) {
                    Date period = new Date();
                    try {
                        period = dateFormat.parse(voucher.getVoucherPeriod());
                    }
                    catch (Exception e) {
                        logger.error((Throwable)e);
                    }
                    for (Long billingId : billInfo.getBillingIds()) {
                        Object[] param;
                        if (existIds.contains(billInfo.getBillId())) {
                            param = new Object[]{voucher.getVoucherId(), voucher.getSubmitter(), period, voucher.getVouchertype(), voucher.getVoucherNo(), billInfo.getBillId()};
                            updateParams.add(param);
                            continue;
                        }
                        param = new Object[]{billingId, 0, period, voucher.getVouchertype(), voucher.getVoucherNo(), voucher.getSubmitter(), billInfo.getBillId(), billInfo.getEntityName(), billInfo.getBillNo(), voucher.getVoucherId()};
                        insertParams.add(param);
                    }
                }
                if (updateParams.size() > 0) {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)"update t_er_billingpool_voucher set fvoucherid = ?, fvouchercreator = ?, fperiod = ?, fvouchertype = ?, fvouchernum = ? where frelbillid =?", updateParams);
                }
                if (insertParams.size() > 0) {
                    this.insertNewRecords(insertParams);
                }
                this.updateBillHeadVoucherInfo(billingIds, voucher);
            }
            catch (Exception e) {
                logger.error("saveBillingPoolVoucherInfo error :", (Throwable)e);
            }
        }
    }

    private void saveVoucher(String entityName, Voucher voucher) {
        this.saveBillingPoolVoucherInfo(voucher);
        List billPkIds = voucher.billPks.stream().map(id -> String.valueOf(id)).collect(Collectors.toList());
        int total = billPkIds.size();
        Long invoiceOrgId = this.getAnyEnabledInvoiceOrgId(voucher);
        if (invoiceOrgId == null) {
            logger.info("\u5355\u636e\uff1a{}, id: {}\uff0c\u6ca1\u6709\u4e00\u4e2a\u627f\u62c5\u516c\u53f8\u542f\u7528\u53d1\u7968\u4e91", (Object)entityName, (Object)JSONArray.toJSONString(billPkIds));
            return;
        }
        for (int i = 0; i < total; i += 100) {
            if (i % 100 != 0) continue;
            List temp = null;
            temp = i < total - 100 ? billPkIds.subList(i, i + 100) : billPkIds.subList(i, total);
            SaveVoucherRequestParam saveRequestParam = new SaveVoucherRequestParam();
            saveRequestParam.setEntityName(entityName);
            saveRequestParam.setExpenseIdArray(new ArrayList<String>(temp));
            List<String> serialNos = voucher.billInfos.stream().flatMap(bill -> bill.serialNos.stream()).collect(Collectors.toList());
            saveRequestParam.setSerialNoArray(serialNos);
            saveRequestParam.setInvoiceOrgId(invoiceOrgId);
            SaveVoucherRequestParam.VoucherInfo voucherInfo = new SaveVoucherRequestParam.VoucherInfo();
            voucherInfo.setPeriod(voucher.voucherPeriod);
            voucherInfo.setAccountDate(voucher.bookedDate);
            voucherInfo.setBusinessDate(voucher.bizDate);
            voucherInfo.setVouchId(String.valueOf(voucher.voucherId));
            voucherInfo.setVouchNo(voucher.voucherNo);
            saveRequestParam.setVoucherInfo(voucherInfo);
            InvoiceService.getInstanceService().saveVoucherToInvoiceCloud(saveRequestParam, null);
        }
    }

    private void insertNewRecords(List<Object[]> newRecords) {
        String tableName = "t_er_billingpool_voucher";
        long[] ids = DB.genLongIds((String)tableName, (int)newRecords.size());
        for (int j = 0; j < ids.length; ++j) {
            newRecords.get((int)j)[1] = ids[j];
        }
        String insertSql = "insert into t_er_billingpool_voucher(fid, fentryid, fperiod, fvouchertype, fvouchernum, fvouchercreator, frelbillid, fentityid, frelbills, fvoucherid) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
        DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)insertSql, newRecords);
        newRecords.clear();
    }

    private void clearBillingPoolVoucher(Voucher voucher) {
        try {
            Long voucherId = voucher.getVoucherId();
            DB.execute((DBRoute)DBRoute.of((String)"er"), (String)String.format("update t_er_billingpool_voucher set fvoucherid = 0, fvouchernum = '', fvouchercreator = '', fperiod = null, fvouchertype = '' where fvoucherid = '%s'", voucherId.toString()));
            Set<Long> billingIds = voucher.getBillInfos().stream().flatMap(v -> v.getBillingIds().stream()).collect(Collectors.toSet());
            if (billingIds.size() > 0) {
                this.updateBillHeadVoucherInfo(billingIds, voucher);
            }
        }
        catch (Exception e) {
            logger.error("deleteBillingPoolVoucher error :", (Throwable)e);
        }
    }

    private void deleteVoucher(String entityName, Voucher voucher) {
        this.clearBillingPoolVoucher(voucher);
        List billPkIds = voucher.billPks.stream().map(id -> String.valueOf(id)).collect(Collectors.toList());
        int total = billPkIds.size();
        Long invoiceOrgId = this.getAnyEnabledInvoiceOrgId(voucher);
        if (invoiceOrgId == null) {
            logger.info("\u5355\u636e\uff1a{}, id: {}\uff0c\u6ca1\u6709\u4e00\u4e2a\u627f\u62c5\u516c\u53f8\u542f\u7528\u53d1\u7968\u4e91", (Object)entityName, (Object)JSONArray.toJSONString(billPkIds));
            return;
        }
        for (int i = 0; i < total; i += 100) {
            if (i % 100 != 0) continue;
            List temp = null;
            temp = i < total - 100 ? billPkIds.subList(i, i + 100) : billPkIds.subList(i, total);
            DeleteVoucherRequestParam deleteRequestParam = new DeleteVoucherRequestParam();
            deleteRequestParam.setEntityName(entityName);
            deleteRequestParam.setExpenseIdArray(new ArrayList<String>(temp));
            deleteRequestParam.setInvoiceOrgId(invoiceOrgId);
            deleteRequestParam.setVouchId(String.valueOf(voucher.voucherId));
            InvoiceService.getInstanceService().deleteVoucherInInvoiceCloud(deleteRequestParam, null);
        }
    }

    private List<Voucher> getVoucherInfoList(Map<Long, List<Long>> billPkMap, Map<Long, String> vchMap) {
        List<Object> billPks;
        HashMap<Long, ArrayList<Object>> voucherBillIdMap = new HashMap<Long, ArrayList<Object>>(billPkMap.size());
        HashSet<Long> voucherPks = new HashSet<Long>();
        for (Map.Entry<Long, List<Long>> e : billPkMap.entrySet()) {
            List<Long> voucherPkLst = e.getValue();
            Long billPk = e.getKey();
            for (Long voucherPk : voucherPkLst) {
                billPks = (ArrayList<Object>)voucherBillIdMap.get(voucherPk);
                if (billPks == null) {
                    billPks = new ArrayList<Object>();
                }
                billPks.add(billPk);
                voucherBillIdMap.put(voucherPk, (ArrayList<Object>)billPks);
            }
            voucherPks.addAll(voucherPkLst);
        }
        QFilter qFilter = new QFilter("id", "in", voucherPks);
        DynamicObjectCollection vouchers = QueryServiceHelper.query((String)"gl_voucher", (String)"id, billno, period.number, bizdate, bookeddate, submitter.name submitter, vouchertype.name vouchertype ", (QFilter[])new QFilter[]{qFilter});
        ArrayList<Voucher> voucherInfoList = new ArrayList<Voucher>();
        for (DynamicObject voucherDO : vouchers) {
            Long voucherId = voucherDO.getLong("id");
            billPks = (List)voucherBillIdMap.get(voucherId);
            String voucherNo = voucherDO.getString("billno");
            String voucherNewNo = vchMap.get(voucherId);
            if (voucherNewNo != null) {
                voucherNo = voucherNewNo;
            }
            String voucherPeriod = voucherDO.getString("period.number");
            Voucher voucher = new Voucher(voucherId, voucherNo, voucherPeriod, billPks);
            voucher.setBizDate(voucherDO.getDate("bizdate"));
            voucher.setBookedDate(voucherDO.getDate("bookeddate"));
            voucher.setSubmitter(voucherDO.getString("submitter"));
            voucher.setVouchertype(voucherDO.getString("vouchertype"));
            voucherInfoList.add(voucher);
        }
        HashSet voucherPksCopy = new HashSet(voucherPks);
        Set voucherPksFromDB = voucherInfoList.stream().map(v -> v.voucherId).collect(Collectors.toSet());
        voucherPksCopy.removeAll(voucherPksFromDB);
        for (Long voucherId : voucherPksCopy) {
            Voucher voucher = new Voucher();
            voucher.voucherId = voucherId;
            List billPks2 = (List)voucherBillIdMap.get(voucherId);
            voucher.setBillPks(billPks2);
            voucherInfoList.add(voucher);
        }
        return voucherInfoList;
    }

    private Long getAnyEnabledInvoiceOrgId(Voucher voucher) {
        for (BillInfo billInfo : voucher.billInfos) {
            Long costCompanyId = billInfo.invoiceOrgId;
            InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig(costCompanyId);
            if (config == null) continue;
            return costCompanyId;
        }
        return null;
    }

    private static class BillInfo {
        Long billId;
        String billNo;
        String entityName;
        Long invoiceOrgId;
        List<String> serialNos = new LinkedList<String>();
        Set<Long> billingIds = new HashSet<Long>(0);

        private BillInfo() {
        }

        public Long getBillId() {
            return this.billId;
        }

        public void setBillId(Long billId) {
            this.billId = billId;
        }

        public Long getInvoiceOrgId() {
            return this.invoiceOrgId;
        }

        public void setInvoiceOrgId(Long invoiceOrgId) {
            this.invoiceOrgId = invoiceOrgId;
        }

        public List<String> getSerialNos() {
            return this.serialNos;
        }

        public void setSerialNos(List<String> serialNos) {
            this.serialNos = serialNos;
        }

        public void setBillingIds(Set<Long> billingIds) {
            this.billingIds = billingIds;
        }

        public Set<Long> getBillingIds() {
            return this.billingIds;
        }

        public String getBillNo() {
            return this.billNo;
        }

        public void setBillNo(String billNo) {
            this.billNo = billNo;
        }

        public String getEntityName() {
            return this.entityName;
        }

        public void setEntityName(String entityName) {
            this.entityName = entityName;
        }
    }

    private static class Voucher {
        String voucherNo;
        String voucherPeriod;
        List<Long> billPks;
        List<BillInfo> billInfos = new LinkedList<BillInfo>();
        Long voucherId;
        Date bizDate;
        Date bookedDate;
        String submitter;
        String vouchertype;

        public Voucher(Long voucherId, String voucherNo, String voucherPeriod, List<Long> billPks) {
            this.voucherNo = voucherNo;
            this.voucherPeriod = voucherPeriod;
            this.billPks = billPks;
            this.voucherId = voucherId;
        }

        public Voucher() {
        }

        public String getVoucherNo() {
            return this.voucherNo;
        }

        public void setVoucherNo(String voucherNo) {
            this.voucherNo = voucherNo;
        }

        public String getVoucherPeriod() {
            return this.voucherPeriod;
        }

        public void setVoucherPeriod(String voucherPeriod) {
            this.voucherPeriod = voucherPeriod;
        }

        public List<Long> getBillPks() {
            return this.billPks;
        }

        public void setBillPks(List<Long> billPks) {
            this.billPks = billPks;
        }

        public List<BillInfo> getBillInfos() {
            return this.billInfos;
        }

        public void setBillInfos(List<BillInfo> billInfos) {
            this.billInfos = billInfos;
        }

        public Long getVoucherId() {
            return this.voucherId;
        }

        public void setVoucherId(Long voucherId) {
            this.voucherId = voucherId;
        }

        public Date getBizDate() {
            return this.bizDate;
        }

        public void setBizDate(Date bizDate) {
            this.bizDate = bizDate;
        }

        public Date getBookedDate() {
            return this.bookedDate;
        }

        public void setBookedDate(Date bookedDate) {
            this.bookedDate = bookedDate;
        }

        public String getSubmitter() {
            return this.submitter;
        }

        public void setSubmitter(String submitter) {
            this.submitter = submitter;
        }

        public String getVouchertype() {
            return this.vouchertype;
        }

        public void setVouchertype(String vouchertype) {
            this.vouchertype = vouchertype;
        }
    }
}

