/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.fi.er.business.invoicecloud.cache.model.InvoiceCloudCfgBO;
import kd.fi.er.business.invoicecloud.kingdee.APIHelper;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.invoicecloud.kingdee.action.QueryBySerialNoAction;
import kd.fi.er.common.utils.Er;

public class DevUtilsFormPlugin
extends AbstractBillPlugIn {
    private String[] getBtns() {
        return new String[]{"getinvoicejson", "gotoinvcfg"};
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setShortCuts();
        this.getView().setVisible(Boolean.valueOf(false), this.getBtns());
    }

    private void setShortCuts() {
        JSONArray arrayItem = new JSONArray();
        JSONObject item = new JSONObject();
        item.put("type", (Object)"keyUp");
        item.put("shortCuts", (Object)"shift+m");
        arrayItem.add((Object)item);
        IFormView formView = this.getView();
        IClientViewProxy clientViewProxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
        JSONArray action = new JSONArray();
        action.add((Object)arrayItem);
        clientViewProxy.addAction("setShortCuts", (Object)action);
    }

    public void customEvent(CustomEventArgs e) {
        String key;
        super.customEvent(e);
        if (e.getEventName().equalsIgnoreCase("shortCuts") && "[16,77]".equals(key = e.getEventArgs())) {
            this.getView().setVisible(Boolean.valueOf(true), this.getBtns());
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("getinvoicejson".equals(key)) {
            this.getInvoiceJson();
        } else if ("gotoinvcfg".equals(key)) {
            this.gotoInvCfg();
        }
    }

    private void gotoInvCfg() {
        DynamicObject costCompanyDO = (DynamicObject)this.getModel().getValue("costcompany");
        long orgId = (Long)costCompanyDO.getPkValue();
        InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig(orgId);
        if (config == null) {
            return;
        }
        long id = config.getId();
        String entityName = config.getEntityName();
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setPkId((Object)id);
        parameter.setFormId(entityName);
        parameter.setParentFormId(this.getView().getFormShowParameter().getParentFormId());
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setBillStatus(BillOperationStatus.EDIT);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setAppId(this.getView().getFormShowParameter().getAppId());
        parameter.setHasRight(true);
        HashMap<String, String> customMap = new HashMap<String, String>(4);
        customMap.put("hiddenTbmain", "false");
        parameter.setCustomParams(customMap);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void getInvoiceJson() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("invoiceentry");
        int[] rows = entryGrid.getSelectRows();
        if (rows.length == 0) {
            this.getView().showTipNotification("select rows first!");
            return;
        }
        ArrayList<String> serialNoLst = new ArrayList<String>();
        IDataModel model = this.getModel();
        for (int row : rows) {
            Object serialNo = model.getValue("serialno", row);
            if (serialNo == null) continue;
            serialNoLst.add(serialNo.toString());
        }
        String serialNos = Er.join(serialNoLst, (String)",");
        DynamicObject costCompanyDO = (DynamicObject)this.getModel().getValue("costcompany");
        long orgId = (Long)costCompanyDO.getPkValue();
        InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig(orgId);
        QueryBySerialNoAction queryAction = new QueryBySerialNoAction(serialNos);
        queryAction.setTaxNo(config.getTaxRegnum());
        queryAction.setCompanyName(config.getFirmname());
        queryAction.setBxdKey(APIHelper.getBillNoCachedInCloud(this.getModel().getDataEntity()));
        queryAction.setInvoiceOrgId(orgId);
        String content = queryAction.execute();
        try {
            String appNumberFile = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl("invoice.json", content.getBytes("utf-8"), 5000);
            this.getView().openUrl(appNumberFile);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

