/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.Control;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.er.common.utils.Er;

public class ErKSQLExpPlugin
extends AbstractFormPlugin {
    private static final String ALGO = ErKSQLExpPlugin.class.getName();
    private static final Object CR = "\r\n";

    public void preOpenForm(PreOpenFormEventArgs e) {
        boolean adminUser;
        super.preOpenForm(e);
        long userId = RequestContext.get().getCurrUserId();
        boolean isSuperAdmin = PermissionServiceHelper.isAdminUser((long)userId, (String)"10");
        if (!isSuperAdmin && !(adminUser = PermissionServiceHelper.isAdminUser((long)userId))) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u6743\u9650\u4f7f\u7528\u8be5\u529f\u80fd\u3002", (String)"ErKSQLExpPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
        }
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"fillfields", "genId", "exportentity"});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "fillfields": {
                this.fillFields();
                break;
            }
            case "genid": {
                this.genId();
                break;
            }
            case "exportentity": {
                break;
            }
        }
    }

    private Map<String, String[]> getTableMap(String strWhere) {
        IDataModel model = this.getModel();
        String entityName = model.getValue("entityname").toString();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        String routefield = dataEntityType.getDBRouteKey();
        Map allEntities = dataEntityType.getAllEntities();
        Set entrySet = allEntities.entrySet();
        LinkedHashMap<String, String[]> tableMap = new LinkedHashMap<String, String[]>(allEntities.size());
        for (Map.Entry mapEntry : entrySet) {
            EntityType entityType = (EntityType)mapEntry.getValue();
            if (entityType instanceof LinkEntryType) continue;
            String displayName = entityType.getDisplayName().toString();
            String tableName = entityType.getAlias();
            if (StringUtils.isEmpty((CharSequence)tableName)) continue;
            String strWhere2 = strWhere;
            if (strWhere != null && entityType instanceof SubEntryType) {
                SubEntryType subEntryType = (SubEntryType)entityType;
                IDataEntityType parentType = subEntryType.getParent();
                String sql = "select %s from %s where %s";
                String parentKeyField = parentType.getPrimaryKey().getAlias();
                sql = String.format(sql, parentKeyField, parentType.getAlias(), strWhere);
                ArrayList<Object> parentKeyValues = new ArrayList<Object>();
                try (DataSet ds = DB.queryDataSet((String)ALGO, (DBRoute)DBRoute.of((String)routefield), (String)sql);){
                    for (Row row : ds) {
                        parentKeyValues.add(row.get(parentKeyField));
                    }
                }
                strWhere2 = String.format("%s in (%s)", parentKeyField, Er.join(parentKeyValues, (String)","));
            }
            tableMap.put(displayName + ": " + tableName, new String[]{tableName, strWhere2});
            DataEntityPropertyCollection properties = entityType.getProperties();
            for (IDataEntityProperty property : properties) {
                if (!(property instanceof MulBasedataProp)) continue;
                MulBasedataProp mulBdProp = (MulBasedataProp)property;
                String tableName2 = mulBdProp.getAlias();
                String displayName2 = mulBdProp.getDisplayName().toString();
                String pPKField2 = entityType.getPrimaryKey().getAlias();
                displayName2 = String.format("%s.%s: %s", displayName, displayName2, tableName2);
                tableMap.put(displayName2, new String[]{tableName2, tableName, pPKField2});
                System.out.println();
            }
            boolean hasMultiLang = entityType.getProperties().stream().anyMatch(v -> v instanceof MuliLangTextProp);
            if (!hasMultiLang) continue;
            tableName = tableName + "_L";
            tableMap.put(displayName + "\uff08MultiLang\uff09: " + tableName, new String[]{tableName, strWhere2});
        }
        return tableMap;
    }

    private void fillFields() {
        IDataModel model = this.getModel();
        Object routeField = model.getValue("routefield");
        Object fromField = model.getValue("fromfield");
        Object entityname = model.getValue("entityname");
        if (!ObjectUtils.isEmpty((Object)fromField)) {
            String selectfield = this.getTableFields(DBRoute.of((String)routeField.toString()), fromField);
            model.setValue("selectfield", (Object)selectfield);
        } else if (!ObjectUtils.isEmpty((Object)entityname)) {
            Map<String, String[]> tableMap = this.getTableMap(null);
            ArrayList<String> outputLst = new ArrayList<String>(tableMap.size());
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityname.toString());
            for (String[] mapValue : tableMap.values()) {
                String tableName = mapValue[0];
                outputLst.add(String.format("%s=%s", tableName, this.getTableFields(DBRoute.of((String)dataEntityType.getDBRouteKey()), tableName)));
            }
            model.setValue("selectfield2_tag", (Object)Er.join(outputLst, (String)"\n"));
            model.setValue("selectfield2", (Object)"filled");
        }
    }

    private String getTableFields(DBRoute dbRoute, Object tableName) {
        String sql = String.format("/*dialect*/select * from %s where 1=2", tableName.toString());
        DataSet ds = DB.queryDataSet((String)"ErKSQLExpPlugin", (DBRoute)dbRoute, (String)sql);
        String selectfield = Stream.of(ds.getRowMeta().getFields()).map(Field::getName).collect(Collectors.joining(","));
        return selectfield;
    }

    private void genId() {
        IDataModel model = this.getModel();
        int count = Integer.parseInt(model.getValue("selectfield").toString());
        String tableName = model.getValue("fromfield").toString();
        long[] longIds = DB.genLongIds((String)tableName, (int)count);
        StringBuilder text = new StringBuilder();
        for (long longId : longIds) {
            text.append(longId).append("\n");
        }
        CodeEdit sqlEditor = (CodeEdit)this.getControl("ksqltext");
        sqlEditor.setText(text.toString());
    }
}

