/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.web.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class DateUtils {
    private static final String YMD = "yyyy-MM-dd";
    private static final Log logger = LogFactory.getLog(DateUtils.class);

    public static Date delayByMonth(Date date, int delayMonth) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int month = cal.get(2);
        cal.set(2, month + delayMonth);
        return cal.getTime();
    }

    public static String getTime() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("hh:mm:ss");
        return simpleDateFormat.format(Calendar.getInstance().getTime());
    }

    public static String getDate() {
        SimpleDateFormat sdf = new SimpleDateFormat(YMD);
        return sdf.format(Calendar.getInstance().getTime());
    }

    public static String getTime(Calendar calendar) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
        return simpleDateFormat.format(calendar.getTime());
    }

    public static String getDate(Calendar calendar) {
        SimpleDateFormat sdf = new SimpleDateFormat(YMD);
        return sdf.format(calendar.getTime());
    }

    public static String getDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(YMD);
        return sdf.format(date);
    }

    public static String getWeek() {
        String[] weeks = DateUtils.getWeeks();
        return weeks[6];
    }

    public static String getWeek(Calendar calendar) {
        String[] weeks = DateUtils.getWeeks();
        return weeks[calendar.get(7) - 1];
    }

    private static String[] getWeeks() {
        return new String[]{ResManager.loadKDString((String)"\u661f\u671f\u65e5", (String)"DateUtils_0", (String)"fi-er-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u661f\u671f\u4e00", (String)"DateUtils_1", (String)"fi-er-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u661f\u671f\u4e8c", (String)"DateUtils_2", (String)"fi-er-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u661f\u671f\u4e09", (String)"DateUtils_3", (String)"fi-er-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u661f\u671f\u56db", (String)"DateUtils_4", (String)"fi-er-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u661f\u671f\u4e94", (String)"DateUtils_5", (String)"fi-er-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u661f\u671f\u516d", (String)"DateUtils_6", (String)"fi-er-business", (Object[])new Object[0])};
    }

    public static Calendar str2Date(String date) {
        Calendar newTime = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(YMD);
        try {
            newTime.setTime(sdf.parse(date));
            return newTime;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return null;
        }
    }

    public static Calendar setTime(Calendar calendar, int hour, int minute, int second) {
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        return calendar;
    }

    public static double secondsBetween(Calendar calendar) {
        return (calendar.getTimeInMillis() - Calendar.getInstance().getTimeInMillis()) / 1000L;
    }

    public static double secondsBetween(Calendar calendar1, Calendar calendar2) {
        return (calendar1.getTimeInMillis() - calendar2.getTimeInMillis()) / 1000L;
    }

    public static double minutesBetween(Calendar calendar) {
        return DateUtils.secondsBetween(calendar) / 60.0;
    }

    public static double minutesBetween(Calendar calendar1, Calendar calendar2) {
        return DateUtils.secondsBetween(calendar1, calendar2) / 60.0;
    }

    public static double hoursBetween(Calendar calendar) {
        return DateUtils.minutesBetween(calendar) / 60.0;
    }

    public static double hoursBetween(Calendar calendar1, Calendar calendar2) {
        return DateUtils.minutesBetween(calendar1, calendar2) / 60.0;
    }

    public static double daysBetween(Calendar calendar) {
        return DateUtils.hoursBetween(calendar) / 24.0;
    }

    public static double daysBetween(Calendar calendar1, Calendar calendar2) {
        return DateUtils.hoursBetween(calendar1, calendar2) / 24.0;
    }

    public static Date dateFomat(String dateStr, String dateFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        try {
            Date date = sdf.parse(dateStr);
            return date;
        }
        catch (ParseException e) {
            logger.info("DateUtils_dateFomat>>> dateStr:" + dateStr + ",dateFormat:" + dateFormat + " ,exmsg:" + e.getMessage());
            return null;
        }
    }
}

