/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.web.util;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.CreditLevelServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import org.apache.commons.lang.StringUtils;

public class ShowUserInfoUtils {
    public static final String CHANGE_APPLIER = "changeapplier";

    public static void initUserInfo(IDataModel model, IFormView view) {
        String applierStr = null;
        String deptStr = null;
        String applierPicUrl = null;
        String positionStr = null;
        DynamicObject applier = (DynamicObject)model.getValue("applier");
        if (applier == null) {
            Object value;
            RequestContext requestContext = RequestContext.get();
            Long currentUserID = Long.valueOf(requestContext.getUserId());
            Map<String, Object> billMap = CoreBaseBillServiceHelper.createNewData(currentUserID);
            CoreBaseBillServiceHelper.extService(view, billMap);
            if (model.getProperty("costcompany") != null && (value = model.getValue("costcompany")) != null) {
                billMap.put("costcompany", ErCommonUtils.getPk(value));
            }
            CoreBaseBillServiceHelper.initObjByMap(model, billMap);
            if (model.getProperty("currency") != null && model.getValue("currency") == null) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u672c\u4f4d\u5e01\u3002", (String)"ShowUserInfoUtils_0", (String)"fi-er-business", (Object[])new Object[0]));
            }
            if (model.getValue("company") == null) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ShowUserInfoUtils_1", (String)"fi-er-business", (Object[])new Object[0]));
            }
            applier = (DynamicObject)model.getValue("applier");
        }
        DynamicObject dept = (DynamicObject)model.getValue("org");
        Object applierPositionText = model.getValue("applierpositionstr");
        String telStr = (String)model.getValue("tel");
        if (applier != null) {
            applierStr = applier.getLocaleString("name").getLocaleValue();
            applierPicUrl = ErCommonUtils.getUserImageFullPath((Long)applier.getPkValue());
        }
        if (applierPositionText != null) {
            positionStr = ObjectUtils.nullSafeToString((Object)applierPositionText);
        }
        if (dept != null) {
            deptStr = dept.getLocaleString("name").getLocaleValue();
        }
        ((Label)view.getControl("applierv")).setText(applierStr);
        ((Label)view.getControl("orgv")).setText(deptStr);
        ((Label)view.getControl("telv")).setText(telStr);
        view.updateView("tel");
        ((Label)view.getControl("applierpositionv")).setText(positionStr);
        Image applierPic = (Image)view.getControl("applierpic");
        applierPic.setUrl(applierPicUrl);
        if (applier != null) {
            String appilerIdStr = String.valueOf(applier.getPkValue());
            String creditlevelStr = CreditLevelServiceHelper.getCreditLevelByUserAndView(appilerIdStr, view);
            if (StringUtils.isEmpty((String)creditlevelStr)) {
                view.setVisible(Boolean.valueOf(false), new String[]{"creditlevel"});
            } else {
                ((Label)view.getControl("creditlevel")).setText(creditlevelStr);
            }
        }
    }

    public static void loadUserData(IDataModel model) {
        DynamicObject applier = (DynamicObject)model.getValue("applier");
        Long currentUserID = Long.valueOf("" + applier.getPkValue());
        Map<String, Object> billMap = CommonServiceHelper.getUserMap(currentUserID);
        model.setValue("applierpositionstr", billMap.get("applierpositionstr"));
    }

    public static void hiddenChangeApplier(IFormView view) {
        if (ErEntityTypeUtils.isRepaymentBill(view.getEntityId())) {
            view.setVisible(Boolean.valueOf(false), new String[]{CHANGE_APPLIER});
        }
    }
}

