/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.web.workflow;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.sysint.servicehelper.SysIntegrationServiceHelper;
import kd.bos.workflow.component.ApprovalRecord;
import kd.bos.workflow.component.IApprovalRecord;
import kd.fi.er.business.isc.IscHelper;
import kd.fi.er.business.servicehelper.ApproveRecoderServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class ErDailyWorkFlowService {
    private static final Log logger = LogFactory.getLog(ErDailyWorkFlowService.class);
    public static final String APPROVAL_RECORD_CONTROL = "approvalrecordap";

    public static void noApprovel(IFormView view) {
        ApprovalRecord record = (ApprovalRecord)view.getControl(APPROVAL_RECORD_CONTROL);
        if (record != null) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("noAutoFillData", "noAutoFillData");
            record.setParameters(parameters);
        }
    }

    public static boolean isNoApproval(IDataModel model, IFormView view) {
        BillOperationStatus status = BillOperationStatus.VIEW;
        if (view.getFormShowParameter() instanceof BillShowParameter) {
            status = ((BillShowParameter)view.getFormShowParameter()).getBillStatus();
            BillShowParameter billShow = (BillShowParameter)view.getFormShowParameter();
            Object businessKey = billShow.getPkId();
            String billStatus = (String)model.getValue("billstatus");
            boolean isInProcess = true;
            if (businessKey != null && StringUtils.isNotBlank((CharSequence)businessKey.toString())) {
                logger.info("\u5f00\u59cb\u8c03\u7528\u5de5\u4f5c\u6d41inProcess");
                isInProcess = WorkflowServiceHelper.inProcess((String)businessKey.toString());
                logger.info("\u7ed3\u675f\u8c03\u7528\u5de5\u4f5c\u6d41inProcess");
            }
            return billStatus != null && "A".equals(billStatus) && !isInProcess || BillOperationStatus.ADDNEW.compareTo((Enum)status) == 0 || CommonServiceHelper.isSSC(view) || CommonServiceHelper.isSCENE(view);
        }
        FormShowParameter showParameter = view.getFormShowParameter();
        Object billId = showParameter.getCustomParam("billId");
        Object billStatus = showParameter.getCustomParam("Status");
        if (billId != null && StringUtils.isNotBlank((CharSequence)billId.toString())) {
            logger.info("\u5f00\u59cb\u8c03\u7528\u5de5\u4f5c\u6d41inProcess");
            boolean inProcess = WorkflowServiceHelper.inProcess((String)billId.toString());
            logger.info("\u7ed3\u675f\u8c03\u7528\u5de5\u4f5c\u6d41inProcess");
            if ("1".equals(billStatus) && !inProcess) {
                return true;
            }
        }
        return false;
    }

    public static void showApprovelFromEas(IFormView view, String entityName, Object businessKey) {
        Object[] approves = ErDailyWorkFlowService.getEASAppApproves(entityName, businessKey);
        if (approves != null) {
            ErDailyWorkFlowService.buildApprovalRecord(view, Long.valueOf(businessKey.toString()), entityName, approves);
        }
    }

    public static Object[] getEASAppApproves(String entityName, Object businessKey) {
        String easId;
        Map<String, Object> easInfo = IscHelper.getEasId(entityName, businessKey);
        if (easInfo != null && StringUtils.isNotBlank((CharSequence)(easId = (String)easInfo.get("data")))) {
            try {
                DynamicObject connection = (DynamicObject)easInfo.get("TAR_LINK");
                Map<String, Object> linkMap = IscHelper.buildIscLinkMap(connection);
                if (linkMap == null || linkMap.size() < 1) {
                    logger.info("\u83b7\u53d6\u76ee\u6807\u7cfb\u7edf\u5de5\u4f5c\u6d41\u5931\u8d25:\u672a\u83b7\u53d6\u5230\u76ee\u6807\u7cfb\u7edf\u8fde\u63a5\u914d\u7f6e\u4fe1\u606f,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
                    return null;
                }
                String ret = IscHelper.getEasApproves(easId);
                return ErDailyWorkFlowService.consoleApprove(ret);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
        return null;
    }

    public static List<Map<String, Object>> getEASApprovalRecordItems(String entityName, Object businessKey) {
        Object[] easAppApproves = ErDailyWorkFlowService.getEASAppApproves(entityName, businessKey);
        if (easAppApproves != null) {
            return ErDailyWorkFlowService.getApprovalRecordItems(easAppApproves);
        }
        return null;
    }

    public static List<Map<String, Object>> getApprovalRecordItems(Object[] objs) {
        ArrayList<Map<String, Object>> approvalRecordItems = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < objs.length; ++i) {
            HashMap<String, Object> approvalRecordItem = new HashMap<String, Object>();
            ArrayList childrenItems = new ArrayList();
            HashMap<String, Object> childrenItem = new HashMap<String, Object>();
            Map approveHst = new HashMap();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String personname = "";
            String resultName = "";
            Boolean ispass = true;
            if (i == 0) {
                approvalRecordItem.put("group", "startGroup");
                approvalRecordItem.put("groupDecisionType", "approve");
                approveHst = (Map)objs[0];
                Long personId = (Long)approveHst.get("personid");
                if (personId != null) {
                    DynamicObject user = CommonServiceHelper.getObjById("bos_user", personId);
                    if (user != null) {
                        personname = user.getString("name");
                        childrenItem.put("userName", personname);
                        childrenItem.put("openId", user.get("useropenid"));
                        childrenItem.put("avatar", user.get("picturefield"));
                    }
                } else {
                    personname = (String)approveHst.get("personname");
                    childrenItem.put("userName", personname);
                    childrenItem.put("openId", "");
                    childrenItem.put("avatar", "");
                }
                resultName = ResManager.loadKDString((String)"\u63d0\u51fa\u7533\u8bf7", (String)"ErDailyWorkFlowService_0", (String)"fi-er-business", (Object[])new Object[0]);
                childrenItem.put("resultName", resultName);
                childrenItem.put("aactdefname", approveHst.getOrDefault("aactdefname", ""));
                Date timestamp = (Date)approveHst.get("createtime");
                if (timestamp != null) {
                    childrenItem.put("time", dateFormat.format(timestamp));
                }
                childrenItem.put("message", approveHst.get("opinion"));
                childrenItems.add(childrenItem);
                approvalRecordItem.put("children", childrenItems);
                approvalRecordItems.add(approvalRecordItem);
                continue;
            }
            if (i == 1) {
                List approveList = (List)objs[1];
                if (approveList.size() == 0) continue;
                for (int j = 0; j < approveList.size(); ++j) {
                    approvalRecordItem = new HashMap();
                    childrenItems = new ArrayList();
                    childrenItem = new HashMap();
                    approvalRecordItem.put("group", "approved");
                    approvalRecordItem.put("groupDecisionType", "approve");
                    approveHst = (Map)approveList.get(j);
                    ispass = (Boolean)approveHst.get("ispass");
                    Long personId = (Long)approveHst.get("personid");
                    if (personId != null) {
                        DynamicObject user = CommonServiceHelper.getObjById("bos_user", personId);
                        if (user != null) {
                            personname = user.getString("name");
                            childrenItem.put("userName", personname);
                            childrenItem.put("openId", user.get("useropenid"));
                            childrenItem.put("avatar", user.get("picturefield"));
                        }
                    } else {
                        personname = (String)approveHst.get("personname");
                        childrenItem.put("userName", personname);
                        childrenItem.put("openId", "");
                        childrenItem.put("avatar", "");
                    }
                    if (ispass.booleanValue()) {
                        Object aactdefname = approveHst.get("aactdefname");
                        resultName = ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"ErDailyWorkFlowService_1", (String)"fi-er-business", (Object[])new Object[0]).equals(aactdefname) ? (String)aactdefname : ResManager.loadKDString((String)"\u5df2\u901a\u8fc7\u5ba1\u6279", (String)"ErDailyWorkFlowService_2", (String)"fi-er-business", (Object[])new Object[0]);
                        childrenItem.put("decisionType", "approve");
                    } else {
                        resultName = ResManager.loadKDString((String)"\u5ba1\u6279\u4e0d\u901a\u8fc7", (String)"ErDailyWorkFlowService_3", (String)"fi-er-business", (Object[])new Object[0]);
                        childrenItem.put("decisionType", "reject");
                    }
                    childrenItem.put("resultName", resultName);
                    childrenItem.put("aactdefname", approveHst.getOrDefault("aactdefname", ""));
                    Date timestamp = (Date)approveHst.get("createtime");
                    if (timestamp != null) {
                        childrenItem.put("time", dateFormat.format(timestamp));
                    }
                    childrenItem.put("message", approveHst.get("opinion"));
                    childrenItems.add(childrenItem);
                    approvalRecordItem.put("children", childrenItems);
                    approvalRecordItems.add(approvalRecordItem);
                }
                continue;
            }
            if (i != 2) continue;
            approvalRecordItem.put("group", "currentGroup");
            approvalRecordItem.put("groupDecisionType", "wait");
            List nextorList = (List)objs[2];
            if (nextorList.size() == 0) continue;
            approveHst = (Map)nextorList.get(nextorList.size() - 1);
            Long personId = (Long)approveHst.get("personid");
            if (personId != null) {
                DynamicObject user = CommonServiceHelper.getObjById("bos_user", personId);
                if (user != null) {
                    personname = user.getString("name");
                    childrenItem.put("userName", "");
                    childrenItem.put("openId", user.get("useropenid"));
                    childrenItem.put("avatar", user.get("picturefield"));
                }
            } else {
                personname = (String)approveHst.get("personname");
                childrenItem.put("userName", "");
                childrenItem.put("openId", "");
                childrenItem.put("avatar", "");
            }
            resultName = String.format(ResManager.loadKDString((String)"\u7b49\u5f85%s\u5ba1\u6279", (String)"ErDailyWorkFlowService_4", (String)"fi-er-business", (Object[])new Object[0]), personname);
            childrenItem.put("resultName", resultName);
            Date timestamp = (Date)approveHst.get("createtime");
            if (timestamp != null) {
                childrenItem.put("time", dateFormat.format(timestamp));
            }
            childrenItem.put("message", approveHst.get("opinion"));
            childrenItems.add(childrenItem);
            approvalRecordItem.put("children", childrenItems);
            approvalRecordItems.add(approvalRecordItem);
        }
        return approvalRecordItems;
    }

    public static void buildApprovalRecord(IFormView view, Long nextId, String entityName, Object[] objs) {
        view.setVisible(Boolean.valueOf(false), new String[]{"imageap", "labelap"});
        logger.info("print objs................" + Arrays.toString(objs));
        List<Map<String, Object>> approvalRecordItems = ErDailyWorkFlowService.getApprovalRecordItems(objs);
        if (!approvalRecordItems.isEmpty()) {
            IApprovalRecord approvalRecord = (IApprovalRecord)view.getControl(APPROVAL_RECORD_CONTROL);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("hideMoreChat", "true");
            parameters.put("isPC", "false");
            approvalRecord.setParameters(parameters);
            approvalRecord.setData(approvalRecordItems);
            Map<String, Object> shareParams = ApproveRecoderServiceHelper.setParamBeaforeShareReqBill(entityName, nextId.toString());
            approvalRecord.setShareParams(shareParams);
            logger.info("print approvalRecordItems:{}, bill's pkid is:{}, shareParam value:{}", new Object[]{approvalRecordItems, nextId.toString(), shareParams});
        }
    }

    public static Object[] consoleApprove(String json) {
        long t3 = System.currentTimeMillis();
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            JsonNode root = (JsonNode)objectMapper.readValue(json, JsonNode.class);
            int size = root.size();
            if (size == 0) {
                return null;
            }
            HashMap<String, Object> originator = new HashMap<String, Object>();
            ArrayList<Map<String, Object>> approveList = new ArrayList<Map<String, Object>>();
            ArrayList<Map<String, Object>> nextorList = new ArrayList<Map<String, Object>>();
            for (int idx = 0; idx < size; ++idx) {
                JsonNode node = root.get(idx);
                if ("0".equals(node.get("type").toString())) {
                    ErDailyWorkFlowService.convert2Map(node, originator, new String[]{"personid", "personname", "personnumber", "adminname", "admindisplayname", "createtime", "aactdefname"});
                    continue;
                }
                if ("1".equals(node.get("type").toString())) {
                    HashMap<String, Object> approve = new HashMap<String, Object>();
                    ErDailyWorkFlowService.convert2Map(node, approve, new String[]{"personid", "personname", "personnumber", "adminname", "admindisplayname", "createtime", "ispass", "opinion", "aactdefname"});
                    ErDailyWorkFlowService.addListMap(approveList, approve, node);
                    continue;
                }
                if (!"2".equals(node.get("type").toString())) continue;
                HashMap<String, Object> nextor = new HashMap<String, Object>();
                ErDailyWorkFlowService.convert2Map(node, nextor, new String[]{"personid", "personname", "personnumber", "adminname", "admindisplayname"});
                ErDailyWorkFlowService.addListMap(nextorList, nextor, node);
            }
            return new Object[]{originator, approveList, nextorList};
        }
        catch (Exception e) {
            logger.error("consoleApprove:", (Throwable)e);
            logger.info("consoleApprove.time: " + (System.currentTimeMillis() - t3));
            return null;
        }
    }

    private static void convert2Map(JsonNode node, Map<String, Object> map, String[] fields) {
        for (String field : fields) {
            JsonNode jn = node.get(field);
            if (jn == null) continue;
            if ("createtime".equals(field)) {
                map.put(field, new Date(jn.longValue()));
                continue;
            }
            if ("ispass".equals(field)) {
                map.put(field, "true".equals(jn.textValue()));
                continue;
            }
            if ("personid".equals(field)) {
                map.put(field, ErDailyWorkFlowService.getNGUserByPerson(jn.textValue()));
                continue;
            }
            map.put(field, jn.textValue());
        }
    }

    private static void addListMap(List<Map<String, Object>> personMapList, Map<String, Object> person, JsonNode node) {
        if (person.get("personid") == null) {
            logger.info(String.format("\u7528\u6237\u3010%s\u3011\u67e5\u8be2\u6620\u5c04\u8868\u5931\u8d25\uff0cid=%s", node.get("personname").textValue(), node.get("personid").textValue()));
            personMapList.add(person);
        } else {
            personMapList.add(person);
        }
    }

    private static Long getNGUserByPerson(String id) {
        String entityType = "bos_person";
        long t = System.currentTimeMillis();
        Map internalData = SysIntegrationServiceHelper.getInternalData((Long)1L, (String)entityType, (String)(id == null ? "" : id.toString()), null, null);
        logger.info(String.format("calling getNGUserByPerson time:%1$s,SysIntegrationServiceHelper.getInternalData:String id=%2$s,String entityType=%3$s ret=%4$s", System.currentTimeMillis() - t, id, entityType, internalData == null ? "{}" : internalData.toString()));
        if (internalData.containsKey("id")) {
            return Long.valueOf(((String)internalData.get("id")).toString());
        }
        return null;
    }

    private static Map<String, Object> getChildrenMap(String openId, String avatar, String decisionType, String time, String userName, String message, String resultName) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("openId", openId);
        hashMap.put("avatar", avatar);
        hashMap.put("decisionType", decisionType);
        hashMap.put("userName", userName);
        hashMap.put("message", message);
        hashMap.put("resultName", resultName);
        try {
            if (time != null) {
                hashMap.put("time", new SimpleDateFormat("YYYY - MM - DD HH:mm:ss").parse(time));
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return hashMap;
    }

    private static Map<String, Object> getApproveItemMap(String group, String groupDecisionType, Object children) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("group", group);
        hashMap.put("groupDecisionType", groupDecisionType);
        hashMap.put("children", children);
        return hashMap;
    }
}

