/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web.tripboards.factory;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import kd.fi.er.formplugin.web.tripboards.ChartConfig;

public class ChartFactory {
    public static Map<String, Object> createChart(String type, ChartConfig config) {
        switch (type) {
            case "BAR": 
            case "LINE": {
                return ChartFactory.createBarChart(config);
            }
            case "PIE": {
                return ChartFactory.createPieChart(config);
            }
        }
        throw new IllegalArgumentException("Unsupported chart type: " + type);
    }

    private static Map<String, Object> createBarChart(ChartConfig config) {
        HashMap commandMap = Maps.newHashMapWithExpectedSize((int)16);
        Map<String, Object> xAxisMap = config.getxAxisMap() != null ? config.getxAxisMap() : ChartFactory.defaultXAxisMap();
        commandMap.put("xAxis", xAxisMap);
        Map<String, Object> yAxisMap = config.getyAxisMap() != null ? config.getyAxisMap() : ChartFactory.defaultYAxisMap(config.getCategoryData());
        commandMap.put("yAxis", yAxisMap);
        JSONArray seriesArray = config.getSeriesList() != null ? config.getSeriesList() : ChartFactory.createBarSeries(config);
        commandMap.put("series", seriesArray);
        Map<String, Object> legendMap = config.getLegendMap() != null ? config.getLegendMap() : ChartFactory.defaultLegendMap("horizontal", "10%");
        commandMap.put("legend", legendMap);
        Map<String, Object> gridMap = config.getGridMap() != null ? config.getGridMap() : ChartFactory.defaultGridMap();
        commandMap.put("grid", gridMap);
        Map<String, Object> tooltipMap = config.getTooltipMap() != null ? config.getTooltipMap() : ChartFactory.defaultTooltipMap();
        commandMap.put("tooltip", tooltipMap);
        Map<String, Object> titleMap = config.getTitleMap() != null ? config.getTitleMap() : ChartFactory.defaultTitleMap(config.getTitle());
        commandMap.put("title", titleMap);
        if (config.getFunctions() != null) {
            commandMap.put("functions", config.getFunctions());
        }
        return commandMap;
    }

    private static Map<String, Object> createPieChart(ChartConfig config) {
        HashMap commandMap = Maps.newHashMapWithExpectedSize((int)16);
        Map<String, Object> legendMap = config.getLegendMap() != null ? config.getLegendMap() : ChartFactory.defaultLegendMap("vertical", "20%");
        commandMap.put("legend", legendMap);
        JSONArray seriesMap = config.getSeriesList() != null ? config.getSeriesList() : ChartFactory.defaultPieSeriesMap(config.getPieData());
        commandMap.put("series", seriesMap);
        Map<String, Object> tooltipMap = config.getTooltipMap() != null ? config.getTooltipMap() : ChartFactory.defaultTooltipMap();
        commandMap.put("tooltip", tooltipMap);
        Map<String, Object> titleMap = config.getTitleMap() != null ? config.getTitleMap() : ChartFactory.defaultTitleMap(config.getTitle());
        commandMap.put("title", titleMap);
        if (config.getFunctions() != null) {
            commandMap.put("functions", config.getFunctions());
        }
        return commandMap;
    }

    private static Map<String, Object> defaultXAxisMap() {
        HashMap xAxisMap = Maps.newHashMapWithExpectedSize((int)16);
        xAxisMap.put("type", "value");
        return xAxisMap;
    }

    private static Map<String, Object> defaultYAxisMap(Object[] categoryData) {
        HashMap yAxisMap = Maps.newHashMapWithExpectedSize((int)16);
        yAxisMap.put("type", "category");
        yAxisMap.put("data", categoryData);
        yAxisMap.put("axisLabel", ChartFactory.defaultAxisLabelMap());
        return yAxisMap;
    }

    private static JSONArray createBarSeries(ChartConfig config) {
        JSONArray seriesArray = new JSONArray();
        JSONObject seriesJsonCurrent = new JSONObject();
        seriesJsonCurrent.put("name", (Object)config.getCurrentName());
        seriesJsonCurrent.put("type", (Object)"bar");
        seriesJsonCurrent.put("data", (Object)config.getCurrentData());
        seriesJsonCurrent.put("barMaxWidth", (Object)20);
        seriesArray.add((Object)seriesJsonCurrent);
        if (config.isNeedComparison()) {
            JSONObject seriesJsonComparison = new JSONObject();
            seriesJsonComparison.put("name", (Object)config.getComparisonName());
            seriesJsonComparison.put("type", (Object)"bar");
            seriesJsonComparison.put("data", (Object)config.getComparisonData());
            seriesJsonComparison.put("barMaxWidth", (Object)20);
            seriesArray.add((Object)seriesJsonComparison);
        }
        return seriesArray;
    }

    private static JSONArray defaultPieSeriesMap(JSONArray pieData) {
        JSONArray jsonArray = new JSONArray();
        HashMap seriesMap = Maps.newHashMapWithExpectedSize((int)16);
        seriesMap.put("radius", new String[]{"60%", "70%"});
        seriesMap.put("center", new String[]{"30%", "50%"});
        seriesMap.put("data", pieData);
        seriesMap.put("type", "pie");
        seriesMap.put("label", ChartFactory.defaultLabelMap());
        seriesMap.put("labelLine", ChartFactory.defaultLabelLineMap());
        jsonArray.add((Object)seriesMap);
        return jsonArray;
    }

    private static Map<String, Object> defaultLegendMap(String orient, String position) {
        HashMap legendMap = Maps.newHashMapWithExpectedSize((int)16);
        legendMap.put("orient", orient);
        legendMap.put("right", position);
        legendMap.put("show", true);
        return legendMap;
    }

    private static Map<String, Object> defaultGridMap() {
        HashMap gridMap = Maps.newHashMapWithExpectedSize((int)16);
        gridMap.put("left", "5%");
        gridMap.put("right", "10%");
        gridMap.put("top", "5%");
        gridMap.put("bottom", "2%");
        gridMap.put("height", "75%");
        return gridMap;
    }

    private static Map<String, Object> defaultTooltipMap() {
        HashMap toolTipMap = Maps.newHashMapWithExpectedSize((int)4);
        toolTipMap.put("show", true);
        toolTipMap.put("trigger", "item");
        toolTipMap.put("formatter", "{b}<br/>{c} ({d}%)");
        return toolTipMap;
    }

    private static Map<String, Object> defaultTitleMap(String title) {
        HashMap titleMap = Maps.newHashMapWithExpectedSize((int)8);
        titleMap.put("left", "22%");
        titleMap.put("top", "middle");
        titleMap.put("text", title);
        return titleMap;
    }

    private static Map<String, Object> defaultLabelMap() {
        HashMap labelMap = Maps.newHashMapWithExpectedSize((int)4);
        labelMap.put("show", false);
        return labelMap;
    }

    private static Map<String, Object> defaultLabelLineMap() {
        HashMap labelLineMap = Maps.newHashMapWithExpectedSize((int)4);
        labelLineMap.put("show", false);
        return labelLineMap;
    }

    private static Map<String, Object> defaultAxisLabelMap() {
        HashMap axisLabelMap = Maps.newHashMapWithExpectedSize((int)4);
        axisLabelMap.put("formatter", "function(value) {\n    return value.length > 5 ? value.slice(0, 5) + '...' : value; }");
        return axisLabelMap;
    }
}

