/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web.tripboards.listener;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.util.CollectionUtils;
import kd.fi.er.formplugin.web.tripboards.utils.OrgTreeBuilder;
import kd.fi.er.formplugin.web.tripboards.utils.TripBoardsUtil;
import org.apache.commons.lang.StringUtils;

public class BeforeFinanceOrgF7SelectListener
implements BeforeF7SelectListener {
    IPageCache pageCache;

    public BeforeFinanceOrgF7SelectListener(IPageCache pageCache) {
        this.pageCache = pageCache;
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        List<Long> hasPermOrgs;
        if (StringUtils.isEmpty((String)this.pageCache.get("hasPermOrgs"))) {
            hasPermOrgs = TripBoardsUtil.getHasPermOrgResult();
        } else {
            String permOrgs = this.pageCache.get("hasPermOrgs");
            String[] split = permOrgs.split("#");
            hasPermOrgs = Arrays.stream(split).map(Long::parseLong).collect(Collectors.toList());
        }
        Set<Long> rangIds = this.buildOrgTree(hasPermOrgs);
        FormShowParameter formShowParameter = evt.getFormShowParameter();
        formShowParameter.setCustomParam("range", rangIds);
        formShowParameter.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
        if (formShowParameter instanceof ListShowParameter) {
            ListShowParameter listShowParameter = (ListShowParameter)formShowParameter;
            listShowParameter.setMultiSelect(Boolean.FALSE.booleanValue());
        }
    }

    private Set<Long> buildOrgTree(List<Long> hasPermIds) {
        HashSet childIdSet = Sets.newHashSetWithExpectedSize((int)hasPermIds.size());
        OrgTreeBuilder newOrgTreeBuilder = OrgTreeBuilder.getInstance();
        for (Long hasPermId : hasPermIds) {
            Set<Long> childSet = newOrgTreeBuilder.getChildById(hasPermId, newOrgTreeBuilder);
            if (childSet == null) continue;
            childIdSet.addAll(childSet);
        }
        if (CollectionUtils.isEmpty((Collection)childIdSet)) {
            childIdSet.add(RequestContext.get().getOrgId());
        }
        return childIdSet;
    }
}

