/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web.tripboards.tripindex.financeindex;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.fi.er.business.trip.supplier.ctrip.invoke.convert.ConvertUtil;
import kd.fi.er.formplugin.web.tripboards.dataprocesshandle.TripOrderDataProcessHandle;
import kd.fi.er.formplugin.web.tripboards.model.Indicator;
import kd.fi.er.formplugin.web.tripboards.utils.TripBoardsUtil;

public class PlaneDataProcessHandle
extends TripOrderDataProcessHandle {
    static Map<String, Object> DEFAULT_MAP_PLAIN = new HashMap<String, Object>(16);
    public static final String TOTAL_AMOUNT_KEY = "totalamount";
    private static final String SERVICE_FEE_KEY = "servicefee";
    private static final String ENDORSEMENT_AMOUNT_KEY = "endorsementamount";
    private static final String REFUND_AMOUNT_KEY = "refundamount";
    private static final String TICKET_STATUS_KEY = "ticketstatus";
    private static final String DISCOUNT_KEY = "discount";
    private static final String ID_KEY = "id";
    private static final String TIME_KEY = "takeofftime";
    private static final String SUMMARY_DISCOUNT_KEY = "summarydiscount";

    public PlaneDataProcessHandle(Map<String, Object> paramMap) {
        super(paramMap);
        this.setNeedYoY(Boolean.TRUE);
        this.setDataResult(DEFAULT_MAP_PLAIN);
    }

    public PlaneDataProcessHandle() {
        this.setNeedYoY(Boolean.TRUE);
        this.setDataResult(DEFAULT_MAP_PLAIN);
    }

    @Override
    public QFilter[] getFilters(Map<String, Object> filterMap) {
        return this.getCommonFilters(TIME_KEY, "expcommitcomnum", "expcommitdepnum", filterMap);
    }

    @Override
    public String getFormId() {
        if (this.getParam().containsKey("isReal")) {
            return "er_planebill";
        }
        return "er_plane_summary";
    }

    @Override
    public String getSelectProps() {
        if (this.getParam().containsKey("isReal")) {
            return "id,totalamount,servicefee,endorsementamount,refundamount,expcommitcomnum,expcommitdepnum,ticketstatus,discount,sourcetravelerid,fromcityname,tocityname,takeofftime,ordertype,happenddate";
        }
        return "id,summaryamount,summarydiscount,orgid,summarystart,summaryend,traveluser_tag,orgtype,otherdatasummary_tag";
    }

    @Override
    public String getCacheKey() {
        return RequestContext.get().getCurrUserId() + "_TRIP_FINANCE_DATA_PLANE";
    }

    @Override
    protected String getResultKey() {
        return RequestContext.get().getCurrUserId() + "_TRIP_FINANCE_RESULT_PLANE";
    }

    @Override
    public void dataHandle(Object data) {
        if (this.getParam().containsKey("isReal")) {
            this.endDataProcess(data, Boolean.FALSE);
        } else {
            this.endDataProcess(data, Boolean.TRUE);
        }
    }

    public void dataDeal(Map<String, Object> resultMap, List<DynamicObject> handleData, Boolean isSummary) {
        double totalamount = 0.0;
        double servicefee = 0.0;
        double endorsementamount = 0.0;
        double refundamount = 0.0;
        long nums = 0L;
        ArrayList<String> ticketStatusList = new ArrayList<String>(Arrays.asList("USED", "UNUSED", "CHANGED"));
        if (isSummary.booleanValue()) {
            List summaryTag = handleData.parallelStream().map(dynamicObject -> dynamicObject.getString("otherdatasummary_tag")).collect(Collectors.toList());
            HashSet allOrderInfoSet = new HashSet();
            for (String s : summaryTag) {
                JSONObject jsonObject = JSONObject.parseObject((String)s);
                JSONArray orderArray = jsonObject.getJSONArray("orderNumsAndAmount");
                allOrderInfoSet.addAll(orderArray.stream().map(String::valueOf).collect(Collectors.toSet()));
            }
            for (String orderInfo : allOrderInfoSet) {
                String ticketsStatus;
                String[] info = orderInfo.split("\\$");
                int length = info.length;
                String totalamountStr = length >= 2 ? info[1] : "0";
                String servicefeeStr = length >= 3 ? info[2] : "0";
                String endorsementamountStr = length >= 4 ? info[3] : "0";
                String refundamountStr = length >= 5 ? info[4] : "0";
                String string = ticketsStatus = length >= 6 ? info[5] : "unknown";
                if (ticketStatusList.contains(ticketsStatus)) {
                    ++nums;
                }
                totalamount = Double.sum(totalamount, Double.parseDouble(totalamountStr));
                servicefee = Double.sum(servicefee, Double.parseDouble(servicefeeStr));
                endorsementamount = Double.sum(endorsementamount, Double.parseDouble(endorsementamountStr));
                refundamount = Double.sum(refundamount, Double.parseDouble(refundamountStr));
            }
        } else {
            totalamount = handleData.parallelStream().filter(obj -> obj.get(TOTAL_AMOUNT_KEY) != null && obj.getBigDecimal(TOTAL_AMOUNT_KEY).compareTo(ConvertUtil.getOrderAmountInit()) != 0).mapToDouble(obj -> Double.parseDouble(obj.get(TOTAL_AMOUNT_KEY).toString())).sum();
            servicefee = handleData.parallelStream().filter(obj -> obj.get(SERVICE_FEE_KEY) != null && obj.getBigDecimal(TOTAL_AMOUNT_KEY).compareTo(ConvertUtil.getOrderAmountInit()) != 0).mapToDouble(obj -> Double.parseDouble(obj.get(SERVICE_FEE_KEY).toString())).sum();
            endorsementamount = handleData.parallelStream().filter(obj -> obj.get(ENDORSEMENT_AMOUNT_KEY) != null && obj.getBigDecimal(TOTAL_AMOUNT_KEY).compareTo(ConvertUtil.getOrderAmountInit()) != 0).mapToDouble(obj -> Double.parseDouble(obj.get(ENDORSEMENT_AMOUNT_KEY).toString())).sum();
            refundamount = handleData.parallelStream().filter(obj -> obj.get(REFUND_AMOUNT_KEY) != null && obj.getBigDecimal(TOTAL_AMOUNT_KEY).compareTo(ConvertUtil.getOrderAmountInit()) != 0).mapToDouble(obj -> Double.parseDouble(obj.get(REFUND_AMOUNT_KEY).toString())).sum();
        }
        Set<Object> discounts = new HashSet();
        if (!isSummary.booleanValue()) {
            nums = handleData.parallelStream().filter(obj -> ticketStatusList.contains(obj.getString(TICKET_STATUS_KEY))).count();
            ticketStatusList.remove("CHANGED");
            discounts = handleData.parallelStream().filter(obj -> obj.get(TOTAL_AMOUNT_KEY) != null && obj.get(DISCOUNT_KEY) != null && ticketStatusList.contains(obj.getString(TICKET_STATUS_KEY)) && obj.getBigDecimal(TOTAL_AMOUNT_KEY).compareTo(ConvertUtil.getOrderAmountInit()) != 0).map(obj -> obj.getBigDecimal(DISCOUNT_KEY)).collect(Collectors.toSet());
        } else {
            discounts = handleData.parallelStream().filter(obj -> obj.get(SUMMARY_DISCOUNT_KEY) != null).map(obj -> obj.getBigDecimal(SUMMARY_DISCOUNT_KEY)).collect(Collectors.toSet());
        }
        BigDecimal averageDiscount = discounts.isEmpty() ? BigDecimal.ZERO : (nums == 0L ? BigDecimal.ZERO : discounts.stream().reduce(BigDecimal.ZERO, BigDecimal::add).divide(BigDecimal.valueOf(nums), 2, RoundingMode.HALF_UP));
        this.getResultMap(resultMap, nums, averageDiscount, totalamount, endorsementamount, refundamount, servicefee);
        PlaneDataProcessHandle.putOriginValueMap(resultMap, nums, totalamount, endorsementamount, refundamount, servicefee);
    }

    private static void putOriginValueMap(Map<String, Object> resultMap, long nums, double totalamount, double endorsementamount, double refundamount, double servicefee) {
        HashMap<String, Number> originValueMap = new HashMap<String, Number>(16);
        originValueMap.put("p_month_amount", BigDecimal.valueOf(totalamount));
        originValueMap.put("p_order_nums", nums);
        originValueMap.put("p_changes_fee", BigDecimal.valueOf(endorsementamount));
        originValueMap.put("p_refund_fee", BigDecimal.valueOf(refundamount));
        originValueMap.put("p_service_fee", BigDecimal.valueOf(servicefee));
        resultMap.put("origin", originValueMap);
    }

    private void getResultMap(Map<String, Object> resultMap, long nums, BigDecimal averageDiscount, double totalamount, double endorsementamount, double refundamount, double servicefee) {
        resultMap.put("p_ave_discount", nums != 0L ? averageDiscount : "-");
        resultMap.put("p_month_amount", BigDecimal.valueOf(totalamount));
        resultMap.put("p_order_nums", nums);
        resultMap.put("p_changes_fee", BigDecimal.valueOf(endorsementamount));
        resultMap.put("p_refund_fee", BigDecimal.valueOf(refundamount));
        resultMap.put("p_service_fee", BigDecimal.valueOf(servicefee));
        resultMap.put("p_month_title", this.getNewAmountTitle(totalamount, this.getAmountTitle(), this.getTenThousandAmountTitle()));
        resultMap.put("p_changes_title", this.getNewAmountTitle(endorsementamount, this.getChangeTitle(), this.getTenThousandChangeTitle()));
        resultMap.put("p_refund_title", this.getNewAmountTitle(refundamount, this.getRefundTitle(), this.getTenThousandRefundTitle()));
        resultMap.put("p_service_title", this.getNewAmountTitle(servicefee, this.getServiceTitle(), this.getTenThousandServiceTitle()));
    }

    @Override
    public void rateDeal(Map<String, Object> resultMap, Map<String, Object> compareResultMap) {
        INDICATORS = new HashMap(16);
        INDICATORS.put("p_changes_fee", new Indicator("p_changes_fee", "p_changes_fee", "p_changes_arrow", "p_changes_rate"));
        INDICATORS.put("p_month_amount", new Indicator("p_month_amount", "p_month_amount", "p_month_arrow", "p_month_rate"));
        INDICATORS.put("p_refund_fee", new Indicator("p_refund_fee", "p_refund_fee", "p_refund_arrow", "p_refund_rate"));
        INDICATORS.put("p_service_fee", new Indicator("p_service_fee", "p_service_fee", "p_service_arrow", "p_service_rate"));
        INDICATORS.put("p_order_nums", new Indicator("p_order_nums", "p_order_nums", "p_ordernums_arrow", "p_ordernums_rate"));
        super.rateDeal(resultMap, compareResultMap);
    }

    private void endDataProcess(Object data, Boolean isSummary) {
        this.setDataResult(DEFAULT_MAP_PLAIN);
        if (data == null) {
            return;
        }
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)8);
        HashMap compareResultMap = Maps.newHashMapWithExpectedSize((int)8);
        List handleData = (List)((Map)data).get("current");
        List compareHandleData = (List)((Map)data).get("compare");
        if (handleData.isEmpty() && compareHandleData.isEmpty()) {
            return;
        }
        this.dataDeal(resultMap, handleData, isSummary);
        this.dataDeal(compareResultMap, compareHandleData, isSummary);
        this.rateDeal(resultMap, compareResultMap);
        TripBoardsUtil.formatDecimal(resultMap);
        this.setDataResult(resultMap);
    }

    @Override
    protected void calcByAlgoX() {
        TripOrderDataProcessHandle.OrderInputs result = this.getResult(TIME_KEY);
        JobSession tripBoards = AlgoX.createSession((String)"TripBoards-Plane-Algox");
        DataSetX dataSetX = tripBoards.fromInput(result.inputs.toArray(new Input[0]));
        DataSetX compareDataSetX = tripBoards.fromInput(result.compareInputs.toArray(new Input[0]));
        DataSetX allDataSetX = dataSetX.select(new String[]{TOTAL_AMOUNT_KEY, SERVICE_FEE_KEY, ENDORSEMENT_AMOUNT_KEY, REFUND_AMOUNT_KEY, DISCOUNT_KEY, TICKET_STATUS_KEY, ID_KEY});
        DataSetX compareAllDataSetX = compareDataSetX.select(new String[]{TOTAL_AMOUNT_KEY, SERVICE_FEE_KEY, ENDORSEMENT_AMOUNT_KEY, REFUND_AMOUNT_KEY, DISCOUNT_KEY, TICKET_STATUS_KEY, ID_KEY});
        DataSetX numsSet = PlaneDataProcessHandle.getNumsSet(allDataSetX);
        DataSetX compareNumsSet = PlaneDataProcessHandle.getNumsSet(compareAllDataSetX);
        DataSetX sum = PlaneDataProcessHandle.getDataSetX(allDataSetX);
        DataSetX compareSum = PlaneDataProcessHandle.getDataSetX(compareAllDataSetX);
        DataSetX discountSum = PlaneDataProcessHandle.getDiscountSet(allDataSetX);
        DataSetX compareDiscountSumDataX = PlaneDataProcessHandle.getDiscountSet(compareAllDataSetX);
        DataSet currentAmountSum = PlaneDataProcessHandle.getResult(sum, tripBoards);
        DataSet currentDiscountSum = PlaneDataProcessHandle.getResult(discountSum, tripBoards);
        DataSet compareAmountSum = PlaneDataProcessHandle.getResult(compareSum, tripBoards);
        DataSet compareDiscountSum = PlaneDataProcessHandle.getResult(compareDiscountSumDataX, tripBoards);
        DataSet currentNums = PlaneDataProcessHandle.getResult(numsSet, tripBoards);
        DataSet compareNums = PlaneDataProcessHandle.getResult(compareNumsSet, tripBoards);
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        this.algoxResultDeal(resultMap, currentAmountSum, currentDiscountSum, currentNums);
        HashMap<String, Object> compareResultMap = new HashMap<String, Object>(16);
        this.algoxResultDeal(compareResultMap, compareAmountSum, compareDiscountSum, compareNums);
        this.rateDeal(resultMap, compareResultMap);
        TripBoardsUtil.formatDecimal(resultMap);
        this.setDataResult(resultMap);
    }

    private static DataSetX getDiscountSet(DataSetX allDataSetX) {
        return allDataSetX.filter("ticketstatus in ('USED','UNUSED')").sum(DISCOUNT_KEY);
    }

    private static DataSetX getNumsSet(DataSetX allDataSetX) {
        return allDataSetX.filter("ticketstatus in ('USED','UNUSED','CHANGED')").count(ID_KEY);
    }

    private static DataSetX getDataSetX(DataSetX allDataSetX) {
        return allDataSetX.sum(TOTAL_AMOUNT_KEY).sum(SERVICE_FEE_KEY).sum(ENDORSEMENT_AMOUNT_KEY).sum(REFUND_AMOUNT_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void algoxResultDeal(Map<String, Object> resultMap, DataSet currentAmountSum, DataSet currentDiscountSum, DataSet numCountSet) {
        try {
            BigDecimal averageDiscount;
            Iterator iterator = currentAmountSum.iterator();
            BigDecimal discountBigDecimal = BigDecimal.ZERO;
            for (Object row : currentDiscountSum) {
                discountBigDecimal = discountBigDecimal.add(row.getBigDecimal(DISCOUNT_KEY));
            }
            int orderNums = 0;
            for (Row row : numCountSet) {
                orderNums = row.getInteger(ID_KEY);
            }
            BigDecimal bigDecimal = averageDiscount = orderNums == 0 ? BigDecimal.ZERO : discountBigDecimal.divide(BigDecimal.valueOf(orderNums), 2, RoundingMode.HALF_UP);
            while (iterator.hasNext()) {
                Row row;
                row = (Row)iterator.next();
                this.getResultMap(resultMap, Long.parseLong(String.valueOf(orderNums)), averageDiscount, row.getDouble(TOTAL_AMOUNT_KEY), row.getDouble(ENDORSEMENT_AMOUNT_KEY), row.getDouble(REFUND_AMOUNT_KEY), row.getDouble(SERVICE_FEE_KEY));
                PlaneDataProcessHandle.putOriginValueMap(resultMap, Long.parseLong(String.valueOf(orderNums)), row.getDouble(TOTAL_AMOUNT_KEY), row.getDouble(ENDORSEMENT_AMOUNT_KEY), row.getDouble(REFUND_AMOUNT_KEY), row.getDouble(SERVICE_FEE_KEY));
            }
        }
        finally {
            currentAmountSum.close();
            currentDiscountSum.close();
            numCountSet.close();
        }
    }

    static {
        DEFAULT_MAP_PLAIN.put("p_order_nums", 0);
        DEFAULT_MAP_PLAIN.put("p_ordernums_arrow", "-");
        DEFAULT_MAP_PLAIN.put("p_ordernums_rate", "-");
        DEFAULT_MAP_PLAIN.put("p_month_rate", "-");
        DEFAULT_MAP_PLAIN.put("p_month_arrow", "-");
        DEFAULT_MAP_PLAIN.put("p_month_amount", "-");
        DEFAULT_MAP_PLAIN.put("p_changes_rate", "-");
        DEFAULT_MAP_PLAIN.put("p_changes_arrow", "-");
        DEFAULT_MAP_PLAIN.put("p_changes_fee", "-");
        DEFAULT_MAP_PLAIN.put("p_refund_fee", "-");
        DEFAULT_MAP_PLAIN.put("p_refund_arrow", "-");
        DEFAULT_MAP_PLAIN.put("p_refund_rate", "-");
        DEFAULT_MAP_PLAIN.put("p_service_fee", "-");
        DEFAULT_MAP_PLAIN.put("p_service_arrow", "-");
        DEFAULT_MAP_PLAIN.put("p_service_rate", "-");
        DEFAULT_MAP_PLAIN.put("p_ave_discount", "-");
    }
}

