/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web.tripboards.tripindex.financeindex;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.fi.er.business.trip.supplier.ctrip.invoke.convert.ConvertUtil;
import kd.fi.er.business.trip.task.tripboards.OrderSummaryTask;
import kd.fi.er.formplugin.web.tripboards.ChartConfig;
import kd.fi.er.formplugin.web.tripboards.dataprocesshandle.DataProcessHandle;
import kd.fi.er.formplugin.web.tripboards.factory.ChartFactory;
import kd.fi.er.formplugin.web.tripboards.manager.CacheManager;
import kd.fi.er.formplugin.web.tripboards.model.SummaryModel;
import kd.fi.er.formplugin.web.tripboards.utils.TripBoardsUtil;

public class TripAllExpenseAndRankDataProcessHandle
extends DataProcessHandle {
    private static final Log logger = LogFactory.getLog(TripAllExpenseAndRankDataProcessHandle.class);
    public static String[] KEYS = new String[]{"_TRIP_FINANCE_DATA_PLANE", "_TRIP_FINANCE_DATA_HOTEL", "_TRIP_FINANCE_DATA_TRAIN", "_TRIP_FINANCE_DATA_VEHICLE"};
    public static final String SUMMARY_AMOUNT_KEY = "summaryamount";
    public static final String ORG_KEY = "orgid";
    public static final String ORG_TYPE = "orgtype";

    public TripAllExpenseAndRankDataProcessHandle(Map<String, Object> paramMap) {
        super(paramMap);
        this.setNeedYoY(Boolean.FALSE);
    }

    @Override
    public Object dataFilter(Object data) {
        HashMap<String, Object> cacheMap = new HashMap<String, Object>(16);
        this.getCachedDataWithFilters(cacheMap);
        logger.info("kd.fi.er.formplugin.web.tripboards.tripindex.financeindex.TripAllExpenseAndRankDataProcessHandle.dataFilter");
        this.getCompareDataWithFilters(cacheMap);
        return cacheMap;
    }

    private void getAndFilterCacheData(Map<String, Object> resultMap, String cacheKey, String suffix) {
        String cachePrefix = RequestContext.get().getCurrUserId() + "";
        cacheKey = cachePrefix + cacheKey;
        String fullKey = cacheKey + suffix;
        ArrayList<Object> returnData = new ArrayList<Object>(16);
        LocalDate beginDate = (LocalDate)this.getParam().get("beginDate");
        LocalDate endDate = (LocalDate)this.getParam().get("endDate");
        List<OrderSummaryTask.DateRange> monthlyDateRanges = TripBoardsUtil.getMonthlyDateRanges(beginDate, endDate);
        ArrayList<String> keys = new ArrayList<String>(16);
        for (OrderSummaryTask.DateRange monthlyDateRange : monthlyDateRanges) {
            LocalDate start = monthlyDateRange.getStart();
            LocalDate end = monthlyDateRange.getEnd();
            if (StringUtils.isNotEmpty((String)suffix)) {
                start = start.minusMonths(12L);
                end = end.minusMonths(12L);
            }
            int year = start.getYear();
            int monthValue = start.getMonthValue();
            int dayOfMonth = start.getDayOfMonth();
            String startKey = year + "-" + monthValue + "-" + dayOfMonth;
            int endYear = end.getYear();
            int endMonthValue = end.getMonthValue();
            int endDayOfMonth = end.getDayOfMonth();
            String endKey = endYear + "-" + endMonthValue + "-" + endDayOfMonth;
            keys.add(fullKey + startKey + "-" + endKey);
        }
        keys.add(fullKey);
        for (String key : keys) {
            Object localCacheData = CacheManager.getLocalCacheData(key, TripAllExpenseAndRankDataProcessHandle.getPageQueryMap(this.getParam()), ArrayList.class);
            if (localCacheData == null) continue;
            if (this.getParam().containsKey("isReal")) {
                List dbCacheData = (List)localCacheData;
                returnData.addAll(dbCacheData);
                continue;
            }
            returnData.addAll(CacheManager.typeCheckAndReturnData(localCacheData, returnData));
        }
        resultMap.put(fullKey, returnData);
        if (this.getParam().containsKey("isReal")) {
            this.filterData(resultMap, cacheKey);
        }
    }

    protected void filterData(Map<String, Object> resultMap, String key) {
        for (int i = 0; i < 2; ++i) {
            List filteredList;
            List dataList;
            String currentKey = i == 0 ? key : key + "_compare";
            Object filterData = resultMap.get(currentKey);
            if (!(filterData instanceof List) || (dataList = (List)filterData).isEmpty()) continue;
            if (dataList.get(0) instanceof SummaryModel) {
                filteredList = dataList.parallelStream().filter(obj -> obj instanceof SummaryModel).map(obj -> (SummaryModel)obj).filter(obj -> {
                    BigDecimal totalAmount = obj.getSummaryAmount();
                    return totalAmount != null && totalAmount.compareTo(ConvertUtil.getOrderAmountInit()) != 0;
                }).collect(Collectors.toList());
                resultMap.put(currentKey, filteredList);
                continue;
            }
            if (!(dataList.get(0) instanceof LinkedHashMap) && !(dataList.get(0) instanceof DynamicObject)) continue;
            if (dataList.get(0) instanceof LinkedHashMap) {
                filteredList = dataList.parallelStream().map(obj -> (LinkedHashMap)obj).filter(obj -> {
                    Object o = obj.get("totalamount");
                    BigDecimal totalAmount = o == null || StringUtils.isEmpty((String)o.toString()) ? BigDecimal.ZERO : new BigDecimal(o.toString());
                    return totalAmount.compareTo(ConvertUtil.getOrderAmountInit()) != 0;
                }).collect(Collectors.toList());
                resultMap.put(currentKey, filteredList);
                continue;
            }
            if (!(dataList.get(0) instanceof DynamicObject)) continue;
            filteredList = dataList.parallelStream().map(obj -> (DynamicObject)obj).filter(obj -> {
                Object o = obj.get("totalamount");
                BigDecimal totalAmount = o == null || StringUtils.isEmpty((String)o.toString()) ? BigDecimal.ZERO : new BigDecimal(o.toString());
                return totalAmount.compareTo(ConvertUtil.getOrderAmountInit()) != 0;
            }).collect(Collectors.toList());
            resultMap.put(currentKey, filteredList);
        }
    }

    public void getCachedDataWithFilters(Map<String, Object> resultMap) {
        for (String key : KEYS) {
            this.getAndFilterCacheData(resultMap, key, "");
        }
    }

    public void getCompareDataWithFilters(Map<String, Object> resultMap) {
        for (String key : KEYS) {
            this.getAndFilterCacheData(resultMap, key, "_compare");
        }
    }

    @Override
    public void dataHandle(Object data) {
        if (data == null) {
            this.setDataResult(new HashMap());
            return;
        }
        Map resultMap = (Map)data;
        Map<String, Map<String, BigDecimal>> dataMap = this.processData(resultMap);
        this.dealFinalResult(dataMap);
    }

    private void dealFinalResult(Map<String, Map<String, BigDecimal>> dataMap) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>(4);
        ArrayList<BigDecimal> allValue = new ArrayList<BigDecimal>(16);
        for (Map.Entry<String, Map<String, BigDecimal>> entry : dataMap.entrySet()) {
            List<Long> orgIdList = entry.getValue().keySet().stream().map(key -> Long.parseLong(key.replace("_compare", ""))).distinct().collect(Collectors.toList());
            Map<Long, String> orgAndNameMap = TripBoardsUtil.getOrganizationInfo(orgIdList);
            ArrayList<String> categoryName = new ArrayList<String>(16);
            ArrayList<BigDecimal> xData = new ArrayList<BigDecimal>(16);
            ArrayList<BigDecimal> compareXData = new ArrayList<BigDecimal>(16);
            String key2 = entry.getKey();
            this.organizeData(entry.getValue(), orgAndNameMap, categoryName, xData, compareXData);
            ChartConfig barConfig = this.getChartConfig(xData, compareXData, categoryName);
            returnMap.put(key2, ChartFactory.createChart("BAR", barConfig));
            allValue.addAll(compareXData);
        }
        HashSet<String> amountUnitSet = new HashSet<String>(16);
        for (BigDecimal amount : allValue) {
            amountUnitSet.add(TripBoardsUtil.getAmountUnit(amount));
        }
        String string = ResManager.loadKDString((String)"\u5546\u65c5\u603b\u4f53\u8d39\u7528\u53ca\u6392\u540d\uff08\u5143\uff09", (String)"TripBoard_12", (String)"fi-er-business", (Object[])new Object[0]);
        String tenThousandTitle = ResManager.loadKDString((String)"\u5546\u65c5\u603b\u4f53\u8d39\u7528\u53ca\u6392\u540d\uff08\u4e07\u5143\uff09", (String)"TripBoard_12_1", (String)"fi-er-business", (Object[])new Object[0]);
        returnMap.put("all_rank_title", amountUnitSet.size() == 1 ? ("tenThousand".equals(new ArrayList(amountUnitSet).get(0)) ? tenThousandTitle : string) : string);
        this.setDataResult(returnMap);
    }

    private ChartConfig getChartConfig(List<BigDecimal> xData, List<BigDecimal> compareXData, List<String> categoryName) {
        ArrayList<String> funs = new ArrayList<String>();
        funs.add("yAxis");
        funs.add("axisLabel");
        funs.add("formatter");
        ArrayList<List<Object>> funList = new ArrayList<List<Object>>();
        funList.add(funs);
        LocalDate beginDate = (LocalDate)this.getParam().get("beginDate");
        ChartConfig barConfig = new ChartConfig();
        barConfig.setCurrentName(String.valueOf(beginDate.getYear()));
        barConfig.setCurrentData(xData.toArray(new BigDecimal[0]));
        barConfig.setNeedComparison(true);
        barConfig.setComparisonName(String.valueOf(beginDate.minusMonths(12L).getYear()));
        barConfig.setComparisonData(compareXData.toArray(new BigDecimal[0]));
        barConfig.setCategoryData(categoryName.toArray());
        barConfig.setFunctions(funList);
        HashMap toolTipMap = Maps.newHashMapWithExpectedSize((int)4);
        toolTipMap.put("trigger", "axis");
        toolTipMap.put("show", true);
        barConfig.setTooltipMap(toolTipMap);
        HashMap legendMap = Maps.newHashMapWithExpectedSize((int)4);
        legendMap.put("right", "10");
        legendMap.put("itemWidth", 10);
        legendMap.put("itemHeight", 10);
        barConfig.setLegendMap(legendMap);
        HashMap gridMap = Maps.newHashMapWithExpectedSize((int)4);
        gridMap.put("bottom", "5");
        gridMap.put("top", "18");
        barConfig.setGridMap(gridMap);
        return barConfig;
    }

    private List<Map.Entry<Long, BigDecimal>> sortMap(Map<Long, BigDecimal> orgAndTotalAmountMap) {
        ArrayList<Map.Entry<Long, BigDecimal>> list = new ArrayList<Map.Entry<Long, BigDecimal>>(orgAndTotalAmountMap.entrySet());
        list.sort(new Comparator<Map.Entry<Long, BigDecimal>>(){

            @Override
            public int compare(Map.Entry<Long, BigDecimal> o1, Map.Entry<Long, BigDecimal> o2) {
                BigDecimal subtract = o2.getValue().subtract(o1.getValue());
                if (subtract.compareTo(BigDecimal.ZERO) > 0) {
                    return -1;
                }
                if (subtract.compareTo(BigDecimal.ZERO) < 0) {
                    return 1;
                }
                return 0;
            }
        });
        return list;
    }

    @SafeVarargs
    private final Map<String, Map<Long, BigDecimal>> dealMap(Map<Long, BigDecimal> orgAndTotalAmountMap, List<Object> ... list) {
        Map<String, Object> param = this.getParam();
        Object rootOrg = param.get("rootOrg");
        if (rootOrg == null) {
            return Collections.emptyMap();
        }
        Iterator iterator = Arrays.stream(list).collect(Collectors.toList()).iterator();
        while (iterator.hasNext()) {
            List next = (List)iterator.next();
            if (!next.isEmpty()) continue;
            iterator.remove();
        }
        if (list.length == 0) {
            return Collections.emptyMap();
        }
        Set orgIds = (Set)param.get("orgIds");
        if (orgIds.size() > 1) {
            orgIds.remove(Long.parseLong(rootOrg.toString()));
        }
        ConcurrentHashMap<Long, BigDecimal> tempMap = new ConcurrentHashMap<Long, BigDecimal>();
        ArrayList companyIds = new ArrayList(16);
        ArrayList deptIds = new ArrayList(16);
        ((Stream)Arrays.stream(list).parallel()).forEach(dynamicObjects -> {
            block41: {
                Object o;
                block40: {
                    TripAllExpenseAndRankDataProcessHandle tripAllExpenseAndRankDataProcessHandle;
                    BigDecimal totalamount;
                    Object dept;
                    long deptId;
                    long companyId;
                    Object company;
                    List dynamicObjectList;
                    if (dynamicObjects.isEmpty()) {
                        return;
                    }
                    o = dynamicObjects.get(0);
                    if (!(o instanceof LinkedHashMap) && !(o instanceof DynamicObject)) break block40;
                    if (o instanceof LinkedHashMap) {
                        dynamicObjectList = dynamicObjects.parallelStream().map(obj -> (LinkedHashMap)obj).collect(Collectors.toList());
                        for (LinkedHashMap dynamicObject : dynamicObjectList) {
                            company = dynamicObject.get("expcommitcomnum");
                            companyId = 0L;
                            deptId = 0L;
                            if (company instanceof Long) {
                                companyId = (Long)company;
                            } else if (company instanceof Integer) {
                                companyId = Long.parseLong(company.toString());
                            }
                            dept = dynamicObject.get("expcommitdepnum");
                            if (dept instanceof Long) {
                                deptId = (Long)dept;
                            } else if (dept instanceof Integer) {
                                deptId = Long.parseLong(dept.toString());
                            }
                            BigDecimal bigDecimal = totalamount = dynamicObject.get("totalamount") == null || StringUtils.isEmpty((String)dynamicObject.get("totalamount").toString()) ? BigDecimal.ZERO : new BigDecimal(dynamicObject.get("totalamount").toString());
                            if (orgIds.contains(companyId)) {
                                tempMap.merge(companyId, totalamount, BigDecimal::add);
                                tripAllExpenseAndRankDataProcessHandle = this;
                                synchronized (tripAllExpenseAndRankDataProcessHandle) {
                                    companyIds.add(companyId);
                                }
                            }
                            if (!orgIds.contains(deptId)) continue;
                            tempMap.merge(deptId, totalamount, BigDecimal::add);
                            tripAllExpenseAndRankDataProcessHandle = this;
                            synchronized (tripAllExpenseAndRankDataProcessHandle) {
                                deptIds.add(deptId);
                            }
                        }
                    }
                    if (!(o instanceof DynamicObject)) break block41;
                    dynamicObjectList = dynamicObjects.parallelStream().map(obj -> (DynamicObject)obj).collect(Collectors.toList());
                    for (LinkedHashMap dynamicObject : dynamicObjectList) {
                        company = dynamicObject.get("expcommitcomnum");
                        companyId = 0L;
                        deptId = 0L;
                        if (company instanceof Long) {
                            companyId = (Long)company;
                        } else if (company instanceof Integer) {
                            companyId = Long.parseLong(company.toString());
                        }
                        dept = dynamicObject.get("expcommitdepnum");
                        if (dept instanceof Long) {
                            deptId = (Long)dept;
                        } else if (dept instanceof Integer) {
                            deptId = Long.parseLong(dept.toString());
                        }
                        BigDecimal bigDecimal = totalamount = dynamicObject.get("totalamount") == null || StringUtils.isEmpty((String)dynamicObject.get("totalamount").toString()) ? BigDecimal.ZERO : new BigDecimal(dynamicObject.get("totalamount").toString());
                        if (orgIds.contains(companyId)) {
                            tempMap.merge(companyId, totalamount, BigDecimal::add);
                            tripAllExpenseAndRankDataProcessHandle = this;
                            synchronized (tripAllExpenseAndRankDataProcessHandle) {
                                companyIds.add(companyId);
                            }
                        }
                        if (!orgIds.contains(deptId)) continue;
                        tempMap.merge(deptId, totalamount, BigDecimal::add);
                        tripAllExpenseAndRankDataProcessHandle = this;
                        synchronized (tripAllExpenseAndRankDataProcessHandle) {
                            deptIds.add(deptId);
                        }
                    }
                    break block41;
                }
                if (o instanceof SummaryModel) {
                    List summaryModels = dynamicObjects.parallelStream().map(obj -> (SummaryModel)obj).collect(Collectors.toList());
                    for (SummaryModel summaryModel : summaryModels) {
                        TripAllExpenseAndRankDataProcessHandle tripAllExpenseAndRankDataProcessHandle;
                        long companyId = Long.parseLong(summaryModel.getOrgId());
                        BigDecimal totalamount = summaryModel.getSummaryAmount();
                        String orgtype = summaryModel.getOrgType();
                        if (!orgIds.contains(companyId)) continue;
                        if ("company".equals(orgtype)) {
                            tripAllExpenseAndRankDataProcessHandle = this;
                            synchronized (tripAllExpenseAndRankDataProcessHandle) {
                                companyIds.add(companyId);
                            }
                        }
                        if ("dept".equals(orgtype)) {
                            tripAllExpenseAndRankDataProcessHandle = this;
                            synchronized (tripAllExpenseAndRankDataProcessHandle) {
                                deptIds.add(companyId);
                            }
                        }
                        tempMap.merge(companyId, totalamount, BigDecimal::add);
                    }
                }
            }
        });
        TreeMap companyMap = new TreeMap();
        TreeMap deptMap = new TreeMap();
        tempMap.forEach((key, value) -> orgAndTotalAmountMap.merge((Long)key, (BigDecimal)value, BigDecimal::add));
        companyIds.forEach(id -> companyMap.merge(id, tempMap.get(id), BigDecimal::add));
        deptIds.forEach(id -> deptMap.merge(id, tempMap.get(id), BigDecimal::add));
        HashMap<String, Map<Long, BigDecimal>> resultMap = new HashMap<String, Map<Long, BigDecimal>>(8);
        resultMap.put("all", orgAndTotalAmountMap);
        resultMap.put("company", companyMap);
        resultMap.put("dept", deptMap);
        return resultMap;
    }

    public Map<String, Map<String, BigDecimal>> processData(Map<String, List<Object>> resultMap) {
        String cachePrefix = RequestContext.get().getCurrUserId() + "";
        HashMap<String, Map<Long, BigDecimal>> currentMap = new HashMap<String, Map<Long, BigDecimal>>(8);
        HashMap<String, Map<Long, BigDecimal>> compareMap = new HashMap<String, Map<Long, BigDecimal>>(8);
        this.retrieveAndProcessData(resultMap, cachePrefix, currentMap, compareMap);
        HashMap<String, List<Map.Entry<Long, BigDecimal>>> sortedMap = new HashMap<String, List<Map.Entry<Long, BigDecimal>>>(16);
        for (Map.Entry entry : currentMap.entrySet()) {
            String key = (String)entry.getKey();
            List<Map.Entry<Long, BigDecimal>> sortedEntries = this.getTopSortedEntries((Map)entry.getValue(), (Map)compareMap.get(key), 10);
            sortedMap.put(key, sortedEntries);
        }
        HashMap<String, Map<String, BigDecimal>> finalMap = new HashMap<String, Map<String, BigDecimal>>(8);
        for (Map.Entry sortedEntry : sortedMap.entrySet()) {
            String key = (String)sortedEntry.getKey();
            finalMap.put(key, this.buildDataMap((Map)currentMap.get(key), (Map)compareMap.get(key), (List)sortedEntry.getValue()));
        }
        return finalMap;
    }

    private void retrieveAndProcessData(Map<String, List<Object>> resultMap, String cachePrefix, Map<String, Map<Long, BigDecimal>> currentMap, Map<String, Map<Long, BigDecimal>> compareMap) {
        List planeList = resultMap.getOrDefault(cachePrefix + "_TRIP_FINANCE_DATA_PLANE", null);
        List hotelList = resultMap.getOrDefault(cachePrefix + "_TRIP_FINANCE_DATA_HOTEL", null);
        List trainList = resultMap.getOrDefault(cachePrefix + "_TRIP_FINANCE_DATA_TRAIN", null);
        List vehicleList = resultMap.getOrDefault(cachePrefix + "_TRIP_FINANCE_DATA_VEHICLE", null);
        List comparePlaneList = resultMap.getOrDefault(cachePrefix + "_TRIP_FINANCE_DATA_PLANE" + "_compare", null);
        List compareHotelList = resultMap.getOrDefault(cachePrefix + "_TRIP_FINANCE_DATA_HOTEL" + "_compare", null);
        List compareTrainList = resultMap.getOrDefault(cachePrefix + "_TRIP_FINANCE_DATA_TRAIN" + "_compare", null);
        List compareVehicleList = resultMap.getOrDefault(cachePrefix + "_TRIP_FINANCE_DATA_VEHICLE" + "_compare", null);
        TreeMap<Long, BigDecimal> orgAndTotalAmountMap = new TreeMap<Long, BigDecimal>();
        TreeMap<Long, BigDecimal> compareOrgAndTotalAmountMap = new TreeMap<Long, BigDecimal>();
        currentMap.putAll(this.dealMap(orgAndTotalAmountMap, planeList, hotelList, trainList, vehicleList));
        compareMap.putAll(this.dealMap(compareOrgAndTotalAmountMap, comparePlaneList, compareHotelList, compareVehicleList, compareTrainList));
    }

    private List<Map.Entry<Long, BigDecimal>> getTopSortedEntries(Map<Long, BigDecimal> orgAndTotalAmountMap, Map<Long, BigDecimal> compareOrgAndTotalAmountMap, int n) {
        List<Map.Entry<Long, BigDecimal>> entries = this.sortMap(!orgAndTotalAmountMap.isEmpty() ? orgAndTotalAmountMap : compareOrgAndTotalAmountMap);
        return entries.stream().limit(n).collect(Collectors.toList());
    }

    private Map<String, BigDecimal> buildDataMap(Map<Long, BigDecimal> orgAndTotalAmountMap, Map<Long, BigDecimal> compareOrgAndTotalAmountMap, List<Map.Entry<Long, BigDecimal>> sortedEntries) {
        LinkedHashMap<String, BigDecimal> dataMap = new LinkedHashMap<String, BigDecimal>(16);
        for (Map.Entry<Long, BigDecimal> entry : sortedEntries) {
            Long orgId = entry.getKey();
            dataMap.put(orgId.toString(), orgAndTotalAmountMap.getOrDefault(orgId, BigDecimal.ZERO));
            dataMap.put(orgId + "_compare", compareOrgAndTotalAmountMap.getOrDefault(orgId, BigDecimal.ZERO));
        }
        return dataMap;
    }

    public void organizeData(Map<String, BigDecimal> dataMap, Map<Long, String> orgAndNameMap, List<String> categoryName, List<BigDecimal> xData, List<BigDecimal> compareXData) {
        int cycle = 0;
        for (Map.Entry<String, BigDecimal> entry : dataMap.entrySet()) {
            if (cycle == 10) break;
            String key = entry.getKey();
            BigDecimal amount = entry.getValue();
            Long orgId = Long.parseLong(key.replace("_compare", ""));
            if (key.endsWith("_compare")) {
                compareXData.add(amount);
                continue;
            }
            xData.add(amount);
            categoryName.add(orgAndNameMap.get(orgId));
            ++cycle;
        }
    }

    @Override
    public Boolean isNeedDB() {
        return Boolean.FALSE;
    }

    @Override
    protected void calcByAlgoX() {
        Map<String, Object> param = this.getParam();
        param.put("isReal", "flag");
        this.setParam(param);
        LocalDate localBeginDate = (LocalDate)param.get("beginDate");
        LocalDate localEndDate = (LocalDate)param.get("endDate");
        List<OrderSummaryTask.DateRange> pairs = TripBoardsUtil.getMonthlyDateRanges(localBeginDate, localEndDate);
        JobSession tripBoards = AlgoX.createSession((String)"TripBoards-Rank-Algox");
        Set orgIds = (Set)this.getParam().get("orgIds");
        Set<String> paramOrg = orgIds.stream().map(String::valueOf).collect(Collectors.toSet());
        List<Input> inputsMap = this.getInputs(pairs, "er_plane_summary", paramOrg);
        List<Input> hotelInputsMap = this.getInputs(pairs, "er_hotel_summary", paramOrg);
        List<Input> trainInputsMap = this.getInputs(pairs, "er_train_summary", paramOrg);
        List<Input> vehicleInputsMap = this.getInputs(pairs, "er_vehicle_summary", paramOrg);
        this.dealFinalResult(this.startDataX(tripBoards, inputsMap, hotelInputsMap, trainInputsMap, vehicleInputsMap));
    }

    private Map<String, Map<String, BigDecimal>> startDataX(JobSession tripBoards, List<Input> planeInputs, List<Input> hotelInputs, List<Input> trainInputs, List<Input> vehicleInputs) {
        DataSetX dataSetX = tripBoards.fromInput(planeInputs.toArray(new Input[0])).union(tripBoards.fromInput(hotelInputs.toArray(new Input[0]))).union(tripBoards.fromInput(trainInputs.toArray(new Input[0]))).union(tripBoards.fromInput(vehicleInputs.toArray(new Input[0])));
        Map<String, Map<String, BigDecimal>> currentMap = TripAllExpenseAndRankDataProcessHandle.dealDataSetX(dataSetX, tripBoards);
        Map<String, Object> param = this.getParam();
        LocalDate localBeginDate = (LocalDate)param.get("beginDate");
        LocalDate localEndDate = (LocalDate)param.get("endDate");
        List<OrderSummaryTask.DateRange> pairs = TripBoardsUtil.getMonthlyDateRanges(localBeginDate.minusMonths(12L), localEndDate.minusMonths(12L));
        Set<String> orgIds = currentMap.values().stream().flatMap(entry -> entry.keySet().stream()).collect(Collectors.toSet());
        DataSetX compareDataSetX = tripBoards.fromInput(this.getInputs(pairs, "er_plane_summary", orgIds).toArray(new Input[0])).union(tripBoards.fromInput(this.getInputs(pairs, "er_hotel_summary", orgIds).toArray(new Input[0]))).union(tripBoards.fromInput(this.getInputs(pairs, "er_train_summary", orgIds).toArray(new Input[0]))).union(tripBoards.fromInput(this.getInputs(pairs, "er_vehicle_summary", orgIds).toArray(new Input[0])));
        Map<String, Map<String, BigDecimal>> compareMap = TripAllExpenseAndRankDataProcessHandle.dealDataSetX(compareDataSetX, tripBoards);
        HashMap<String, Map<String, BigDecimal>> finalMap = new HashMap<String, Map<String, BigDecimal>>(8);
        for (Map.Entry<String, Map<String, BigDecimal>> entry2 : currentMap.entrySet()) {
            LinkedHashMap<String, BigDecimal> dataMap = new LinkedHashMap<String, BigDecimal>(16);
            String key = entry2.getKey();
            Map<String, BigDecimal> currentValue = entry2.getValue();
            Map<String, BigDecimal> compareValue = compareMap.get(key);
            for (Map.Entry<String, BigDecimal> innerEntry : currentValue.entrySet()) {
                String id = innerEntry.getKey();
                dataMap.put(id, innerEntry.getValue());
                dataMap.put(id + "_compare", compareValue.get(id));
            }
            finalMap.put(key, dataMap);
        }
        return finalMap;
    }

    private static Map<String, Map<String, BigDecimal>> dealDataSetX(DataSetX dataSetX, JobSession tripBoards) {
        DataSetX allDataSetX = dataSetX.select(new String[]{SUMMARY_AMOUNT_KEY, ORG_KEY, ORG_TYPE}).orderBy(new String[]{"summaryamount desc"});
        DataSetX companySum = allDataSetX.filter("orgtype='company'").groupBy(new String[]{ORG_KEY}).sum(SUMMARY_AMOUNT_KEY).top(10);
        DataSetX deptSum = allDataSetX.filter("orgtype='dept'").groupBy(new String[]{ORG_KEY}).sum(SUMMARY_AMOUNT_KEY).top(10);
        DataSetX allSum = allDataSetX.groupBy(new String[]{ORG_KEY}).sum(SUMMARY_AMOUNT_KEY).top(10);
        DataSet companyAlgoXResult = TripAllExpenseAndRankDataProcessHandle.getAlgoXResult(companySum, tripBoards);
        LinkedHashMap<String, BigDecimal> companyMap = new LinkedHashMap<String, BigDecimal>(16);
        TripAllExpenseAndRankDataProcessHandle.getDataMap(companyAlgoXResult, companyMap);
        DataSet deptAlgoXResult = TripAllExpenseAndRankDataProcessHandle.getAlgoXResult(deptSum, tripBoards);
        LinkedHashMap<String, BigDecimal> deptMap = new LinkedHashMap<String, BigDecimal>(16);
        TripAllExpenseAndRankDataProcessHandle.getDataMap(deptAlgoXResult, deptMap);
        DataSet allAlgoXResult = TripAllExpenseAndRankDataProcessHandle.getAlgoXResult(allSum, tripBoards);
        LinkedHashMap<String, BigDecimal> allMap = new LinkedHashMap<String, BigDecimal>(16);
        TripAllExpenseAndRankDataProcessHandle.getDataMap(allAlgoXResult, allMap);
        HashMap<String, Map<String, BigDecimal>> resultMap = new HashMap<String, Map<String, BigDecimal>>(16);
        resultMap.put("all", allMap);
        resultMap.put("company", companyMap);
        resultMap.put("dept", deptMap);
        return resultMap;
    }

    private static void getDataMap(DataSet companyAlgoXResult, Map<String, BigDecimal> map) {
        for (Row row : companyAlgoXResult) {
            BigDecimal summaryAmount = row.getBigDecimal(SUMMARY_AMOUNT_KEY);
            String orgId = row.getString(ORG_KEY);
            map.put(orgId, summaryAmount);
        }
    }

    private List<Input> getInputs(List<OrderSummaryTask.DateRange> pairs, String formId, Set<String> paramOrg) {
        ArrayList<Input> input = new ArrayList<Input>(16);
        for (OrderSummaryTask.DateRange pair : pairs) {
            QFilter startFilter = new QFilter("summarystart", ">=", (Object)pair.getStart());
            QFilter endFilter = new QFilter("summaryend", "<=", (Object)pair.getEnd());
            QFilter current = startFilter.and(endFilter);
            QFilter orgFilter = new QFilter(ORG_KEY, "in", paramOrg);
            OrmInput ormInput = new OrmInput("this.getClass().getName()", formId, "summaryamount,orgid,orgtype", new QFilter[]{current, orgFilter});
            input.add((Input)ormInput);
        }
        return input;
    }

    private static DataSet getAlgoXResult(DataSetX sum, JobSession tripBoards) {
        RowMeta rowMeta = sum.getRowMeta();
        DataSetOutput dataSetOutput = new DataSetOutput(rowMeta);
        sum.output((Output)dataSetOutput);
        tripBoards.commit(600, TimeUnit.SECONDS);
        return tripBoards.readDataSet(dataSetOutput.getId());
    }
}

