/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web.tripboards.tripindex.financeindex;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ConfigurationUtil;
import kd.fi.er.business.trip.task.tripboards.OrderSummaryTask;
import kd.fi.er.formplugin.web.tripboards.ChartConfig;
import kd.fi.er.formplugin.web.tripboards.dataprocesshandle.DataProcessHandle;
import kd.fi.er.formplugin.web.tripboards.factory.ChartFactory;
import kd.fi.er.formplugin.web.tripboards.manager.CacheManager;
import kd.fi.er.formplugin.web.tripboards.model.SummaryModel;
import kd.fi.er.formplugin.web.tripboards.tripindex.financeindex.HotelDataProcessHandle;
import kd.fi.er.formplugin.web.tripboards.tripindex.financeindex.PlaneDataProcessHandle;
import kd.fi.er.formplugin.web.tripboards.tripindex.financeindex.TrainDataProcessHandle;
import kd.fi.er.formplugin.web.tripboards.tripindex.financeindex.VehicleDataProcessHandle;
import kd.fi.er.formplugin.web.tripboards.utils.TripBoardsUtil;

public class TripYearBasicAnlyDataProcessHandle
extends DataProcessHandle {
    private static final Log logger = LogFactory.getLog(TripYearBasicAnlyDataProcessHandle.class);
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM");

    public TripYearBasicAnlyDataProcessHandle(Map<String, Object> paramMap) {
        super(paramMap);
        this.setNeedYoY(Boolean.FALSE);
    }

    @Override
    public Object queryData(RequestContext context) {
        Map<String, Object> param = this.getParam();
        HashMap<String, Object> newParam = new HashMap<String, Object>(param);
        LocalDate newEndDate = (LocalDate)param.get("endDate");
        LocalDate beginDate = (LocalDate)param.get("beginDate");
        if (!beginDate.isBefore(newEndDate)) {
            return TripBoardsUtil.getNullChartMap();
        }
        long betweenMonth = ChronoUnit.MONTHS.between(beginDate, newEndDate) + 1L;
        ConcurrentHashMap<String, Map<String, Object>> resultMap = new ConcurrentHashMap<String, Map<String, Object>>();
        if (betweenMonth <= 11L) {
            long realNeedMinusMonths = 12L - betweenMonth;
            LocalDate newBeginDate = beginDate.minusMonths(realNeedMinusMonths);
            newBeginDate = newBeginDate.with(TemporalAdjusters.firstDayOfMonth());
            newParam.put("endDate", beginDate.minusMonths(1L).with(TemporalAdjusters.lastDayOfMonth()));
            if (newParam.containsKey("isReal")) {
                realNeedMinusMonths = 11L;
                newBeginDate = newEndDate.minusMonths(realNeedMinusMonths);
                newParam.put("endDate", newEndDate.with(TemporalAdjusters.lastDayOfMonth()));
            }
            newParam.put("beginDate", newBeginDate.with(TemporalAdjusters.firstDayOfMonth()));
            newParam.remove("isReal");
            logger.info("yoy plane");
            PlaneDataProcessHandle plane = new PlaneDataProcessHandle(newParam);
            plane.setNeedCache(Boolean.FALSE);
            resultMap.put("plane", this.combineAllData(plane, context));
            logger.info("yoy hotel");
            HotelDataProcessHandle hotel = new HotelDataProcessHandle(newParam);
            hotel.setNeedCache(Boolean.FALSE);
            resultMap.put("hotel", this.combineAllData(hotel, context));
            logger.info("yoy train");
            TrainDataProcessHandle train = new TrainDataProcessHandle(newParam);
            train.setNeedCache(Boolean.FALSE);
            resultMap.put("train", this.combineAllData(train, context));
            logger.info("yoy vehicle");
            VehicleDataProcessHandle vehicle = new VehicleDataProcessHandle(newParam);
            vehicle.setNeedCache(Boolean.FALSE);
            resultMap.put("vehicle", this.combineAllData(vehicle, context));
        } else {
            List<OrderSummaryTask.DateRange> monthlyDateRanges = TripBoardsUtil.getMonthlyDateRanges(newEndDate.minusMonths(11L), newEndDate);
            long restMonths = betweenMonth - 12L;
            boolean isNegate = Boolean.FALSE;
            boolean isEqual = Boolean.FALSE;
            if (restMonths < 11L && restMonths > 0L) {
                monthlyDateRanges = TripBoardsUtil.getMonthlyDateRanges(beginDate, beginDate.plusMonths(restMonths - 1L).with(TemporalAdjusters.lastDayOfMonth()));
                isNegate = Boolean.TRUE;
            } else if (restMonths == 0L) {
                isEqual = Boolean.TRUE;
            }
            logger.info("kd.fi.er.formplugin.web.tripboards.tripindex.financeindex.TripYearBasicAnlyDataProcessHandle.queryData>11");
            ConcurrentHashMap<String, Object> returnDataMap = new ConcurrentHashMap<String, Object>(16);
            PlaneDataProcessHandle plane = new PlaneDataProcessHandle(param);
            this.returnDataGet(returnDataMap, monthlyDateRanges, plane, isNegate, isEqual);
            resultMap.put("plane", returnDataMap);
            returnDataMap.clear();
            HotelDataProcessHandle hotel = new HotelDataProcessHandle(param);
            this.returnDataGet(returnDataMap, monthlyDateRanges, hotel, isNegate, isEqual);
            resultMap.put("hotel", returnDataMap);
            returnDataMap.clear();
            TrainDataProcessHandle train = new TrainDataProcessHandle(param);
            this.returnDataGet(returnDataMap, monthlyDateRanges, train, isNegate, isEqual);
            resultMap.put("train", returnDataMap);
            returnDataMap.clear();
            VehicleDataProcessHandle vehicle = new VehicleDataProcessHandle(param);
            this.returnDataGet(returnDataMap, monthlyDateRanges, vehicle, isNegate, isEqual);
            resultMap.put("vehicle", returnDataMap);
        }
        return resultMap;
    }

    private void returnDataGet(Map<String, Object> returnDataMap, List<OrderSummaryTask.DateRange> monthlyDateRanges, DataProcessHandle dataProcessHandle, boolean isNegate, boolean isEqual) {
        try {
            ArrayList<Object> data = new ArrayList<Object>(16);
            String cacheKey = dataProcessHandle.getCacheKey();
            this.getCacheData(cacheKey, data, dataProcessHandle.getFormId());
            returnDataMap.put("current", isEqual ? data : this.filterCacheData(monthlyDateRanges, "", isNegate, data));
            data = new ArrayList(16);
            this.getCacheData(cacheKey + "_compare", data, dataProcessHandle.getFormId());
            returnDataMap.put("compare", isEqual ? data : this.filterCacheData(monthlyDateRanges, "_compare", isNegate, data));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<Object> getCacheData(String cacheKey, List<Object> data, String formId) {
        LocalDate beginDate = (LocalDate)this.getParam().get("beginDate");
        LocalDate endDate = (LocalDate)this.getParam().get("endDate");
        List<OrderSummaryTask.DateRange> monthlyDateRanges = TripBoardsUtil.getMonthlyDateRanges(beginDate, endDate);
        ArrayList<String> keys = new ArrayList<String>(16);
        for (OrderSummaryTask.DateRange monthlyDateRange : monthlyDateRanges) {
            LocalDate start = monthlyDateRange.getStart();
            LocalDate end = monthlyDateRange.getEnd();
            if (cacheKey.endsWith("compare")) {
                start = start.minusMonths(12L);
                end = end.minusMonths(12L);
            }
            int year = start.getYear();
            int monthValue = start.getMonthValue();
            int dayOfMonth = start.getDayOfMonth();
            String startKey = year + "-" + monthValue + "-" + dayOfMonth;
            int endYear = end.getYear();
            int endMonthValue = end.getMonthValue();
            int endDayOfMonth = end.getDayOfMonth();
            String endKey = endYear + "-" + endMonthValue + "-" + endDayOfMonth;
            keys.add(cacheKey + startKey + "-" + endKey);
        }
        keys.add(cacheKey);
        String inThreshold = ConfigurationUtil.getString((String)"orm.opt.in.threshold");
        if (StringUtils.isEmpty((String)inThreshold)) {
            inThreshold = "10000";
        }
        for (String key : keys) {
            Object localCacheData = CacheManager.getLocalCacheData(key, TripYearBasicAnlyDataProcessHandle.getPageQueryMap(this.getParam()), ArrayList.class);
            if (localCacheData == null) continue;
            data.addAll(CacheManager.typeCheckAndReturnData(localCacheData, data));
            List summaryModels = data.parallelStream().map(obj -> (SummaryModel)obj).collect(Collectors.toList());
            Set summaryIds = summaryModels.stream().map(SummaryModel::getId).collect(Collectors.toSet());
            List partition = Lists.partition(new ArrayList(summaryIds), (int)(Integer.parseInt(inThreshold) - 1));
            for (List ids : partition) {
                DynamicObjectCollection query = QueryServiceHelper.query((String)formId, (String)"otherdatasummary_tag,id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)});
                Map<Long, String> idMap = query.stream().collect(Collectors.toMap(obj -> obj.getLong("id"), obj -> obj.getString("otherdatasummary_tag")));
                for (SummaryModel filteredDatum : summaryModels) {
                    if (!idMap.containsKey(filteredDatum.getId())) continue;
                    filteredDatum.setOtherSummary(idMap.get(filteredDatum.getId()));
                }
            }
        }
        return data;
    }

    private List<SummaryModel> filterCacheData(List<OrderSummaryTask.DateRange> monthlyDateRanges, String suffixKey, boolean isNegate, List<Object> data) {
        List summaryModels = data.parallelStream().map(obj -> (SummaryModel)obj).collect(Collectors.toList());
        AbstractList returnList = Lists.newArrayListWithCapacity((int)16);
        List dateRanges = monthlyDateRanges.stream().map(range -> {
            LocalDate start = kd.bos.util.StringUtils.isNotEmpty((String)suffixKey) ? range.getStart().minusMonths(12L) : range.getStart();
            LocalDate end = kd.bos.util.StringUtils.isNotEmpty((String)suffixKey) ? range.getEnd().minusMonths(12L) : range.getEnd();
            return new LocalDate[]{start, end};
        }).collect(Collectors.toList());
        LocalDate startDate = ((LocalDate[])dateRanges.get(0))[0];
        LocalDate endDate = ((LocalDate[])dateRanges.get(dateRanges.size() - 1))[1];
        returnList.addAll(summaryModels.parallelStream().filter(obj -> {
            if (obj == null) {
                return false;
            }
            LocalDate summaryStart = TripBoardsUtil.convertDateToLocalDate(obj.getSummaryStart());
            LocalDate summaryEnd = TripBoardsUtil.convertDateToLocalDate(obj.getSummaryEnd());
            return !summaryStart.isBefore(startDate) && !summaryEnd.isAfter(endDate);
        }).collect(Collectors.toList()));
        if (isNegate) {
            LinkedList linkedList = new LinkedList(summaryModels);
            HashSet smallSet = new HashSet(returnList);
            linkedList.removeIf(smallSet::contains);
            returnList = linkedList;
        }
        return returnList;
    }

    private Map<String, Object> combineAllData(DataProcessHandle dataProcessHandle, RequestContext context) {
        ArrayList<Object> compareData;
        List<Object> currentData;
        HashMap<String, Object> returnDataMap = new HashMap<String, Object>(16);
        ArrayList<Object> current = new ArrayList<Object>(16);
        ArrayList<Object> compare = new ArrayList<Object>(16);
        if (!this.getParam().containsKey("isReal")) {
            try {
                String cacheKey = dataProcessHandle.getCacheKey();
                currentData = new ArrayList(16);
                this.getCacheData(cacheKey, currentData, dataProcessHandle.getFormId());
                compareData = new ArrayList<Object>(16);
                this.getCacheData(cacheKey + "_compare", compareData, dataProcessHandle.getFormId());
                current.addAll(currentData);
                compare.addAll(compareData);
            }
            catch (Exception e) {
                logger.error("\u7f13\u5b58\u83b7\u53d6\u5931\u8d25:", (Throwable)e);
            }
        }
        Map dataMap = (Map)dataProcessHandle.queryData(context);
        currentData = (List)dataMap.get("current");
        currentData.parallelStream().forEach(dynamicObject -> {
            SummaryModel summaryModel = new SummaryModel(dynamicObject.getLong("id"), dynamicObject.getBigDecimal("summaryamount"), dynamicObject.getString("orgid"), dynamicObject.getDate("summarystart"), dynamicObject.getDate("summaryend"), dynamicObject.getString("orgtype"), dynamicObject.getString("otherdatasummary_tag"));
            List list = current;
            synchronized (list) {
                current.add(summaryModel);
            }
        });
        compareData = (ArrayList<Object>)dataMap.get("compare");
        compareData.parallelStream().forEach(dynamicObject -> {
            SummaryModel summaryModel = new SummaryModel(dynamicObject.getLong("id"), dynamicObject.getBigDecimal("summaryamount"), dynamicObject.getString("orgid"), dynamicObject.getDate("summarystart"), dynamicObject.getDate("summaryend"), dynamicObject.getString("orgtype"), dynamicObject.getString("otherdatasummary_tag"));
            List list = compare;
            synchronized (list) {
                compare.add(summaryModel);
            }
        });
        returnDataMap.put("current", current);
        returnDataMap.put("compare", compare);
        return returnDataMap;
    }

    @Override
    public Object dataFilter(Object data) {
        Map resultMap = (Map)data;
        List<Object> returnData = new ArrayList(16);
        if (resultMap.isEmpty()) {
            return returnData;
        }
        HashMap<String, BigDecimal> dataMap = new HashMap<String, BigDecimal>(16);
        ArrayList<SummaryModel> filteredData = new ArrayList<SummaryModel>(16);
        resultMap.forEach((key, value) -> filteredData.addAll(((Map)value).values().stream().flatMap(v -> ((List)v).stream()).collect(Collectors.toList())));
        dataMap.putAll(this.dealData(filteredData));
        returnData = dataMap.entrySet().stream().map(entry -> {
            String key = (String)entry.getKey();
            String[] yearAndMonth = key.split("-");
            return new ThreeTuple((Object)Integer.parseInt(yearAndMonth[0]), (Object)Integer.parseInt(yearAndMonth[1]), entry.getValue());
        }).sorted(Comparator.comparingInt(th -> (Integer)th.item1).thenComparingInt(th -> (Integer)th.item2)).collect(Collectors.toList());
        return returnData;
    }

    private Map<String, BigDecimal> dealData(List<SummaryModel> allData) {
        HashMap<String, BigDecimal> dataMap = new HashMap<String, BigDecimal>(16);
        Map<Date, List<SummaryModel>> summaryGroup = allData.stream().collect(Collectors.groupingBy(SummaryModel::getSummaryEnd));
        for (Map.Entry<Date, List<SummaryModel>> entry : summaryGroup.entrySet()) {
            Date time = entry.getKey();
            LocalDate date = TripBoardsUtil.convertDateToLocalDate(time);
            List<SummaryModel> value = entry.getValue();
            HashSet allOrderInfoSet = new HashSet();
            BigDecimal totalAmount = BigDecimal.ZERO;
            for (SummaryModel summaryModel : value) {
                JSONObject jsonObject = JSONObject.parseObject((String)summaryModel.getOtherSummary());
                JSONArray orderArray = jsonObject.getJSONArray("orderNumsAndAmount");
                allOrderInfoSet.addAll(new HashSet(orderArray.stream().map(String::valueOf).collect(Collectors.toSet())));
            }
            for (String orderInfo : allOrderInfoSet) {
                String[] info = orderInfo.split("\\$");
                String totalamountStr = info[1];
                totalAmount = totalAmount.add(new BigDecimal(totalamountStr));
            }
            String key = date.getYear() + "-" + date.getMonthValue();
            dataMap.merge(key, totalAmount, BigDecimal::add);
        }
        return dataMap;
    }

    @Override
    public void dataHandle(Object data) {
        if (data == null) {
            this.setDataResult(new HashMap());
            return;
        }
        List returnData = (List)data;
        if (returnData.isEmpty()) {
            this.setDataResult(new HashMap());
            return;
        }
        TreeSet<String> years = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (Integer.parseInt(o1) > Integer.parseInt(o2)) {
                    return 1;
                }
                if (Integer.parseInt(o1) < Integer.parseInt(o2)) {
                    return -1;
                }
                return 0;
            }
        });
        LocalDate newEndDate = (LocalDate)this.getParam().get("endDate");
        LocalDate newBeginDate = newEndDate.minusMonths(11L);
        List<String> monthsBetweenDates = TripBoardsUtil.getMonthsBetweenDates(newBeginDate, newEndDate, "yyyy-MM");
        Set<String> tmpXAxisData = TripYearBasicAnlyDataProcessHandle.getXAxisCompareSet();
        String suffix = ResManager.loadKDString((String)"\u6708", (String)"AccumulateControlServiceImpl_0", (String)"fi-er-business", (Object[])new Object[0]);
        String yearSuffix = ResManager.loadKDString((String)"\u5e74", (String)"TripBoard_9", (String)"fi-er-business", (Object[])new Object[0]);
        for (ThreeTuple returnDatum : returnData) {
            Integer year = (Integer)returnDatum.item1;
            tmpXAxisData.add(returnDatum.item2 + suffix);
            years.add(year + "");
        }
        Set<String> amountUnitSet = TripYearBasicAnlyDataProcessHandle.getAmountUnitSet(years, tmpXAxisData, returnData);
        Result result = TripYearBasicAnlyDataProcessHandle.getResult(amountUnitSet, years, tmpXAxisData, monthsBetweenDates, returnData, "bar");
        String language = Lang.get().getLocale().getLanguage();
        String pattern = "yyyy" + yearSuffix + "MM" + suffix;
        if (!"zh".equals(language)) {
            pattern = "yyyy'Year'MM'Monthly'";
        }
        monthsBetweenDates = TripBoardsUtil.getMonthsBetweenDates(newBeginDate, newEndDate, pattern);
        JSONArray jsonArray = result.jsonArray;
        boolean isNumberFormatter = result.isNumberFormatter;
        ChartConfig barConfig = TripYearBasicAnlyDataProcessHandle.getChartConfig(jsonArray, monthsBetweenDates, isNumberFormatter, amountUnitSet, years);
        Map<String, Object> returnMap = ChartFactory.createChart("BAR", barConfig);
        String title = ResManager.loadKDString((String)"\u5546\u65c5\u8d39\u7528\u540c\u6bd4\u5206\u6790\uff08\u5143\uff09", (String)"TripBoard_13", (String)"fi-er-business", (Object[])new Object[0]);
        String tenThousandTitle = ResManager.loadKDString((String)"\u5546\u65c5\u8d39\u7528\u540c\u6bd4\u5206\u6790\uff08\u4e07\u5143\uff09", (String)"TripBoard_13_1", (String)"fi-er-business", (Object[])new Object[0]);
        returnMap.put("yoy_title", isNumberFormatter ? ("tenThousand".equals(new ArrayList<String>(amountUnitSet).get(0)) ? tenThousandTitle : title) : title);
        this.setDataResult(returnMap);
    }

    private static ChartConfig getChartConfig(JSONArray jsonArray, List<String> monthsBetweenDates, boolean isNumberFormatter, Set<String> amountUnitSet, Set<String> years) {
        ChartConfig barConfig = new ChartConfig();
        barConfig.setSeriesList(jsonArray);
        HashMap xAxisMap = Maps.newHashMapWithExpectedSize((int)4);
        xAxisMap.put("type", "category");
        xAxisMap.put("data", monthsBetweenDates);
        HashMap axisLabelMap = Maps.newHashMapWithExpectedSize((int)4);
        axisLabelMap.put("interval", 0);
        axisLabelMap.put("rotate", 45);
        xAxisMap.put("axisLabel", axisLabelMap);
        barConfig.setxAxisMap(xAxisMap);
        HashMap yAxisMap = Maps.newHashMapWithExpectedSize((int)4);
        yAxisMap.put("type", "value");
        barConfig.setyAxisMap(yAxisMap);
        HashMap toolTipMap = Maps.newHashMapWithExpectedSize((int)4);
        toolTipMap.put("show", true);
        toolTipMap.put("trigger", "axis");
        barConfig.setTooltipMap(toolTipMap);
        HashMap legendMap = Maps.newHashMapWithExpectedSize((int)4);
        legendMap.put("show", true);
        legendMap.put("right", "10");
        legendMap.put("top", "1");
        legendMap.put("itemWidth", 10);
        legendMap.put("itemHeight", 10);
        legendMap.put("data", years);
        barConfig.setLegendMap(legendMap);
        HashMap gridMap = Maps.newHashMapWithExpectedSize((int)8);
        gridMap.put("bottom", "1");
        gridMap.put("top", "30");
        barConfig.setGridMap(gridMap);
        return barConfig;
    }

    public static Result getResult(Set<String> amountUnitSet, Set<String> years, Set<String> xAxisData, List<String> monthsBetweenDates, List<ThreeTuple<Integer, Integer, BigDecimal>> returnData, String chartType) {
        boolean isNumberFormatter = amountUnitSet.size() == 1;
        Iterator<String> iterator = years.iterator();
        JSONArray jsonArray = new JSONArray();
        while (iterator.hasNext()) {
            HashMap<String, Object> jsonObject = new HashMap<String, Object>();
            ArrayList datas = Lists.newArrayListWithCapacity((int)16);
            String next = iterator.next();
            for (String monthsBetweenDate : monthsBetweenDates) {
                String[] yearAndMonth = monthsBetweenDate.split("-");
                if (yearAndMonth.length == 0) continue;
                String tmpMonth = yearAndMonth[1];
                for (String month : xAxisData) {
                    int month_int = Integer.parseInt(month.replace(ResManager.loadKDString((String)"\u6708", (String)"AccumulateControlServiceImpl_0", (String)"fi-er-business", (Object[])new Object[0]), ""));
                    if (month_int != Integer.parseInt(tmpMonth)) continue;
                    boolean b = returnData.stream().anyMatch(tuple -> ((Integer)tuple.item1).toString().equals(next) && ((Integer)tuple.item2).equals(month_int));
                    if (b) {
                        ThreeTuple threeTuple = returnData.stream().filter(tuple -> ((Integer)tuple.item1).toString().equals(next) && ((Integer)tuple.item2).equals(month_int)).findFirst().get();
                        datas.add(isNumberFormatter ? TripBoardsUtil.numberFormatter((BigDecimal)threeTuple.item3) : threeTuple.item3);
                        continue;
                    }
                    datas.add(BigDecimal.ZERO);
                }
            }
            jsonObject.put("type", chartType);
            jsonObject.put("name", next);
            jsonObject.put("data", datas);
            if ("bar".equals(chartType)) {
                jsonObject.put("barWidth", 10);
            } else {
                jsonObject.put("areaStyle", new JSONObject());
            }
            jsonArray.add(jsonObject);
        }
        return new Result(isNumberFormatter, jsonArray);
    }

    public static Set<String> getAmountUnitSet(Set<String> years, Set<String> xAxisData, List<ThreeTuple<Integer, Integer, BigDecimal>> returnData) {
        Iterator<String> iterator = years.iterator();
        HashSet<String> amountUnitSet = new HashSet<String>();
        while (iterator.hasNext()) {
            String next = iterator.next();
            for (String month : xAxisData) {
                int month_int = Integer.parseInt(month.replace(ResManager.loadKDString((String)"\u6708", (String)"AccumulateControlServiceImpl_0", (String)"fi-er-business", (Object[])new Object[0]), ""));
                boolean b = returnData.stream().anyMatch(tuple -> ((Integer)tuple.item1).toString().equals(next) && ((Integer)tuple.item2).equals(month_int));
                if (!b) continue;
                ThreeTuple threeTuple = returnData.stream().filter(tuple -> ((Integer)tuple.item1).toString().equals(next) && ((Integer)tuple.item2).equals(month_int)).findFirst().get();
                String amountUnit = TripBoardsUtil.getAmountUnit((BigDecimal)threeTuple.item3);
                amountUnitSet.add(amountUnit);
            }
        }
        return amountUnitSet;
    }

    public static Set<String> getXAxisCompareSet() {
        return Sets.newTreeSet((Comparator)new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int int_o2;
                String new_o1 = o1.replace(ResManager.loadKDString((String)"\u6708", (String)"AccumulateControlServiceImpl_0", (String)"fi-er-business", (Object[])new Object[0]), "");
                String new_o2 = o2.replace(ResManager.loadKDString((String)"\u6708", (String)"AccumulateControlServiceImpl_0", (String)"fi-er-business", (Object[])new Object[0]), "");
                int int_o1 = Integer.parseInt(new_o1);
                if (int_o1 > (int_o2 = Integer.parseInt(new_o2))) {
                    return 1;
                }
                if (int_o1 < int_o2) {
                    return -1;
                }
                return 0;
            }
        });
    }

    @Override
    protected void calcByAlgoX() {
        Map<String, Object> param = this.getParam();
        param.put("isReal", "flag");
        this.setParam(param);
        LocalDate localBeginDate = (LocalDate)param.get("beginDate");
        LocalDate localEndDate = (LocalDate)param.get("endDate");
        List<OrderSummaryTask.DateRange> pairs = TripBoardsUtil.getMonthlyDateRanges(localEndDate.minusMonths(11L).with(TemporalAdjusters.firstDayOfMonth()), localEndDate);
        JobSession tripBoards = AlgoX.createSession((String)"TripBoards-YOY-Algox");
        Set orgIds = (Set)this.getParam().get("orgIds");
        Set<String> paramOrg = orgIds.stream().map(String::valueOf).collect(Collectors.toSet());
        List<Input> planeInputs = this.getInputs(pairs, "er_plane_summary", paramOrg);
        List<Input> hotelInputs = this.getInputs(pairs, "er_hotel_summary", paramOrg);
        List<Input> trainInputs = this.getInputs(pairs, "er_train_summary", paramOrg);
        List<Input> vehicleInputs = this.getInputs(pairs, "er_vehicle_summary", paramOrg);
        DataSetX unionDataSetX = tripBoards.fromInput(planeInputs.toArray(new Input[0])).union(tripBoards.fromInput(trainInputs.toArray(new Input[0]))).union(tripBoards.fromInput(hotelInputs.toArray(new Input[0]))).union(tripBoards.fromInput(vehicleInputs.toArray(new Input[0])));
        LocalDate compareBeginDate = localEndDate.minusMonths(11L).minusMonths(12L).with(TemporalAdjusters.firstDayOfMonth());
        LocalDate compareEndDate = localEndDate.minusMonths(12L);
        List<OrderSummaryTask.DateRange> comparePairs = TripBoardsUtil.getMonthlyDateRanges(compareBeginDate, compareEndDate);
        List<Input> comparePlaneInputs = this.getInputs(comparePairs, "er_plane_summary", paramOrg);
        List<Input> compareHotelInputs = this.getInputs(comparePairs, "er_hotel_summary", paramOrg);
        List<Input> compareTrainInputs = this.getInputs(comparePairs, "er_train_summary", paramOrg);
        List<Input> compareVehicleInputs = this.getInputs(comparePairs, "er_vehicle_summary", paramOrg);
        DataSetX join = tripBoards.fromInput(comparePlaneInputs.toArray(new Input[0])).union(tripBoards.fromInput(compareTrainInputs.toArray(new Input[0]))).union(tripBoards.fromInput(compareHotelInputs.toArray(new Input[0]))).union(tripBoards.fromInput(compareVehicleInputs.toArray(new Input[0])));
        Map<String, BigDecimal> currentDataMap = this.dealAlgoxData(TripYearBasicAnlyDataProcessHandle.commitAlgoX(unionDataSetX, tripBoards));
        Map<String, BigDecimal> compareDataMap = this.dealAlgoxData(TripYearBasicAnlyDataProcessHandle.commitAlgoX(join, tripBoards));
        LinkedHashSet<String> key = new LinkedHashSet<String>(16);
        key.addAll(currentDataMap.keySet());
        key.addAll(compareDataMap.keySet());
        Set years = key.stream().map(obj -> obj.split("-")[0]).collect(Collectors.toSet()).stream().sorted(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (Integer.parseInt(o1) > Integer.parseInt(o2)) {
                    return 1;
                }
                if (Integer.parseInt(o1) < Integer.parseInt(o2)) {
                    return -1;
                }
                return 0;
            }
        }).collect(Collectors.toCollection(TreeSet::new));
        ArrayList<String> months = new ArrayList<String>(16);
        for (OrderSummaryTask.DateRange pair : pairs) {
            LocalDate start = pair.getStart();
            int monthValue = start.getMonthValue();
            months.add(String.valueOf(monthValue).length() == 1 ? "0" + monthValue : String.valueOf(monthValue));
        }
        JSONArray array = new JSONArray();
        LocalDate newEndDate = (LocalDate)this.getParam().get("endDate");
        LocalDate newBeginDate = newEndDate.minusMonths(11L);
        String suffix = ResManager.loadKDString((String)"\u6708", (String)"AccumulateControlServiceImpl_0", (String)"fi-er-business", (Object[])new Object[0]);
        String yearSuffix = ResManager.loadKDString((String)"\u5e74", (String)"TripBoard_9", (String)"fi-er-business", (Object[])new Object[0]);
        List<String> monthsBetweenDates = TripBoardsUtil.getMonthsBetweenDates(newBeginDate, newEndDate, "yyyy" + yearSuffix + "MM" + suffix);
        LinkedHashMap<String, BigDecimal> allDataMap = new LinkedHashMap<String, BigDecimal>(16);
        allDataMap.putAll(currentDataMap);
        allDataMap.putAll(compareDataMap);
        HashSet<String> amountUnitSet = new HashSet<String>(4);
        allDataMap.values().forEach(amount -> {
            String amountUnit = TripBoardsUtil.getAmountUnit(amount);
            amountUnitSet.add(amountUnit);
        });
        boolean isNumberFormatter = amountUnitSet.size() == 1;
        for (String year : years) {
            ArrayList arrayDatas = Lists.newArrayListWithCapacity((int)16);
            JSONObject jsonObject = new JSONObject();
            for (String month : months) {
                String dataKey = year + "-" + month;
                BigDecimal amount2 = allDataMap.getOrDefault(dataKey, BigDecimal.ZERO);
                arrayDatas.add(isNumberFormatter ? TripBoardsUtil.numberFormatter(amount2) : amount2);
            }
            jsonObject.put("type", (Object)"bar");
            jsonObject.put("name", (Object)year);
            jsonObject.put("data", (Object)arrayDatas);
            jsonObject.put("barWidth", (Object)10);
            array.add((Object)jsonObject);
        }
        ChartConfig barConfig = TripYearBasicAnlyDataProcessHandle.getChartConfig(array, monthsBetweenDates, isNumberFormatter, amountUnitSet, years);
        Map<String, Object> returnMap = ChartFactory.createChart("BAR", barConfig);
        String title = ResManager.loadKDString((String)"\u5546\u65c5\u8d39\u7528\u540c\u6bd4\u5206\u6790\uff08\u5143\uff09", (String)"TripBoard_13", (String)"fi-er-business", (Object[])new Object[0]);
        String tenThousandTitle = ResManager.loadKDString((String)"\u5546\u65c5\u8d39\u7528\u540c\u6bd4\u5206\u6790\uff08\u4e07\u5143\uff09", (String)"TripBoard_13_1", (String)"fi-er-business", (Object[])new Object[0]);
        returnMap.put("yoy_title", isNumberFormatter ? ("tenThousand".equals(new ArrayList<String>(amountUnitSet).get(0)) ? tenThousandTitle : title) : title);
        this.setDataResult(returnMap);
    }

    private static DataSet commitAlgoX(DataSetX unionDataSetX, JobSession tripBoards) {
        DataSetX select = unionDataSetX.select(new String[]{"year_month", "sumamount"});
        RowMeta rowMeta = select.getRowMeta();
        DataSetOutput dataSetOutput = new DataSetOutput(rowMeta);
        unionDataSetX.output((Output)dataSetOutput);
        tripBoards.commit(600, TimeUnit.SECONDS);
        return tripBoards.readDataSet(dataSetOutput.getId());
    }

    private Map<String, BigDecimal> dealAlgoxData(DataSet rows) {
        ConcurrentHashMap dateAndSummaryTagMap = new ConcurrentHashMap();
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        ExecutorService executor = Executors.newFixedThreadPool(availableProcessors * 4);
        int batchSize = 10000;
        ArrayList<Row> batch = new ArrayList<Row>(batchSize);
        while (rows.hasNext()) {
            Row row = rows.next();
            batch.add(row);
            if (batch.size() != batchSize && rows.hasNext()) continue;
            ArrayList currentBatch = new ArrayList(batch);
            batch.clear();
            CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
                for (Row dealRow : currentBatch) {
                    Date yearMonth = dealRow.getDate("year_month");
                    String key = DATE_FORMATTER.format(yearMonth.toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
                    JSONObject jsonObject = JSONObject.parseObject((String)dealRow.getString("sumamount"));
                    JSONArray orderArray = jsonObject.getJSONArray("orderNumsAndAmount");
                    HashSet<String> tags = new HashSet<String>(orderArray.size());
                    for (int i = 0; i < orderArray.size(); ++i) {
                        tags.add(orderArray.getString(i));
                    }
                    dateAndSummaryTagMap.compute(key, (k, v) -> {
                        if (v == null) {
                            v = new HashSet();
                        }
                        v.addAll(tags);
                        return v;
                    });
                }
            }, executor);
            futures.add(future);
        }
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
        executor.shutdown();
        LinkedHashMap<String, BigDecimal> returnMap = new LinkedHashMap<String, BigDecimal>(16);
        for (Map.Entry entry : dateAndSummaryTagMap.entrySet()) {
            String yearAndMonth = (String)entry.getKey();
            BigDecimal totalAmount = ((Set)entry.getValue()).stream().map(tag -> new BigDecimal(tag.split("\\$")[1])).reduce(BigDecimal.ZERO, BigDecimal::add);
            returnMap.put(yearAndMonth, totalAmount);
        }
        return returnMap;
    }

    private List<Input> getInputs(List<OrderSummaryTask.DateRange> pairs, String formId, Set<String> paramOrg) {
        ArrayList<Input> input = new ArrayList<Input>(16);
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("year_month", (DataType)DataType.DateType), new Field("sumamount", (DataType)DataType.StringType)});
        for (OrderSummaryTask.DateRange pair : pairs) {
            QFilter startFilter = new QFilter("summarystart", ">=", (Object)pair.getStart());
            QFilter endFilter = new QFilter("summaryend", "<=", (Object)pair.getEnd());
            QFilter current = startFilter.and(endFilter);
            QFilter orgFilter = new QFilter("orgid", "in", paramOrg);
            OrmInput ormInput = new OrmInput("this.getClass().getName()", formId, "summaryend as year_month,otherdatasummary_tag as sumamount", new QFilter[]{current, orgFilter}, rowMeta);
            input.add((Input)ormInput);
        }
        return input;
    }

    public static class Result {
        public final boolean isNumberFormatter;
        public final JSONArray jsonArray;

        public Result(boolean isNumberFormatter, JSONArray jsonArray) {
            this.isNumberFormatter = isNumberFormatter;
            this.jsonArray = jsonArray;
        }
    }
}

