/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web.tripboards.tripindex.planeindex;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IPageCache;
import kd.fi.er.formplugin.web.tripboards.ChartConfig;
import kd.fi.er.formplugin.web.tripboards.factory.ChartFactory;
import kd.fi.er.formplugin.web.tripboards.model.SummaryModel;
import kd.fi.er.formplugin.web.tripboards.tripindex.planeindex.TripPlaneCostsOverViewDataProcessHandle;
import kd.fi.er.formplugin.web.tripboards.utils.TripBoardsUtil;

public class TripPlaneAverageDiscountDataProcessHandle
extends TripPlaneCostsOverViewDataProcessHandle {
    private static final String JSON_KEY = "averagediscount";
    private static final String JSON_DISCOUNT_KEY = "discount";
    private static final String JSON_ORDERNUM_KEY = "orderNums";

    public TripPlaneAverageDiscountDataProcessHandle(Map<String, Object> paramMap) {
        super(paramMap);
        this.setNeedYoY(Boolean.FALSE);
    }

    public TripPlaneAverageDiscountDataProcessHandle() {
        this.setNeedYoY(Boolean.FALSE);
    }

    @Override
    public Boolean isNeedDB() {
        return Boolean.FALSE;
    }

    @Override
    public void dataHandle(Object data) {
        if (!this.getZipper().booleanValue()) {
            List<Object> convertData;
            LocalDate localEndDate;
            Map<String, Object> param = this.getParam();
            HashMap<String, Object> newParam = new HashMap<String, Object>(param);
            LocalDate localDate = (LocalDate)newParam.get("beginDate");
            long between = ChronoUnit.MONTHS.between(localDate, localEndDate = (LocalDate)newParam.get("endDate")) + 1L;
            if (between != 12L) {
                newParam.put("beginDate", localDate.minusMonths(12L - between));
            }
            if ((convertData = this.getCacheData(this.getCacheKeys(newParam))).isEmpty()) {
                return;
            }
            List<SummaryModel> summaryModels = convertData.parallelStream().map(obj -> (SummaryModel)obj).collect(Collectors.toList());
            summaryModels = this.getOtherSummaryTag(summaryModels.parallelStream().map(SummaryModel::getId).collect(Collectors.toList()));
            this.finalDataDeal(summaryModels);
        }
    }

    private void finalDataDeal(List<SummaryModel> summaryModels) {
        ConcurrentHashMap<String, Tuple> dataMap = new ConcurrentHashMap<String, Tuple>(16);
        String suffix = ResManager.loadKDString((String)"\u6708", (String)"AccumulateControlServiceImpl_0", (String)"fi-er-business", (Object[])new Object[0]);
        String yearSuffix = ResManager.loadKDString((String)"\u5e74", (String)"TripBoard_9", (String)"fi-er-business", (Object[])new Object[0]);
        List<String> ticketStatus = Arrays.asList("USED", "UNUSED", "CHANGED");
        Map tempMap = summaryModels.parallelStream().filter(obj -> obj.getSummaryEnd() != null && obj.getOtherSummary() != null && JSONObject.parseObject((String)obj.getOtherSummary()).containsKey((Object)"orderNumsAndAmount")).map(obj -> {
            Date time = obj.getSummaryEnd();
            LocalDate date = TripBoardsUtil.convertDateToLocalDate(time);
            String key = date.getYear() + yearSuffix + date.getMonthValue() + suffix;
            JSONObject jsonObject = JSONObject.parseObject((String)obj.getOtherSummary());
            HashSet orderInfoSet = new HashSet(jsonObject.getJSONArray("orderNumsAndAmount").stream().map(String::valueOf).collect(Collectors.toSet()));
            BigDecimal totalDiscount = BigDecimal.ZERO;
            int orderCount = 0;
            for (String orderInfo : orderInfoSet) {
                String[] split = orderInfo.split("\\$");
                if (split.length < 9 || !ticketStatus.contains(split[5])) continue;
                ++orderCount;
                BigDecimal discount = new BigDecimal(split[8]);
                totalDiscount = totalDiscount.add(discount);
            }
            return new AbstractMap.SimpleEntry<String, Tuple>(key, Tuple.create((Object)totalDiscount, (Object)orderCount));
        }).collect(Collectors.toConcurrentMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> {
            BigDecimal newTotalDiscount = ((BigDecimal)v1.item1).add((BigDecimal)v2.item1);
            int newOrderCount = (Integer)v1.item2 + (Integer)v2.item2;
            return Tuple.create((Object)newTotalDiscount, (Object)newOrderCount);
        }, ConcurrentHashMap::new));
        Map sortedDataMap = tempMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        for (Map.Entry next : sortedDataMap.entrySet()) {
            String key = (String)next.getKey();
            Tuple value = (Tuple)next.getValue();
            BigDecimal averageDiscount = BigDecimal.ZERO;
            if ((Integer)value.item2 != 0) {
                averageDiscount = ((BigDecimal)value.item1).divide(new BigDecimal((Integer)value.item2), 2, RoundingMode.HALF_UP);
            }
            dataMap.put(key, Tuple.create((Object)averageDiscount, (Object)value.item2));
        }
        Set<Object> xAxisDataSet = new LinkedHashSet(dataMap.keySet());
        xAxisDataSet = xAxisDataSet.stream().sorted((o1, o2) -> {
            String o1Replace = o1.replace(suffix, "").replace(yearSuffix, "-");
            String o2Replace = o2.replace(suffix, "").replace(yearSuffix, "-");
            String[] split = o1Replace.split("-");
            String[] split1 = o2Replace.split("-");
            String o1_year = split[0];
            String o1_month = split[1];
            String o2_year = split1[0];
            String o2_month = split1[1];
            if (o1_year.equals(o2_year) && Integer.parseInt(o1_month) > Integer.parseInt(o2_month)) {
                return 1;
            }
            if (o1_year.equals(o2_year) && Integer.parseInt(o1_month) < Integer.parseInt(o2_month)) {
                return -1;
            }
            return Integer.compare(Integer.parseInt(o1_year), Integer.parseInt(o2_year));
        }).collect(Collectors.toCollection(LinkedHashSet::new));
        Iterator<Object> iterator = xAxisDataSet.iterator();
        ArrayList<Object> value = new ArrayList<Object>(16);
        while (iterator.hasNext()) {
            String month = (String)iterator.next();
            value.add(((Tuple)dataMap.get((Object)month)).item1);
        }
        JSONArray seriesJsonArray = new JSONArray();
        JSONObject seriesJson = new JSONObject();
        seriesJson.put("data", value);
        seriesJson.put("type", (Object)"line");
        seriesJson.put("smooth", (Object)true);
        seriesJson.put("symbol", (Object)"emptyCircle");
        seriesJson.put("symbolSize", (Object)"8");
        JSONObject areaStyle = new JSONObject();
        JSONObject colorStyle = new JSONObject();
        colorStyle.put("type", (Object)"linear");
        colorStyle.put("x", (Object)"0");
        colorStyle.put("y", (Object)"0");
        colorStyle.put("x2", (Object)"0");
        colorStyle.put("y2", (Object)"1");
        JSONArray colorStops = new JSONArray();
        JSONObject stopFirst = new JSONObject();
        stopFirst.put("offset", (Object)"0");
        stopFirst.put("color", (Object)"#FF991C");
        JSONObject stopSecond = new JSONObject();
        stopSecond.put("offset", (Object)"1");
        stopSecond.put("color", (Object)"#fff");
        colorStops.add((Object)stopFirst);
        colorStops.add((Object)stopSecond);
        colorStyle.put("colorStops", (Object)colorStops);
        areaStyle.put("color", (Object)colorStyle);
        seriesJson.put("areaStyle", (Object)areaStyle);
        JSONObject itemJson = new JSONObject();
        itemJson.put("color", (Object)"#FF991C");
        seriesJson.put("lineStyle", (Object)itemJson);
        itemJson = new JSONObject();
        itemJson.put("color", (Object)"#FF991C");
        seriesJson.put("itemStyle", (Object)itemJson);
        seriesJsonArray.add((Object)seriesJson);
        ChartConfig lineConfig = new ChartConfig();
        lineConfig.setSeriesList(seriesJsonArray);
        HashMap xAxisMap = Maps.newHashMapWithExpectedSize((int)4);
        xAxisMap.put("type", "category");
        xAxisMap.put("data", xAxisDataSet);
        lineConfig.setxAxisMap(xAxisMap);
        HashMap yAxisMap = Maps.newHashMapWithExpectedSize((int)4);
        yAxisMap.put("type", "value");
        yAxisMap.put("name", "%");
        lineConfig.setyAxisMap(yAxisMap);
        HashMap toolTipMap = Maps.newHashMapWithExpectedSize((int)4);
        toolTipMap.put("show", true);
        toolTipMap.put("trigger", "axis");
        lineConfig.setTooltipMap(toolTipMap);
        HashMap gridMap = Maps.newHashMapWithExpectedSize((int)8);
        gridMap.put("bottom", "15");
        gridMap.put("top", "30");
        lineConfig.setGridMap(gridMap);
        this.setDataResult(ChartFactory.createChart("LINE", lineConfig));
    }

    @Override
    public Object handleRequest(List<SummaryModel> filterData, List<SummaryModel> allData, IPageCache pageCache) {
        this.finalDataDeal(allData);
        return this.getDataResult();
    }

    @Override
    public Boolean getZipper() {
        return Boolean.TRUE;
    }
}

