/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web.tripboards.tripindex.planeindex;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.form.IPageCache;
import kd.fi.er.formplugin.web.tripboards.model.SummaryModel;
import kd.fi.er.formplugin.web.tripboards.tripindex.planeindex.TripPlaneTakeOffTimeDataProcessHandle;

public class TripPlanePopularAirDataProcessHandle
extends TripPlaneTakeOffTimeDataProcessHandle {
    private static final String JSON_KEY = "popularairlines";

    public TripPlanePopularAirDataProcessHandle(Map<String, Object> paramMap) {
        super(paramMap);
        this.setNeedYoY(Boolean.FALSE);
    }

    public TripPlanePopularAirDataProcessHandle() {
        this.setNeedYoY(Boolean.FALSE);
    }

    @Override
    public void dataHandle(Object data) {
        if (!this.getZipper().booleanValue()) {
            List<Object> convertData = this.getCacheData(this.getCacheKeys(this.getParam()));
            if (convertData.isEmpty()) {
                return;
            }
            List<SummaryModel> filterData = convertData.parallelStream().map(obj1 -> (SummaryModel)obj1).collect(Collectors.toList());
            filterData = this.getOtherSummaryTag(filterData.parallelStream().map(SummaryModel::getId).collect(Collectors.toList()));
            this.finalDataDeal(filterData);
        }
    }

    private void finalDataDeal(List<SummaryModel> filterData) {
        AtomicInteger totalOrderNumCount = new AtomicInteger(0);
        ConcurrentHashMap airAndOrderCountMap = new ConcurrentHashMap(16);
        List<String> ticketStatus = Arrays.asList("USED", "UNUSED", "CHANGED");
        Set summaryTag = filterData.parallelStream().map(SummaryModel::getOtherSummary).collect(Collectors.toSet());
        Set allOrderSummaryTag = summaryTag.parallelStream().map(JSON::parseObject).filter(jsonObject -> jsonObject != null && jsonObject.containsKey((Object)"orderNumsAndAmount")).flatMap(jsonObject -> jsonObject.getJSONArray("orderNumsAndAmount").stream()).map(String::valueOf).collect(Collectors.toSet());
        allOrderSummaryTag.parallelStream().forEach(obj -> {
            String[] split = obj.split("\\$");
            if (split.length < 12) {
                return;
            }
            if (!ticketStatus.contains(split[5])) {
                return;
            }
            String airName = split[11];
            airAndOrderCountMap.merge(airName, 1, Integer::sum);
            totalOrderNumCount.incrementAndGet();
        });
        Map topAirMap = airAndOrderCountMap.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).limit(10L).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Integer::sum, LinkedHashMap::new));
        JSONArray returnArray = new JSONArray();
        int rank = 0;
        JSONArray top3Array = new JSONArray();
        for (Map.Entry entry : topAirMap.entrySet()) {
            JSONObject airData = new JSONObject();
            String key = (String)entry.getKey();
            Integer orderNums = (Integer)entry.getValue();
            airData.put("rank", (Object)(++rank));
            airData.put("airline", (Object)key);
            airData.put("orders", (Object)orderNums);
            String rate = "0%";
            if (totalOrderNumCount.get() != 0) {
                rate = new BigDecimal(orderNums).divide(new BigDecimal(totalOrderNumCount.get()), 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100)).setScale(2, RoundingMode.HALF_UP) + "%";
            }
            airData.put("percentage", (Object)rate);
            returnArray.add((Object)airData);
        }
        JSONObject returnJson = new JSONObject();
        returnJson.put("top3", (Object)top3Array);
        returnJson.put("others", (Object)returnArray);
        this.setDataResult(returnJson);
    }

    @Override
    public Object handleRequest(List<SummaryModel> filterData, List<SummaryModel> allData, IPageCache pageCache) {
        this.finalDataDeal(filterData);
        return this.getDataResult();
    }
}

