/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web.tripboards.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.er.formplugin.web.tripboards.utils.TreeNode;
import org.apache.commons.lang.StringUtils;

public class OrgTreeBuilder {
    private final Map<Long, TreeNode> nodeMap = new HashMap<Long, TreeNode>();
    private final Map<Long, ThreeTuple<Long, Long, String>> orgMap = new HashMap<Long, ThreeTuple<Long, Long, String>>();
    private final Map<Long, String> childrenCacheMap;

    public OrgTreeBuilder() {
        this.childrenCacheMap = new HashMap<Long, String>();
    }

    public OrgTreeBuilder(Map<Long, String> cacheMap) {
        this.childrenCacheMap = cacheMap;
    }

    public void addOrg(ThreeTuple<Long, Long, String> org) {
        this.nodeMap.put((Long)org.item1, new TreeNode((Long)org.item1, (String)org.item3));
        this.orgMap.put((Long)org.item1, org);
    }

    public TreeNode buildTree(List<ThreeTuple<Long, Long, String>> orgs) {
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        ThreeTuple rootOrg = orgs.stream().filter(org -> (Long)org.item1 == rootOrgId).findFirst().orElseThrow(() -> new RuntimeException("Root organization not found"));
        return this.buildTreeIterative((ThreeTuple<Long, Long, String>)rootOrg);
    }

    private TreeNode buildTreeIterative(ThreeTuple<Long, Long, String> rootOrg) {
        Stack<TreeNode> stack = new Stack<TreeNode>();
        TreeNode rootNode = this.nodeMap.get(rootOrg.item1);
        stack.push(rootNode);
        while (!stack.isEmpty()) {
            TreeNode currentNode = (TreeNode)stack.pop();
            List<TreeNode> children = this.getChildren(currentNode.id);
            currentNode.children.addAll(children);
            stack.addAll(children);
        }
        return rootNode;
    }

    private List<TreeNode> getChildren(Long parentId) {
        ArrayList<TreeNode> children = new ArrayList<TreeNode>();
        for (ThreeTuple<Long, Long, String> org : this.orgMap.values()) {
            if (!((Long)org.item2).equals(parentId)) continue;
            TreeNode childNode = this.nodeMap.get(org.item1);
            children.add(childNode);
        }
        return children;
    }

    public Set<Long> getChildById(Long orgId, OrgTreeBuilder treeBuilder) {
        return this.getChildById(orgId, treeBuilder, false);
    }

    public Set<Long> getChildById(Long orgId, OrgTreeBuilder treeBuilder, Boolean onlyNext) {
        String parentNodeStr = treeBuilder.childrenCacheMap.get(orgId);
        HashSet<Long> orgIdSet = new HashSet<Long>();
        orgIdSet.add(orgId);
        if (StringUtils.isNotEmpty((String)parentNodeStr)) {
            JSONObject jsonObject = JSONObject.parseObject((String)parentNodeStr);
            TreeNode treeNode = OrgTreeBuilder.buildTreeNode(jsonObject);
            if (onlyNext.booleanValue()) {
                this.getNextLevelChildId(treeNode.children, orgIdSet);
            } else {
                this.getAllChildId(treeNode.children, orgIdSet);
            }
        }
        return orgIdSet;
    }

    private void getAllChildId(List<TreeNode> childrenNodeList, Set<Long> orgIdSet) {
        for (TreeNode treeNode : childrenNodeList) {
            orgIdSet.add(treeNode.id);
            if (treeNode.children.isEmpty()) continue;
            this.getAllChildId(treeNode.children, orgIdSet);
        }
    }

    private void getNextLevelChildId(List<TreeNode> childrenNodeList, Set<Long> orgIdSet) {
        for (TreeNode treeNode : childrenNodeList) {
            orgIdSet.add(treeNode.id);
        }
    }

    public static void createTreeNode(OrgTreeBuilder treeBuilder) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
        if (!cache.contains("org_tree") || StringUtils.isEmpty((String)((String)cache.get("org_tree"))) || !cache.contains("org_map") || StringUtils.isEmpty((String)((String)cache.get("org_map")))) {
            List<Integer> viewType = Arrays.asList(Integer.parseInt("01"), Integer.parseInt("12"), Integer.parseInt("10"));
            DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bos_org_structure", (String)"org,parent,fullname", (QFilter[])new QFilter[]{new QFilter("view", "in", viewType)});
            ArrayList<ThreeTuple<Long, Long, String>> orgDataList = new ArrayList<ThreeTuple<Long, Long, String>>(orgs.size());
            for (DynamicObject org : orgs) {
                Object parent = org.get("parent");
                if (parent == null) continue;
                ThreeTuple threeTuple = new ThreeTuple((Object)org.getLong("org"), (Object)Long.parseLong(parent.toString()), (Object)org.getString("fullname"));
                orgDataList.add((ThreeTuple<Long, Long, String>)threeTuple);
                treeBuilder.addOrg((ThreeTuple<Long, Long, String>)threeTuple);
            }
            TreeNode treeNode = treeBuilder.buildTree(orgDataList);
            cache.put("org_tree", (Object)treeNode.toJsonString(), 604800);
            HashMap<Long, String> cacheMap = new HashMap<Long, String>(16);
            for (Map.Entry<Long, TreeNode> orgEntry : treeBuilder.nodeMap.entrySet()) {
                cacheMap.put(orgEntry.getKey(), orgEntry.getValue().toJsonString());
            }
            cache.put("org_map", (Object)JSON.toJSONString(cacheMap), 604800);
        }
    }

    private static TreeNode buildTreeNode(JSONObject jsonObject) {
        TreeNode node = new TreeNode(jsonObject.getLong("id"), jsonObject.getString("name"));
        JSONArray childrenArray = jsonObject.getJSONArray("children");
        if (childrenArray != null) {
            for (int i = 0; i < childrenArray.size(); ++i) {
                JSONObject childObject = childrenArray.getJSONObject(i);
                node.children.add(OrgTreeBuilder.buildTreeNode(childObject));
            }
        }
        return node;
    }

    public static OrgTreeBuilder getInstance() {
        OrgTreeBuilder orgTreeBuilder;
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
        Map childrenMap = (Map)JSON.parse((String)((String)cache.get("org_map")));
        if (childrenMap == null || childrenMap.isEmpty()) {
            orgTreeBuilder = new OrgTreeBuilder();
            OrgTreeBuilder.createTreeNode(orgTreeBuilder);
        } else {
            orgTreeBuilder = new OrgTreeBuilder(childrenMap);
        }
        return orgTreeBuilder;
    }
}

