/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web.tripstandard.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class PlaneSeatUtil {
    private static final Log log = LogFactory.getLog(PlaneSeatUtil.class);
    private static final String[] VEHIC_ATTRIBUTE = new String[]{"2", "4", "7"};

    public static DynamicObject[] findSeatByAttribute(String attribute, Set<String> names) {
        if (CollectionUtils.isEmpty(names)) {
            return new DynamicObject[0];
        }
        QFilter qf = new QFilter("attribute", "=", (Object)attribute);
        qf.and(new QFilter("enable", "=", (Object)"1"));
        boolean isPlaneOrTrain = org.apache.commons.lang3.StringUtils.equalsAny((CharSequence)attribute, (CharSequence[])new CharSequence[]{"2", "4"});
        if (!isPlaneOrTrain) {
            qf.and(new QFilter("name", "in", names));
        }
        Object[] seatGradeArr = BusinessDataServiceHelper.load((String)"er_seatgradestd", (String)"id,name,attribute,number,outattribute", (QFilter[])new QFilter[]{qf});
        if (isPlaneOrTrain) {
            Set planeNames = names.stream().map(e -> e.trim()).collect(Collectors.toSet());
            seatGradeArr = Arrays.stream(seatGradeArr).filter(e -> {
                String outattribute = e.getString("outattribute");
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)outattribute)) {
                    if (e.get("name") == null) {
                        return false;
                    }
                    return planeNames.contains(e.get("name").toString());
                }
                HashSet<String> list = new HashSet<String>(Arrays.asList(outattribute.split(",")));
                list.retainAll(planeNames);
                return list.size() > 0;
            }).collect(Collectors.toList()).toArray(new DynamicObject[0]);
        }
        log.info("seatGradeArr:" + Arrays.toString(seatGradeArr));
        return seatGradeArr;
    }

    public static void refreshSeatGradeByTripExpItemChange(IFormView childView, Object oldValue, Object newValue, int index) {
        IDataModel model = childView.getModel();
        DynamicObject detailEntry = null;
        Long tripItemEntryId = 0L;
        String parentPageId = childView.getFormShowParameter().getParentPageId();
        IFormView parentView = childView.getViewNoPlugin(parentPageId);
        if (parentPageId == null) {
            return;
        }
        DynamicObject dataEntity = parentView.getModel().getDataEntity(true);
        if ("er_tripitem_edit_mb".equals(childView.getEntityId())) {
            DynamicObjectCollection collection = childView.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            Integer detailIndex = (Integer)childView.getFormShowParameter().getCustomParams().get("index");
            if (collection.size() == 0 || detailIndex < 0) {
                return;
            }
            detailEntry = (DynamicObject)collection.get(0);
            collection = dataEntity.getDynamicObjectCollection("tripentry");
            if (collection.size() == 0) {
                return;
            }
            collection = ((DynamicObject)collection.get(0)).getDynamicObjectCollection("entryentity");
            if (detailIndex >= collection.size()) {
                return;
            }
            tripItemEntryId = (Long)((DynamicObject)collection.get(detailIndex.intValue())).getPkValue();
        } else {
            detailEntry = childView.getModel().getDataEntity(true);
            tripItemEntryId = detailEntry.getLong("enpenseid");
        }
        if (detailEntry == null) {
            return;
        }
        DynamicObjectCollection detailSeatGrade = detailEntry.getDynamicObjectCollection("mulseatgrade");
        if (!(newValue != null && oldValue != null && ((DynamicObject)oldValue).getString("attribute").equals(((DynamicObject)newValue).getString("attribute")) || detailSeatGrade == null || detailSeatGrade.size() <= 0)) {
            model.setValue("mulseatgrade", null, index);
        }
        if (newValue != null) {
            DynamicObject tripItem = (DynamicObject)newValue;
            String attribute = tripItem.getString("attribute");
            DynamicObjectCollection expItemSeatGrade = detailEntry.getDynamicObjectCollection("mulseatgrade");
            if (!expItemSeatGrade.isEmpty()) {
                return;
            }
            String itemFrom = detailEntry.getString("itemfrom");
            if (Arrays.asList(VEHIC_ATTRIBUTE).contains(attribute) && (org.apache.commons.lang3.StringUtils.equals((CharSequence)"1", (CharSequence)itemFrom) || org.apache.commons.lang3.StringUtils.equals((CharSequence)"3", (CharSequence)itemFrom)) && ErEntityTypeUtils.isTripReimburseBill(parentView.getEntityId())) {
                Long finalTripItemEntryId = tripItemEntryId;
                Set invoiceHeadIds = dataEntity.getDynamicObjectCollection("invoiceitementry").stream().filter(invoiceItemEntry -> Objects.equals(finalTripItemEntryId, invoiceItemEntry.getLong("itementryid"))).map(invoiceItemEntry -> invoiceItemEntry.getLong("invoiceheadentryid")).collect(Collectors.toSet());
                Set<String> invoiceList = dataEntity.getDynamicObjectCollection("invoiceentry").stream().filter(invoiceEntry -> invoiceHeadIds.contains(invoiceEntry.getPkValue())).filter(invoiceEntry -> StringUtils.isNotBlank((String)invoiceEntry.getString("seatgrade"))).map(invoiceEntry -> invoiceEntry.getString("seatgrade")).collect(Collectors.toSet());
                if (!invoiceList.isEmpty()) {
                    DynamicObject[] seatGradeArr = PlaneSeatUtil.findSeatByAttribute(attribute, invoiceList);
                    if (seatGradeArr != null && seatGradeArr.length > 0) {
                        Object[] seats = Arrays.stream(seatGradeArr).map(seat -> seat.get("id")).toArray();
                        model.setValue("mulseatgrade", (Object)seats, index);
                    } else {
                        model.setValue("mulseatgrade", null, index);
                    }
                }
            }
        }
    }
}

