/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.daily.web.importplugin.utils;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import org.apache.commons.lang3.StringUtils;

public class ImportUtils {
    public static JSONObject packageJsonObject(DynamicObject value) {
        if (value == null) {
            return null;
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("importprop", (Object)"number");
        jsonObject.put("number", (Object)value.getString("number"));
        jsonObject.put("name", (Object)value.getString("name"));
        return jsonObject;
    }

    public static JSONObject packageJsonObject(Object number, Object name) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("importprop", (Object)"number");
        jsonObject.put("number", number);
        jsonObject.put("name", name);
        return jsonObject;
    }

    public static Map<String, Object> getUserMap(DynamicObject user) {
        Map<String, Object> resultMap = new HashMap<String, Object>();
        if (user != null) {
            resultMap = CoreBaseBillServiceHelper.createNewData(ErCommonUtils.getPk(user));
        }
        return resultMap;
    }

    public static DynamicObject getUserByNumber(String number) {
        QFilter qFilter = new QFilter("number", "=", (Object)number);
        QFilter[] qFilters = new QFilter[]{qFilter};
        String selectFields = "id,name,enable,number,phone,entryentity,entryentity.id,entryentity.position,entryentity.dpt,entryentity.ispartjob,entryentity.orgstructure";
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (String)selectFields, (QFilter[])qFilters);
    }

    public static void setProjectOwer(Map<String, Object> data) {
        JSONObject projectOwerJSON = (JSONObject)data.get("projectower");
        if (projectOwerJSON == null || !projectOwerJSON.getString("importprop").equals("number")) {
            projectOwerJSON = new JSONObject();
            JSONObject applierJSON = (JSONObject)data.get("applier");
            projectOwerJSON.put("number", (Object)applierJSON.getString("number"));
            projectOwerJSON.put("id", (Object)applierJSON.getString("id"));
            data.put("projectower", projectOwerJSON);
        }
    }

    public static JSONObject getProjectower(Long companyId, JSONObject applierJson, JSONObject currentUser) {
        JSONObject owers = new JSONObject();
        if (companyId != null) {
            String defaultProjectOwerParam = SystemParamterUtil.getDefaultProjectOwer(companyId);
            if ("0".equals(defaultProjectOwerParam) && null != applierJson) {
                return applierJson;
            }
            if ("1".equals(defaultProjectOwerParam) && null != applierJson && null != currentUser) {
                String number = String.join((CharSequence)",", applierJson.getString("number"), currentUser.getString("number"));
                owers.put("number", (Object)number);
            }
        }
        return owers;
    }

    public static DynamicObject getPayer(String number) {
        Map.Entry entry;
        String selectFields = "id,name,number,payeraccount,isdefault";
        QFilter qFilter = new QFilter("payer.number", "=", (Object)number);
        QFilter[] qFilters = new QFilter[]{qFilter};
        Map payerMap = BusinessDataServiceHelper.loadFromCache((String)"er_payeer", (String)selectFields, (QFilter[])qFilters);
        DynamicObject payer = null;
        Iterator iterator = payerMap.entrySet().iterator();
        while (iterator.hasNext() && !(payer = (DynamicObject)(entry = iterator.next()).getValue()).getBoolean("isdefault")) {
        }
        return payer;
    }

    public static BigDecimal getExchangeRate(String sourceCurrencyNumber, String targetCurrencyNumber, String companyNumber, Date bizdate) {
        DynamicObject sourceCurrency = ImportUtils.getCurrencyIdByNumber(sourceCurrencyNumber);
        DynamicObject targetCurrency = ImportUtils.getCurrencyIdByNumber(targetCurrencyNumber);
        DynamicObject company = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)companyNumber)});
        return CommonServiceHelper.getExchangeRateFromSysParams(ErCommonUtils.getPk(sourceCurrency), ErCommonUtils.getPk(targetCurrency), ErCommonUtils.getPk(company), bizdate);
    }

    public static BigDecimal getExchangeRate(String sourceCurrencyNumber, String targetCurrencyNumber, Long companyId, Date bizdate) {
        DynamicObject sourceCurrency = ImportUtils.getCurrencyIdByNumber(sourceCurrencyNumber);
        DynamicObject targetCurrency = ImportUtils.getCurrencyIdByNumber(targetCurrencyNumber);
        DynamicObject company = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)companyId)});
        return CommonServiceHelper.getExchangeRateFromSysParams(ErCommonUtils.getPk(sourceCurrency), ErCommonUtils.getPk(targetCurrency), ErCommonUtils.getPk(company), bizdate);
    }

    public static DynamicObject getCurrencyIdByNumber(String number) {
        QFilter qFilter = new QFilter("number", "=", (Object)number);
        qFilter.and(new QFilter("enable", "=", (Object)true));
        String selectFields = "id,name,number,priceprecision";
        QFilter[] qFilters = new QFilter[]{qFilter};
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bd_currency", (String)selectFields, (QFilter[])qFilters);
    }

    public static DynamicObject getOrgByNumber(String orgNumber) {
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)orgNumber)});
    }

    public static DynamicObject getCostCenterByNumber(String number) {
        DynamicObject dys = BusinessDataServiceHelper.loadSingle((String)"bos_costcenter", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number), new QFilter("enable", "=", (Object)"1")});
        return dys;
    }

    public static boolean orgFreeze(Long orgId) {
        return ImportUtils.orgFreeze(orgId, "01");
    }

    public static boolean orgFreeze(Long orgId, String treeType) {
        String selectFields = "isfreeze";
        QFilter treeTypeFilter = new QFilter("view.number", "=", (Object)treeType);
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter[] filters = new QFilter[]{treeTypeFilter, orgFilter};
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_structure", (String)selectFields, (QFilter[])filters);
        return dynamicObject != null && dynamicObject.getBoolean("isfreeze");
    }

    public static DynamicObject getCompany(String companyNumber) {
        QFilter companyFilter = new QFilter("number", "=", (Object)companyNumber);
        companyFilter.and("structure.view", "=", (Object)10);
        companyFilter.and("structure.isfreeze", "=", (Object)false);
        if (ErCommonUtils.costcompanyonlyleaf()) {
            companyFilter.and("structure.isleaf", "=", (Object)true);
        }
        companyFilter.and("enable", "=", (Object)true);
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{companyFilter});
    }

    public static boolean isenableExpenseItem(String number, String entityName) {
        DynamicObject itemBill;
        if (StringUtils.isEmpty((CharSequence)number)) {
            return false;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"er_expenseitemedit", (String)"enable,isleaf", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number), new QFilter("isleaf", "=", (Object)true)});
        return dynamicObject != null && dynamicObject.getBoolean("enable") && (itemBill = QueryServiceHelper.queryOne((String)"er_expenseitembill", (String)"enable", (QFilter[])new QFilter[]{new QFilter("expenseitem.number", "=", (Object)number), new QFilter("billtype.number", "=", (Object)entityName)})) != null && itemBill.getBoolean("enable");
    }

    public static Date formatDate(String date) throws Exception {
        SimpleDateFormat dateFormat;
        int dateStrLen = date.length();
        if (dateStrLen == 10) {
            dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        } else if (dateStrLen == 19) {
            dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        } else {
            throw new NumberFormatException();
        }
        return dateFormat.parse(date);
    }

    public static String checkCostDeptSelectInRange(long applierId, long companyId, long costDeptId) {
        Set<Object> allSubOrgWithoutCompany;
        String scopeName;
        block21: {
            block20: {
                String costdeptScope = (String)ErCommonUtils.getEMParameter(companyId, "costdeptscope");
                scopeName = "";
                Long costcompanyId = -1L;
                if (ThreadCache.exists((Object)companyId)) break block20;
                switch (costdeptScope) {
                    case "2": {
                        allSubOrgWithoutCompany = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"01", (List)Lists.newArrayList((Object[])new Long[]{companyId}), (boolean)true).stream().collect(Collectors.toSet());
                        scopeName = ResManager.loadKDString((String)"\u672c\u516c\u53f8\u53ca\u4e0b\u7ea7", (String)"ImportUtils_0", (String)"fi-er-business", (Object[])new Object[0]);
                        ThreadCache.put((Object)companyId, (Object)(allSubOrgWithoutCompany == null ? new HashSet() : allSubOrgWithoutCompany));
                        break;
                    }
                    case "4": {
                        QFilter qFilter = new QFilter("id", "=", (Object)applierId);
                        DynamicObject applier = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (String)"entryentity.dpt", (QFilter[])new QFilter[]{qFilter});
                        DynamicObjectCollection depts = applier.getDynamicObjectCollection("entryentity");
                        List dpt = depts.stream().map(v -> ErCommonUtils.getPk(v.get("dpt"))).collect(Collectors.toList());
                        List companyIds = dpt.stream().map(id -> CoreBaseBillServiceHelper.initCompanyByDept(id)).collect(Collectors.toList());
                        allSubOrgWithoutCompany = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"01", companyIds, (boolean)true).stream().collect(Collectors.toSet());
                        scopeName = ResManager.loadKDString((String)"\u4efb\u804c\u516c\u53f8", (String)"ImportUtils_1", (String)"fi-er-business", (Object[])new Object[0]);
                        ThreadCache.put((Object)companyId, (Object)(allSubOrgWithoutCompany == null ? new HashSet() : allSubOrgWithoutCompany));
                        break;
                    }
                    case "6": {
                        QFilter qf = new QFilter("id", "=", (Object)applierId);
                        DynamicObject applierv = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (String)"entryentity.dpt", (QFilter[])new QFilter[]{qf});
                        DynamicObjectCollection deptList = applierv.getDynamicObjectCollection("entryentity");
                        allSubOrgWithoutCompany = deptList.stream().map(v -> ErCommonUtils.getPk(v.get("dpt"))).collect(Collectors.toSet());
                        scopeName = ResManager.loadKDString((String)"\u4efb\u804c\u90e8\u95e8", (String)"ImportUtils_3", (String)"fi-er-business", (Object[])new Object[0]);
                        ThreadCache.put((Object)companyId, (Object)(allSubOrgWithoutCompany == null ? new HashSet() : allSubOrgWithoutCompany));
                        break;
                    }
                    case "8": {
                        allSubOrgWithoutCompany = new HashSet();
                        scopeName = ResManager.loadKDString((String)"\u8d39\u7528\u627f\u62c5\u516c\u53f8", (String)"ImportUtils_4", (String)"fi-er-business", (Object[])new Object[0]);
                        Object val = ThreadCache.get((Object)"entrycostcompany.number");
                        if (null != val) {
                            costcompanyId = Long.getLong(val.toString(), -1L);
                            String key = String.format("%s-%s", companyId, costcompanyId);
                            if (ThreadCache.exists((Object)key)) {
                                allSubOrgWithoutCompany = (Set)ThreadCache.get((Object)key);
                                break;
                            }
                            List<Long> orgIds = Collections.singletonList(costcompanyId);
                            QFilter treeTypeFilter = new QFilter("view.treetype", "=", (Object)"01");
                            QFilter orgFilter = new QFilter("org.id", "=", (Object)costcompanyId);
                            DynamicObject orgInfo = QueryServiceHelper.queryOne((String)"bos_org_structure", (String)"org", (QFilter[])new QFilter[]{treeTypeFilter, orgFilter});
                            if (orgInfo != null) {
                                List allOrgList = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)1L, orgIds, (boolean)true);
                                allSubOrgWithoutCompany.addAll(allOrgList);
                            }
                            List relationOrgList = OrgUnitServiceHelper.getAdminOrgRelation(orgIds, (boolean)true);
                            allSubOrgWithoutCompany.addAll(relationOrgList);
                            ThreadCache.put((Object)key, (Object)(allSubOrgWithoutCompany == null ? new HashSet() : allSubOrgWithoutCompany));
                            break;
                        }
                        break block21;
                    }
                    case "10": {
                        List orgList = OrgUnitServiceHelper.getSubOrgLimitLevel((List)Lists.newArrayList((Object[])new Long[]{companyId}), (int)1, (boolean)true);
                        Map allSubOrgWithoutCompanyMap = BusinessDataServiceHelper.loadFromCache((Object[])orgList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bos_org"));
                        allSubOrgWithoutCompany = new HashSet(orgList.size());
                        List<String> excludePattern = Arrays.asList("1", "2");
                        for (Map.Entry companyEntry : allSubOrgWithoutCompanyMap.entrySet()) {
                            String patterntype;
                            DynamicObject orgpattern;
                            Long companyPk;
                            DynamicObject company = (DynamicObject)companyEntry.getValue();
                            if (company == null || (companyPk = ErCommonUtils.getPk(company)) == null || companyPk == 0L) continue;
                            if (companyPk.compareTo(companyId) == 0) {
                                allSubOrgWithoutCompany.add(companyPk);
                            }
                            if ((orgpattern = company.getDynamicObject("orgpattern")) == null || excludePattern.contains(patterntype = orgpattern.getString("patterntype"))) continue;
                            allSubOrgWithoutCompany.add(companyPk);
                        }
                        scopeName = ResManager.loadKDString((String)"\u672c\u516c\u53f8", (String)"ImportUtils_5", (String)"fi-er-business", (Object[])new Object[0]);
                        ThreadCache.put((Object)companyId, (Object)(allSubOrgWithoutCompany == null ? new HashSet() : allSubOrgWithoutCompany));
                        break;
                    }
                    default: {
                        return "";
                    }
                }
                break block21;
            }
            allSubOrgWithoutCompany = (HashSet)ThreadCache.get((Object)companyId);
        }
        if (null != allSubOrgWithoutCompany && allSubOrgWithoutCompany.contains(costDeptId)) {
            return "";
        }
        String msg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7533\u8bf7\u4eba\u516c\u53f8\u7684\u8d39\u7528\u627f\u62c5\u90e8\u95e8\u9009\u62e9\u8303\u56f4\u662f\u201c%1$s\u201d\uff0c\u5bfc\u5165\u7684\u8d39\u7528\u627f\u62c5\u90e8\u95e8\u4e0d\u5728\u9009\u62e9\u8303\u56f4\u5185\u3002", (String)"ImportUtils_2", (String)"fi-er-business", (Object[])new Object[0]), scopeName);
        return msg;
    }

    public static boolean assertFalse(ImportLogger logger, int rowIndex, String msg) {
        logger.log(Integer.valueOf(rowIndex), msg);
        logger.fail();
        return false;
    }
}

